/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.job;

import com.intuit.karate.FileUtils;
import com.intuit.karate.Http;
import com.intuit.karate.LogAppender;
import com.intuit.karate.Logger;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.StringUtils;
import com.intuit.karate.job.JobCommand;
import com.intuit.karate.job.JobExecutorPulse;
import com.intuit.karate.job.JobMessage;
import com.intuit.karate.job.JobUtils;
import com.intuit.karate.shell.Command;
import com.intuit.karate.shell.FileLogAppender;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JobExecutor {
    protected final String serverUrl;
    private final Http http;
    private final Logger logger;
    protected final LogAppender appender;
    private final String workingDir;
    protected final String jobId;
    protected final String executorId;
    protected String chunkId = null;
    private final String uploadDir;
    private final Map<String, String> environment;
    private final List<JobCommand> shutdownCommands;
    private final List<Command> backgroundCommands = new ArrayList<Command>(1);

    private JobExecutor(String serverUrl) {
        this.serverUrl = serverUrl;
        String targetDir = FileUtils.getBuildDir();
        this.appender = new FileLogAppender(new File(targetDir + File.separator + "karate-executor.log"));
        this.logger = new Logger();
        this.logger.setAppender(this.appender);
        if (!Command.waitForHttp(serverUrl)) {
            this.logger.error("unable to connect to server, aborting", new Object[0]);
            System.exit(1);
        }
        this.http = Http.forUrl(this.appender, serverUrl);
        this.http.config("lowerCaseResponseHeaders", "true");
        JobMessage download = this.invokeServer(new JobMessage("download"));
        this.logger.info("download response: {}", download);
        this.jobId = download.getJobId();
        this.executorId = download.getExecutorId();
        this.workingDir = FileUtils.getBuildDir() + File.separator + this.jobId + "_" + this.executorId;
        byte[] bytes = download.getBytes();
        File file = new File(this.workingDir + ".zip");
        FileUtils.writeToFile(file, bytes);
        JobUtils.unzip(file, new File(this.workingDir));
        this.logger.info("download done: {}", this.workingDir);
        JobMessage init = this.invokeServer(new JobMessage("init").put("log", this.appender.collect()));
        this.logger.info("init response: {}", init);
        this.uploadDir = this.workingDir + File.separator + init.get("uploadDir", String.class);
        List<JobCommand> startupCommands = init.getCommands("startupCommands");
        this.environment = init.get("environment", Map.class);
        this.executeCommands(startupCommands, this.environment);
        this.shutdownCommands = init.getCommands("shutdownCommands");
        this.logger.info("init done", new Object[0]);
    }

    public static void run(String serverUrl) {
        JobExecutor je = new JobExecutor(serverUrl);
        JobExecutorPulse pulse = new JobExecutorPulse(je);
        pulse.start();
        try {
            je.loopNext();
            je.shutdown();
        }
        catch (Exception e) {
            je.logger.error("{}", e.getMessage());
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            je.invokeServer(new JobMessage("error").put("log", sw.toString()));
            System.exit(1);
        }
    }

    private File getWorkingDir(String relativePath) {
        if (relativePath == null) {
            return new File(this.workingDir);
        }
        return new File(relativePath + File.separator + this.workingDir);
    }

    private void stopBackgroundCommands() {
        while (!this.backgroundCommands.isEmpty()) {
            Command command = this.backgroundCommands.remove(0);
            command.close(false);
            command.waitSync();
        }
    }

    private byte[] toBytes(File file) {
        try {
            FileInputStream is = new FileInputStream(file);
            return FileUtils.toBytes(is);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void loopNext() {
        while (true) {
            File uploadDirFile = new File(this.uploadDir);
            uploadDirFile.mkdirs();
            JobMessage req = new JobMessage("next").put("uploadDir", uploadDirFile.getAbsolutePath());
            req.setChunkId(this.chunkId);
            JobMessage res = this.invokeServer(req);
            if (res.is("stop")) break;
            this.chunkId = res.getChunkId();
            this.executeCommands(res.getCommands("preCommands"), this.environment);
            this.executeCommands(res.getCommands("mainCommands"), this.environment);
            this.stopBackgroundCommands();
            this.executeCommands(res.getCommands("postCommands"), this.environment);
            String log = this.appender.collect();
            File logFile = new File(this.uploadDir + File.separator + "karate.log");
            FileUtils.writeToFile(logFile, log);
            String zipBase = this.uploadDir + "_" + this.chunkId;
            File toZip = new File(zipBase);
            uploadDirFile.renameTo(toZip);
            File toUpload = new File(zipBase + ".zip");
            JobUtils.zip(toZip, toUpload);
            byte[] upload = this.toBytes(toUpload);
            req = new JobMessage("upload");
            req.setChunkId(this.chunkId);
            req.setBytes(upload);
            this.invokeServer(req);
        }
        this.logger.info("stop received, shutting down", new Object[0]);
    }

    private void shutdown() {
        this.stopBackgroundCommands();
        this.executeCommands(this.shutdownCommands, this.environment);
        this.logger.info("shutdown complete", new Object[0]);
    }

    private void executeCommands(List<JobCommand> commands, Map<String, String> environment) {
        if (commands == null) {
            return;
        }
        for (JobCommand jc : commands) {
            String commandLine = jc.getCommand();
            File commandWorkingDir = this.getWorkingDir(jc.getWorkingPath());
            String[] args = Command.tokenize(commandLine);
            if (jc.isBackground()) {
                Logger silentLogger = new Logger(this.executorId);
                silentLogger.setAppendOnly(true);
                Command command = new Command(false, silentLogger, this.executorId, null, commandWorkingDir, args);
                command.setEnvironment(environment);
                command.start();
                this.backgroundCommands.add(command);
                continue;
            }
            Command command = new Command(false, this.logger, this.executorId, null, commandWorkingDir, args);
            command.setEnvironment(environment);
            command.start();
            command.waitSync();
        }
    }

    private JobMessage invokeServer(JobMessage req) {
        return JobExecutor.invokeServer(this.http, this.jobId, this.executorId, req);
    }

    protected static JobMessage invokeServer(Http http, String jobId, String executorId, JobMessage req) {
        JobMessage jm;
        ScriptValue body;
        String contentType;
        byte[] bytes = req.getBytes();
        if (bytes != null) {
            contentType = "application/octet-stream";
            body = new ScriptValue(bytes);
        } else {
            contentType = "application/json";
            body = new ScriptValue(req.body);
        }
        Http.Response res = http.header("karate-method", req.method).header("karate-job-id", jobId).header("karate-executor-id", executorId).header("karate-chunk-id", req.getChunkId()).header("content-type", contentType).post(body);
        String method = StringUtils.trimToNull(res.header("karate-method"));
        contentType = StringUtils.trimToNull(res.header("content-type"));
        if (contentType != null && contentType.contains("octet-stream")) {
            jm = new JobMessage(method);
            jm.setBytes(res.bodyBytes().asType(byte[].class));
        } else {
            jm = new JobMessage(method, res.body().asMap());
        }
        jm.setJobId(StringUtils.trimToNull(res.header("karate-job-id")));
        jm.setExecutorId(StringUtils.trimToNull(res.header("karate-executor-id")));
        jm.setChunkId(StringUtils.trimToNull(res.header("karate-chunk-id")));
        return jm;
    }
}

