/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.job;

import com.intuit.karate.job.JobCommand;
import com.intuit.karate.job.JobContext;
import com.intuit.karate.shell.Command;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public interface JobConfig {
    public String getHost();

    public int getPort();

    public int getExecutorCount();

    default public int getTimeoutMinutes() {
        return -1;
    }

    default public String getSourcePath() {
        return "";
    }

    default public String getUploadDir() {
        return null;
    }

    public String getExecutorCommand(String var1, String var2, int var3);

    default public void startExecutors(String jobId, String jobUrl) throws Exception {
        int count = this.getExecutorCount();
        if (count <= 0) {
            return;
        }
        ExecutorService executor = Executors.newFixedThreadPool(count);
        int i = 0;
        while (i < count) {
            int index = i++;
            executor.submit(() -> Command.execLine(null, this.getExecutorCommand(jobId, jobUrl, index)));
        }
        executor.shutdown();
        int timeout = this.getTimeoutMinutes();
        if (timeout > 0) {
            executor.awaitTermination(timeout, TimeUnit.MINUTES);
        }
    }

    public Map<String, String> getEnvironment();

    public List<JobCommand> getStartupCommands();

    default public List<JobCommand> getShutdownCommands() {
        return Collections.EMPTY_LIST;
    }

    public List<JobCommand> getMainCommands(JobContext var1);

    default public List<JobCommand> getPreCommands(JobContext jc) {
        return Collections.EMPTY_LIST;
    }

    default public List<JobCommand> getPostCommands(JobContext jc) {
        return Collections.EMPTY_LIST;
    }
}

