/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver;

import com.intuit.karate.Http;
import com.intuit.karate.Json;
import com.intuit.karate.Logger;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.driver.Driver;
import com.intuit.karate.driver.DriverElement;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.driver.Element;
import com.intuit.karate.shell.Command;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public abstract class WebDriver
implements Driver {
    protected final DriverOptions options;
    protected final Command command;
    protected final Http http;
    private final String sessionId;
    private final String windowId;
    protected boolean open = true;
    protected final Logger logger;

    protected WebDriver(DriverOptions options) {
        this.options = options;
        this.logger = options.driverLogger;
        this.command = options.startProcess();
        this.http = options.getHttp();
        Http.Response response = this.http.path("session").post(options.getWebDriverSessionPayload());
        if (response.status() != 200) {
            String message = "webdriver session create status " + response.status() + ", " + response.body().asString();
            this.logger.error(message, new Object[0]);
            throw new RuntimeException(message);
        }
        this.sessionId = response.jsonPath("get[0] response..sessionId").asString();
        this.logger.debug("init session id: {}", this.sessionId);
        this.http.url("/session/" + this.sessionId);
        this.windowId = this.http.path("window").get().jsonPath("$.value").asString();
        this.logger.debug("init window id: {}", this.windowId);
        if (options.start) {
            this.activate();
        }
    }

    private String getSubmitHash() {
        return this.getUrl() + this.elementId("html");
    }

    protected <T> T retryIfEnabled(String locator, Supplier<T> action) {
        String before;
        if (this.options.isRetryEnabled()) {
            this.waitFor(locator);
        }
        if ((before = this.options.getPreSubmitHash()) != null) {
            this.logger.trace("submit requested, will wait for page load after next action on : {}", locator);
            this.options.setPreSubmitHash(null);
            T result = action.get();
            Integer retryInterval = this.options.getRetryInterval();
            this.options.setRetryInterval(500);
            this.options.retry(() -> this.getSubmitHash(), hash -> !before.equals(hash), "waiting for document to change");
            this.options.setRetryInterval(retryInterval);
            return result;
        }
        return action.get();
    }

    protected boolean isJavaScriptError(Http.Response res) {
        return res.status() != 200 && !res.jsonPath("$.value").asString().contains("unexpected alert open");
    }

    protected boolean isLocatorError(Http.Response res) {
        return res.status() != 200;
    }

    protected boolean isCookieError(Http.Response res) {
        return res.status() != 200;
    }

    private Element evalLocator(String locator, String dotExpression) {
        this.eval(this.prefixReturn(this.options.selector(locator) + "." + dotExpression));
        return DriverElement.locatorExists(this, locator);
    }

    private Element evalFocus(String locator) {
        this.eval(this.options.focusJs(locator));
        return DriverElement.locatorExists(this, locator);
    }

    private ScriptValue eval(String expression) {
        Json json = new Json().set("script", expression).set("args", "[]");
        Http.Response res = this.http.path("execute", "sync").post(json);
        if (this.isJavaScriptError(res)) {
            this.logger.warn("javascript failed, will retry once: {}", res.body().asString());
            this.options.sleep();
            res = this.http.path("execute", "sync").post(json);
            if (this.isJavaScriptError(res)) {
                String message = "javascript failed twice: " + res.body().asString();
                this.logger.error(message, new Object[0]);
                throw new RuntimeException(message);
            }
        }
        return res.jsonPath("$.value").value();
    }

    protected String getElementKey() {
        return "element-6066-11e4-a52e-4f735466cecf";
    }

    protected String getJsonForInput(String text) {
        return new Json().set("text", text).toString();
    }

    protected String getJsonForHandle(String text) {
        return new Json().set("handle", text).toString();
    }

    protected String getJsonForFrame(String text) {
        return new Json().set("id", text).toString();
    }

    protected String selectorPayload(String locator) {
        if (locator.startsWith("{")) {
            locator = DriverOptions.preProcessWildCard(locator);
        }
        Json json = new Json();
        if (locator.startsWith("/")) {
            json.set("using", "xpath").set("value", locator);
        } else {
            json.set("using", "css selector").set("value", locator);
        }
        return json.toString();
    }

    @Override
    public String elementId(String locator) {
        String json = this.selectorPayload(locator);
        Http.Response res = this.http.path("element").post(json);
        if (this.isLocatorError(res)) {
            this.logger.warn("locator failed, will retry once: {}", res.body().asString());
            this.options.sleep();
            res = this.http.path("element").post(json);
            if (this.isLocatorError(res)) {
                String message = "locator failed twice: " + res.body().asString();
                this.logger.error(message, new Object[0]);
                throw new RuntimeException(message);
            }
        }
        return res.jsonPath("get[0] $.." + this.getElementKey()).asString();
    }

    @Override
    public List<String> elementIds(String locator) {
        return this.http.path("elements").post(this.selectorPayload(locator)).jsonPath("$.." + this.getElementKey()).asList();
    }

    @Override
    public DriverOptions getOptions() {
        return this.options;
    }

    @Override
    public void setUrl(String url) {
        Json json = new Json().set("url", url);
        this.http.path("url").post(json);
    }

    @Override
    public Map<String, Object> getDimensions() {
        return this.http.path("window", "rect").get().jsonPath("$.value").asMap();
    }

    @Override
    public void setDimensions(Map<String, Object> map) {
        this.http.path("window", "rect").post(map);
    }

    @Override
    public void refresh() {
        this.http.path("refresh").post("{}");
    }

    @Override
    public void reload() {
        this.refresh();
    }

    @Override
    public void back() {
        this.http.path("back").post("{}");
    }

    @Override
    public void forward() {
        this.http.path("forward").post("{}");
    }

    @Override
    public void maximize() {
        this.http.path("window", "maximize").post("{}");
    }

    @Override
    public void minimize() {
        this.http.path("window", "minimize").post("{}");
    }

    @Override
    public void fullscreen() {
        this.http.path("window", "fullscreen").post("{}");
    }

    @Override
    public Element focus(String locator) {
        return this.retryIfEnabled(locator, () -> this.evalFocus(locator));
    }

    @Override
    public Element clear(String locator) {
        return this.retryIfEnabled(locator, () -> this.evalLocator(locator, "value = ''"));
    }

    @Override
    public Element input(String locator, String value) {
        return this.retryIfEnabled(locator, () -> {
            String elementId;
            if (locator.startsWith("(")) {
                this.evalFocus(locator);
                elementId = this.http.path("element", "active").get().jsonPath("get[0] $.." + this.getElementKey()).asString();
            } else {
                elementId = this.elementId(locator);
            }
            this.http.path("element", elementId, "value").post(this.getJsonForInput(value));
            return DriverElement.locatorExists(this, locator);
        });
    }

    @Override
    public Element click(String locator) {
        return this.retryIfEnabled(locator, () -> this.evalLocator(locator, "click()"));
    }

    @Override
    public Driver submit() {
        this.options.setPreSubmitHash(this.getSubmitHash());
        return this;
    }

    @Override
    public Element select(String locator, String text) {
        return this.retryIfEnabled(locator, () -> {
            this.eval(this.options.optionSelector(locator, text));
            return DriverElement.locatorExists(this, locator);
        });
    }

    @Override
    public Element select(String locator, int index) {
        return this.retryIfEnabled(locator, () -> {
            this.eval(this.options.optionSelector(locator, index));
            return DriverElement.locatorExists(this, locator);
        });
    }

    @Override
    public void actions(List<Map<String, Object>> actions) {
        this.http.path("actions").post(Collections.singletonMap("actions", actions));
    }

    @Override
    public void close() {
        this.http.path("window").delete();
        this.open = false;
    }

    @Override
    public void quit() {
        if (this.open) {
            this.close();
        }
        try {
            this.http.delete();
        }
        catch (Exception e) {
            this.logger.warn("session delete failed: {}", e.getMessage());
        }
        if (this.command != null) {
            this.command.close(true);
        }
    }

    @Override
    public String getUrl() {
        return this.http.path("url").get().jsonPath("$.value").asString();
    }

    private String evalReturn(String locator, String dotExpression) {
        return this.eval("return " + this.options.selector(locator) + "." + dotExpression).getAsString();
    }

    @Override
    public String html(String locator) {
        return this.retryIfEnabled(locator, () -> this.evalReturn(locator, "outerHTML"));
    }

    @Override
    public String text(String locator) {
        return this.retryIfEnabled(locator, () -> this.evalReturn(locator, "textContent"));
    }

    @Override
    public String value(String locator) {
        return this.retryIfEnabled(locator, () -> this.evalReturn(locator, "value"));
    }

    @Override
    public Element value(String locator, String value) {
        return this.retryIfEnabled(locator, () -> this.evalLocator(locator, "value = '" + value + "'"));
    }

    @Override
    public String attribute(String locator, String name) {
        return this.retryIfEnabled(locator, () -> this.evalReturn(locator, "getAttribute('" + name + "')"));
    }

    @Override
    public String property(String locator, String name) {
        return this.retryIfEnabled(locator, () -> this.evalReturn(locator, name));
    }

    @Override
    public Map<String, Object> position(String locator) {
        return this.retryIfEnabled(locator, () -> this.eval("return " + this.options.selector(locator) + ".getBoundingClientRect()").getAsMap());
    }

    @Override
    public boolean enabled(String locator) {
        return this.retryIfEnabled(locator, () -> this.eval("return !" + this.options.selector(locator) + ".disabled").isBooleanTrue());
    }

    private String prefixReturn(String expression) {
        return expression.startsWith("return ") ? expression : "return " + expression;
    }

    @Override
    public boolean waitUntil(String expression) {
        return this.options.retry(() -> {
            try {
                return this.eval(this.prefixReturn(expression)).isBooleanTrue();
            }
            catch (Exception e) {
                this.logger.warn("waitUntil evaluate failed: {}", e.getMessage());
                return false;
            }
        }, b -> b, "waitUntil (js)");
    }

    @Override
    public Object script(String expression) {
        expression = this.prefixReturn(expression);
        return this.eval(expression).getValue();
    }

    @Override
    public String getTitle() {
        return this.http.path("title").get().jsonPath("$.value").asString();
    }

    @Override
    public List<Map> getCookies() {
        return this.http.path("cookie").get().jsonPath("$.value").asList();
    }

    @Override
    public Map<String, Object> cookie(String name) {
        return this.http.path("cookie", name).get().jsonPath("$.value").asMap();
    }

    @Override
    public void cookie(Map<String, Object> cookie) {
        Http.Response res = this.http.path("cookie").post(Collections.singletonMap("cookie", cookie));
        if (this.isCookieError(res)) {
            throw new RuntimeException("set-cookie failed: " + res.body().asString());
        }
    }

    @Override
    public void deleteCookie(String name) {
        this.http.path("cookie", name).delete();
    }

    @Override
    public void clearCookies() {
        this.http.path("cookie").delete();
    }

    @Override
    public void dialog(boolean accept) {
        this.dialog(accept, null);
    }

    @Override
    public String getDialog() {
        return this.http.path("alert", "text").get().jsonPath("$.value").asString();
    }

    @Override
    public void dialog(boolean accept, String text) {
        if (text == null) {
            this.http.path("alert", accept ? "accept" : "dismiss").post("{}");
        } else {
            this.http.path("alert", "text").post(Collections.singletonMap("text", text));
            this.http.path("alert", "accept").post("{}");
        }
    }

    @Override
    public byte[] screenshot(boolean embed) {
        return this.screenshot(null, embed);
    }

    @Override
    public byte[] screenshot(String locator, boolean embed) {
        String temp = locator == null ? this.http.path("screenshot").get().jsonPath("$.value").asString() : this.retryIfEnabled(locator, () -> {
            String id = this.elementId(locator);
            return this.http.path("element", id, "screenshot").get().jsonPath("$.value").asString();
        });
        byte[] bytes = Base64.getDecoder().decode(temp);
        if (embed) {
            this.options.embedPngImage(bytes);
        }
        return bytes;
    }

    @Override
    public List<String> getPages() {
        return this.http.path("window", "handles").get().jsonPath("$.value").asList();
    }

    @Override
    public void switchPage(String titleOrUrl) {
        if (titleOrUrl == null) {
            return;
        }
        List<String> list = this.getPages();
        for (String handle : list) {
            String url;
            this.http.path("window").post(this.getJsonForHandle(handle));
            String title = this.getTitle();
            if (titleOrUrl.equals(title)) {
                return;
            }
            String temp = this.options.removeProtocol(titleOrUrl);
            if (!temp.equals(url = this.options.removeProtocol(this.getUrl()))) continue;
            return;
        }
    }

    @Override
    public void switchFrame(int index) {
        if (index == -1) {
            this.http.path("frame", "parent").post("{}");
            return;
        }
        String json = new Json().set("id", index).toString();
        this.http.path("frame").post(json);
    }

    @Override
    public void switchFrame(String locator) {
        if (locator == null) {
            this.http.path("frame", "parent").post("{}");
            return;
        }
        this.retryIfEnabled(locator, () -> {
            String frameId = this.elementId(locator);
            if (frameId == null) {
                return null;
            }
            List<String> ids = this.elementIds("iframe,frame");
            for (int i = 0; i < ids.size(); ++i) {
                String id = ids.get(i);
                if (!frameId.equals(id)) continue;
                this.switchFrame(i);
                break;
            }
            return null;
        });
    }
}

