/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver;

import com.intuit.karate.driver.Key;

public class Input {
    protected boolean control;
    protected boolean alt;
    protected boolean shift;
    protected boolean meta;
    private int pos = 0;
    public final char[] chars;

    public Input(String chars) {
        this.chars = chars.toCharArray();
    }

    public boolean hasNext() {
        return this.pos < this.chars.length;
    }

    private void updateModifiers(char c) {
        if (c == Key.INSTANCE.CONTROL) {
            this.control = !this.control;
        } else if (c == Key.INSTANCE.ALT) {
            this.alt = !this.alt;
        } else if (c == Key.INSTANCE.SHIFT) {
            this.shift = !this.shift;
        } else if (c == Key.INSTANCE.META) {
            this.meta = !this.meta;
        }
    }

    public char next() {
        char c = this.chars[this.pos++];
        this.updateModifiers(c);
        return c;
    }

    public int getModifier() {
        int modifier = 0;
        if (this.control) {
            modifier += 2;
        }
        if (this.alt) {
            ++modifier;
        }
        if (this.shift) {
            modifier += 8;
        }
        if (this.meta) {
            modifier += 4;
        }
        return modifier;
    }
}

