/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver;

import com.intuit.karate.FileUtils;
import com.intuit.karate.Logger;
import com.intuit.karate.StringUtils;
import com.intuit.karate.driver.Target;
import com.intuit.karate.shell.Command;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class DockerTarget
implements Target {
    private final String imageId;
    private String containerId;
    private Function<Integer, String> command;
    private final Map<String, Object> options;
    private boolean pull = false;
    private boolean karateChrome = false;

    public DockerTarget(String dockerImage) {
        this(Collections.singletonMap("docker", dockerImage));
    }

    public DockerTarget(Map<String, Object> options) {
        this.options = options;
        if (options != null) {
            this.imageId = (String)options.get("docker");
            Integer vncPort = (Integer)options.get("vncPort");
            String secComp = (String)options.get("secComp");
            Boolean temp = (Boolean)options.get("pull");
            this.pull = temp == null ? false : temp;
            StringBuilder sb = new StringBuilder();
            sb.append("docker run -d -e KARATE_SOCAT_START=true");
            if (secComp == null) {
                sb.append(" --cap-add=SYS_ADMIN");
            } else {
                sb.append(" --security-opt seccomp=").append(secComp);
            }
            if (vncPort != null) {
                sb.append(" -p ").append(vncPort).append(":5900");
            }
            if (this.imageId != null) {
                if (this.imageId.contains("/chrome-headless")) {
                    this.command = p -> sb.toString() + " -p " + p + ":9222 " + this.imageId;
                } else if (this.imageId.contains("/karate-chrome")) {
                    this.karateChrome = true;
                    this.command = p -> sb.toString() + " -p " + p + ":9222 " + this.imageId;
                }
            }
        } else {
            this.imageId = null;
        }
    }

    public void setCommand(Function<Integer, String> command) {
        this.command = command;
    }

    public Function<Integer, String> getCommand() {
        return this.command;
    }

    @Override
    public Map<String, Object> start(Logger logger) {
        if (this.command == null) {
            throw new RuntimeException("docker target command (function) not set");
        }
        if (this.imageId != null && this.pull) {
            logger.debug("attempting to pull docker image: {}", this.imageId);
            Command.execLine(null, "docker pull " + this.imageId);
        }
        int port = Command.getFreePort(0);
        this.containerId = Command.execLine(null, this.command.apply(port));
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.options != null) {
            map.putAll(this.options);
        }
        map.put("start", false);
        map.put("port", port);
        map.put("type", "chrome");
        Command.waitForHttp("http://127.0.0.1:" + port + "/json");
        return map;
    }

    @Override
    public Map<String, Object> stop(Logger logger) {
        Command.execLine(null, "docker stop " + this.containerId);
        if (!this.karateChrome) {
            Command.execLine(null, "docker rm " + this.containerId);
            return Collections.EMPTY_MAP;
        }
        String shortName = this.containerId.contains("_") ? this.containerId : StringUtils.truncate(this.containerId, 12, false);
        String dirName = "karate-chrome_" + shortName;
        String resultsDir = Command.getBuildDir() + File.separator + dirName;
        Command.execLine(null, "docker cp " + this.containerId + ":/tmp " + resultsDir);
        Command.execLine(null, "docker rm " + this.containerId);
        String video = resultsDir + File.separator + "karate.mp4";
        File file = new File(video);
        if (!file.exists()) {
            logger.warn("video file missing: {}", file);
            return Collections.EMPTY_MAP;
        }
        File copy = new File(Command.getBuildDir() + File.separator + "cucumber-html-reports" + File.separator + dirName + ".mp4");
        FileUtils.copy(file, copy);
        return Collections.singletonMap("video", copy.getName());
    }
}

