/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.debug;

import com.intuit.karate.LogAppender;
import com.intuit.karate.Results;
import com.intuit.karate.core.ExecutionContext;
import com.intuit.karate.core.ExecutionHook;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.PerfEvent;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.core.ScenarioResult;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.StepResult;
import com.intuit.karate.debug.DapServerHandler;
import com.intuit.karate.http.HttpRequestBuilder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugThread
implements ExecutionHook,
LogAppender {
    private static final Logger logger = LoggerFactory.getLogger(DebugThread.class);
    public final long id;
    public final String name;
    public final Thread thread;
    public final Stack<Long> stack = new Stack();
    private final Map<Integer, Boolean> stepModes = new HashMap<Integer, Boolean>();
    public final DapServerHandler handler;
    private boolean stepIn;
    private boolean stepBack;
    private boolean paused;
    private boolean interrupted;
    private boolean stopped;
    private boolean errored;
    private final String appenderPrefix;
    private LogAppender appender = LogAppender.NO_OP;

    public DebugThread(Thread thread, DapServerHandler handler) {
        this.id = thread.getId();
        this.name = thread.getName();
        this.appenderPrefix = "[" + this.name + "] ";
        this.thread = thread;
        this.handler = handler;
    }

    protected void pause() {
        this.paused = true;
    }

    private boolean stop(String reason) {
        return this.stop(reason, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stop(String reason, String description) {
        this.handler.stopEvent(this.id, reason, description);
        this.stopped = true;
        DebugThread debugThread = this;
        synchronized (debugThread) {
            try {
                this.wait();
            }
            catch (Exception e) {
                logger.warn("thread error: {}", (Object)e.getMessage());
                this.interrupted = true;
                return false;
            }
        }
        this.handler.continueEvent(this.id);
        if (this.stepBack) {
            this.getContext().getExecutionUnit().stepBack();
            return false;
        }
        if (this.stopped) {
            this.getContext().getExecutionUnit().stepReset();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resume() {
        this.stopped = false;
        Iterator<DebugThread> iterator = this.handler.THREADS.values().iterator();
        while (iterator.hasNext()) {
            DebugThread dt;
            DebugThread debugThread = dt = iterator.next();
            synchronized (debugThread) {
                dt.notify();
            }
        }
    }

    @Override
    public boolean beforeScenario(Scenario scenario, ScenarioContext context) {
        long frameId = this.handler.nextFrameId();
        this.stack.push(frameId);
        this.handler.FRAMES.put(frameId, context);
        if (context.callDepth == 0) {
            this.handler.THREADS.put(this.id, this);
        }
        this.appender = context.appender;
        context.logger.setAppender(this);
        return true;
    }

    @Override
    public void afterScenario(ScenarioResult result, ScenarioContext context) {
        this.stack.pop();
        if (context.callDepth == 0) {
            this.handler.THREADS.remove(this.id);
        }
        context.logger.setAppender(this.appender);
    }

    @Override
    public boolean beforeStep(Step step, ScenarioContext context) {
        if (this.interrupted) {
            return false;
        }
        if (this.paused) {
            this.paused = false;
            return this.stop("pause");
        }
        if (this.errored) {
            this.errored = false;
            context.getExecutionUnit().stepReset();
            return false;
        }
        if (this.stepBack) {
            this.stepBack = false;
            return this.stop("step");
        }
        if (this.stepIn) {
            this.stepIn = false;
            return this.stop("step");
        }
        if (this.isStepMode()) {
            return this.stop("step");
        }
        int line = step.getLine();
        if (this.handler.isBreakpoint(step, line)) {
            return this.stop("breakpoint");
        }
        return true;
    }

    @Override
    public void afterStep(StepResult result, ScenarioContext context) {
        if (result.getResult().isFailed()) {
            String errorMessage = result.getErrorMessage();
            this.getContext().getExecutionUnit().stepReset();
            this.handler.output("*** step failed: " + errorMessage + "\n");
            this.stop("exception", errorMessage);
            this.errored = true;
        }
    }

    protected ScenarioContext getContext() {
        return this.handler.FRAMES.get(this.stack.peek());
    }

    protected DebugThread clearStepModes() {
        this.stepModes.clear();
        return this;
    }

    protected DebugThread step() {
        this.stepModes.put(this.stack.size(), true);
        return this;
    }

    protected DebugThread stepOut() {
        int stackSize = this.stack.size();
        this.stepModes.put(stackSize, false);
        if (stackSize > 1) {
            this.stepModes.put(stackSize - 1, true);
        }
        return this;
    }

    protected boolean isStepMode() {
        Boolean stepMode = this.stepModes.get(this.stack.size());
        return stepMode == null ? false : stepMode;
    }

    protected DebugThread stepIn() {
        this.stepIn = true;
        return this;
    }

    protected DebugThread stepBack(boolean stepBack) {
        this.stepBack = stepBack;
        return this;
    }

    public LogAppender getAppender() {
        return this.appender;
    }

    public void setAppender(LogAppender appender) {
        this.appender = appender;
    }

    @Override
    public String collect() {
        return this.appender.collect();
    }

    @Override
    public void append(String text) {
        this.handler.output(this.appenderPrefix + text);
        this.appender.append(text);
    }

    @Override
    public void close() {
    }

    @Override
    public boolean beforeFeature(Feature feature, ExecutionContext context) {
        return true;
    }

    @Override
    public void afterFeature(FeatureResult result, ExecutionContext context) {
    }

    @Override
    public void beforeAll(Results results) {
    }

    @Override
    public void afterAll(Results results) {
    }

    @Override
    public String getPerfEventName(HttpRequestBuilder req, ScenarioContext context) {
        return null;
    }

    @Override
    public void reportPerfEvent(PerfEvent event) {
    }
}

