/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.debug;

import com.intuit.karate.FileUtils;
import com.intuit.karate.debug.DapDecoder;
import com.intuit.karate.debug.DapEncoder;
import com.intuit.karate.debug.DapServerHandler;
import io.netty.karate.bootstrap.ServerBootstrap;
import io.netty.karate.channel.Channel;
import io.netty.karate.channel.ChannelInitializer;
import io.netty.karate.channel.ChannelPipeline;
import io.netty.karate.channel.EventLoopGroup;
import io.netty.karate.channel.nio.NioEventLoopGroup;
import io.netty.karate.channel.socket.nio.NioServerSocketChannel;
import java.io.File;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DapServer {
    private static final Logger logger = LoggerFactory.getLogger(DapServer.class);
    private final EventLoopGroup bossGroup = new NioEventLoopGroup(1);
    private final EventLoopGroup workerGroup = new NioEventLoopGroup();
    private final Channel channel;
    private final String host;
    private final int port;

    public int getPort() {
        return this.port;
    }

    public void waitSync() {
        try {
            this.channel.closeFuture().sync();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        logger.info("stop: shutting down");
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        logger.info("stop: shutdown complete");
    }

    public DapServer(int requestedPort) {
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler(new ChannelInitializer(){

                protected void initChannel(Channel c) {
                    ChannelPipeline p = c.pipeline();
                    p.addLast(new DapDecoder());
                    p.addLast(new DapEncoder());
                    p.addLast(new DapServerHandler(DapServer.this));
                }
            });
            this.channel = b.bind(requestedPort).sync().channel();
            InetSocketAddress isa = (InetSocketAddress)this.channel.localAddress();
            this.host = "127.0.0.1";
            this.port = isa.getPort();
            logger.info("debug server started on port: {}", (Object)this.port);
            String buildDir = FileUtils.getBuildDir();
            FileUtils.writeToFile(new File(buildDir + File.separator + "karate-debug-port.txt"), this.port + "");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

