/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.core.Embed;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.Result;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StepResult {
    private static final Map<String, Object> DUMMY_MATCH = new HashMap<String, Object>(2);
    private final Step step;
    private final Result result;
    private final List<FeatureResult> callResults;
    private boolean hidden;
    private boolean showLog = true;
    private List<Embed> embeds;
    private String stepLog;
    private Map<String, Object> json;

    public String getErrorMessage() {
        if (this.result == null) {
            return null;
        }
        Throwable error = this.result.getError();
        return error == null ? null : error.getMessage();
    }

    public void appendToStepLog(String log) {
        if (log == null) {
            return;
        }
        if (this.stepLog == null) {
            this.stepLog = "";
        }
        this.stepLog = this.stepLog + log;
    }

    private static Map<String, Object> docStringToMap(int line, String text) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("content_type", "");
        map.put("line", line);
        map.put("value", text);
        return map;
    }

    private static List<Map> tableToMap(Table table) {
        List<List<String>> rows = table.getRows();
        ArrayList<Map> list = new ArrayList<Map>(rows.size());
        int count = rows.size();
        for (int i = 0; i < count; ++i) {
            List<String> row = rows.get(i);
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("cells", row);
            map.put("line", table.getLineNumberForRow(i));
            list.add(map);
        }
        return list;
    }

    public StepResult(Map<String, Object> map) {
        this.json = map;
        this.step = new Step();
        this.step.setLine((Integer)map.get("line"));
        this.step.setPrefix((String)map.get("prefix"));
        this.step.setText((String)map.get("name"));
        this.result = new Result((Map)map.get("result"));
        this.callResults = null;
    }

    public Map<String, Object> toMap() {
        if (this.json != null) {
            return this.json;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("line", this.step.getLine());
        map.put("keyword", this.step.getPrefix());
        map.put("name", this.step.getText());
        map.put("result", this.result.toMap());
        map.put("match", DUMMY_MATCH);
        StringBuilder sb = new StringBuilder();
        if (this.step.getDocString() != null) {
            sb.append(this.step.getDocString());
        }
        if (this.stepLog != null) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(this.stepLog);
        }
        if (sb.length() > 0) {
            map.put("doc_string", StepResult.docStringToMap(this.step.getLine(), sb.toString()));
        }
        if (this.step.getTable() != null) {
            map.put("rows", StepResult.tableToMap(this.step.getTable()));
        }
        if (this.embeds != null) {
            ArrayList<Map> embedList = new ArrayList<Map>(this.embeds.size());
            for (Embed embed : this.embeds) {
                embedList.add(embed.toMap());
            }
            map.put("embeddings", embedList);
        }
        return map;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isShowLog() {
        return this.showLog;
    }

    public void setShowLog(boolean showLog) {
        this.showLog = showLog;
    }

    public boolean isStopped() {
        return this.result.isFailed() || this.result.isAborted();
    }

    public StepResult(Step step, Result result, String stepLog, List<Embed> embeds, List<FeatureResult> callResults) {
        this.step = step;
        this.result = result;
        this.stepLog = stepLog;
        this.embeds = embeds;
        this.callResults = callResults;
    }

    public Step getStep() {
        return this.step;
    }

    public Result getResult() {
        return this.result;
    }

    public String getStepLog() {
        return this.stepLog;
    }

    public List<Embed> getEmbeds() {
        return this.embeds;
    }

    public void addEmbed(Embed embed) {
        if (this.embeds == null) {
            this.embeds = new ArrayList<Embed>();
        }
        this.embeds.add(embed);
    }

    public List<FeatureResult> getCallResults() {
        return this.callResults;
    }

    static {
        DUMMY_MATCH.put("location", "karate");
        DUMMY_MATCH.put("arguments", Collections.EMPTY_LIST);
    }
}

