/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.core.Engine;
import com.intuit.karate.core.Step;
import com.intuit.karate.exception.KarateException;
import java.util.HashMap;
import java.util.Map;

public class Result {
    private static final String PASSED = "passed";
    private static final String FAILED = "failed";
    private static final String SKIPPED = "skipped";
    private final String status;
    private final long durationNanos;
    private final boolean aborted;
    private final Throwable error;
    private final boolean skipped;

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(this.error == null ? 2 : 3);
        map.put("status", this.status);
        map.put("duration", this.durationNanos);
        if (this.error != null) {
            map.put("error_message", this.error.getClass().getName() + ": " + this.error.getMessage());
        }
        return map;
    }

    public Result(Map<String, Object> map) {
        this.status = (String)map.get("status");
        Number num = (Number)map.get("duration");
        this.durationNanos = num == null ? 0L : num.longValue();
        String errorMessage = (String)map.get("error_message");
        this.error = errorMessage == null ? null : new KarateException(errorMessage);
        this.aborted = false;
        this.skipped = false;
    }

    private Result(String status, long nanos, Throwable error, boolean aborted) {
        this.status = status;
        this.durationNanos = nanos;
        this.error = error;
        this.aborted = aborted;
        this.skipped = SKIPPED.equals(status);
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    public boolean isFailed() {
        return this.error != null;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public Throwable getError() {
        return this.error;
    }

    public static Result passed(long nanos) {
        return new Result(PASSED, nanos, null, false);
    }

    public static Result failed(long nanos, Throwable error, Step step) {
        String featureName = Engine.getFeatureName(step);
        error = new KarateException(featureName + ":" + step.getLine() + " - " + error.getMessage());
        StackTraceElement[] newTrace = new StackTraceElement[]{new StackTraceElement("\u273d", step.getPrefix() + ' ' + step.getText() + ' ', featureName, step.getLine())};
        error.setStackTrace(newTrace);
        return new Result(FAILED, nanos, error, false);
    }

    public static Result skipped() {
        return new Result(SKIPPED, 0L, null, false);
    }

    public static Result aborted(long nanos) {
        return new Result(PASSED, nanos, null, true);
    }

    public String getStatus() {
        return this.status;
    }

    public long getDurationNanos() {
        return this.durationNanos;
    }

    public String toString() {
        return this.status;
    }
}

