/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.Logger;
import com.intuit.karate.Resource;
import com.intuit.karate.Script;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.StringUtils;
import com.intuit.karate.core.Background;
import com.intuit.karate.core.ExecutionContext;
import com.intuit.karate.core.FeatureExecutionUnit;
import com.intuit.karate.core.FeatureParser;
import com.intuit.karate.core.FeatureSection;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.core.ScenarioExecutionUnit;
import com.intuit.karate.core.ScenarioOutline;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.Tag;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Feature {
    public static final String KEYWORD = "Feature";
    private final Resource resource;
    private int line;
    private List<Tag> tags;
    private String name;
    private String description;
    private Background background;
    private List<FeatureSection> sections = new ArrayList<FeatureSection>();
    private List<String> lines;
    private String callTag;
    private String callName;
    private int callLine = -1;

    public Feature(Resource resource) {
        this.resource = resource;
    }

    public boolean isBackgroundPresent() {
        return this.background != null && this.background.getSteps() != null;
    }

    public String getNameForReport() {
        if (this.name == null) {
            return "[" + this.resource.getFileNameWithoutExtension() + "]";
        }
        return "[" + this.resource.getFileNameWithoutExtension() + "] " + this.name;
    }

    public Step findStepByLine(int line) {
        for (FeatureSection section : this.sections) {
            List<Step> steps = section.isOutline() ? section.getScenarioOutline().getSteps() : section.getScenario().getStepsIncludingBackground();
            for (Step step : steps) {
                if (step.getLine() != line) continue;
                return step;
            }
        }
        return null;
    }

    public List<ScenarioExecutionUnit> getScenarioExecutionUnits(ExecutionContext exec) {
        ArrayList<ScenarioExecutionUnit> units = new ArrayList<ScenarioExecutionUnit>();
        for (FeatureSection section : this.sections) {
            if (section.isOutline()) {
                for (Scenario scenario : section.getScenarioOutline().getScenarios()) {
                    if (scenario.isDynamic()) {
                        ScriptValue listValue;
                        if (!FeatureExecutionUnit.isSelected(exec.featureContext, scenario, new Logger())) continue;
                        ScenarioExecutionUnit bgUnit = new ScenarioExecutionUnit(scenario, null, exec);
                        bgUnit.run();
                        ScenarioContext bgContext = bgUnit.getContext();
                        if (bgContext == null || bgUnit.isStopped()) {
                            units.add(bgUnit);
                            continue;
                        }
                        String expression = scenario.getDynamicExpression();
                        try {
                            listValue = Script.evalKarateExpression(expression, bgContext);
                        }
                        catch (Exception e) {
                            String message = "dynamic expression evaluation failed: " + expression;
                            bgUnit.result.addError(message, e);
                            units.add(bgUnit);
                            continue;
                        }
                        if (listValue.isListLike()) {
                            List list = listValue.getAsList();
                            int count = list.size();
                            for (int i = 0; i < count; ++i) {
                                ScriptValue rowValue = new ScriptValue(list.get(i));
                                if (rowValue.isMapLike()) {
                                    Scenario dynamic = scenario.copy(i);
                                    dynamic.setBackgroundDone(true);
                                    Map<String, Object> map = rowValue.getAsMap();
                                    dynamic.setExampleData(map);
                                    map.forEach((k, v) -> {
                                        ScriptValue sv = new ScriptValue(v);
                                        dynamic.replace("<" + k + ">", sv.getAsString());
                                    });
                                    ScenarioExecutionUnit unit = new ScenarioExecutionUnit(dynamic, bgUnit.result.getStepResults(), exec, bgContext);
                                    units.add(unit);
                                    continue;
                                }
                                bgContext.logger.warn("ignoring dynamic expression list item {}, not map-like: {}", i, rowValue);
                            }
                            continue;
                        }
                        bgContext.logger.warn("ignoring dynamic expression, did not evaluate to list: {} - {}", expression, listValue);
                        continue;
                    }
                    units.add(new ScenarioExecutionUnit(scenario, null, exec));
                }
                continue;
            }
            units.add(new ScenarioExecutionUnit(section.getScenario(), null, exec));
        }
        return units;
    }

    public void addSection(FeatureSection section) {
        section.setIndex(this.sections.size());
        this.sections.add(section);
    }

    public FeatureSection getSection(int sectionIndex) {
        return this.sections.get(sectionIndex);
    }

    public Scenario getScenario(int sectionIndex, int scenarioIndex) {
        FeatureSection section = this.getSection(sectionIndex);
        if (scenarioIndex == -1) {
            return section.getScenario();
        }
        ScenarioOutline outline = section.getScenarioOutline();
        return outline.getScenarios().get(scenarioIndex);
    }

    public Step getStep(int sectionIndex, int scenarioIndex, int stepIndex) {
        Scenario scenario = this.getScenario(sectionIndex, scenarioIndex);
        List<Step> steps = scenario.getSteps();
        if (stepIndex == -1 || steps.isEmpty() || steps.size() <= stepIndex) {
            return null;
        }
        return steps.get(stepIndex);
    }

    public Feature replaceStep(Step step, String text) {
        return this.replaceLines(step.getLine(), step.getEndLine(), text);
    }

    public Feature replaceLines(int start, int end, String text) {
        for (int i = start - 1; i < end - 1; ++i) {
            this.lines.remove(start);
        }
        this.lines.set(start - 1, text);
        return this.replaceText(this.getText());
    }

    public Feature addLine(int index, String line) {
        this.lines.add(index, line);
        return this.replaceText(this.getText());
    }

    public String getText() {
        this.initLines();
        return this.joinLines();
    }

    public void initLines() {
        if (this.lines == null && this.resource != null) {
            this.lines = StringUtils.toStringLines(this.resource.getAsString());
        }
    }

    public String joinLines(int startLine, int endLine) {
        this.initLines();
        StringBuilder sb = new StringBuilder();
        if (endLine > this.lines.size()) {
            endLine = this.lines.size();
        }
        for (int i = startLine; i < endLine; ++i) {
            String temp = this.lines.get(i);
            sb.append(temp).append("\n");
        }
        return sb.toString();
    }

    public String joinLines() {
        int lineCount = this.lines.size();
        return this.joinLines(0, lineCount);
    }

    public Feature replaceText(String text) {
        return FeatureParser.parseText(this, text);
    }

    public String getCallTag() {
        return this.callTag;
    }

    public void setCallTag(String callTag) {
        this.callTag = callTag;
    }

    public String getCallName() {
        return this.callName;
    }

    public void setCallName(String callName) {
        this.callName = callName;
    }

    public int getCallLine() {
        return this.callLine;
    }

    public void setCallLine(int callLine) {
        this.callLine = callLine;
    }

    public List<String> getLines() {
        return this.lines;
    }

    public void setLines(List<String> lines) {
        this.lines = lines;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Path getPath() {
        return this.resource == null ? null : this.resource.getPath();
    }

    public String getRelativePath() {
        return this.resource == null ? null : this.resource.getRelativePath();
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Background getBackground() {
        return this.background;
    }

    public void setBackground(Background background) {
        this.background = background;
    }

    public List<FeatureSection> getSections() {
        return this.sections;
    }

    public void setSections(List<FeatureSection> sections) {
        this.sections = sections;
    }

    public String toString() {
        return this.resource.toString();
    }
}

