/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.cli;

import com.intuit.karate.Results;
import com.intuit.karate.StringUtils;
import com.intuit.karate.core.Engine;
import com.intuit.karate.core.ExecutionContext;
import com.intuit.karate.core.ExecutionHook;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.PerfEvent;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.core.ScenarioResult;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.StepResult;
import com.intuit.karate.http.HttpRequestBuilder;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.locks.ReentrantLock;

public class CliExecutionHook
implements ExecutionHook {
    private final boolean htmlReport;
    private final String targetDir;
    private final boolean intellij;
    private final ReentrantLock LOCK = new ReentrantLock();
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSSZ");
    private static final String TEAMCITY_PREFIX = "##teamcity";
    private static final String TEMPLATE_TEST_STARTED = "##teamcity[testStarted timestamp = '%s' locationHint = '%s' captureStandardOutput = 'true' name = '%s']";
    private static final String TEMPLATE_TEST_FAILED = "##teamcity[testFailed timestamp = '%s' details = '%s' message = '%s' name = '%s' %s]";
    private static final String TEMPLATE_TEST_FINISHED = "##teamcity[testFinished timestamp = '%s' duration = '%s' name = '%s']";
    private static final String TEMPLATE_ENTER_THE_MATRIX = "##teamcity[enteredTheMatrix timestamp = '%s']";
    private static final String TEMPLATE_TEST_SUITE_STARTED = "##teamcity[testSuiteStarted timestamp = '%s' locationHint = 'file://%s' name = '%s']";
    private static final String TEMPLATE_TEST_SUITE_FINISHED = "##teamcity[testSuiteFinished timestamp = '%s' name = '%s']";

    public CliExecutionHook(boolean htmlReport, String targetDir, boolean intellij) {
        this.htmlReport = htmlReport;
        this.targetDir = targetDir;
        this.intellij = intellij;
        if (intellij) {
            CliExecutionHook.log(String.format(TEMPLATE_ENTER_THE_MATRIX, CliExecutionHook.getCurrentTime()));
        }
    }

    @Override
    public void beforeAll(Results results) {
    }

    @Override
    public void afterAll(Results results) {
    }

    @Override
    public boolean beforeStep(Step step, ScenarioContext context) {
        return true;
    }

    @Override
    public void afterStep(StepResult result, ScenarioContext context) {
    }

    @Override
    public boolean beforeScenario(Scenario scenario, ScenarioContext context) {
        if (this.intellij && context.callDepth == 0) {
            Path absolutePath = scenario.getFeature().getResource().getPath().toAbsolutePath();
            CliExecutionHook.log(String.format(TEMPLATE_TEST_STARTED, CliExecutionHook.getCurrentTime(), absolutePath + ":" + scenario.getLine(), CliExecutionHook.escape(scenario.getNameForReport())));
        }
        return true;
    }

    @Override
    public void afterScenario(ScenarioResult result, ScenarioContext context) {
        if (this.intellij && context.callDepth == 0) {
            Scenario scenario = result.getScenario();
            if (result.isFailed()) {
                StringUtils.Pair error = CliExecutionHook.details(result.getError());
                CliExecutionHook.log(String.format(TEMPLATE_TEST_FAILED, CliExecutionHook.getCurrentTime(), CliExecutionHook.escape(error.right), CliExecutionHook.escape(error.left), CliExecutionHook.escape(scenario.getNameForReport()), ""));
            }
            CliExecutionHook.log(String.format(TEMPLATE_TEST_FINISHED, CliExecutionHook.getCurrentTime(), result.getDurationNanos() / 1000000L, CliExecutionHook.escape(scenario.getNameForReport())));
        }
    }

    @Override
    public boolean beforeFeature(Feature feature, ExecutionContext context) {
        if (this.intellij && context.callContext.callDepth == 0) {
            Path absolutePath = feature.getResource().getPath().toAbsolutePath();
            CliExecutionHook.log(String.format(TEMPLATE_TEST_SUITE_STARTED, CliExecutionHook.getCurrentTime(), absolutePath + ":" + feature.getLine(), CliExecutionHook.escape(feature.getNameForReport())));
        }
        return true;
    }

    @Override
    public void afterFeature(FeatureResult result, ExecutionContext context) {
        if (context.callContext.callDepth > 0) {
            return;
        }
        if (this.intellij) {
            CliExecutionHook.log(String.format(TEMPLATE_TEST_SUITE_FINISHED, CliExecutionHook.getCurrentTime(), CliExecutionHook.escape(result.getFeature().getNameForReport())));
        }
        if (result.getScenarioCount() == 0) {
            return;
        }
        if (this.htmlReport) {
            Engine.saveResultHtml(this.targetDir, result, null);
        }
        if (this.LOCK.tryLock()) {
            Engine.saveStatsJson(this.targetDir, context.results, null);
            this.LOCK.unlock();
        }
    }

    @Override
    public String getPerfEventName(HttpRequestBuilder req, ScenarioContext context) {
        return null;
    }

    @Override
    public void reportPerfEvent(PerfEvent event) {
    }

    private static void log(String s) {
        System.out.println(s);
    }

    private static String getCurrentTime() {
        return DATE_FORMAT.format(new Date());
    }

    private static String escape(String source) {
        if (source == null) {
            return "";
        }
        return source.replace("|", "||").replace("\n", "|n").replace("\r", "|r").replace("'", "|'").replace("[", "|[").replace("]", "|]");
    }

    private static StringUtils.Pair details(Throwable error) {
        String fullMessage = error.getMessage().replace("\r", "").replace("\t", "  ");
        String[] messageInfo = fullMessage.split("\n", 2);
        if (messageInfo.length == 2) {
            return StringUtils.pair(messageInfo[0].trim(), messageInfo[1].trim());
        }
        return StringUtils.pair(fullMessage, "");
    }
}

