/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.Actions;
import com.intuit.karate.AssignType;
import com.intuit.karate.CallContext;
import com.intuit.karate.LogAppender;
import com.intuit.karate.core.Action;
import com.intuit.karate.core.FeatureContext;
import com.intuit.karate.core.MatchStep;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioContext;
import cucumber.api.DataTable;
import cucumber.api.java.en.When;
import java.util.List;
import java.util.Map;

public class StepActions
implements Actions {
    public final ScenarioContext context;

    public StepActions(FeatureContext featureContext, CallContext callContext, Scenario scenario, LogAppender appender) {
        this(featureContext, callContext, null, scenario, appender);
    }

    public StepActions(FeatureContext featureContext, CallContext callContext, ClassLoader classLoader, Scenario scenario, LogAppender appender) {
        this.context = new ScenarioContext(featureContext, callContext, classLoader, scenario, appender);
    }

    public StepActions(ScenarioContext context) {
        this.context = context;
    }

    @Override
    @When(value="^configure ([^\\s]+) =$")
    public void configureDocstring(String key, String exp) {
        this.context.configure(key, exp);
    }

    @Override
    @When(value="^configure ([^\\s]+) = (.+)")
    public void configure(String key, String exp) {
        this.context.configure(key, exp);
    }

    @Override
    @When(value="^url (.+)")
    public void url(String expression) {
        this.context.url(expression);
    }

    @Override
    @When(value="^path (.+)")
    public void path(List<String> paths) {
        this.context.path(paths);
    }

    @Override
    @When(value="^param ([^\\s]+) = (.+)")
    public void param(String name, List<String> values) {
        this.context.param(name, values);
    }

    @Override
    @When(value="^params (.+)")
    public void params(String expr) {
        this.context.params(expr);
    }

    @Override
    @When(value="^cookie ([^\\s]+) = (.+)")
    public void cookie(String name, String value) {
        this.context.cookie(name, value);
    }

    @Override
    @When(value="^cookies (.+)")
    public void cookies(String expr) {
        this.context.cookies(expr);
    }

    @Override
    @When(value="^csv (.+) = (.+)")
    public void csv(String name, String expression) {
        this.context.assign(AssignType.CSV, name, expression);
    }

    @Override
    @When(value="^header ([^\\s]+) = (.+)")
    public void header(String name, List<String> values) {
        this.context.header(name, values);
    }

    @Override
    @When(value="^headers (.+)")
    public void headers(String expr) {
        this.context.headers(expr);
    }

    @Override
    @When(value="^form field ([^\\s]+) = (.+)")
    public void formField(String name, List<String> values) {
        this.context.formField(name, values);
    }

    @Override
    @When(value="^form fields (.+)")
    public void formFields(String expr) {
        this.context.formFields(expr);
    }

    @Override
    @When(value="^request$")
    public void requestDocstring(String body) {
        this.context.request(body);
    }

    @Override
    @When(value="^request (.+)")
    public void request(String body) {
        this.context.request(body);
    }

    @When(value="^table (.+)")
    public void table(String name, DataTable table) {
        this.table(name, table.asMaps(String.class, String.class));
    }

    @Override
    @Action(value="^table (.+)")
    public void table(String name, List<Map<String, String>> table) {
        this.context.table(name, table);
    }

    @When(value="^replace (\\w+)$")
    public void replace(String name, DataTable table) {
        this.replace(name, table.asMaps(String.class, String.class));
    }

    @Override
    @Action(value="^replace (\\w+)$")
    public void replace(String name, List<Map<String, String>> table) {
        this.context.replace(name, table);
    }

    @Override
    @When(value="^replace (\\w+).([^\\s]+) = (.+)")
    public void replace(String name, String token, String value) {
        this.context.replace(name, token, value);
    }

    @Override
    @When(value="^def (.+) =$")
    public void defDocstring(String name, String expression) {
        this.context.assign(AssignType.AUTO, name, expression);
    }

    @Override
    @When(value="^def (\\w+) = (.+)")
    public void def(String name, String expression) {
        this.context.assign(AssignType.AUTO, name, expression);
    }

    @Override
    @When(value="^text (.+) =$")
    public void text(String name, String expression) {
        this.context.assign(AssignType.TEXT, name, expression);
    }

    @Override
    @When(value="^yaml (.+) = (.+)")
    public void yaml(String name, String expression) {
        this.context.assign(AssignType.YAML, name, expression);
    }

    @Override
    @When(value="^copy (.+) = (.+)")
    public void copy(String name, String expression) {
        this.context.assign(AssignType.COPY, name, expression);
    }

    @Override
    @When(value="^json (.+) = (.+)")
    public void json(String name, String expression) {
        this.context.assign(AssignType.JSON, name, expression);
    }

    @Override
    @When(value="^string (.+) = (.+)")
    public void string(String name, String expression) {
        this.context.assign(AssignType.STRING, name, expression);
    }

    @Override
    @When(value="^xml (.+) = (.+)")
    public void xml(String name, String expression) {
        this.context.assign(AssignType.XML, name, expression);
    }

    @Override
    @When(value="^xmlstring (.+) = (.+)")
    public void xmlstring(String name, String expression) {
        this.context.assign(AssignType.XML_STRING, name, expression);
    }

    @Override
    @When(value="^bytes (.+) = (.+)")
    public void bytes(String name, String expression) {
        this.context.assign(AssignType.BYTE_ARRAY, name, expression);
    }

    @Override
    @When(value="^assert (.+)")
    public void assertTrue(String expression) {
        this.context.assertTrue(expression);
    }

    @Override
    @When(value="^method (\\w+)")
    public void method(String method) {
        this.context.method(method);
    }

    @Override
    @When(value="^retry until (.+)")
    public void retry(String until) {
        this.context.retry(until);
    }

    @Override
    @When(value="^soap action( .+)?")
    public void soapAction(String action) {
        this.context.soapAction(action);
    }

    @Override
    @When(value="^multipart entity (.+)")
    public void multipartEntity(String value) {
        this.context.multipartField(null, value);
    }

    @Override
    @When(value="^multipart field (.+) = (.+)")
    public void multipartField(String name, String value) {
        this.context.multipartField(name, value);
    }

    @Override
    @When(value="^multipart fields (.+)")
    public void multipartFields(String expr) {
        this.context.multipartFields(expr);
    }

    @Override
    @When(value="^multipart file (.+) = (.+)")
    public void multipartFile(String name, String value) {
        this.context.multipartFile(name, value);
    }

    @Override
    @When(value="^multipart files (.+)")
    public void multipartFiles(String expr) {
        this.context.multipartFiles(expr);
    }

    @Override
    @When(value="^print (.+)")
    public void print(List<String> exps) {
        this.context.print(exps);
    }

    @Override
    @When(value="^status (\\d+)")
    public void status(int status) {
        this.context.status(status);
    }

    @Override
    @When(value="^match (.+)(=|contains|any|only)$")
    public void matchDocstring(String expression, String operators, String rhs) {
        MatchStep m = new MatchStep(expression + operators);
        this.context.match(m.type, m.name, m.path, rhs);
    }

    @Override
    @When(value="^match (.+)(=|contains|any|only)( .+)$")
    public void match(String expression, String operators, String rhs) {
        MatchStep m = new MatchStep(expression + operators + rhs);
        this.context.match(m.type, m.name, m.path, m.expected);
    }

    @Override
    @When(value="^set ([^\\s]+)( .+)? =$")
    public void setDocstring(String name, String path, String value) {
        this.context.set(name, path, value);
    }

    @Override
    @When(value="^set ([^\\s]+)( .+)? = (.+)")
    public void set(String name, String path, String value) {
        this.context.set(name, path, value);
    }

    @When(value="^set ([^\\s]+)( [^=]+)?$")
    public void set(String name, String path, DataTable table) {
        this.set(name, path, table.asMaps(String.class, String.class));
    }

    @Override
    @Action(value="^set ([^\\s]+)( [^=]+)?$")
    public void set(String name, String path, List<Map<String, String>> table) {
        this.context.set(name, path, table);
    }

    @Override
    @When(value="^remove ([^\\s]+)( .+)?")
    public void remove(String name, String path) {
        this.context.remove(name, path);
    }

    @Override
    @When(value="^call ([^\\s]+)( .*)?")
    public void call(String name, String arg) {
        this.context.call(false, name, arg);
    }

    @Override
    @When(value="^callonce ([^\\s]+)( .*)?")
    public void callonce(String name, String arg) {
        this.context.call(true, name, arg);
    }

    @Override
    @When(value="^eval (.+)")
    public void eval(String exp) {
        this.context.eval(exp);
    }

    @Override
    @When(value="^eval$")
    public void evalDocstring(String exp) {
        this.context.eval(exp);
    }

    @Override
    @When(value="^([\\w]+)([^\\s^\\w])(.+)")
    public void eval(String name, String dotOrParen, String expression) {
        this.context.eval(name + dotOrParen + expression);
    }

    @Override
    @When(value="^if (.+)")
    public void evalIf(String exp) {
        this.context.eval("if " + exp);
    }

    @Override
    @When(value="^driver (.+)")
    public void driver(String expression) {
        this.context.driver(expression);
    }

    @Override
    @When(value="^robot (.+)")
    public void robot(String expression) {
        this.context.robot(expression);
    }
}

