/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.Json;
import com.intuit.karate.LogAppender;
import com.intuit.karate.Match;
import com.intuit.karate.ScriptValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Http {
    private final Match match;
    public final String urlBase;

    private Http(Match match, String urlBase) {
        this.match = match;
        this.urlBase = urlBase;
    }

    public Http url(String url) {
        if (url.startsWith("/") && this.urlBase != null) {
            url = this.urlBase + url;
        }
        this.match.context.url(Match.quote(url));
        return this;
    }

    public Http path(String ... paths) {
        ArrayList<String> list = new ArrayList<String>(paths.length);
        for (String p : paths) {
            list.add(Match.quote(p));
        }
        this.match.context.path(list);
        return this;
    }

    public Http header(String name, String value) {
        this.match.context.header(name, Collections.singletonList(Match.quote(value)));
        return this;
    }

    private Response handleError() {
        Response res = new Response();
        int code = res.status();
        if (code >= 400) {
            this.match.context.logger.warn("http response code: {}, response: {}, request: {}", code, res.body().asString(), this.match.context.getPrevRequest());
        }
        return res;
    }

    public Response get() {
        this.match.context.method("get");
        return this.handleError();
    }

    public Response post(String body) {
        return this.post(new Json(body));
    }

    public Response post(byte[] bytes) {
        return this.post(new ScriptValue(bytes));
    }

    public Response post(Map<String, Object> body) {
        return this.post(new Json(body));
    }

    public Response post(ScriptValue body) {
        this.match.context.request(body);
        this.match.context.method("post");
        return this.handleError();
    }

    public Response post(Json json) {
        return this.post(json.getValue());
    }

    public Response delete() {
        this.match.context.method("delete");
        return this.handleError();
    }

    public static Http forUrl(LogAppender appender, String url) {
        Http http = new Http(Match.forHttp(appender), url);
        return http.url(url);
    }

    public Match config(String key, String value) {
        return this.match.config(key, value);
    }

    public Match config(Map<String, Object> config) {
        return this.match.config(config);
    }

    public class Response {
        public int status() {
            return Http.this.match.get("responseStatus").asInt();
        }

        public Match body() {
            return Http.this.match.get("response");
        }

        public Match bodyBytes() {
            return Http.this.match.eval("responseBytes");
        }

        public Match jsonPath(String exp) {
            return this.body().jsonPath(exp);
        }

        public String header(String name) {
            Map<String, Object> map = Http.this.match.get("responseHeaders").asMap();
            List headers = (List)map.get(name);
            if (headers != null && !headers.isEmpty()) {
                return (String)headers.get(0);
            }
            return null;
        }
    }
}

