/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.h2.message.DbException;
import org.h2.util.ToDateParser;

class ToDateTokenizer {
    static final Pattern PATTERN_NUMBER = Pattern.compile("^([+-]?[0-9]+)");
    static final Pattern PATTERN_FOUR_DIGITS = Pattern.compile("^([+-]?[0-9]{4})");
    static final Pattern PATTERN_THREE_DIGITS = Pattern.compile("^([+-]?[0-9]{3})");
    static final Pattern PATTERN_TWO_DIGITS = Pattern.compile("^([+-]?[0-9]{2})");
    static final Pattern PATTERN_TWO_DIGITS_OR_LESS = Pattern.compile("^([+-]?[0-9][0-9]?)");
    static final Pattern PATTERN_ONE_DIGIT = Pattern.compile("^([+-]?[0-9])");
    static final Pattern PATTERN_FF = Pattern.compile("^(FF[0-9]?)", 2);
    static final Pattern PATTERN_AM_PM = Pattern.compile("^(AM|A\\.M\\.|PM|P\\.M\\.)", 2);
    static final Pattern PATTERN_BC_AD = Pattern.compile("^(BC|B\\.C\\.|AD|A\\.D\\.)", 2);
    static final YearParslet PARSLET_YEAR = new YearParslet();
    static final MonthParslet PARSLET_MONTH = new MonthParslet();
    static final DayParslet PARSLET_DAY = new DayParslet();
    static final TimeParslet PARSLET_TIME = new TimeParslet();
    static final int MILLIS_IN_HOUR = 3600000;

    ToDateTokenizer() {
    }

    static String matchStringOrThrow(Pattern pattern, ToDateParser toDateParser, Enum<?> enum_) {
        String string = toDateParser.getInputStr();
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            ToDateTokenizer.throwException(toDateParser, String.format("Issue happened when parsing token '%s'", enum_.name()));
        }
        return matcher.group(1);
    }

    static String setByName(Calendar calendar, ToDateParser toDateParser, int n, int n2) {
        String string = null;
        String string2 = toDateParser.getInputStr();
        Map<String, Integer> map = calendar.getDisplayNames(n, n2, Locale.getDefault());
        for (String string3 : map.keySet()) {
            int n3;
            if (!string3.equalsIgnoreCase(string2.substring(0, n3 = string3.length()))) continue;
            calendar.set(n, map.get(string3));
            string = string3;
            break;
        }
        if (string == null || string.isEmpty()) {
            ToDateTokenizer.throwException(toDateParser, String.format("Tried to parse one of '%s' but failed (may be an internal error?)", map.keySet()));
        }
        return string;
    }

    static void throwException(ToDateParser toDateParser, String string) {
        throw DbException.get(90056, toDateParser.getFunctionName(), String.format(" %s. Details: %s", string, toDateParser));
    }

    public static enum FormatTokenEnum {
        YYYY(PARSLET_YEAR),
        SYYYY(PARSLET_YEAR),
        IYYY(PARSLET_YEAR),
        YYY(PARSLET_YEAR),
        IYY(PARSLET_YEAR),
        YY(PARSLET_YEAR),
        IY(PARSLET_YEAR),
        SCC(PARSLET_YEAR),
        CC(PARSLET_YEAR),
        RRRR(PARSLET_YEAR),
        RR(PARSLET_YEAR),
        BC_AD(PARSLET_YEAR, PATTERN_BC_AD),
        MONTH(PARSLET_MONTH),
        MON(PARSLET_MONTH),
        MM(PARSLET_MONTH),
        RM(PARSLET_MONTH),
        DDD(PARSLET_DAY),
        DAY(PARSLET_DAY),
        DD(PARSLET_DAY),
        DY(PARSLET_DAY),
        HH24(PARSLET_TIME),
        HH12(PARSLET_TIME),
        HH(PARSLET_TIME),
        MI(PARSLET_TIME),
        SSSSS(PARSLET_TIME),
        SS(PARSLET_TIME),
        FF(PARSLET_TIME, PATTERN_FF),
        TZH(PARSLET_TIME),
        TZM(PARSLET_TIME),
        TZR(PARSLET_TIME),
        TZD(PARSLET_TIME),
        AM_PM(PARSLET_TIME, PATTERN_AM_PM),
        EE(PARSLET_YEAR),
        E(PARSLET_YEAR),
        Y(PARSLET_YEAR),
        I(PARSLET_YEAR),
        Q(PARSLET_MONTH),
        D(PARSLET_DAY),
        J(PARSLET_DAY);

        private static final List<FormatTokenEnum> EMPTY_LIST;
        private static final Map<Character, List<FormatTokenEnum>> CACHE;
        private final ToDateParslet toDateParslet;
        private final Pattern patternToUse;

        private FormatTokenEnum(ToDateParslet toDateParslet, Pattern pattern) {
            this.toDateParslet = toDateParslet;
            this.patternToUse = pattern;
        }

        private FormatTokenEnum(ToDateParslet toDateParslet) {
            this.toDateParslet = toDateParslet;
            this.patternToUse = Pattern.compile(String.format("^(%s)", this.name()), 2);
        }

        static List<FormatTokenEnum> getTokensInQuestion(String string) {
            List<FormatTokenEnum> list = EMPTY_LIST;
            if (CACHE.size() <= 0) {
                FormatTokenEnum.initCache();
            }
            if (string != null && string.length() > 0) {
                Character c = Character.valueOf(Character.toUpperCase(string.charAt(0)));
                list = CACHE.get(c);
            }
            if (list == null) {
                list = EMPTY_LIST;
            }
            return list;
        }

        private static synchronized void initCache() {
            if (CACHE.size() <= 0) {
                for (FormatTokenEnum formatTokenEnum : FormatTokenEnum.values()) {
                    ArrayList<Character> arrayList = new ArrayList<Character>();
                    if (formatTokenEnum.name().contains("_")) {
                        String[] stringArray = formatTokenEnum.name().split("_");
                        for (String string : stringArray) {
                            arrayList.add(Character.valueOf(string.toUpperCase().charAt(0)));
                        }
                    } else {
                        arrayList.add(Character.valueOf(formatTokenEnum.name().toUpperCase().charAt(0)));
                    }
                    for (Character c : arrayList) {
                        List<FormatTokenEnum> list = CACHE.get(c);
                        if (list == null) {
                            list = new ArrayList<FormatTokenEnum>(1);
                            CACHE.put(c, list);
                        }
                        list.add(formatTokenEnum);
                    }
                }
            }
        }

        boolean parseFormatStrWithToken(ToDateParser toDateParser) {
            Matcher matcher = this.patternToUse.matcher(toDateParser.getFormatStr());
            boolean bl = matcher.find();
            if (bl) {
                String string = matcher.group(1);
                this.toDateParslet.parse(toDateParser, this, string);
            }
            return bl;
        }

        static {
            EMPTY_LIST = new ArrayList<FormatTokenEnum>(0);
            CACHE = new HashMap<Character, List<FormatTokenEnum>>(FormatTokenEnum.values().length);
        }
    }

    static class TimeParslet
    implements ToDateParslet {
        TimeParslet() {
        }

        @Override
        public void parse(ToDateParser toDateParser, FormatTokenEnum formatTokenEnum, String string) {
            Calendar calendar = toDateParser.getResultCalendar();
            String string2 = null;
            int n = 0;
            block0 : switch (formatTokenEnum) {
                case HH24: {
                    string2 = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS_OR_LESS, toDateParser, formatTokenEnum);
                    n = Integer.parseInt(string2);
                    calendar.set(11, n);
                    break;
                }
                case HH12: 
                case HH: {
                    string2 = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS_OR_LESS, toDateParser, formatTokenEnum);
                    n = Integer.parseInt(string2);
                    calendar.set(10, n);
                    break;
                }
                case MI: {
                    string2 = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS_OR_LESS, toDateParser, formatTokenEnum);
                    n = Integer.parseInt(string2);
                    calendar.set(12, n);
                    break;
                }
                case SS: {
                    string2 = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS_OR_LESS, toDateParser, formatTokenEnum);
                    n = Integer.parseInt(string2);
                    calendar.set(13, n);
                    break;
                }
                case SSSSS: {
                    string2 = ToDateTokenizer.matchStringOrThrow(PATTERN_NUMBER, toDateParser, formatTokenEnum);
                    n = Integer.parseInt(string2);
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, n);
                    break;
                }
                case FF: {
                    string2 = ToDateTokenizer.matchStringOrThrow(PATTERN_NUMBER, toDateParser, formatTokenEnum);
                    String string3 = String.format("%-9s", string2).replace(' ', '0');
                    string3 = string3.substring(0, 9);
                    Double d = Double.parseDouble(string3);
                    toDateParser.setNanos(d.intValue());
                    n = (int)Math.round(d / 1000000.0);
                    calendar.set(14, n);
                    break;
                }
                case AM_PM: {
                    string2 = ToDateTokenizer.matchStringOrThrow(PATTERN_AM_PM, toDateParser, formatTokenEnum);
                    if (string2.toUpperCase().startsWith("A")) {
                        calendar.set(9, 0);
                        break;
                    }
                    calendar.set(9, 1);
                    break;
                }
                case TZH: {
                    string2 = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS_OR_LESS, toDateParser, formatTokenEnum);
                    n = Integer.parseInt(string2);
                    TimeZone timeZone = calendar.getTimeZone();
                    int n2 = timeZone.getRawOffset();
                    n2 = n2 / 3600000 * 3600000;
                    timeZone.setRawOffset(n2 + n);
                    calendar.setTimeZone(timeZone);
                    break;
                }
                case TZM: {
                    string2 = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS_OR_LESS, toDateParser, formatTokenEnum);
                    n = Integer.parseInt(string2);
                    TimeZone timeZone = calendar.getTimeZone();
                    int n3 = timeZone.getRawOffset();
                    timeZone.setRawOffset(n * 3600000 + (n3 %= 3600000));
                    calendar.setTimeZone(timeZone);
                    break;
                }
                case TZR: {
                    String string4 = toDateParser.getInputStr();
                    TimeZone timeZone = calendar.getTimeZone();
                    for (String string5 : TimeZone.getAvailableIDs()) {
                        int n4 = string5.length();
                        if (string4.length() < n4 || !string5.equalsIgnoreCase(string4.substring(0, n4))) continue;
                        timeZone.setID(string5);
                        calendar.setTimeZone(timeZone);
                        string2 = string5;
                        break block0;
                    }
                    break;
                }
                case TZD: {
                    ToDateTokenizer.throwException(toDateParser, String.format("token '%s' not supported yet.", formatTokenEnum.name()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("%s: Internal Error. Unhandled case: %s", new Object[]{this.getClass().getSimpleName(), formatTokenEnum}));
                }
            }
            toDateParser.remove(string2, string);
        }
    }

    static class DayParslet
    implements ToDateParslet {
        DayParslet() {
        }

        @Override
        public void parse(ToDateParser toDateParser, FormatTokenEnum formatTokenEnum, String string) {
            Calendar calendar = toDateParser.getResultCalendar();
            String string2 = null;
            int n = 0;
            switch (formatTokenEnum) {
                case DDD: {
                    string2 = ToDateTokenizer.matchStringOrThrow(PATTERN_NUMBER, toDateParser, formatTokenEnum);
                    n = Integer.parseInt(string2);
                    calendar.set(6, n);
                    break;
                }
                case DD: {
                    string2 = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS_OR_LESS, toDateParser, formatTokenEnum);
                    n = Integer.parseInt(string2);
                    calendar.set(5, n);
                    break;
                }
                case D: {
                    string2 = ToDateTokenizer.matchStringOrThrow(PATTERN_ONE_DIGIT, toDateParser, formatTokenEnum);
                    n = Integer.parseInt(string2);
                    calendar.set(5, n);
                    break;
                }
                case DAY: {
                    string2 = ToDateTokenizer.setByName(calendar, toDateParser, 7, 2);
                    break;
                }
                case DY: {
                    string2 = ToDateTokenizer.setByName(calendar, toDateParser, 7, 1);
                    break;
                }
                case J: {
                    string2 = ToDateTokenizer.matchStringOrThrow(PATTERN_NUMBER, toDateParser, formatTokenEnum);
                    try {
                        Date date = new SimpleDateFormat("Myydd").parse(string2);
                        calendar.setTime(date);
                    }
                    catch (ParseException parseException) {
                        ToDateTokenizer.throwException(toDateParser, String.format("Failed to parse Julian date: %s", string2));
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("%s: Internal Error. Unhandled case: %s", new Object[]{this.getClass().getSimpleName(), formatTokenEnum}));
                }
            }
            toDateParser.remove(string2, string);
        }
    }

    static class MonthParslet
    implements ToDateParslet {
        private static final String[] ROMAN_MONTH = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII"};

        MonthParslet() {
        }

        @Override
        public void parse(ToDateParser toDateParser, FormatTokenEnum formatTokenEnum, String string) {
            Calendar calendar = toDateParser.getResultCalendar();
            String string2 = toDateParser.getInputStr();
            String string3 = null;
            int n = 0;
            switch (formatTokenEnum) {
                case MONTH: {
                    string3 = ToDateTokenizer.setByName(calendar, toDateParser, 2, 2);
                    break;
                }
                case Q: {
                    ToDateTokenizer.throwException(toDateParser, String.format("token '%s' not supported yet.", formatTokenEnum.name()));
                    break;
                }
                case MON: {
                    string3 = ToDateTokenizer.setByName(calendar, toDateParser, 2, 1);
                    break;
                }
                case MM: {
                    string3 = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS_OR_LESS, toDateParser, formatTokenEnum);
                    n = Integer.parseInt(string3);
                    calendar.set(2, n - 1);
                    break;
                }
                case RM: {
                    n = 0;
                    for (String string4 : ROMAN_MONTH) {
                        ++n;
                        int n2 = string4.length();
                        if (string2.length() < n2 || !string4.equalsIgnoreCase(string2.substring(0, n2))) continue;
                        calendar.set(2, n);
                        string3 = string4;
                        break;
                    }
                    if (string3 != null && !string3.isEmpty()) break;
                    ToDateTokenizer.throwException(toDateParser, String.format("Issue happened when parsing token '%s'. Expected one of: %s", formatTokenEnum.name(), Arrays.toString(ROMAN_MONTH)));
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("%s: Internal Error. Unhandled case: %s", new Object[]{this.getClass().getSimpleName(), formatTokenEnum}));
                }
            }
            toDateParser.remove(string3, string);
        }
    }

    static class YearParslet
    implements ToDateParslet {
        YearParslet() {
        }

        @Override
        public void parse(ToDateParser toDateParser, FormatTokenEnum formatTokenEnum, String string) {
            Calendar calendar = toDateParser.getResultCalendar();
            String string2 = null;
            int n = 0;
            switch (formatTokenEnum) {
                case SYYYY: 
                case YYYY: 
                case IYYY: {
                    string2 = ToDateTokenizer.matchStringOrThrow(PATTERN_FOUR_DIGITS, toDateParser, formatTokenEnum);
                    n = Integer.parseInt(string2);
                    calendar.set(1, n >= 0 ? n : n + 1);
                    break;
                }
                case YYY: 
                case IYY: {
                    string2 = ToDateTokenizer.matchStringOrThrow(PATTERN_THREE_DIGITS, toDateParser, formatTokenEnum);
                    n = Integer.parseInt(string2);
                    calendar.set(1, n >= 0 ? n : n + 1);
                    break;
                }
                case RRRR: {
                    string2 = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS, toDateParser, formatTokenEnum);
                    n = Integer.parseInt(string2);
                    calendar.set(1, n += n < 50 ? 2000 : 1900);
                    break;
                }
                case RR: {
                    Calendar calendar2 = Calendar.getInstance();
                    int n2 = calendar2.get(1) / 100;
                    string2 = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS, toDateParser, formatTokenEnum);
                    n = Integer.parseInt(string2) + n2 * 100;
                    calendar.set(1, n);
                    break;
                }
                case EE: {
                    ToDateTokenizer.throwException(toDateParser, String.format("token '%s' not supported yet.", formatTokenEnum.name()));
                    break;
                }
                case E: {
                    ToDateTokenizer.throwException(toDateParser, String.format("token '%s' not supported yet.", formatTokenEnum.name()));
                    break;
                }
                case YY: 
                case IY: {
                    string2 = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS, toDateParser, formatTokenEnum);
                    n = Integer.parseInt(string2);
                    calendar.set(1, n >= 0 ? n : n + 1);
                    break;
                }
                case SCC: 
                case CC: {
                    string2 = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS, toDateParser, formatTokenEnum);
                    n = Integer.parseInt(string2) * 100;
                    calendar.set(1, n);
                    break;
                }
                case Y: 
                case I: {
                    string2 = ToDateTokenizer.matchStringOrThrow(PATTERN_ONE_DIGIT, toDateParser, formatTokenEnum);
                    n = Integer.parseInt(string2);
                    calendar.set(1, n >= 0 ? n : n + 1);
                    break;
                }
                case BC_AD: {
                    string2 = ToDateTokenizer.matchStringOrThrow(PATTERN_BC_AD, toDateParser, formatTokenEnum);
                    if (string2.toUpperCase().startsWith("B")) {
                        calendar.set(0, 0);
                        break;
                    }
                    calendar.set(0, 1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("%s: Internal Error. Unhandled case: %s", new Object[]{this.getClass().getSimpleName(), formatTokenEnum}));
                }
            }
            toDateParser.remove(string2, string);
        }
    }

    static interface ToDateParslet {
        public void parse(ToDateParser var1, FormatTokenEnum var2, String var3);
    }
}

