/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.compress;

import com.esotericsoftware.kryo.Compressor;
import com.esotericsoftware.kryo.Context;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import java.nio.ByteBuffer;

public abstract class ByteArrayCompressor
extends Compressor {
    public ByteArrayCompressor(Serializer serializer) {
        super(serializer);
    }

    public ByteArrayCompressor(Serializer serializer, int bufferSize) {
        super(serializer, bufferSize);
    }

    public void compress(ByteBuffer inputBuffer, Object object, ByteBuffer outputBuffer) {
        Context context = Kryo.getContext();
        int inputLength = inputBuffer.remaining();
        byte[] inputBytes = context.getBuffer(Math.max(inputLength, this.bufferSize)).array();
        inputBuffer.get(inputBytes, 0, inputLength);
        this.compress(inputBytes, inputLength, outputBuffer);
    }

    public abstract void compress(byte[] var1, int var2, ByteBuffer var3);

    public void decompress(ByteBuffer inputBuffer, Class type, ByteBuffer outputBuffer) {
        Context context = Kryo.getContext();
        int inputLength = inputBuffer.remaining();
        byte[] inputBytes = context.getBuffer(Math.max(inputLength, this.bufferSize)).array();
        inputBuffer.get(inputBytes, 0, inputLength);
        this.decompress(inputBytes, inputLength, outputBuffer);
    }

    public abstract void decompress(byte[] var1, int var2, ByteBuffer var3);
}

