/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.newtypes.EnumType;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.JSTypes;
import com.google.javascript.jscomp.newtypes.MismatchInfo;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.ObjectType;
import com.google.javascript.jscomp.newtypes.QualifiedName;
import com.google.javascript.jscomp.newtypes.RawNominalType;
import com.google.javascript.jscomp.newtypes.SubtypeCache;
import com.google.javascript.jscomp.newtypes.ToStringContext;
import com.google.javascript.jscomp.newtypes.TypeWithPropertiesStatics;
import com.google.javascript.jscomp.parsing.parser.util.format.SimpleFormat;
import com.google.javascript.rhino.FunctionTypeI;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.ObjectTypeI;
import com.google.javascript.rhino.TypeI;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public abstract class JSType
implements TypeI,
FunctionTypeI,
ObjectTypeI {
    private static final int BOTTOM_MASK = 0;
    private static final int TYPEVAR_MASK = 1;
    private static final int NON_SCALAR_MASK = 2;
    private static final int ENUM_MASK = 4;
    private static final int TRUE_MASK = 8;
    private static final int FALSE_MASK = 16;
    private static final int NULL_MASK = 32;
    private static final int NUMBER_MASK = 64;
    private static final int STRING_MASK = 128;
    private static final int UNDEFINED_MASK = 256;
    private static final int END_MASK = 512;
    private static final int TRUTHY_MASK = 512;
    private static final int FALSY_MASK = 1024;
    private static final int UNKNOWN_MASK = Integer.MAX_VALUE;
    private static final int TOP_MASK = -1;
    private static final int BOOLEAN_MASK = 24;
    private static final int TOP_SCALAR_MASK = 504;
    private static final int NUMBER_OR_STRING_MASK = 192;
    private static final int UNDEFINED_OR_BOOLEAN_MASK = 280;
    private static final int UNDEFINED_OR_NUMBER_MASK = 320;
    private static final int UNDEFINED_OR_STRING_MASK = 384;
    private static final int UNDEFINED_OR_NULL_MASK = 288;
    private static final int NULL_OR_BOOLEAN_MASK = 56;
    private static final int NULL_OR_NUMBER_MASK = 96;
    private static final int NULL_OR_STRING_MASK = 160;
    private static final ImmutableSet<ObjectType> NO_OBJS = ImmutableSet.of();
    private static final ImmutableSet<EnumType> NO_ENUMS = ImmutableSet.of();
    private final JSTypes commonTypes;
    public static boolean mockToString = false;
    private static final Joiner PIPE_JOINER = Joiner.on((String)"|");

    private JSType(JSTypes commonTypes) {
        Preconditions.checkNotNull((Object)commonTypes);
        this.commonTypes = commonTypes;
    }

    private static JSType makeType(JSTypes commonTypes, int mask, ImmutableSet<ObjectType> objs, String typeVar, ImmutableSet<EnumType> enums) {
        mask = ((ImmutableSet)Preconditions.checkNotNull(enums)).isEmpty() ? (mask &= 0xFFFFFFFB) : (mask |= 4);
        mask = ((ImmutableSet)Preconditions.checkNotNull(objs)).isEmpty() ? (mask &= 0xFFFFFFFD) : (mask |= 2);
        if (objs.isEmpty() && enums.isEmpty() && typeVar == null && (mask & 1) == 0) {
            return JSType.makeMaskType(commonTypes, mask);
        }
        if (!JSType.isInhabitable(objs)) {
            return commonTypes.BOTTOM;
        }
        if (mask == 2) {
            return new ObjsType(commonTypes, objs);
        }
        if (mask == 34) {
            return new NullableObjsType(commonTypes, objs);
        }
        return new UnionType(commonTypes, mask, objs, typeVar, enums);
    }

    private static JSType makeType(JSTypes commonTypes, int mask) {
        return JSType.makeType(commonTypes, mask, NO_OBJS, null, NO_ENUMS);
    }

    static JSType makeMaskType(JSTypes commonTypes, int mask) {
        switch (mask) {
            case 0: {
                return commonTypes.BOTTOM;
            }
            case 8: {
                return commonTypes.TRUE_TYPE;
            }
            case 16: {
                return commonTypes.FALSE_TYPE;
            }
            case 32: {
                return commonTypes.NULL;
            }
            case 64: {
                return commonTypes.NUMBER;
            }
            case 128: {
                return commonTypes.STRING;
            }
            case 256: {
                return commonTypes.UNDEFINED;
            }
            case 512: {
                return commonTypes.TRUTHY;
            }
            case 1024: {
                return commonTypes.FALSY;
            }
            case 0x7FFFFFFF: {
                return commonTypes.UNKNOWN;
            }
            case -1: {
                return commonTypes.TOP;
            }
            case 24: {
                return commonTypes.BOOLEAN;
            }
            case 192: {
                return commonTypes.NUMBER_OR_STRING;
            }
            case 280: {
                return commonTypes.UNDEFINED_OR_BOOLEAN;
            }
            case 320: {
                return commonTypes.UNDEFINED_OR_NUMBER;
            }
            case 384: {
                return commonTypes.UNDEFINED_OR_STRING;
            }
            case 288: {
                return commonTypes.NULL_OR_UNDEFINED;
            }
            case 56: {
                return commonTypes.NULL_OR_BOOLEAN;
            }
            case 96: {
                return commonTypes.NULL_OR_NUMBER;
            }
            case 160: {
                return commonTypes.NULL_OR_STRING;
            }
        }
        return new MaskType(commonTypes, mask);
    }

    protected abstract int getMask();

    abstract ImmutableSet<ObjectType> getObjs();

    protected abstract String getTypeVar();

    protected abstract ImmutableSet<EnumType> getEnums();

    static JSType fromFunctionType(FunctionType fn, NominalType fnNominal) {
        return JSType.makeType(fn.getCommonTypes(), 2, (ImmutableSet<ObjectType>)ImmutableSet.of((Object)ObjectType.fromFunction(fn, fnNominal)), null, NO_ENUMS);
    }

    public static JSType fromObjectType(ObjectType obj) {
        return JSType.makeType(obj.getCommonTypes(), 2, (ImmutableSet<ObjectType>)ImmutableSet.of((Object)obj), null, NO_ENUMS);
    }

    public static JSType fromTypeVar(JSTypes commonTypes, String typevarName) {
        return JSType.makeType(commonTypes, 1, NO_OBJS, typevarName, NO_ENUMS);
    }

    static JSType fromEnum(EnumType e) {
        return JSType.makeType(e.getCommonTypes(), 4, NO_OBJS, null, (ImmutableSet<EnumType>)ImmutableSet.of((Object)e));
    }

    final boolean isValidType() {
        if (this.isUnknown() || this.isTop()) {
            return true;
        }
        if ((this.getMask() & 2) != 0 && this.getObjs().isEmpty()) {
            return false;
        }
        if ((this.getMask() & 2) == 0 && !this.getObjs().isEmpty()) {
            return false;
        }
        if ((this.getMask() & 4) != 0 && this.getEnums().isEmpty()) {
            return false;
        }
        if ((this.getMask() & 4) == 0 && !this.getEnums().isEmpty()) {
            return false;
        }
        return (this.getMask() & 1) != 0 == (this.getTypeVar() != null);
    }

    static Map<String, JSType> createScalars(JSTypes commonTypes) {
        LinkedHashMap<String, JSType> types = new LinkedHashMap<String, JSType>();
        types.put("BOOLEAN", new MaskType(commonTypes, 24));
        types.put("BOTTOM", new MaskType(commonTypes, 0));
        types.put("FALSE_TYPE", new MaskType(commonTypes, 16));
        types.put("FALSY", new MaskType(commonTypes, 1024));
        types.put("NULL", new MaskType(commonTypes, 32));
        types.put("NUMBER", new MaskType(commonTypes, 64));
        types.put("STRING", new MaskType(commonTypes, 128));
        types.put("TOP", new MaskType(commonTypes, -1));
        types.put("TOP_SCALAR", new MaskType(commonTypes, 504));
        types.put("TRUE_TYPE", new MaskType(commonTypes, 8));
        types.put("TRUTHY", new MaskType(commonTypes, 512));
        types.put("UNDEFINED", new MaskType(commonTypes, 256));
        types.put("UNKNOWN", new MaskType(commonTypes, Integer.MAX_VALUE));
        types.put("UNDEFINED_OR_BOOLEAN", new MaskType(commonTypes, 280));
        types.put("UNDEFINED_OR_NUMBER", new MaskType(commonTypes, 320));
        types.put("UNDEFINED_OR_STRING", new MaskType(commonTypes, 384));
        types.put("NULL_OR_BOOLEAN", new MaskType(commonTypes, 56));
        types.put("NULL_OR_NUMBER", new MaskType(commonTypes, 96));
        types.put("NULL_OR_STRING", new MaskType(commonTypes, 160));
        types.put("NULL_OR_UNDEFINED", new MaskType(commonTypes, 288));
        types.put("NUMBER_OR_STRING", new MaskType(commonTypes, 192));
        return types;
    }

    @Override
    public final boolean isTop() {
        return -1 == this.getMask();
    }

    @Override
    public final boolean isBottom() {
        return 0 == this.getMask();
    }

    public final boolean isUndefined() {
        return 256 == this.getMask();
    }

    public final boolean isUnknown() {
        return Integer.MAX_VALUE == this.getMask();
    }

    public final boolean isTrueOrTruthy() {
        return 512 == this.getMask() || 8 == this.getMask();
    }

    private boolean isTheTruthyType() {
        return 512 == this.getMask();
    }

    private boolean isTheTrueType() {
        return 8 == this.getMask();
    }

    public final boolean isFalseOrFalsy() {
        return 1024 == this.getMask() || 16 == this.getMask();
    }

    public final boolean isAnyTruthyType() {
        int mask = this.getMask();
        int truthyMask = 522;
        return mask != 0 && (mask | truthyMask) == truthyMask;
    }

    public final boolean isAnyFalsyType() {
        int mask = this.getMask();
        int falsyMask = 1328;
        return mask != 0 && (mask | falsyMask) == falsyMask;
    }

    private boolean isTheFalsyType() {
        return 1024 == this.getMask();
    }

    private boolean isTheFalseType() {
        return 16 == this.getMask();
    }

    public final boolean isBoolean() {
        return (this.getMask() & 0xFFFFFFE7) == 0 && (this.getMask() & 0x18) != 0;
    }

    @Override
    public final boolean isBooleanValueType() {
        return this.isBoolean();
    }

    public final boolean isString() {
        return 128 == this.getMask();
    }

    @Override
    public final boolean isStringValueType() {
        return this.isString();
    }

    public final boolean isNumber() {
        return 64 == this.getMask();
    }

    @Override
    public final boolean isNumberValueType() {
        return this.isNumber();
    }

    public final boolean isNullOrUndef() {
        int nullUndefMask = 288;
        return this.getMask() != 0 && (this.getMask() | nullUndefMask) == nullUndefMask;
    }

    public final boolean isScalar() {
        return this.getMask() == 64 || this.getMask() == 128 || this.getMask() == 32 || this.getMask() == 256 || this.isBoolean();
    }

    private static boolean isInhabitable(Set<ObjectType> objs) {
        for (ObjectType obj : objs) {
            if (obj.isInhabitable()) continue;
            return false;
        }
        return true;
    }

    final JSTypes getCommonTypes() {
        return this.commonTypes;
    }

    final boolean hasScalar() {
        return (this.getMask() & 0x1F8) != 0 || EnumType.hasScalar(this.getEnums());
    }

    public final boolean hasNonScalar() {
        return !this.getObjs().isEmpty() || EnumType.hasNonScalar(this.getEnums());
    }

    @Override
    public final boolean isNullable() {
        return !this.isTop() && (this.getMask() & 0x20) != 0;
    }

    @Override
    public final boolean isTypeVariable() {
        return this.getMask() == 1;
    }

    public final boolean hasTypeVariable() {
        return (this.getMask() & 1) != 0;
    }

    public final boolean isStruct() {
        if (this.isUnknown()) {
            return false;
        }
        Preconditions.checkState((!this.getObjs().isEmpty() ? 1 : 0) != 0, (String)"Expected object type but found %s", (Object)this);
        for (ObjectType objType : this.getObjs()) {
            if (objType.isStruct()) continue;
            return false;
        }
        return true;
    }

    public final boolean mayBeStruct() {
        for (ObjectType objType : this.getObjs()) {
            if (!objType.isStruct()) continue;
            return true;
        }
        return false;
    }

    public final boolean isStructWithoutProp(QualifiedName pname) {
        for (ObjectType obj : this.getObjs()) {
            if (!obj.isStruct() || obj.mayHaveProp(pname)) continue;
            return true;
        }
        return false;
    }

    public final boolean isLoose() {
        ImmutableSet<ObjectType> objs = this.getObjs();
        return objs.size() == 1 && ((ObjectType)Iterables.getOnlyElement(objs)).isLoose();
    }

    public final boolean isDict() {
        if (this.isUnknown()) {
            return false;
        }
        Preconditions.checkState((!this.getObjs().isEmpty() ? 1 : 0) != 0);
        for (ObjectType objType : this.getObjs()) {
            if (objType.isDict()) continue;
            return false;
        }
        return true;
    }

    public final JSType getIndexType() {
        if (this.getMask() != 2) {
            return null;
        }
        JSType result = this.commonTypes.TOP;
        boolean foundIObject = false;
        for (ObjectType objType : this.getObjs()) {
            JSType tmp = objType.getNominalType().getIndexType();
            if (tmp == null) {
                return null;
            }
            foundIObject = true;
            result = JSType.meet(result, tmp);
        }
        return foundIObject ? result : null;
    }

    public final JSType getIndexedType() {
        if ((this.getMask() & 2) == 0) {
            return null;
        }
        JSType result = this.commonTypes.BOTTOM;
        for (ObjectType objType : this.getObjs()) {
            JSType tmp = objType.getNominalType().getIndexedType();
            if (tmp == null) {
                return null;
            }
            result = JSType.join(result, tmp);
        }
        return result.isBottom() ? null : result;
    }

    public final boolean mayBeDict() {
        for (ObjectType objType : this.getObjs()) {
            if (!objType.isDict()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isEnumElement() {
        return this.getMask() == 4 && this.getEnums().size() == 1;
    }

    @Override
    public final boolean isEnumObject() {
        ObjectType obj = this.getObjTypeIfSingletonObj();
        return obj != null && obj.isEnumObject();
    }

    @Override
    public final TypeI getEnumeratedTypeOfEnumObject() {
        return this.isEnumObject() ? this.getObjTypeIfSingletonObj().getEnumType().getEnumeratedType() : null;
    }

    public final boolean isUnion() {
        if (this.isBottom() || this.isTop() || this.isUnknown() || this.isScalar() || this.isTypeVariable() || this.isEnumElement() || this.isTheTruthyType() || this.isTheFalsyType()) {
            return false;
        }
        return this.getMask() != 2 || this.getObjs().size() != 1;
    }

    public final boolean isFunctionWithProperties() {
        ObjectType obj = this.getObjTypeIfSingletonObj();
        return obj != null && obj.isFunctionWithProperties();
    }

    public final boolean isNamespace() {
        ObjectType obj = this.getObjTypeIfSingletonObj();
        return obj != null && obj.isNamespace();
    }

    @Override
    public final JSType getEnumeratedTypeOfEnumElement() {
        return this.isEnumElement() ? ((EnumType)Iterables.getOnlyElement(this.getEnums())).getEnumeratedType() : null;
    }

    @Override
    public final JSType autobox() {
        if (this.isTop() || this.isUnknown()) {
            return this;
        }
        int mask = this.getMask();
        if ((mask & 0xDC) == 0) {
            return this;
        }
        switch (mask) {
            case 64: {
                return this.commonTypes.getNumberInstance();
            }
            case 8: 
            case 16: 
            case 24: {
                return this.commonTypes.getBooleanInstance();
            }
            case 128: {
                return this.commonTypes.getStringInstance();
            }
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(this.getObjs());
        if ((mask & 0x40) != 0) {
            builder.add((Object)this.commonTypes.getNumberInstanceObjType());
        }
        if ((mask & 0x80) != 0) {
            builder.add((Object)this.commonTypes.getStringInstanceObjType());
        }
        if ((mask & 0x18) != 0) {
            builder.add((Object)this.commonTypes.getBooleanInstanceObjType());
        }
        JSType result = JSType.makeType(this.commonTypes, mask & 0xFFFFFF27, (ImmutableSet<ObjectType>)builder.build(), this.getTypeVar(), NO_ENUMS);
        for (EnumType e : this.getEnums()) {
            result = JSType.join(result, e.getEnumeratedType().autobox());
        }
        return result;
    }

    static JSType nullAcceptingJoin(JSType t1, JSType t2) {
        if (t1 == null) {
            return t2;
        }
        if (t2 == null) {
            return t1;
        }
        return JSType.join(t1, t2);
    }

    static JSType joinManyTypes(JSTypes commonTypes, Iterable<JSType> types) {
        JSType result = commonTypes.BOTTOM;
        for (JSType t : types) {
            result = JSType.join(result, t);
        }
        return result;
    }

    public static JSType join(JSType lhs, JSType rhs) {
        Preconditions.checkNotNull((Object)lhs);
        Preconditions.checkNotNull((Object)rhs);
        JSTypes commonTypes = lhs.commonTypes;
        if (lhs.isTop() || rhs.isTop()) {
            return commonTypes.TOP;
        }
        if (lhs.isUnknown() || rhs.isUnknown()) {
            return commonTypes.UNKNOWN;
        }
        if (lhs.isBottom()) {
            return rhs;
        }
        if (rhs.isBottom()) {
            return lhs;
        }
        if (lhs.isTheTruthyType() || lhs.isTheFalsyType() || rhs.isTheTruthyType() || rhs.isTheFalsyType()) {
            return commonTypes.UNKNOWN;
        }
        if (lhs.getTypeVar() != null && rhs.getTypeVar() != null && !lhs.getTypeVar().equals(rhs.getTypeVar())) {
            return commonTypes.UNKNOWN;
        }
        int newMask = lhs.getMask() | rhs.getMask();
        ImmutableSet<ObjectType> newObjs = ObjectType.joinSets(lhs.getObjs(), rhs.getObjs());
        String newTypevar = lhs.getTypeVar() != null ? lhs.getTypeVar() : rhs.getTypeVar();
        ImmutableSet<EnumType> newEnums = EnumType.union(lhs.getEnums(), rhs.getEnums());
        if (newEnums.isEmpty()) {
            return JSType.makeType(commonTypes, newMask, newObjs, newTypevar, NO_ENUMS);
        }
        JSType tmpJoin = JSType.makeType(commonTypes, newMask & 0xFFFFFFFB, newObjs, newTypevar, NO_ENUMS);
        return JSType.makeType(commonTypes, newMask, newObjs, newTypevar, EnumType.normalizeForJoin(newEnums, tmpJoin));
    }

    public final JSType substituteGenerics(Map<String, JSType> concreteTypes) {
        if (this.isTop() || this.isUnknown() || this.getObjs().isEmpty() && this.getTypeVar() == null || concreteTypes.isEmpty()) {
            return this;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ObjectType obj : this.getObjs()) {
            builder.add((Object)obj.substituteGenerics(concreteTypes));
        }
        JSType current = JSType.makeType(this.commonTypes, this.getMask() & 0xFFFFFFFE, (ImmutableSet<ObjectType>)builder.build(), null, this.getEnums());
        if (this.hasTypeVariable()) {
            current = JSType.join(current, concreteTypes.containsKey(this.getTypeVar()) ? concreteTypes.get(this.getTypeVar()) : JSType.fromTypeVar(this.commonTypes, this.getTypeVar()));
        }
        return current;
    }

    final JSType instantiateGenerics(JSType ... types) {
        Preconditions.checkState((boolean)this.isSingletonObj());
        NominalType uninstantiated = this.getNominalTypeIfSingletonObj();
        NominalType instantiated = uninstantiated.instantiateGenerics(Arrays.asList(types));
        return JSType.fromObjectType(ObjectType.fromNominalType(instantiated));
    }

    public final JSType substituteGenericsWithUnknown() {
        return this.substituteGenerics(this.commonTypes.MAP_TO_UNKNOWN);
    }

    public JSType getInstantiatedTypeOfIterable() {
        String typeParam = "";
        JSType newTypeVar = JSType.fromTypeVar(this.commonTypes, typeParam);
        JSType iterableType = this.commonTypes.getIterableInstance(newTypeVar);
        LinkedHashMultimap typeMultimap = LinkedHashMultimap.create();
        iterableType.unifyWith(this, (List<String>)ImmutableList.of((Object)typeParam), (Multimap<String, JSType>)typeMultimap);
        Collection types = typeMultimap.get((Object)typeParam);
        return JSType.joinManyTypes(this.commonTypes, types);
    }

    private static void updateTypemap(Multimap<String, JSType> typeMultimap, String typeParam, JSType type) {
        Preconditions.checkNotNull((Object)type);
        LinkedHashSet<JSType> typesToRemove = new LinkedHashSet<JSType>();
        for (JSType other : typeMultimap.get((Object)typeParam)) {
            if (type.isUnknown()) {
                typesToRemove.add(other);
                continue;
            }
            if (other.isUnknown()) {
                type = null;
                break;
            }
            if (type.isLoose()) {
                type = null;
                break;
            }
            if (other.isLoose()) {
                typesToRemove.add(other);
                continue;
            }
            JSType unified = JSType.unifyUnknowns(type, other);
            if (unified != null) {
                typesToRemove.add(other);
                type = unified;
                continue;
            }
            if (other.isSubtypeOf(type, SubtypeCache.create())) {
                typesToRemove.add(other);
                continue;
            }
            if (!type.isSubtypeOf(other, SubtypeCache.create())) continue;
            type = null;
            break;
        }
        for (JSType typeToRemove : typesToRemove) {
            typeMultimap.remove((Object)typeParam, (Object)typeToRemove);
        }
        if (type != null) {
            typeMultimap.put((Object)typeParam, (Object)type);
        }
    }

    private final JSType promoteBoolean() {
        return this.isTheTrueType() || this.isTheFalseType() ? this.commonTypes.BOOLEAN : this;
    }

    private static int promoteBooleanMask(int mask) {
        if ((mask & 0x18) != 0) {
            return mask | 8 | 0x10;
        }
        return mask;
    }

    static JSType unifyUnknowns(JSType t1, JSType t2) {
        int t2Mask;
        Preconditions.checkNotNull((Object)t1);
        Preconditions.checkNotNull((Object)t2);
        if (t1.isUnknown() || t1.isLoose()) {
            return t2;
        }
        if (t2.isUnknown() || t2.isLoose()) {
            return t1;
        }
        if (t1.isTop() && t2.isTop()) {
            return t1.commonTypes.TOP;
        }
        if (t1.isTop() || t2.isTop()) {
            return null;
        }
        if (!t1.getEnums().equals(t2.getEnums())) {
            return null;
        }
        ImmutableSet<EnumType> newEnums = t1.getEnums();
        int t1Mask = JSType.promoteBooleanMask(t1.getMask());
        if (t1Mask != (t2Mask = JSType.promoteBooleanMask(t2.getMask())) || !Objects.equals(t1.getTypeVar(), t2.getTypeVar())) {
            return null;
        }
        if ((t1Mask & 2) == 0) {
            return t1;
        }
        if (t1.getObjs().size() != t2.getObjs().size()) {
            return null;
        }
        LinkedHashSet<ObjectType> ununified = new LinkedHashSet<ObjectType>((Collection<ObjectType>)t2.getObjs());
        LinkedHashSet<ObjectType> unifiedObjs = new LinkedHashSet<ObjectType>();
        UnmodifiableIterator unmodifiableIterator = t1.getObjs().iterator();
        while (unmodifiableIterator.hasNext()) {
            ObjectType objType1;
            ObjectType unified = objType1 = (ObjectType)unmodifiableIterator.next();
            boolean hasUnified = false;
            for (ObjectType objType2 : t2.getObjs()) {
                ObjectType tmp = ObjectType.unifyUnknowns(unified, objType2);
                if (tmp == null) continue;
                hasUnified = true;
                ununified.remove(objType2);
                unified = tmp;
            }
            if (!hasUnified) {
                return null;
            }
            unifiedObjs.add(unified);
        }
        if (!ununified.isEmpty()) {
            return null;
        }
        return JSType.makeType(t1.commonTypes, t1Mask, (ImmutableSet<ObjectType>)ImmutableSet.copyOf(unifiedObjs), t1.getTypeVar(), newEnums);
    }

    public final void unifyWith(JSType other, List<String> typeParameters, Multimap<String, JSType> typeMultimap) {
        this.unifyWithSubtype(other, typeParameters, typeMultimap, SubtypeCache.create());
    }

    final boolean unifyWithSubtype(JSType other, List<String> typeParameters, Multimap<String, JSType> typeMultimap, SubtypeCache subSuperMap) {
        if (other.isUnknown()) {
            String thisTypevar = this.getTypeVar();
            if (thisTypevar != null && typeParameters.contains(thisTypevar)) {
                JSType.updateTypemap(typeMultimap, thisTypevar, other);
            }
            return true;
        }
        HashSet<JSType> leftovers = new HashSet<JSType>();
        for (JSType otherMember : other.getUnionMembers()) {
            if (otherMember.isSubtypeOf(this) || this.unifyWithSingleType(otherMember = otherMember.promoteBoolean(), typeParameters, typeMultimap, subSuperMap)) continue;
            leftovers.add(otherMember);
        }
        if (leftovers.isEmpty()) {
            return true;
        }
        String thisTypevar = this.getTypeVar();
        if (thisTypevar != null && typeParameters.contains(thisTypevar)) {
            JSType.updateTypemap(typeMultimap, thisTypevar, JSType.joinManyTypes(this.commonTypes, leftovers));
            return true;
        }
        return false;
    }

    final boolean unifyWithSingleType(JSType other, List<String> typeParameters, Multimap<String, JSType> typeMultimap, SubtypeCache subSuperMap) {
        Preconditions.checkArgument((!other.isUnion() ? 1 : 0) != 0, (String)"Expected non-union type but found: %s", (Object)other);
        if (other.isEnumElement()) {
            JSType enumType = other.getEnumeratedTypeOfEnumElement();
            return this.unifyWithSingleType(enumType, typeParameters, typeMultimap, subSuperMap);
        }
        if (other.isSingletonObj()) {
            ObjectType otherObj = other.getObjTypeIfSingletonObj();
            boolean result = false;
            for (ObjectType thisObj : this.getObjs()) {
                if (!thisObj.unifyWithSubtype(otherObj, typeParameters, typeMultimap, subSuperMap)) continue;
                result = true;
            }
            return result;
        }
        return false;
    }

    public final JSType specialize(JSType other) {
        JSType t = this.specializeHelper(other);
        if (t.isBottom() && (this.isLoose() || other.isLoose()) && !(t = this.autobox().specializeHelper(other.autobox())).isBottom()) {
            return this;
        }
        return t.isLoose() ? ObjectType.mayTurnLooseObjectToScalar(t, this.commonTypes) : t;
    }

    private JSType specializeHelper(JSType other) {
        String newTypevar;
        if (other.isTop() || other.isUnknown() || this == other) {
            return this;
        }
        if (other.isTheTruthyType()) {
            return this.makeTruthy();
        }
        if (this.isTheTruthyType()) {
            JSType otherTruthy = other.makeTruthy();
            return otherTruthy.hasNonScalar() ? otherTruthy.withLoose() : otherTruthy;
        }
        if (other.isTheFalsyType()) {
            return this.makeFalsy();
        }
        if (this.isTheFalsyType()) {
            return other.makeFalsy();
        }
        if (this.isTop()) {
            return other;
        }
        if (this.isUnknown()) {
            NominalType otherNt = other.getNominalTypeIfSingletonObj();
            return otherNt != null && otherNt.isBuiltinObject() ? other.withLoose() : other;
        }
        int newMask = this.getMask() & other.getMask();
        if (Objects.equals(this.getTypeVar(), other.getTypeVar())) {
            newTypevar = this.getTypeVar();
        } else {
            if (this.getTypeVar() != null && other.getTypeVar() == null) {
                return other;
            }
            newTypevar = null;
            newMask &= 0xFFFFFFFE;
        }
        return JSType.meetEnums(this.commonTypes, newMask, this.getMask() | other.getMask(), ObjectType.specializeSet(this.getObjs(), other.getObjs()), newTypevar, this.getObjs(), other.getObjs(), this.getEnums(), other.getEnums());
    }

    public static JSType meet(JSType lhs, JSType rhs) {
        JSType t = JSType.meetHelper(lhs, rhs);
        if (t.isBottom() && (lhs.isLoose() || rhs.isLoose()) && !(t = JSType.meetHelper(lhs.autobox(), rhs.autobox())).isBottom()) {
            if (!lhs.isLoose()) {
                return lhs;
            }
            Preconditions.checkState((!rhs.isLoose() ? 1 : 0) != 0, (String)"Two loose types %s and %s that meet to bottom, meet to non-bottom after autoboxing.", (Object)lhs.toString(), (Object)rhs.toString());
            return rhs;
        }
        return t;
    }

    private static JSType meetHelper(JSType lhs, JSType rhs) {
        String newTypevar;
        if (lhs.isTop()) {
            return rhs;
        }
        if (rhs.isTop()) {
            return lhs;
        }
        if (lhs.isUnknown()) {
            return rhs;
        }
        if (rhs.isUnknown()) {
            return lhs;
        }
        if (lhs.isBottom() || rhs.isBottom()) {
            return lhs.commonTypes.BOTTOM;
        }
        if (lhs.isTheTruthyType()) {
            return rhs.makeTruthy();
        }
        if (lhs.isTheFalsyType()) {
            return rhs.makeFalsy();
        }
        if (rhs.isTheTruthyType()) {
            return lhs.makeTruthy();
        }
        if (rhs.isTheFalsyType()) {
            return lhs.makeFalsy();
        }
        int newMask = lhs.getMask() & rhs.getMask();
        if (Objects.equals(lhs.getTypeVar(), rhs.getTypeVar())) {
            newTypevar = lhs.getTypeVar();
        } else {
            newTypevar = null;
            newMask &= 0xFFFFFFFE;
        }
        return JSType.meetEnums(lhs.commonTypes, newMask, lhs.getMask() | rhs.getMask(), ObjectType.meetSets(lhs.getObjs(), rhs.getObjs()), newTypevar, lhs.getObjs(), rhs.getObjs(), lhs.getEnums(), rhs.getEnums());
    }

    private static JSType meetEnums(JSTypes commonTypes, int newMask, int unionMask, ImmutableSet<ObjectType> newObjs, String newTypevar, ImmutableSet<ObjectType> objs1, ImmutableSet<ObjectType> objs2, ImmutableSet<EnumType> enums1, ImmutableSet<EnumType> enums2) {
        if (Objects.equals(enums1, enums2)) {
            return JSType.makeType(commonTypes, newMask, (ImmutableSet<ObjectType>)newObjs, newTypevar, enums1);
        }
        ImmutableSet.Builder enumBuilder = ImmutableSet.builder();
        ImmutableSet<EnumType> allEnums = EnumType.union(enums1, enums2);
        for (EnumType e : allEnums) {
            if (enums1 != null && enums1.contains((Object)e) && enums2 != null && enums2.contains((Object)e)) {
                enumBuilder.add((Object)e);
                continue;
            }
            JSType enumeratedType = e.getEnumeratedType();
            if (enumeratedType.isUnknown()) {
                enumBuilder.add((Object)e);
                continue;
            }
            if (enumeratedType.getMask() != 2) {
                if ((enumeratedType.getMask() & unionMask) == 0) continue;
                enumBuilder.add((Object)e);
                newMask &= ~enumeratedType.getMask();
                continue;
            }
            if (objs1.isEmpty() && objs2.isEmpty()) continue;
            LinkedHashSet<ObjectType> objsToRemove = new LinkedHashSet<ObjectType>();
            ObjectType enumObj = (ObjectType)Iterables.getOnlyElement(enumeratedType.getObjs());
            for (ObjectType obj1 : objs1) {
                if (!enumObj.isSubtypeOf(obj1, SubtypeCache.create())) continue;
                enumBuilder.add((Object)e);
                objsToRemove.add(obj1);
            }
            for (ObjectType obj2 : objs2) {
                if (!enumObj.isSubtypeOf(obj2, SubtypeCache.create())) continue;
                enumBuilder.add((Object)e);
                objsToRemove.add(obj2);
            }
            if (objsToRemove.isEmpty()) continue;
            newObjs = Sets.difference((Set)newObjs, objsToRemove).immutableCopy();
        }
        return JSType.makeType(commonTypes, newMask, (ImmutableSet<ObjectType>)newObjs, newTypevar, (ImmutableSet<EnumType>)enumBuilder.build());
    }

    public static boolean haveCommonSubtype(JSType lhs, JSType rhs) {
        return lhs.isBottom() || rhs.isBottom() || !JSType.meet(lhs, rhs).isBottom();
    }

    private JSType makeTruthy() {
        if (this.isTop()) {
            return this;
        }
        if (this.isUnknown()) {
            return this.commonTypes.TRUTHY;
        }
        return JSType.makeType(this.commonTypes, this.getMask() & 0xFFFFFFDF & 0xFFFFFFEF & 0xFFFFFEFF, this.getObjs(), this.getTypeVar(), this.getEnums());
    }

    private JSType makeFalsy() {
        if (this.isTop()) {
            return this;
        }
        if (this.isUnknown()) {
            return this.commonTypes.FALSY;
        }
        return JSType.makeType(this.commonTypes, this.getMask() & 0xFFFFFFF7 & 0xFFFFFFFD, NO_OBJS, this.getTypeVar(), this.getEnums());
    }

    public static JSType plus(JSType lhs, JSType rhs) {
        JSTypes commonTypes = lhs.commonTypes;
        if (!lhs.isUnknown() && !lhs.isBottom() && lhs.isSubtypeOf(commonTypes.STRING) || !rhs.isUnknown() && !rhs.isBottom() && rhs.isSubtypeOf(commonTypes.STRING)) {
            return commonTypes.STRING;
        }
        if (lhs.isUnknown() || lhs.isTop() || rhs.isUnknown() || rhs.isTop()) {
            return commonTypes.UNKNOWN;
        }
        int newtype = (lhs.getMask() | rhs.getMask()) & 0x80;
        if ((lhs.getMask() & 0xFFFFFF7F) != 0 && (rhs.getMask() & 0xFFFFFF7F) != 0) {
            newtype |= 0x40;
        }
        return JSType.makeType(lhs.commonTypes, newtype);
    }

    public final JSType negate() {
        if (this.isTop() || this.isUnknown()) {
            return this;
        }
        if (this.isTrueOrTruthy()) {
            return this.commonTypes.FALSY;
        }
        if (this.isFalseOrFalsy()) {
            return this.commonTypes.TRUTHY;
        }
        return this.commonTypes.UNKNOWN;
    }

    public final JSType toBoolean() {
        if (this.isTrueOrTruthy()) {
            return this.commonTypes.TRUE_TYPE;
        }
        if (this.isFalseOrFalsy()) {
            return this.commonTypes.FALSE_TYPE;
        }
        return this.commonTypes.BOOLEAN;
    }

    public final boolean isNonLooseSubtypeOf(JSType other) {
        return this.isSubtypeOfHelper(false, other, SubtypeCache.create(), null);
    }

    @Override
    public final boolean isSubtypeOf(TypeI other) {
        return this.isSubtypeOf(other, SubtypeCache.create());
    }

    public static MismatchInfo whyNotSubtypeOf(JSType found, JSType expected) {
        if (found.isSingletonObj() && expected.isSingletonObj()) {
            MismatchInfo[] boxedInfo = new MismatchInfo[1];
            ObjectType.whyNotSubtypeOf(found.getObjTypeIfSingletonObj(), expected.getObjTypeIfSingletonObj(), boxedInfo);
            return boxedInfo[0];
        }
        if (found.isUnion()) {
            MismatchInfo[] boxedInfo = new MismatchInfo[1];
            boolean areSubtypes = found.isSubtypeOfHelper(true, expected, SubtypeCache.create(), boxedInfo);
            Preconditions.checkState((!areSubtypes ? 1 : 0) != 0);
            return boxedInfo[0];
        }
        return null;
    }

    final boolean isSubtypeOf(TypeI other, SubtypeCache subSuperMap) {
        if (this == other) {
            return true;
        }
        JSType type2 = (JSType)other;
        if (this.isLoose() || type2.isLoose()) {
            return this.commonTypes.looseSubtypingForLooseObjects ? JSType.haveCommonSubtype(this.autobox(), type2.autobox()) : this.autobox().isSubtypeOfHelper(true, type2.autobox(), subSuperMap, null);
        }
        return this.isSubtypeOfHelper(true, type2, subSuperMap, null);
    }

    private boolean isSubtypeOfHelper(boolean keepLoosenessOfThis, JSType other, SubtypeCache subSuperMap, MismatchInfo[] boxedInfo) {
        if (this.isUnknown() || other.isUnknown() || other.isTop()) {
            return true;
        }
        if (this.isTheTruthyType()) {
            return !other.makeTruthy().isBottom();
        }
        if (this.isTheFalsyType()) {
            return !other.makeFalsy().isBottom();
        }
        if (!EnumType.areSubtypes(this, other, subSuperMap)) {
            return false;
        }
        int mask = this.getMask() & 0xFFFFFFFB;
        if ((mask | other.getMask()) != other.getMask()) {
            if (boxedInfo != null && this.isUnion()) {
                JSType.whyNotUnionSubtypes(this, other, boxedInfo);
            }
            return false;
        }
        if (this.getTypeVar() != null && !this.getTypeVar().equals(other.getTypeVar())) {
            return false;
        }
        if (this.getObjs().isEmpty()) {
            return true;
        }
        boolean result = ObjectType.isUnionSubtype(keepLoosenessOfThis, this.getObjs(), other.getObjs(), subSuperMap);
        if (boxedInfo != null) {
            ObjectType.whyNotUnionSubtypes(keepLoosenessOfThis, this.getObjs(), other.getObjs(), subSuperMap, boxedInfo);
        }
        return result;
    }

    private static void whyNotUnionSubtypes(JSType found, JSType expected, MismatchInfo[] boxedInfo) {
        JSTypes commonTypes = found.commonTypes;
        if (commonTypes.NUMBER.isSubtypeOf(found) && !commonTypes.NUMBER.isSubtypeOf(expected)) {
            boxedInfo[0] = MismatchInfo.makeUnionTypeMismatch(commonTypes.NUMBER);
        } else if (commonTypes.STRING.isSubtypeOf(found) && !commonTypes.STRING.isSubtypeOf(expected)) {
            boxedInfo[0] = MismatchInfo.makeUnionTypeMismatch(commonTypes.STRING);
        } else if (commonTypes.BOOLEAN.isSubtypeOf(found) && !commonTypes.BOOLEAN.isSubtypeOf(expected)) {
            boxedInfo[0] = MismatchInfo.makeUnionTypeMismatch(commonTypes.BOOLEAN);
        } else if (commonTypes.NULL.isSubtypeOf(found) && !commonTypes.NULL.isSubtypeOf(expected)) {
            boxedInfo[0] = MismatchInfo.makeUnionTypeMismatch(commonTypes.NULL);
        } else if (commonTypes.UNDEFINED.isSubtypeOf(found) && !commonTypes.UNDEFINED.isSubtypeOf(expected)) {
            boxedInfo[0] = MismatchInfo.makeUnionTypeMismatch(commonTypes.UNDEFINED);
        } else if (found.hasTypeVariable() && !expected.hasTypeVariable()) {
            boxedInfo[0] = MismatchInfo.makeUnionTypeMismatch(JSType.fromTypeVar(found.commonTypes, found.getTypeVar()));
        } else if ((found.getMask() & 2) != 0 && (expected.getMask() & 2) == 0) {
            boxedInfo[0] = MismatchInfo.makeUnionTypeMismatch(JSType.makeType(found.commonTypes, 2, found.getObjs(), null, NO_ENUMS));
        }
    }

    public final JSType removeType(JSType other) {
        int otherMask = other.getMask();
        Preconditions.checkState((!other.isTop() && !other.isUnknown() && (otherMask & 1) == 0 && (otherMask & 4) == 0 ? 1 : 0) != 0, (String)"Requested invalid type to remove: %s", (Object)other);
        if (this.isUnknown()) {
            return this;
        }
        if (this.isTop()) {
            JSType almostTop = JSType.makeType(this.commonTypes, 506, (ImmutableSet<ObjectType>)ImmutableSet.of((Object)this.commonTypes.getTopObjectType()), null, NO_ENUMS);
            return almostTop.removeType(other);
        }
        int newMask = this.getMask() & ~otherMask;
        if ((otherMask & 2) == 0) {
            return newMask == this.getMask() ? this : JSType.makeType(this.commonTypes, newMask, this.getObjs(), this.getTypeVar(), this.getEnums());
        }
        Preconditions.checkState((other.getObjs().size() == 1 ? 1 : 0) != 0, (String)"Invalid type to remove: %s", (Object)other);
        ObjectType otherObj = (ObjectType)Iterables.getOnlyElement(other.getObjs());
        ImmutableSet.Builder objsBuilder = ImmutableSet.builder();
        for (ObjectType obj : this.getObjs()) {
            if (!obj.isLoose() && obj.isSubtypeOf(otherObj, SubtypeCache.create())) continue;
            objsBuilder.add((Object)obj);
        }
        ImmutableSet.Builder enumBuilder = ImmutableSet.builder();
        for (EnumType e : this.getEnums()) {
            if (e.getEnumeratedType().isSubtypeOf(other, SubtypeCache.create())) continue;
            enumBuilder.add((Object)e);
        }
        return JSType.makeType(this.commonTypes, newMask, (ImmutableSet<ObjectType>)objsBuilder.build(), this.getTypeVar(), (ImmutableSet<EnumType>)enumBuilder.build());
    }

    public final JSType withFunction(FunctionType ft, NominalType fnNominal) {
        Preconditions.checkNotNull((Object)ft);
        Preconditions.checkState((boolean)this.isNamespace());
        return JSType.fromObjectType(this.getObjTypeIfSingletonObj().withFunction(ft, fnNominal));
    }

    public static String createGetterPropName(String originalPropName) {
        return "%getter_fun" + originalPropName;
    }

    public static String createSetterPropName(String originalPropName) {
        return "%setter_fun" + originalPropName;
    }

    public final boolean isSingletonObj() {
        return this.getMask() == 2 && this.getObjs().size() == 1;
    }

    final boolean isSingletonObjWithNull() {
        return this.getMask() == 34 && this.getObjs().size() == 1;
    }

    final ObjectType getObjTypeIfSingletonObj() {
        return this.isSingletonObj() ? (ObjectType)Iterables.getOnlyElement(this.getObjs()) : null;
    }

    public final FunctionType getFunTypeIfSingletonObj() {
        ObjectType obj = this.getObjTypeIfSingletonObj();
        return obj == null ? null : obj.getFunType();
    }

    public final FunctionType getFunType() {
        for (ObjectType obj : this.getObjs()) {
            FunctionType ft = obj.getFunType();
            if (ft == null) continue;
            return ft;
        }
        return null;
    }

    public final NominalType getNominalTypeIfSingletonObj() {
        return this.isSingletonObj() ? ((ObjectType)Iterables.getOnlyElement(this.getObjs())).getNominalType() : null;
    }

    public final boolean isInterfaceInstance() {
        NominalType nt = this.getNominalTypeIfSingletonObj();
        return nt != null && nt.isInterface();
    }

    public final boolean isNonClassyObject() {
        NominalType nt = this.getNominalTypeIfSingletonObj();
        return nt != null && !nt.isClassy();
    }

    public final boolean isIObject() {
        NominalType nt = this.getNominalTypeIfSingletonObj();
        return nt != null && nt.isIObject();
    }

    public final boolean isInterfaceDefinition() {
        FunctionType ft = this.getFunTypeIfSingletonObj();
        return ft != null && ft.isInterfaceDefinition();
    }

    public final JSType withLoose() {
        if (this.getObjs().isEmpty()) {
            Preconditions.checkState((!this.getEnums().isEmpty() ? 1 : 0) != 0);
            return this;
        }
        ImmutableSet.Builder looseObjs = ImmutableSet.builder();
        for (ObjectType obj : this.getObjs()) {
            looseObjs.add((Object)obj.withLoose());
        }
        return JSType.makeType(this.commonTypes, this.getMask(), (ImmutableSet<ObjectType>)looseObjs.build(), this.getTypeVar(), this.getEnums());
    }

    public final JSType getProp(QualifiedName qname) {
        if (this.isBottom() || this.isUnknown() || this.isTheTruthyType()) {
            return this.commonTypes.UNKNOWN;
        }
        Preconditions.checkState((!this.getObjs().isEmpty() || !this.getEnums().isEmpty() ? 1 : 0) != 0, (String)"Can't getProp %s of type %s", (Object)qname, (Object)this);
        return JSType.nullAcceptingJoin(TypeWithPropertiesStatics.getProp(this.getObjs(), qname), TypeWithPropertiesStatics.getProp(this.getEnums(), qname));
    }

    public final JSType getDeclaredProp(QualifiedName qname) {
        if (this.isUnknown()) {
            return this.commonTypes.UNKNOWN;
        }
        Preconditions.checkState((!this.getObjs().isEmpty() || !this.getEnums().isEmpty() ? 1 : 0) != 0);
        return JSType.nullAcceptingJoin(TypeWithPropertiesStatics.getDeclaredProp(this.getObjs(), qname), TypeWithPropertiesStatics.getDeclaredProp(this.getEnums(), qname));
    }

    public final boolean mayHaveProp(QualifiedName qname) {
        return TypeWithPropertiesStatics.mayHaveProp(this.getObjs(), qname) || TypeWithPropertiesStatics.mayHaveProp(this.getEnums(), qname);
    }

    public final boolean hasProp(QualifiedName qname) {
        if (!this.getObjs().isEmpty() && !TypeWithPropertiesStatics.hasProp(this.getObjs(), qname)) {
            return false;
        }
        if (!this.getEnums().isEmpty() && !TypeWithPropertiesStatics.hasProp(this.getEnums(), qname)) {
            return false;
        }
        return !this.getEnums().isEmpty() || !this.getObjs().isEmpty();
    }

    public final boolean hasConstantProp(QualifiedName pname) {
        Preconditions.checkArgument((boolean)pname.isIdentifier());
        return TypeWithPropertiesStatics.hasConstantProp(this.getObjs(), pname) || TypeWithPropertiesStatics.hasConstantProp(this.getEnums(), pname);
    }

    @Override
    public final boolean containsArray() {
        ObjectType arrayType = this.commonTypes.getArrayInstance().getObjTypeIfSingletonObj();
        Preconditions.checkNotNull((Object)arrayType);
        for (ObjectType objType : this.getObjs()) {
            if (!objType.isSubtypeOf(arrayType, SubtypeCache.create())) continue;
            return true;
        }
        return false;
    }

    public final JSType withoutProperty(QualifiedName qname) {
        return this.getObjs().isEmpty() ? this : JSType.makeType(this.commonTypes, this.getMask(), ObjectType.withoutProperty(this.getObjs(), qname), this.getTypeVar(), this.getEnums());
    }

    public final JSType withProperty(QualifiedName qname, JSType type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0);
        if (this.isUnknown() || this.isBottom() || this.getObjs().isEmpty()) {
            return this;
        }
        ImmutableSet.Builder newObjs = ImmutableSet.builder();
        for (ObjectType obj : this.getObjs()) {
            newObjs.add((Object)obj.withProperty(qname, type));
        }
        return JSType.makeType(this.commonTypes, this.getMask(), (ImmutableSet<ObjectType>)newObjs.build(), this.getTypeVar(), this.getEnums());
    }

    public final JSType withDeclaredProperty(QualifiedName qname, JSType type, boolean isConstant) {
        Preconditions.checkState((!this.getObjs().isEmpty() ? 1 : 0) != 0);
        if (type == null && isConstant) {
            type = this.commonTypes.UNKNOWN;
        }
        ImmutableSet.Builder newObjs = ImmutableSet.builder();
        for (ObjectType obj : this.getObjs()) {
            newObjs.add((Object)obj.withDeclaredProperty(qname, type, isConstant));
        }
        return JSType.makeType(this.commonTypes, this.getMask(), (ImmutableSet<ObjectType>)newObjs.build(), this.getTypeVar(), this.getEnums());
    }

    public final JSType withPropertyRequired(String pname) {
        if (this.isUnknown() || this.getObjs().isEmpty()) {
            return this;
        }
        ImmutableSet.Builder newObjs = ImmutableSet.builder();
        for (ObjectType obj : this.getObjs()) {
            newObjs.add((Object)obj.withPropertyRequired(pname));
        }
        return JSType.makeType(this.commonTypes, this.getMask(), (ImmutableSet<ObjectType>)newObjs.build(), this.getTypeVar(), this.getEnums());
    }

    public final JSType findSubtypeWithProp(QualifiedName pname) {
        Preconditions.checkArgument((boolean)pname.isIdentifier());
        if (this.isTop() || this.isUnknown() || (this.getMask() & 2) == 0) {
            return this.commonTypes.BOTTOM;
        }
        if (this.commonTypes.NUMBER.isSubtypeOf(this) && this.commonTypes.getNumberInstance().mayHaveProp(pname) || this.commonTypes.STRING.isSubtypeOf(this) && this.commonTypes.getNumberInstance().mayHaveProp(pname) || this.commonTypes.BOOLEAN.isSubtypeOf(this) && this.commonTypes.getBooleanInstance().mayHaveProp(pname)) {
            return this.commonTypes.BOTTOM;
        }
        if ((this.getMask() & 4) != 0) {
            return this.commonTypes.BOTTOM;
        }
        if (this.getObjs().size() == 1) {
            ObjectType obj = (ObjectType)Iterables.getOnlyElement(this.getObjs());
            return obj.mayHaveProp(pname) ? this : this.commonTypes.BOTTOM;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        boolean foundObjWithProp = false;
        for (ObjectType o : this.getObjs()) {
            if (!o.mayHaveProp(pname)) continue;
            foundObjWithProp = true;
            builder.add((Object)o);
        }
        return foundObjWithProp ? JSType.makeType(this.commonTypes, 2, (ImmutableSet<ObjectType>)builder.build(), null, NO_ENUMS) : this.commonTypes.BOTTOM;
    }

    public final boolean isPropDefinedOnSubtype(QualifiedName pname) {
        Preconditions.checkArgument((boolean)pname.isIdentifier());
        for (ObjectType obj : this.getObjs()) {
            if (!obj.isPropDefinedOnSubtype(pname)) continue;
            return true;
        }
        return false;
    }

    public final String toString() {
        if (mockToString) {
            return "";
        }
        return this.appendTo(new StringBuilder(), ToStringContext.TO_STRING).toString();
    }

    StringBuilder appendTo(StringBuilder builder, ToStringContext ctx) {
        switch (this.getMask()) {
            case 0: {
                return builder.append("bottom");
            }
            case -1: {
                return builder.append("*");
            }
            case 0x7FFFFFFF: {
                return builder.append("?");
            }
        }
        int tags = this.getMask();
        boolean firstIteration = true;
        block15: for (int tag = 1; tag != 512; tag <<= 1) {
            if ((tags & tag) == 0) continue;
            if (!firstIteration) {
                builder.append('|');
            }
            firstIteration = false;
            switch (tag) {
                case 8: 
                case 16: {
                    builder.append((tags & 0x18) == 24 ? "boolean" : (tag == 8 ? "true" : "false"));
                    tags &= 0xFFFFFFE7;
                    continue block15;
                }
                case 32: {
                    builder.append("null");
                    tags &= 0xFFFFFFDF;
                    continue block15;
                }
                case 64: {
                    builder.append("number");
                    tags &= 0xFFFFFFBF;
                    continue block15;
                }
                case 128: {
                    builder.append("string");
                    tags &= 0xFFFFFF7F;
                    continue block15;
                }
                case 256: {
                    builder.append("undefined");
                    tags &= 0xFFFFFEFF;
                    continue block15;
                }
                case 1: {
                    builder.append(ctx.formatTypeVar(this.getTypeVar()));
                    tags &= 0xFFFFFFFE;
                    continue block15;
                }
                case 2: {
                    TreeSet<String> strReps;
                    if (this.getObjs().size() == 1) {
                        ((ObjectType)Iterables.getOnlyElement(this.getObjs())).appendTo(builder, ctx);
                    } else {
                        strReps = new TreeSet<String>();
                        for (ObjectType obj : this.getObjs()) {
                            strReps.add(obj.toString(ctx));
                        }
                        PIPE_JOINER.appendTo(builder, strReps);
                    }
                    tags &= 0xFFFFFFFD;
                    continue block15;
                }
                case 4: {
                    TreeSet<String> strReps;
                    if (this.getEnums().size() == 1) {
                        builder.append(((EnumType)Iterables.getOnlyElement(this.getEnums())).toString());
                    } else {
                        strReps = new TreeSet();
                        for (EnumType e : this.getEnums()) {
                            strReps.add(e.toString());
                        }
                        PIPE_JOINER.appendTo(builder, strReps);
                    }
                    tags &= 0xFFFFFFFB;
                    continue block15;
                }
                default: {
                    throw new AssertionError((Object)("Impossible: " + tag));
                }
            }
        }
        if (tags == 0) {
            return builder;
        }
        if (tags == 512) {
            return builder.append("truthy");
        }
        if (tags == 1024) {
            return builder.append("falsy");
        }
        return builder.append("Unrecognized type: ").append(tags);
    }

    @Override
    public final String toNonNullAnnotationString() {
        return this.appendTo(new StringBuilder(), ToStringContext.FOR_ANNOTATION).toString();
    }

    @Override
    public final String toAnnotationString() {
        String s = this.toNonNullAnnotationString();
        return s.startsWith("!") ? s.substring(1) : s;
    }

    @Override
    public final boolean isConstructor() {
        FunctionType ft = this.getFunTypeIfSingletonObj();
        return ft != null && ft.isUniqueConstructor();
    }

    @Override
    public final boolean isEquivalentTo(TypeI type) {
        return this.equals(type);
    }

    @Override
    public final boolean isFunctionType() {
        return this.getFunTypeIfSingletonObj() != null;
    }

    @Override
    public final boolean isInterface() {
        return this.isInterfaceDefinition();
    }

    @Override
    public final boolean isUnknownType() {
        return this.isUnknown();
    }

    @Override
    public final boolean isSomeUnknownType() {
        FunctionType ft = this.getFunTypeIfSingletonObj();
        return this.isUnknown() || this.isUnknownObject() && this.isLoose() || ft != null && ft.isTopFunction();
    }

    @Override
    public final boolean isUnresolved() {
        return false;
    }

    @Override
    public final boolean isUnresolvedOrResolvedUnknown() {
        return this.isUnknown();
    }

    @Override
    public final boolean isUnionType() {
        return this.isUnion();
    }

    @Override
    public final boolean isVoidable() {
        return !this.isTop() && (this.getMask() & 0x100) != 0;
    }

    @Override
    public final boolean isNullType() {
        return this.equals(this.commonTypes.NULL);
    }

    @Override
    public final boolean isVoidType() {
        return this.equals(this.commonTypes.UNDEFINED);
    }

    @Override
    public final TypeI restrictByNotNullOrUndefined() {
        return this.removeType(this.commonTypes.NULL_OR_UNDEFINED);
    }

    @Override
    public final FunctionTypeI toMaybeFunctionType() {
        return this.isFunctionType() ? this : null;
    }

    @Override
    public final ObjectTypeI toMaybeObjectType() {
        return this.isSingletonObj() ? this : null;
    }

    @Override
    public final ObjectTypeI autoboxAndGetObject() {
        return this.autobox().restrictByNotNullOrUndefined().toMaybeObjectType();
    }

    @Override
    public final TypeI meetWith(TypeI other) {
        return JSType.meet(this, (JSType)other);
    }

    public final boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        Preconditions.checkArgument((boolean)(o instanceof JSType), (String)"Expected newtypes.JSType but found %s", (Object)o);
        JSType t2 = (JSType)o;
        return this.getMask() == t2.getMask() && Objects.equals(this.getObjs(), t2.getObjs()) && Objects.equals(this.getEnums(), t2.getEnums()) && Objects.equals(this.getTypeVar(), t2.getTypeVar());
    }

    public final int hashCode() {
        return Objects.hash(this.getMask(), this.getObjs(), this.getEnums(), this.getTypeVar());
    }

    @Override
    public final String getDisplayName() {
        NominalType nt = this.getNominalTypeIfSingletonObj();
        if (nt != null && nt.isClassy()) {
            return nt.toString();
        }
        return this.toString();
    }

    @Override
    public final TypeI convertMethodToFunction() {
        Preconditions.checkState((boolean)this.isFunctionType());
        FunctionType devirtualized = this.getFunTypeIfSingletonObj().devirtualize();
        return this.commonTypes.fromFunctionType(devirtualized);
    }

    @Override
    public final boolean hasInstanceType() {
        Preconditions.checkState((boolean)this.isFunctionType());
        return this.getFunTypeIfSingletonObj().getInstanceTypeOfCtor() != null;
    }

    @Override
    public final ObjectTypeI getInstanceType() {
        Preconditions.checkState((boolean)this.isFunctionType());
        JSType instanceType = this.getFunTypeIfSingletonObj().getInstanceTypeOfCtor();
        return instanceType == null ? null : instanceType.toMaybeObjectType();
    }

    @Override
    public final String getReferenceName() {
        return this.isConstructor() ? this.getInstanceType().toString() : null;
    }

    @Override
    public final Node getSource() {
        if (this.isConstructor()) {
            JSType instance = this.getFunTypeIfSingletonObj().getInstanceTypeOfCtor();
            return instance.getNominalTypeIfSingletonObj().getDefSite();
        }
        return this.isSingletonObj() ? this.getNominalTypeIfSingletonObj().getDefSite() : null;
    }

    public final Collection<FunctionTypeI> getSubTypes() {
        Preconditions.checkState((this.isConstructor() || this.isInterface() ? 1 : 0) != 0);
        ImmutableList.Builder result = ImmutableList.builder();
        NominalType nt = this.getFunTypeIfSingletonObj().getInstanceTypeOfCtor().getNominalTypeIfSingletonObj();
        if (nt != null) {
            for (RawNominalType rawType : nt.getSubtypes()) {
                result.add((Object)this.commonTypes.fromFunctionType(rawType.getConstructorFunction()));
            }
        }
        return result.build();
    }

    @Override
    public final TypeI getTypeOfThis() {
        Preconditions.checkState((boolean)this.isFunctionType());
        return this.getFunTypeIfSingletonObj().getThisType();
    }

    @Override
    public final boolean acceptsArguments(List<? extends TypeI> argumentTypes) {
        Preconditions.checkState((boolean)this.isFunctionType());
        int numArgs = argumentTypes.size();
        FunctionType fnType = this.getFunTypeIfSingletonObj();
        if (numArgs < fnType.getMinArity() || numArgs > fnType.getMaxArity()) {
            return false;
        }
        for (int i = 0; i < numArgs; ++i) {
            JSType ithParamType;
            TypeI ithArgType = argumentTypes.get(i);
            if (ithArgType.isSubtypeOf(ithParamType = fnType.getFormalType(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int getMinArity() {
        Preconditions.checkState((boolean)this.isFunctionType());
        return this.getFunTypeIfSingletonObj().getMinArity();
    }

    @Override
    public final int getMaxArity() {
        Preconditions.checkState((boolean)this.isFunctionType());
        return this.getFunTypeIfSingletonObj().getMaxArity();
    }

    public final List<String> getTypeParameters() {
        Preconditions.checkState((boolean)this.isFunctionType());
        return this.getFunTypeIfSingletonObj().getTypeParameters();
    }

    @Override
    public final boolean hasProperties() {
        throw new UnsupportedOperationException("hasProperties not implemented yet");
    }

    @Override
    public final void setSource(Node n) {
        throw new UnsupportedOperationException("setSource not implemented yet");
    }

    @Override
    public final TypeI getReturnType() {
        Preconditions.checkState((boolean)this.isFunctionType());
        return this.getFunTypeIfSingletonObj().getReturnType();
    }

    @Override
    public final FunctionTypeI getConstructor() {
        Preconditions.checkState((boolean)this.isSingletonObj());
        FunctionType ctorType = this.getNominalTypeIfSingletonObj().getConstructorFunction();
        return this.commonTypes.fromFunctionType(ctorType);
    }

    @Override
    public final FunctionTypeI getSuperClassConstructor() {
        if (this.equals(this.commonTypes.getTopObject())) {
            return null;
        }
        JSType proto = this.getPrototypeObject();
        return proto == null ? null : proto.getConstructor();
    }

    @Override
    public final JSType getPrototypeObject() {
        Preconditions.checkState((boolean)this.isSingletonObj());
        JSType proto = this.getNominalTypeIfSingletonObj().getPrototypePropertyOfCtor();
        if (this.equals(proto)) {
            Preconditions.checkState((boolean)this.isBuiltinObjectPrototype(), (String)"Failed to reach Object.prototype in prototype chain, unexpected self-link found at %s", (Object)this);
            return null;
        }
        return proto;
    }

    @Override
    public final JSDocInfo getJSDocInfo() {
        return this.getSource() == null ? null : NodeUtil.getBestJSDocInfo(this.getSource());
    }

    @Override
    public final JSDocInfo getOwnPropertyJSDocInfo(String propertyName) {
        Node defsite = this.getOwnPropertyDefSite(propertyName);
        return defsite == null ? null : NodeUtil.getBestJSDocInfo(defsite);
    }

    @Override
    public final JSDocInfo getPropertyJSDocInfo(String propertyName) {
        Node defsite = this.getPropertyDefSite(propertyName);
        return defsite == null ? null : NodeUtil.getBestJSDocInfo(defsite);
    }

    @Override
    public final Node getOwnPropertyDefSite(String propertyName) {
        Preconditions.checkState((boolean)this.isSingletonObj());
        return this.getObjTypeIfSingletonObj().getOwnPropertyDefSite(propertyName);
    }

    @Override
    public final Node getPropertyDefSite(String propertyName) {
        Preconditions.checkState((boolean)this.isSingletonObj());
        return this.getObjTypeIfSingletonObj().getPropertyDefSite(propertyName);
    }

    @Override
    public final Iterable<String> getOwnPropertyNames() {
        Preconditions.checkState((boolean)this.isSingletonObj());
        Set<String> props = this.getNominalTypeIfSingletonObj().getAllOwnClassProps();
        return props;
    }

    @Override
    public final boolean isPrototypeObject() {
        return this.isSingletonObj() && this.getObjTypeIfSingletonObj().isPrototypeObject();
    }

    @Override
    public final boolean isUnknownObject() {
        if (this.isSingletonObj()) {
            ObjectType obj = this.getObjTypeIfSingletonObj();
            NominalType nt = this.getNominalTypeIfSingletonObj();
            return (nt.isBuiltinObject() || nt.isLiteralObject()) && !obj.isEnumObject() && !obj.isPrototypeObject();
        }
        return false;
    }

    final boolean isBuiltinObjectPrototype() {
        ObjectType obj = this.getObjTypeIfSingletonObj();
        return obj != null && obj.getNominalType().isBuiltinObject() && obj.isPrototypeObject();
    }

    @Override
    public final boolean isLiteralObject() {
        return this.isSingletonObj() && this.getNominalTypeIfSingletonObj().isLiteralObject();
    }

    @Override
    public final boolean isInstanceofObject() {
        if (this.isSingletonObj()) {
            NominalType nt = this.getNominalTypeIfSingletonObj();
            return nt.isLiteralObject() || nt.isBuiltinObject();
        }
        return false;
    }

    public final boolean mayContainUnknownObject() {
        for (ObjectType obj : this.getObjs()) {
            if (!obj.getNominalType().isBuiltinObject()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isInstanceType() {
        Preconditions.checkState((boolean)this.isSingletonObj());
        return this.getNominalTypeIfSingletonObj().isClassy();
    }

    @Override
    public final boolean hasProperty(String propertyName) {
        Preconditions.checkState((boolean)this.isSingletonObj());
        Preconditions.checkArgument((!propertyName.contains(".") ? 1 : 0) != 0);
        return this.hasProp(new QualifiedName(propertyName));
    }

    public final Iterable<JSType> getUnionMembers() {
        UnmodifiableIterator primitiveTypes;
        if (!this.isUnion()) {
            return ImmutableList.of((Object)this);
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (JSType primitiveType : primitiveTypes = new UnmodifiableIterator[]{this.commonTypes.BOOLEAN, this.commonTypes.NUMBER, this.commonTypes.STRING, this.commonTypes.UNDEFINED, this.commonTypes.NULL}) {
            if ((this.getMask() & primitiveType.getMask()) == 0) continue;
            builder.add((Object)primitiveType);
        }
        for (ObjectType obj : this.getObjs()) {
            builder.add((Object)JSType.fromObjectType(obj));
        }
        for (EnumType e : this.getEnums()) {
            builder.add((Object)JSType.fromEnum(e));
        }
        if (this.getTypeVar() != null) {
            builder.add((Object)JSType.fromTypeVar(this.commonTypes, this.getTypeVar()));
        }
        return builder.build();
    }

    @Override
    public final ObjectTypeI normalizeObjectForCheckAccessControls() {
        FunctionTypeI ctor;
        if (this.isSingletonObj() && (ctor = this.getConstructor()) != null) {
            return ctor.getInstanceType();
        }
        return this;
    }

    @Override
    public final boolean isBoxableScalar() {
        return this.isNumber() || this.isString() || this.isBoolean() || this.isEnumElement() && this.getEnumeratedTypeOfEnumElement().isBoxableScalar();
    }

    @Override
    public final boolean isObjectType() {
        return !this.isBottom() && !this.isUnknown() && this.isSubtypeOf(this.commonTypes.getTopObject());
    }

    @Override
    public final boolean isGenericObjectType() {
        NominalType nt = this.getNominalTypeIfSingletonObj();
        return nt != null && nt.isGeneric();
    }

    @Override
    public final Collection<ObjectTypeI> getAncestorInterfaces() {
        FunctionType funType = this.getFunTypeIfSingletonObj();
        if (!funType.isUniqueConstructor() && !funType.isInterfaceDefinition()) {
            return ImmutableSet.of();
        }
        NominalType nt = funType.getInstanceTypeOfCtor().getNominalTypeIfSingletonObj();
        HashSet<ObjectTypeI> interfaces = new HashSet<ObjectTypeI>();
        for (NominalType i : nt.getInstantiatedInterfaces()) {
            if (i.isBuiltinObject()) continue;
            interfaces.add(i.getInstanceAsJSType());
        }
        return interfaces;
    }

    @Override
    public final boolean isStructuralInterface() {
        FunctionType ft = this.getFunTypeIfSingletonObj();
        if (ft != null && ft.isSomeConstructorOrInterface()) {
            NominalType nt = ft.getThisType().getNominalTypeIfSingletonObj();
            return nt != null && nt.isStructuralInterface();
        }
        return false;
    }

    @Override
    public final boolean hasOwnProperty(String propertyName) {
        ObjectType obj = this.getObjTypeIfSingletonObj();
        return obj != null && obj.hasOwnProperty(new QualifiedName(propertyName));
    }

    @Override
    public final ObjectTypeI getRawType() {
        NominalType nt = this.getNominalTypeIfSingletonObj();
        return nt.isGeneric() ? nt.getRawNominalTypeAfterTypeChecking().getInstanceAsJSType() : null;
    }

    @Override
    public final ObjectTypeI instantiateGenericsWithUnknown() {
        NominalType nt = this.getNominalTypeIfSingletonObj();
        if (nt != null && nt.isGeneric()) {
            return nt.instantiateGenericsWithUnknown().getInstanceAsJSType();
        }
        return this;
    }

    @Override
    public final boolean isLegacyNamedType() {
        return false;
    }

    @Override
    public final TypeI getLegacyResolvedType() {
        throw new UnsupportedOperationException("NTI does not have NamedType. This method should never be called on NTI types.");
    }

    final Collection<JSType> getSubtypesWithProperty(QualifiedName qname) {
        Collection<JSType> typesWithProp = TypeWithPropertiesStatics.getSubtypesWithProperty(this.getEnums(), qname);
        typesWithProp.addAll(TypeWithPropertiesStatics.getSubtypesWithProperty(this.getObjs(), qname));
        return typesWithProp;
    }

    @Override
    public final TypeI getGreatestSubtypeWithProperty(String pname) {
        return JSType.joinManyTypes(this.commonTypes, this.getSubtypesWithProperty(new QualifiedName(pname)));
    }

    @Override
    public final ObjectTypeI getPrototypeProperty() {
        return this.getProp(new QualifiedName("prototype"));
    }

    @Override
    public final JSType getTopDefiningInterface(String pname) {
        NominalType nt = this.getNominalTypeIfSingletonObj();
        if (nt != null && nt.isInterface()) {
            return (nt = nt.getTopDefiningInterface(pname)) == null ? null : nt.getInstanceAsJSType();
        }
        return null;
    }

    @Override
    public final FunctionTypeI getOwnerFunction() {
        if (this.isPrototypeObject()) {
            return this.commonTypes.fromFunctionType(this.getObjTypeIfSingletonObj().getOwnerFunction());
        }
        return null;
    }

    @Override
    public final boolean isSubtypeWithoutStructuralTyping(TypeI other) {
        if (!this.isSubtypeOf(other)) {
            return false;
        }
        NominalType thisNt = this.getNominalTypeIfSingletonObj();
        NominalType otherNt = ((JSType)other).getNominalTypeIfSingletonObj();
        return thisNt == null || otherNt == null || thisNt.isNominalSubtypeOf(otherNt);
    }

    @Override
    public final Iterable<TypeI> getParameterTypes() {
        return ((FunctionType)Preconditions.checkNotNull((Object)this.getFunType())).getParameterTypes();
    }

    @Override
    public TypeI getPropertyType(String propName) {
        return this.isObjectType() ? this.getProp(new QualifiedName(propName)) : null;
    }

    @Override
    public boolean isRecordType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasUninstantiatedTypeVariables() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableList<? extends TypeI> getTemplateTypes() {
        NominalType nt = this.getNominalTypeIfSingletonObj();
        if (nt.isGeneric()) {
            ImmutableList.Builder builder = ImmutableList.builder();
            return builder.addAll(nt.getTypeMap().values()).build();
        }
        return null;
    }

    private static final class NullableObjsType
    extends JSType {
        transient Collection<ObjectType> objs;

        NullableObjsType(JSTypes commonTypes, ImmutableSet<ObjectType> objs) {
            super(commonTypes);
            this.objs = (Collection)Preconditions.checkNotNull(objs);
        }

        @Override
        protected int getMask() {
            return 34;
        }

        @Override
        protected String getTypeVar() {
            return null;
        }

        @Override
        protected ImmutableSet<ObjectType> getObjs() {
            Preconditions.checkNotNull(this.objs);
            if (!(this.objs instanceof ImmutableSet)) {
                this.objs = ImmutableSet.copyOf(this.objs);
            }
            return (ImmutableSet)this.objs;
        }

        @Override
        protected ImmutableSet<EnumType> getEnums() {
            return ImmutableSet.of();
        }

        @GwtIncompatible(value="ObjectOutputStream")
        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeObject(new ArrayList<ObjectType>(this.objs));
        }

        @GwtIncompatible(value="ObjectInputStream")
        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.objs = (ArrayList)in.readObject();
        }
    }

    private static final class ObjsType
    extends JSType {
        transient Collection<ObjectType> objs;

        ObjsType(JSTypes commonTypes, ImmutableSet<ObjectType> objs) {
            super(commonTypes);
            this.objs = (Collection)Preconditions.checkNotNull(objs);
        }

        @Override
        protected int getMask() {
            return 2;
        }

        @Override
        protected String getTypeVar() {
            return null;
        }

        @Override
        protected ImmutableSet<ObjectType> getObjs() {
            Preconditions.checkNotNull(this.objs);
            if (!(this.objs instanceof ImmutableSet)) {
                this.objs = ImmutableSet.copyOf(this.objs);
            }
            return (ImmutableSet)this.objs;
        }

        @Override
        protected ImmutableSet<EnumType> getEnums() {
            return ImmutableSet.of();
        }

        @GwtIncompatible(value="ObjectOutputStream")
        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeObject(new ArrayList<ObjectType>(this.objs));
        }

        @GwtIncompatible(value="ObjectInputStream")
        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.objs = (ArrayList)in.readObject();
        }
    }

    private static final class MaskType
    extends JSType {
        final int mask;

        MaskType(JSTypes commonTypes, int mask) {
            super(commonTypes);
            this.mask = mask;
        }

        @Override
        protected int getMask() {
            return this.mask;
        }

        @Override
        protected ImmutableSet<ObjectType> getObjs() {
            return ImmutableSet.of();
        }

        @Override
        protected String getTypeVar() {
            return null;
        }

        @Override
        protected ImmutableSet<EnumType> getEnums() {
            return ImmutableSet.of();
        }
    }

    private static final class UnionType
    extends JSType {
        final int mask;
        transient Collection<ObjectType> objs;
        final String typeVar;
        transient Collection<EnumType> enums;

        UnionType(JSTypes commonTypes, int mask, ImmutableSet<ObjectType> objs, String typeVar, ImmutableSet<EnumType> enums) {
            super(commonTypes);
            this.enums = (Collection)Preconditions.checkNotNull(enums);
            this.objs = (Collection)Preconditions.checkNotNull(objs);
            if (typeVar != null) {
                mask |= 1;
            }
            this.typeVar = typeVar;
            this.mask = mask;
            if (!this.isValidType()) {
                throw new IllegalStateException(SimpleFormat.format("Cannot create type with bits <<<%x>>>, objs <<<%s>>>, typeVar <<<%s>>>, enums <<<%s>>>", mask, objs, typeVar, enums));
            }
        }

        @Override
        protected int getMask() {
            return this.mask;
        }

        @Override
        protected String getTypeVar() {
            return this.typeVar;
        }

        @Override
        protected ImmutableSet<ObjectType> getObjs() {
            Preconditions.checkNotNull(this.objs);
            if (!(this.objs instanceof ImmutableSet)) {
                this.objs = ImmutableSet.copyOf(this.objs);
            }
            return (ImmutableSet)this.objs;
        }

        @Override
        protected ImmutableSet<EnumType> getEnums() {
            Preconditions.checkNotNull(this.enums);
            if (!(this.enums instanceof ImmutableSet)) {
                this.enums = ImmutableSet.copyOf(this.enums);
            }
            return (ImmutableSet)this.enums;
        }

        @GwtIncompatible(value="ObjectOutputStream")
        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeObject(new ArrayList<ObjectType>(this.objs));
            out.writeObject(new ArrayList<EnumType>(this.enums));
        }

        @GwtIncompatible(value="ObjectInputStream")
        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.objs = (ArrayList)in.readObject();
            this.enums = (ArrayList)in.readObject();
        }
    }
}

