/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.newtypes.DeclaredTypeRegistry;
import com.google.javascript.jscomp.newtypes.EnumType;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.Namespace;
import com.google.javascript.jscomp.newtypes.RawNominalType;
import com.google.javascript.jscomp.newtypes.Typedef;

public class Declaration {
    private final JSType simpleType;
    private final Typedef typedef;
    private final Namespace ns;
    private final DeclaredTypeRegistry funScope;
    private final boolean isTypeVar;
    private final boolean isConstant;

    public Declaration(JSType simpleType, Typedef typedef, Namespace ns, DeclaredTypeRegistry funScope, boolean isTypeVar, boolean isConstant) {
        this.simpleType = simpleType;
        this.typedef = typedef;
        this.ns = ns;
        this.funScope = funScope;
        this.isTypeVar = isTypeVar;
        this.isConstant = isConstant;
        this.checkValid();
    }

    private void checkValid() {
        if (this.simpleType != null) {
            Preconditions.checkState((this.typedef == null ? 1 : 0) != 0);
        }
        if (this.typedef != null) {
            Preconditions.checkState((this.simpleType == null && this.ns == null && this.funScope == null ? 1 : 0) != 0);
        }
        if (this.ns != null) {
            Preconditions.checkState((this.typedef == null ? 1 : 0) != 0);
        }
        if (this.funScope != null) {
            Preconditions.checkState((this.typedef == null ? 1 : 0) != 0);
        }
    }

    public JSType getTypeOfSimpleDecl() {
        return this.simpleType;
    }

    public Typedef getTypedef() {
        return this.typedef;
    }

    public EnumType getEnum() {
        return this.ns instanceof EnumType ? (EnumType)this.ns : null;
    }

    public DeclaredTypeRegistry getFunctionScope() {
        return this.funScope;
    }

    public RawNominalType getNominal() {
        return this.ns instanceof RawNominalType ? (RawNominalType)this.ns : null;
    }

    public boolean isTypeVar() {
        return this.isTypeVar;
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    public Namespace getNamespace() {
        return this.ns;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("simpleType", (Object)this.simpleType).add("typedef", (Object)this.typedef).add("namespace", (Object)this.ns).add("scope", (Object)this.funScope).toString();
    }
}

