/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.parsing.TypeTransformationParser;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.ObjectTypeI;
import com.google.javascript.rhino.TypeI;
import com.google.javascript.rhino.TypeIEnv;
import com.google.javascript.rhino.TypeIRegistry;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

class TypeTransformation {
    static final DiagnosticType UNKNOWN_TYPEVAR = DiagnosticType.warning("TYPEVAR_UNDEFINED", "Reference to an unknown type variable {0}");
    static final DiagnosticType UNKNOWN_STRVAR = DiagnosticType.warning("UNKNOWN_STRVAR", "Reference to an unknown string variable {0}");
    static final DiagnosticType UNKNOWN_TYPENAME = DiagnosticType.warning("TYPENAME_UNDEFINED", "Reference to an unknown type name {0}");
    static final DiagnosticType BASETYPE_INVALID = DiagnosticType.warning("BASETYPE_INVALID", "The type {0} cannot be templatized");
    static final DiagnosticType TEMPTYPE_INVALID = DiagnosticType.warning("TEMPTYPE_INVALID", "Expected templatized type in {0} found {1}");
    static final DiagnosticType INDEX_OUTOFBOUNDS = DiagnosticType.warning("INDEX_OUTOFBOUNDS", "Index out of bounds in templateTypeOf: {0} >= {1}");
    static final DiagnosticType DUPLICATE_VARIABLE = DiagnosticType.warning("DUPLICATE_VARIABLE", "The variable {0} is already defined");
    static final DiagnosticType UNKNOWN_NAMEVAR = DiagnosticType.warning("UNKNOWN_NAMEVAR", "Reference to an unknown name variable {0}");
    static final DiagnosticType RECTYPE_INVALID = DiagnosticType.warning("RECTYPE_INVALID", "The first parameter of a maprecord must be a record type, found {0}");
    static final DiagnosticType MAPRECORD_BODY_INVALID = DiagnosticType.warning("MAPRECORD_BODY_INVALID", "The body of a maprecord function must evaluate to a record type or a no type, found {0}");
    static final DiagnosticType VAR_UNDEFINED = DiagnosticType.warning("VAR_UNDEFINED", "Variable {0} is undefined in the scope");
    static final DiagnosticType INVALID_CTOR = DiagnosticType.warning("INVALID_CTOR", "Expected a constructor type, found {0}");
    static final DiagnosticType RECPARAM_INVALID = DiagnosticType.warning("RECPARAM_INVALID", "Expected a record type, found {0}");
    static final DiagnosticType PROPTYPE_INVALID = DiagnosticType.warning("PROPTYPE_INVALID", "Expected object type, found {0}");
    private final AbstractCompiler compiler;
    private final TypeIRegistry registry;
    private final TypeIEnv<TypeI> typeEnv;

    TypeTransformation(AbstractCompiler compiler, TypeIEnv<? extends TypeI> typeEnv) {
        this.compiler = compiler;
        this.registry = compiler.getTypeRegistry();
        this.typeEnv = typeEnv;
    }

    private boolean isTypeVar(Node n) {
        return n.isName();
    }

    private boolean isTypeName(Node n) {
        return n.isString();
    }

    private boolean isBooleanOperation(Node n) {
        return n.isAnd() || n.isOr() || n.isNot();
    }

    private TypeTransformationParser.Keywords nameToKeyword(String s) {
        return TypeTransformationParser.Keywords.valueOf(s.toUpperCase());
    }

    private TypeI getType(String typeName) {
        TypeI type = this.typeEnv.getType(typeName);
        JSDocInfo jsdoc = this.typeEnv.getJsdocOfTypeDeclaration(typeName);
        if (type != null) {
            if (type.isConstructor() || type.isInterface()) {
                return type.toMaybeFunctionType().getInstanceType();
            }
            if (type.isEnumElement()) {
                return type.getEnumeratedTypeOfEnumElement();
            }
        } else if (jsdoc != null && jsdoc.hasTypedefType()) {
            return this.registry.evaluateTypeExpression(jsdoc.getTypedefType(), this.typeEnv);
        }
        return this.registry.getType(typeName);
    }

    private TypeI getUnknownType() {
        return this.registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE);
    }

    private TypeI getNoType() {
        return this.registry.getNativeObjectType(JSTypeNative.NO_TYPE);
    }

    private TypeI getAllType() {
        return this.registry.getNativeType(JSTypeNative.ALL_TYPE);
    }

    private TypeI getObjectType() {
        return this.registry.getNativeType(JSTypeNative.OBJECT_TYPE);
    }

    private TypeI createUnionType(TypeI[] variants) {
        return this.registry.createUnionType(Arrays.asList(variants));
    }

    private TypeI createTemplatizedType(ObjectTypeI baseType, TypeI[] params) {
        return this.registry.instantiateGenericType(baseType, (ImmutableList<? extends TypeI>)ImmutableList.copyOf((Object[])params));
    }

    private TypeI createRecordType(ImmutableMap<String, TypeI> props) {
        return this.registry.createRecordType((Map<String, ? extends TypeI>)props);
    }

    private void reportWarning(Node n, DiagnosticType msg, String ... param) {
        this.compiler.report(JSError.make(n, msg, param));
    }

    private <T> ImmutableMap<String, T> addNewEntry(ImmutableMap<String, T> map, String name, T type) {
        return new ImmutableMap.Builder().putAll(map).put((Object)name, type).build();
    }

    private String getFunctionParameter(Node n, int i) {
        Preconditions.checkArgument((boolean)n.isFunction(), (String)"Expected a function node, found %s", (Object)n);
        return n.getSecondChild().getChildAtIndex(i).getString();
    }

    private Node getFunctionBody(Node n) {
        Preconditions.checkArgument((boolean)n.isFunction(), (String)"Expected a function node, found %s", (Object)n);
        return n.getChildAtIndex(2);
    }

    private String getCallName(Node n) {
        Preconditions.checkArgument((boolean)n.isCall(), (String)"Expected a call node, found %s", (Object)n);
        return n.getFirstChild().getString();
    }

    private Node getCallArgument(Node n, int i) {
        Preconditions.checkArgument((boolean)n.isCall(), (String)"Expected a call node, found %s", (Object)n);
        return n.getChildAtIndex(i + 1);
    }

    private int getCallParamCount(Node n) {
        Preconditions.checkArgument((boolean)n.isCall(), (String)"Expected a call node, found %s", (Object)n);
        return n.getChildCount() - 1;
    }

    private ImmutableList<Node> getCallParams(Node n) {
        Preconditions.checkArgument((boolean)n.isCall(), (String)"Expected a call node, found %s", (Object)n);
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (int i = 0; i < this.getCallParamCount(n); ++i) {
            builder.add((Object)this.getCallArgument(n, i));
        }
        return builder.build();
    }

    private Node getComputedPropValue(Node n) {
        Preconditions.checkArgument((boolean)n.isComputedProp(), (String)"Expected a computed property node, found %s", (Object)n);
        return n.getSecondChild();
    }

    private String getComputedPropName(Node n) {
        Preconditions.checkArgument((boolean)n.isComputedProp(), (String)"Expected a computed property node, found %s", (Object)n);
        return n.getFirstChild().getString();
    }

    TypeI eval(Node ttlAst, ImmutableMap<String, TypeI> typeVars) {
        return this.eval(ttlAst, typeVars, (ImmutableMap<String, String>)ImmutableMap.of());
    }

    TypeI eval(Node ttlAst, ImmutableMap<String, TypeI> typeVars, ImmutableMap<String, String> nameVars) {
        return this.evalInternal(ttlAst, new NameResolver(typeVars, nameVars));
    }

    private TypeI evalInternal(Node ttlAst, NameResolver nameResolver) {
        if (this.isTypeName(ttlAst)) {
            return this.evalTypeName(ttlAst);
        }
        if (this.isTypeVar(ttlAst)) {
            return this.evalTypeVar(ttlAst, nameResolver);
        }
        String name = this.getCallName(ttlAst);
        TypeTransformationParser.Keywords keyword = this.nameToKeyword(name);
        switch (keyword.kind) {
            case TYPE_CONSTRUCTOR: {
                return this.evalTypeExpression(ttlAst, nameResolver);
            }
            case OPERATION: {
                return this.evalOperationExpression(ttlAst, nameResolver);
            }
        }
        throw new IllegalStateException("Could not evaluate the type transformation expression");
    }

    private TypeI evalOperationExpression(Node ttlAst, NameResolver nameResolver) {
        String name = this.getCallName(ttlAst);
        TypeTransformationParser.Keywords keyword = this.nameToKeyword(name);
        switch (keyword) {
            case COND: {
                return this.evalConditional(ttlAst, nameResolver);
            }
            case MAPUNION: {
                return this.evalMapunion(ttlAst, nameResolver);
            }
            case MAPRECORD: {
                return this.evalMaprecord(ttlAst, nameResolver);
            }
            case TYPEOFVAR: {
                return this.evalTypeOfVar(ttlAst);
            }
            case INSTANCEOF: {
                return this.evalInstanceOf(ttlAst, nameResolver);
            }
            case PRINTTYPE: {
                return this.evalPrintType(ttlAst, nameResolver);
            }
            case PROPTYPE: {
                return this.evalPropType(ttlAst, nameResolver);
            }
        }
        throw new IllegalStateException("Invalid type transformation operation");
    }

    private TypeI evalTypeExpression(Node ttlAst, NameResolver nameResolver) {
        String name = this.getCallName(ttlAst);
        TypeTransformationParser.Keywords keyword = this.nameToKeyword(name);
        switch (keyword) {
            case TYPE: {
                return this.evalTemplatizedType(ttlAst, nameResolver);
            }
            case UNION: {
                return this.evalUnionType(ttlAst, nameResolver);
            }
            case NONE: {
                return this.getNoType();
            }
            case ALL: {
                return this.getAllType();
            }
            case UNKNOWN: {
                return this.getUnknownType();
            }
            case RAWTYPEOF: {
                return this.evalRawTypeOf(ttlAst, nameResolver);
            }
            case TEMPLATETYPEOF: {
                return this.evalTemplateTypeOf(ttlAst, nameResolver);
            }
            case RECORD: {
                return this.evalRecordType(ttlAst, nameResolver);
            }
            case TYPEEXPR: {
                return this.evalNativeTypeExpr(ttlAst);
            }
        }
        throw new IllegalStateException("Invalid type expression");
    }

    private TypeI evalTypeName(Node ttlAst) {
        String typeName = ttlAst.getString();
        TypeI resultingType = this.getType(typeName);
        if (resultingType == null) {
            this.reportWarning(ttlAst, UNKNOWN_TYPENAME, typeName);
            return this.getUnknownType();
        }
        return resultingType;
    }

    private TypeI evalTemplatizedType(Node ttlAst, NameResolver nameResolver) {
        ImmutableList<Node> params = this.getCallParams(ttlAst);
        TypeI firstParam = this.evalInternal((Node)params.get(0), nameResolver);
        if (!firstParam.hasUninstantiatedTypeVariables()) {
            this.reportWarning(ttlAst, BASETYPE_INVALID, firstParam.toString());
            return this.getUnknownType();
        }
        TypeI[] templatizedTypes = new TypeI[params.size() - 1];
        for (int i = 0; i < templatizedTypes.length; ++i) {
            templatizedTypes[i] = this.evalInternal((Node)params.get(i + 1), nameResolver);
        }
        ObjectTypeI baseType = firstParam.toMaybeObjectType();
        return this.createTemplatizedType(baseType, templatizedTypes);
    }

    private TypeI evalTypeVar(Node ttlAst, NameResolver nameResolver) {
        String typeVar = ttlAst.getString();
        TypeI resultingType = (TypeI)nameResolver.typeVars.get((Object)typeVar);
        if (resultingType == null) {
            this.reportWarning(ttlAst, UNKNOWN_TYPEVAR, typeVar);
            return this.getUnknownType();
        }
        return resultingType;
    }

    private TypeI evalUnionType(Node ttlAst, NameResolver nameResolver) {
        ImmutableList<Node> params = this.getCallParams(ttlAst);
        int paramCount = params.size();
        TypeI[] basicTypes = new TypeI[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            basicTypes[i] = this.evalInternal((Node)params.get(i), nameResolver);
        }
        return this.createUnionType(basicTypes);
    }

    private TypeI[] evalTypeParams(Node ttlAst, NameResolver nameResolver) {
        ImmutableList<Node> params = this.getCallParams(ttlAst);
        int paramCount = params.size();
        TypeI[] result = new TypeI[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            result[i] = this.evalInternal((Node)params.get(i), nameResolver);
        }
        return result;
    }

    private String evalString(Node ttlAst, NameResolver nameResolver) {
        if (ttlAst.isName()) {
            if (!nameResolver.nameVars.containsKey((Object)ttlAst.getString())) {
                this.reportWarning(ttlAst, UNKNOWN_STRVAR, ttlAst.getString());
                return "";
            }
            return (String)nameResolver.nameVars.get((Object)ttlAst.getString());
        }
        return ttlAst.getString();
    }

    private String[] evalStringParams(Node ttlAst, NameResolver nameResolver) {
        ImmutableList<Node> params = this.getCallParams(ttlAst);
        int paramCount = params.size();
        String[] result = new String[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            result[i] = this.evalString((Node)params.get(i), nameResolver);
        }
        return result;
    }

    private boolean evalTypePredicate(Node ttlAst, NameResolver nameResolver) {
        TypeI[] params = this.evalTypeParams(ttlAst, nameResolver);
        String name = this.getCallName(ttlAst);
        TypeTransformationParser.Keywords keyword = this.nameToKeyword(name);
        TypeI type = params[0];
        switch (keyword) {
            case EQ: {
                return type.isEquivalentTo(params[1]);
            }
            case SUB: {
                return type.isSubtypeOf(params[1]);
            }
            case ISCTOR: {
                return type.isConstructor();
            }
            case ISTEMPLATIZED: {
                return type.isObjectType() && type.toMaybeObjectType().isGenericObjectType();
            }
            case ISRECORD: {
                return type.isRecordType();
            }
            case ISUNKNOWN: {
                return type.isSomeUnknownType();
            }
        }
        throw new IllegalStateException("Invalid type predicate in the type transformation");
    }

    private boolean evalStringPredicate(Node ttlAst, NameResolver nameResolver) {
        String[] params = this.evalStringParams(ttlAst, nameResolver);
        for (int i = 0; i < params.length; ++i) {
            if (!params[i].isEmpty()) continue;
            return false;
        }
        String name = this.getCallName(ttlAst);
        TypeTransformationParser.Keywords keyword = this.nameToKeyword(name);
        switch (keyword) {
            case STREQ: {
                return params[0].equals(params[1]);
            }
        }
        throw new IllegalStateException("Invalid string predicate in the type transformation");
    }

    private boolean evalTypevarPredicate(Node ttlAst, NameResolver nameResolver) {
        String name = this.getCallName(ttlAst);
        TypeTransformationParser.Keywords keyword = this.nameToKeyword(name);
        switch (keyword) {
            case ISDEFINED: {
                return nameResolver.typeVars.containsKey((Object)this.getCallArgument(ttlAst, 0).getString());
            }
        }
        throw new IllegalStateException("Invalid typevar predicate in the type transformation");
    }

    private boolean evalBooleanOperation(Node ttlAst, NameResolver nameResolver) {
        boolean param0 = this.evalBoolean(ttlAst.getFirstChild(), nameResolver);
        if (ttlAst.isNot()) {
            return !param0;
        }
        if (ttlAst.isAnd()) {
            return param0 && this.evalBoolean(ttlAst.getLastChild(), nameResolver);
        }
        if (ttlAst.isOr()) {
            return param0 || this.evalBoolean(ttlAst.getLastChild(), nameResolver);
        }
        throw new IllegalStateException("Invalid boolean predicate in the type transformation");
    }

    private boolean evalBoolean(Node ttlAst, NameResolver nameResolver) {
        if (this.isBooleanOperation(ttlAst)) {
            return this.evalBooleanOperation(ttlAst, nameResolver);
        }
        String name = this.getCallName(ttlAst);
        TypeTransformationParser.Keywords keyword = this.nameToKeyword(name);
        switch (keyword.kind) {
            case STRING_PREDICATE: {
                return this.evalStringPredicate(ttlAst, nameResolver);
            }
            case TYPE_PREDICATE: {
                return this.evalTypePredicate(ttlAst, nameResolver);
            }
            case TYPEVAR_PREDICATE: {
                return this.evalTypevarPredicate(ttlAst, nameResolver);
            }
        }
        throw new IllegalStateException("Invalid boolean predicate in the type transformation");
    }

    private TypeI evalConditional(Node ttlAst, NameResolver nameResolver) {
        ImmutableList<Node> params = this.getCallParams(ttlAst);
        if (this.evalBoolean((Node)params.get(0), nameResolver)) {
            return this.evalInternal((Node)params.get(1), nameResolver);
        }
        return this.evalInternal((Node)params.get(2), nameResolver);
    }

    private TypeI evalMapunion(Node ttlAst, NameResolver nameResolver) {
        ImmutableList<Node> params = this.getCallParams(ttlAst);
        Node unionParam = (Node)params.get(0);
        Node mapFunction = (Node)params.get(1);
        String paramName = this.getFunctionParameter(mapFunction, 0);
        if (nameResolver.typeVars.containsKey((Object)paramName)) {
            this.reportWarning(ttlAst, DUPLICATE_VARIABLE, paramName);
            return this.getUnknownType();
        }
        Node mapFunctionBody = this.getFunctionBody(mapFunction);
        TypeI unionType = this.evalInternal(unionParam, nameResolver);
        if (!unionType.isUnionType()) {
            NameResolver newNameResolver = new NameResolver(this.addNewEntry(nameResolver.typeVars, paramName, unionType), nameResolver.nameVars);
            return this.evalInternal(mapFunctionBody, newNameResolver);
        }
        ImmutableList unionElms = ImmutableList.copyOf(unionType.getUnionMembers());
        int unionSize = unionElms.size();
        TypeI[] newUnionElms = new TypeI[unionSize];
        int i = 0;
        for (TypeI elm : unionElms) {
            NameResolver newNameResolver = new NameResolver(this.addNewEntry(nameResolver.typeVars, paramName, elm), nameResolver.nameVars);
            newUnionElms[i] = this.evalInternal(mapFunctionBody, newNameResolver);
            ++i;
        }
        return this.createUnionType(newUnionElms);
    }

    private TypeI evalRawTypeOf(Node ttlAst, NameResolver nameResolver) {
        ImmutableList<Node> params = this.getCallParams(ttlAst);
        TypeI type = this.evalInternal((Node)params.get(0), nameResolver);
        if (!type.isGenericObjectType()) {
            this.reportWarning(ttlAst, TEMPTYPE_INVALID, "rawTypeOf", type.toString());
            return this.getUnknownType();
        }
        return type.toMaybeObjectType().getRawType();
    }

    private TypeI evalTemplateTypeOf(Node ttlAst, NameResolver nameResolver) {
        ImmutableList<? extends TypeI> templateTypes;
        ImmutableList<Node> params = this.getCallParams(ttlAst);
        TypeI type = this.evalInternal((Node)params.get(0), nameResolver);
        if (!type.isGenericObjectType()) {
            this.reportWarning(ttlAst, TEMPTYPE_INVALID, "templateTypeOf", type.toString());
            return this.getUnknownType();
        }
        int index = (int)((Node)params.get(1)).getDouble();
        if (index >= (templateTypes = type.toMaybeObjectType().getTemplateTypes()).size()) {
            this.reportWarning(ttlAst, INDEX_OUTOFBOUNDS, Integer.toString(index), Integer.toString(templateTypes.size()));
            return this.getUnknownType();
        }
        return (TypeI)templateTypes.get(index);
    }

    private TypeI evalRecord(Node record, NameResolver nameResolver) {
        HashMap<String, TypeI> props = new HashMap<String, TypeI>();
        for (Node propNode : record.children()) {
            if (propNode.isComputedProp()) {
                String compPropName = this.getComputedPropName(propNode);
                if (!nameResolver.nameVars.containsKey((Object)compPropName)) {
                    this.reportWarning(record, UNKNOWN_NAMEVAR, compPropName);
                    return this.getUnknownType();
                }
                Node propValue = this.getComputedPropValue(propNode);
                String resolvedName = (String)nameResolver.nameVars.get((Object)compPropName);
                TypeI resultingType = this.evalInternal(propValue, nameResolver);
                props.put(resolvedName, resultingType);
                continue;
            }
            String propName = propNode.getString();
            TypeI resultingType = this.evalInternal(propNode.getFirstChild(), nameResolver);
            props.put(propName, resultingType);
        }
        return this.registry.createRecordType(props);
    }

    private TypeI evalRecordParam(Node ttlAst, NameResolver nameResolver) {
        if (ttlAst.isObjectLit()) {
            return this.evalRecord(ttlAst, nameResolver);
        }
        return this.evalInternal(ttlAst, nameResolver);
    }

    private TypeI evalRecordType(Node ttlAst, NameResolver nameResolver) {
        int paramCount = this.getCallParamCount(ttlAst);
        ImmutableList.Builder recTypesBuilder = new ImmutableList.Builder();
        for (int i = 0; i < paramCount; ++i) {
            TypeI type = this.evalRecordParam(this.getCallArgument(ttlAst, i), nameResolver);
            ObjectTypeI objType = type.toMaybeObjectType();
            if (objType == null || objType.isUnknownType()) {
                this.reportWarning(ttlAst, RECPARAM_INVALID, type.toString());
                return this.getUnknownType();
            }
            TypeI recType = this.registry.buildRecordTypeFromObject(objType);
            if (recType.isEquivalentTo(this.getObjectType())) continue;
            recTypesBuilder.add((Object)recType.toMaybeObjectType());
        }
        return this.joinRecordTypes((ImmutableList<ObjectTypeI>)recTypesBuilder.build());
    }

    private void putNewPropInPropertyMap(Map<String, TypeI> props, String newPropName, TypeI newPropValue) {
        if (!(props.containsKey(newPropName) && newPropValue.isRecordType() && props.get(newPropName).isRecordType())) {
            props.put(newPropName, newPropValue);
            return;
        }
        props.put(newPropName, this.joinRecordTypes((ImmutableList<ObjectTypeI>)ImmutableList.of((Object)((ObjectTypeI)props.get(newPropName)), (Object)((ObjectTypeI)newPropValue))));
    }

    private TypeI joinRecordTypes(ImmutableList<ObjectTypeI> recTypes) {
        LinkedHashMap<String, TypeI> props = new LinkedHashMap<String, TypeI>();
        for (ObjectTypeI recType : recTypes) {
            for (String newPropName : recType.getOwnPropertyNames()) {
                TypeI newPropValue = recType.getPropertyType(newPropName);
                this.putNewPropInPropertyMap(props, newPropName, newPropValue);
            }
        }
        return this.createRecordType((ImmutableMap<String, TypeI>)ImmutableMap.copyOf(props));
    }

    private TypeI evalMaprecord(Node ttlAst, NameResolver nameResolver) {
        ImmutableList<Node> params = this.getCallParams(ttlAst);
        TypeI type = this.evalInternal((Node)params.get(0), nameResolver);
        if (type.isEquivalentTo(this.getObjectType())) {
            return this.getObjectType();
        }
        if (!type.isRecordType()) {
            this.reportWarning((Node)params.get(0), RECTYPE_INVALID, type.toString());
            return this.getUnknownType();
        }
        ObjectTypeI objtype = type.toMaybeObjectType();
        Node mapFunction = (Node)params.get(1);
        String paramKey = this.getFunctionParameter(mapFunction, 0);
        String paramValue = this.getFunctionParameter(mapFunction, 1);
        if (nameResolver.nameVars.containsKey((Object)paramKey)) {
            this.reportWarning(ttlAst, DUPLICATE_VARIABLE, paramKey);
            return this.getUnknownType();
        }
        if (nameResolver.typeVars.containsKey((Object)paramValue)) {
            this.reportWarning(ttlAst, DUPLICATE_VARIABLE, paramValue);
            return this.getUnknownType();
        }
        Node mapFnBody = this.getFunctionBody(mapFunction);
        LinkedHashMap<String, TypeI> newProps = new LinkedHashMap<String, TypeI>();
        for (String propName : objtype.getOwnPropertyNames()) {
            TypeI propValue = objtype.getPropertyType(propName);
            NameResolver newNameResolver = new NameResolver(this.addNewEntry(nameResolver.typeVars, paramValue, propValue), this.addNewEntry(nameResolver.nameVars, paramKey, propName));
            TypeI body = this.evalInternal(mapFnBody, newNameResolver);
            if (body.isUnknownType()) {
                return this.getUnknownType();
            }
            if (body.isBottom() || body.isEquivalentTo(this.getObjectType())) continue;
            if (!body.isRecordType()) {
                this.reportWarning(ttlAst, MAPRECORD_BODY_INVALID, body.toString());
                return this.getUnknownType();
            }
            ObjectTypeI bodyAsObj = body.toMaybeObjectType();
            for (String newPropName : bodyAsObj.getOwnPropertyNames()) {
                TypeI newPropValue = bodyAsObj.getPropertyType(newPropName);
                this.putNewPropInPropertyMap(newProps, newPropName, newPropValue);
            }
        }
        return this.createRecordType((ImmutableMap<String, TypeI>)ImmutableMap.copyOf(newProps));
    }

    private TypeI evalTypeOfVar(Node ttlAst) {
        String name = this.getCallArgument(ttlAst, 0).getString();
        TypeI type = this.typeEnv.getType(name);
        if (type == null) {
            this.reportWarning(ttlAst, VAR_UNDEFINED, name);
            return this.getUnknownType();
        }
        return type;
    }

    private TypeI evalInstanceOf(Node ttlAst, NameResolver nameResolver) {
        TypeI type = this.evalInternal(this.getCallArgument(ttlAst, 0), nameResolver);
        if (type.isUnknownType() || !type.isConstructor()) {
            this.reportWarning(ttlAst, INVALID_CTOR, type.getDisplayName());
            return this.getUnknownType();
        }
        return type.toMaybeFunctionType().getInstanceType();
    }

    private TypeI evalNativeTypeExpr(Node ttlAst) {
        JSTypeExpression expr = new JSTypeExpression(this.getCallArgument(ttlAst, 0), "");
        return this.registry.evaluateTypeExpression(expr, this.typeEnv);
    }

    private TypeI evalPrintType(Node ttlAst, NameResolver nameResolver) {
        TypeI type = this.evalInternal(this.getCallArgument(ttlAst, 1), nameResolver);
        String msg = this.getCallArgument(ttlAst, 0).getString() + type;
        System.out.println(msg);
        return type;
    }

    private TypeI evalPropType(Node ttlAst, NameResolver nameResolver) {
        TypeI type = this.evalInternal(this.getCallArgument(ttlAst, 1), nameResolver);
        ObjectTypeI objType = type.toMaybeObjectType();
        if (objType == null) {
            this.reportWarning(ttlAst, PROPTYPE_INVALID, type.toString());
            return this.getUnknownType();
        }
        return objType.getPropertyType(this.getCallArgument(ttlAst, 0).getString());
    }

    private static class NameResolver {
        ImmutableMap<String, TypeI> typeVars;
        ImmutableMap<String, String> nameVars;

        NameResolver(ImmutableMap<String, TypeI> typeVars, ImmutableMap<String, String> nameVars) {
            this.typeVars = typeVars;
            this.nameVars = nameVars;
        }
    }
}

