/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.debugging.sourcemap.SourceMapConsumerV3;
import com.google.debugging.sourcemap.SourceMapParseException;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.SourceFile;
import java.io.IOException;
import javax.annotation.Nullable;

public final class SourceMapInput {
    private final SourceFile sourceFile;
    private volatile SourceMapConsumerV3 parsedSourceMap = null;
    private volatile boolean cached = false;
    static final DiagnosticType SOURCEMAP_RESOLVE_FAILED = DiagnosticType.warning("SOURCEMAP_RESOLVE_FAILED", "Failed to resolve sourcemap: {0}");
    static final DiagnosticType SOURCEMAP_PARSE_FAILED = DiagnosticType.warning("SOURCEMAP_PARSE_FAILED", "Failed to parse malformed sourcemap: {0}");

    public SourceMapInput(SourceFile sourceFile) {
        this.sourceFile = sourceFile;
    }

    @Nullable
    public synchronized SourceMapConsumerV3 getSourceMap(ErrorManager errorManager) {
        if (!this.cached) {
            this.cached = true;
            String sourceMapPath = this.sourceFile.getOriginalPath();
            try {
                String sourceMapContents = this.sourceFile.getCode();
                SourceMapConsumerV3 consumer = new SourceMapConsumerV3();
                consumer.parse(sourceMapContents);
                this.parsedSourceMap = consumer;
            }
            catch (IOException e) {
                JSError error = JSError.make(SOURCEMAP_RESOLVE_FAILED, sourceMapPath);
                errorManager.report(error.getDefaultLevel(), error);
            }
            catch (SourceMapParseException e) {
                JSError error = JSError.make(SOURCEMAP_PARSE_FAILED, sourceMapPath);
                errorManager.report(error.getDefaultLevel(), error);
            }
        }
        return this.parsedSourceMap;
    }

    public String getOriginalPath() {
        return this.sourceFile.getOriginalPath();
    }
}

