/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.Deque;

public final class RewriteAsyncFunctions
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    private static final String ASYNC_GENERATOR_NAME = "$jscomp$async$generator";
    private static final String ASYNC_ARGUMENTS = "$jscomp$async$arguments";
    private static final String ASYNC_THIS = "$jscomp$async$this";
    private final Deque<LexicalContext> contextStack;
    private final AbstractCompiler compiler;

    public RewriteAsyncFunctions(AbstractCompiler compiler) {
        Preconditions.checkNotNull((Object)compiler);
        this.compiler = compiler;
        this.contextStack = new ArrayDeque<LexicalContext>();
        this.contextStack.addFirst(new LexicalContext());
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        if (n.isFunction()) {
            this.contextStack.addFirst(new LexicalContext(this.contextStack.getFirst(), n));
            if (n.isAsyncFunction()) {
                this.compiler.ensureLibraryInjected("es6/execute_async_generator", false);
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        LexicalContext context = this.contextStack.getFirst();
        if (n.isFunction()) {
            Preconditions.checkState((context.function.isPresent() && context.function.get() == n ? 1 : 0) != 0, (String)"unexpected function context:\nexpected: %s\nactual: %s", (Object)n, context.function);
            this.contextStack.removeFirst();
        }
        switch (n.getToken()) {
            case FUNCTION: {
                if (!context.isAsyncContext()) break;
                this.convertAsyncFunction(context);
                break;
            }
            case NAME: {
                if (!context.mustReplaceThisAndArguments() || !n.matchesQualifiedName("arguments")) break;
                n.setString(ASYNC_ARGUMENTS);
                context.recordAsyncArgumentsReplacementWasDone();
                break;
            }
            case THIS: {
                if (!context.mustReplaceThisAndArguments()) break;
                parent.replaceChild(n, IR.name(ASYNC_THIS).useSourceInfoIfMissingFrom(n));
                context.recordAsyncThisReplacementWasDone();
                break;
            }
            case AWAIT: {
                Preconditions.checkState((boolean)context.isAsyncContext(), (Object)"await found within non-async function body");
                Preconditions.checkState((boolean)n.hasOneChild(), (String)"await should have 1 operand, but has %s", (int)n.getChildCount());
                parent.replaceChild(n, IR.yield(n.removeFirstChild()).useSourceInfoIfMissingFrom(n));
                break;
            }
        }
    }

    private void convertAsyncFunction(LexicalContext functionContext) {
        Node originalFunction = (Node)functionContext.function.get();
        originalFunction.setIsAsyncFunction(false);
        Node originalBody = originalFunction.getLastChild();
        Node newBody = IR.block().useSourceInfoIfMissingFrom(originalBody);
        originalFunction.replaceChild(originalBody, newBody);
        if (functionContext.asyncThisReplacementWasDone) {
            newBody.addChildToBack(IR.constNode(IR.name(ASYNC_THIS), IR.thisNode()));
        }
        if (functionContext.asyncArgumentsReplacementWasDone) {
            newBody.addChildToBack(IR.constNode(IR.name(ASYNC_ARGUMENTS), IR.name("arguments")));
        }
        if (!originalBody.isNormalBlock()) {
            originalBody = IR.block(IR.returnNode(originalBody)).useSourceInfoFromForTree(originalBody);
        }
        Node newFunctionName = IR.name(ASYNC_GENERATOR_NAME);
        Node originalName = originalFunction.getFirstChild();
        newFunctionName.useSourceInfoIfMissingFromForTree(originalName);
        Node generatorFunction = IR.function(newFunctionName, IR.paramList(), originalBody);
        this.compiler.reportChangeToChangeScope(generatorFunction);
        generatorFunction.setIsGeneratorFunction(true);
        newBody.addChildToBack(generatorFunction);
        Node executeAsyncGenerator = IR.getprop(IR.name("$jscomp"), IR.string("executeAsyncGenerator"));
        newBody.addChildToBack(IR.returnNode(IR.call(executeAsyncGenerator, NodeUtil.newCallNode(IR.name(ASYNC_GENERATOR_NAME), new Node[0]))));
        newBody.useSourceInfoIfMissingFromForTree(originalBody);
        this.compiler.reportChangeToEnclosingScope(newBody);
    }

    private static final class LexicalContext {
        final Optional<Node> function;
        final LexicalContext thisAndArgumentsContext;
        boolean asyncThisReplacementWasDone = false;
        boolean asyncArgumentsReplacementWasDone = false;

        LexicalContext() {
            this.function = Optional.absent();
            this.thisAndArgumentsContext = this;
        }

        LexicalContext(LexicalContext outer, Node function) {
            this.function = Optional.of((Object)function);
            this.thisAndArgumentsContext = function.isArrowFunction() ? outer.thisAndArgumentsContext : this;
        }

        boolean isAsyncContext() {
            return this.function.isPresent() && ((Node)this.function.get()).isAsyncFunction();
        }

        boolean mustReplaceThisAndArguments() {
            return this.thisAndArgumentsContext.isAsyncContext();
        }

        void recordAsyncThisReplacementWasDone() {
            Preconditions.checkState((boolean)this.thisAndArgumentsContext.isAsyncContext());
            this.thisAndArgumentsContext.asyncThisReplacementWasDone = true;
        }

        void recordAsyncArgumentsReplacementWasDone() {
            Preconditions.checkState((boolean)this.thisAndArgumentsContext.isAsyncContext());
            this.thisAndArgumentsContext.asyncArgumentsReplacementWasDone = true;
        }
    }
}

