/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.primitives.Booleans;
import com.google.debugging.sourcemap.Base64;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefaultNameGenerator;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.IdMappingUtil;
import com.google.javascript.jscomp.NameGenerator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.RenamingMap;
import com.google.javascript.jscomp.UniqueRenamingToken;
import com.google.javascript.jscomp.Xid;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.LinkedHashMap;
import java.util.Map;

class ReplaceIdGenerators
implements CompilerPass {
    static final DiagnosticType NON_GLOBAL_ID_GENERATOR_CALL = DiagnosticType.error("JSC_NON_GLOBAL_ID_GENERATOR_CALL", "Id generator call must be in the global scope");
    static final DiagnosticType CONDITIONAL_ID_GENERATOR_CALL = DiagnosticType.error("JSC_CONDITIONAL_ID_GENERATOR_CALL", "Id generator call must be unconditional");
    static final DiagnosticType CONFLICTING_GENERATOR_TYPE = DiagnosticType.error("JSC_CONFLICTING_ID_GENERATOR_TYPE", "Id generator can only be one of consistent, inconsistent, mapped, stable, or xid.");
    static final DiagnosticType INVALID_GENERATOR_ID_MAPPING = DiagnosticType.error("JSC_INVALID_GENERATOR_ID_MAPPING", "Invalid generator id mapping. {0}");
    static final DiagnosticType MISSING_NAME_MAP_FOR_GENERATOR = DiagnosticType.warning("JSC_MISSING_NAME_MAP_FOR_GENERATOR", "The mapped id generator, does not have a renaming map supplied.");
    static final DiagnosticType INVALID_GENERATOR_PARAMETER = DiagnosticType.warning("JSC_INVALID_GENERATOR_PARAMETER", "An id generator must be called with a literal.");
    static final DiagnosticType SHORTHAND_FUNCTION_NOT_SUPPORTED_IN_ID_GEN = DiagnosticType.error("JSC_SHORTHAND_FUNCTION_NOT_SUPPORTED_IN_ID_GEN", "Object literal shorthand functions is not allowed in the arguments of an id generator");
    static final DiagnosticType SHORTHAND_ASSIGNMENT_NOT_SUPPORTED_IN_ID_GEN = DiagnosticType.error("JSC_SHORTHAND_ASSIGNMENT_NOT_SUPPORTED_IN_ID_GEN", "Object literal shorthand assignment is not allowed in the arguments of an id generator");
    static final DiagnosticType COMPUTED_PROP_NOT_SUPPORTED_IN_ID_GEN = DiagnosticType.error("JSC_COMPUTED_PROP_NOT_SUPPORTED_IN_ID_GEN", "Object literal computed property name is not allowed in the arguments of an id generator");
    private final AbstractCompiler compiler;
    private final Map<String, NameSupplier> nameGenerators;
    private final Map<String, Map<String, String>> consistNameMap;
    private final Map<String, Map<String, String>> idGeneratorMaps;
    private final Map<String, BiMap<String, String>> previousMap;
    private final boolean generatePseudoNames;
    private final Xid.HashFunction xidHashFunction;

    public ReplaceIdGenerators(AbstractCompiler compiler, Map<String, RenamingMap> idGens, boolean generatePseudoNames, String previousMapSerialized, Xid.HashFunction xidHashFunction) {
        this.compiler = compiler;
        this.generatePseudoNames = generatePseudoNames;
        this.xidHashFunction = xidHashFunction;
        this.nameGenerators = new LinkedHashMap<String, NameSupplier>();
        this.idGeneratorMaps = new LinkedHashMap<String, Map<String, String>>();
        this.consistNameMap = new LinkedHashMap<String, Map<String, String>>();
        Map<String, BiMap<String, String>> previousMap = IdMappingUtil.parseSerializedIdMappings(previousMapSerialized);
        this.previousMap = previousMap;
        if (idGens != null) {
            for (Map.Entry<String, RenamingMap> gen : idGens.entrySet()) {
                String name = gen.getKey();
                RenamingMap map = gen.getValue();
                if (map instanceof UniqueRenamingToken) {
                    this.nameGenerators.put(name, this.createNameSupplier(RenameStrategy.INCONSISTENT, previousMap.get(name)));
                } else {
                    this.nameGenerators.put(name, ReplaceIdGenerators.createNameSupplier(RenameStrategy.MAPPED, map));
                }
                this.idGeneratorMaps.put(name, new LinkedHashMap());
            }
        }
    }

    private NameSupplier createNameSupplier(RenameStrategy renameStrategy, BiMap<String, String> previousMappings) {
        ImmutableBiMap immutableBiMap = previousMappings = previousMappings != null ? previousMappings : ImmutableBiMap.of();
        if (renameStrategy == RenameStrategy.STABLE) {
            return new StableNameSupplier();
        }
        if (renameStrategy == RenameStrategy.XID) {
            return new XidNameSupplier(this.xidHashFunction);
        }
        if (this.generatePseudoNames) {
            return new PseudoNameSupplier(renameStrategy);
        }
        return new ObfuscatedNameSupplier(renameStrategy, (BiMap<String, String>)previousMappings);
    }

    private static NameSupplier createNameSupplier(RenameStrategy renameStrategy, RenamingMap mappings) {
        Preconditions.checkState((renameStrategy == RenameStrategy.MAPPED ? 1 : 0) != 0);
        return new MappedNameSupplier(mappings);
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, new GatherGenerators());
        if (!this.nameGenerators.isEmpty()) {
            NodeTraversal.traverseEs6(this.compiler, root, new ReplaceGenerators());
        }
    }

    public String getSerializedIdMappings() {
        return IdMappingUtil.generateSerializedIdMappings(this.idGeneratorMaps);
    }

    static String getIdForGeneratorNode(boolean consistent, Node n) {
        Preconditions.checkState((n.isString() || n.isStringKey() ? 1 : 0) != 0, (Object)n);
        if (consistent) {
            return n.getString();
        }
        return n.getSourceFileName() + ':' + n.getLineno() + ":" + n.getCharno();
    }

    private class ReplaceGenerators
    extends NodeTraversal.AbstractPostOrderCallback {
        private ReplaceGenerators() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            Node arg;
            if (!n.isCall()) {
                return;
            }
            String callName = n.getFirstChild().getQualifiedName();
            NameSupplier nameGenerator = (NameSupplier)ReplaceIdGenerators.this.nameGenerators.get(callName);
            if (nameGenerator == null) {
                return;
            }
            if (!t.inGlobalHoistScope() && nameGenerator.getRenameStrategy() == RenameStrategy.INCONSISTENT) {
                ReplaceIdGenerators.this.compiler.report(t.makeError(n, NON_GLOBAL_ID_GENERATOR_CALL, new String[0]));
                return;
            }
            if (nameGenerator.getRenameStrategy() == RenameStrategy.INCONSISTENT) {
                for (Node ancestor : n.getAncestors()) {
                    if (!NodeUtil.isControlStructure(ancestor)) continue;
                    ReplaceIdGenerators.this.compiler.report(t.makeError(n, CONDITIONAL_ID_GENERATOR_CALL, new String[0]));
                    return;
                }
            }
            if ((arg = n.getSecondChild()) == null) {
                ReplaceIdGenerators.this.compiler.report(t.makeError(n, INVALID_GENERATOR_PARAMETER, new String[0]));
            } else if (arg.isString()) {
                String rename = this.getObfuscatedName(arg, callName, nameGenerator, arg.getString());
                parent.replaceChild(n, IR.string(rename));
                t.reportCodeChange();
            } else if (arg.isObjectLit()) {
                for (Node key : arg.children()) {
                    if (key.isMemberFunctionDef()) {
                        ReplaceIdGenerators.this.compiler.report(t.makeError(n, SHORTHAND_FUNCTION_NOT_SUPPORTED_IN_ID_GEN, new String[0]));
                        return;
                    }
                    if (key.isStringKey() && !key.hasChildren()) {
                        ReplaceIdGenerators.this.compiler.report(t.makeError(n, SHORTHAND_ASSIGNMENT_NOT_SUPPORTED_IN_ID_GEN, new String[0]));
                        return;
                    }
                    if (key.isComputedProp()) {
                        ReplaceIdGenerators.this.compiler.report(t.makeError(n, COMPUTED_PROP_NOT_SUPPORTED_IN_ID_GEN, new String[0]));
                        return;
                    }
                    String rename = this.getObfuscatedName(key, callName, nameGenerator, key.getString());
                    key.setString(rename);
                    key.putBooleanProp(36, true);
                }
                arg.detach();
                parent.replaceChild(n, arg);
                t.reportCodeChange();
            } else {
                ReplaceIdGenerators.this.compiler.report(t.makeError(n, INVALID_GENERATOR_PARAMETER, new String[0]));
            }
        }

        private String getObfuscatedName(Node id, String callName, NameSupplier nameGenerator, String name) {
            String rename = null;
            Map idGeneratorMap = (Map)ReplaceIdGenerators.this.idGeneratorMaps.get(callName);
            String instanceId = ReplaceIdGenerators.getIdForGeneratorNode(nameGenerator.getRenameStrategy() != RenameStrategy.INCONSISTENT, id);
            if (nameGenerator.getRenameStrategy() == RenameStrategy.CONSISTENT) {
                Map entry = (Map)ReplaceIdGenerators.this.consistNameMap.get(callName);
                rename = (String)entry.get(instanceId);
                if (rename == null) {
                    rename = nameGenerator.getName(instanceId, name);
                    entry.put(instanceId, rename);
                }
            } else {
                rename = nameGenerator.getName(instanceId, name);
            }
            idGeneratorMap.put(rename, instanceId);
            return rename;
        }
    }

    private class GatherGenerators
    extends NodeTraversal.AbstractPostOrderCallback {
        private GatherGenerators() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            JSDocInfo doc = n.getJSDocInfo();
            if (doc == null) {
                return;
            }
            int numGeneratorAnnotations = Booleans.countTrue((boolean[])new boolean[]{doc.isConsistentIdGenerator(), doc.isIdGenerator(), doc.isStableIdGenerator(), doc.isXidGenerator(), doc.isMappedIdGenerator()});
            if (numGeneratorAnnotations == 0) {
                return;
            }
            if (numGeneratorAnnotations > 1) {
                ReplaceIdGenerators.this.compiler.report(t.makeError(n, CONFLICTING_GENERATOR_TYPE, new String[0]));
            }
            String name = null;
            if (n.isAssign()) {
                name = n.getFirstChild().getQualifiedName();
            } else if (NodeUtil.isNameDeclaration(n)) {
                name = n.getFirstChild().getString();
            } else if (n.isFunction() && (name = n.getFirstChild().getString()).isEmpty()) {
                return;
            }
            if (doc.isConsistentIdGenerator()) {
                ReplaceIdGenerators.this.consistNameMap.put(name, new LinkedHashMap());
                ReplaceIdGenerators.this.nameGenerators.put(name, ReplaceIdGenerators.this.createNameSupplier(RenameStrategy.CONSISTENT, (BiMap<String, String>)((BiMap)ReplaceIdGenerators.this.previousMap.get(name))));
            } else if (doc.isStableIdGenerator()) {
                ReplaceIdGenerators.this.nameGenerators.put(name, ReplaceIdGenerators.this.createNameSupplier(RenameStrategy.STABLE, (BiMap<String, String>)((BiMap)ReplaceIdGenerators.this.previousMap.get(name))));
            } else if (doc.isXidGenerator()) {
                ReplaceIdGenerators.this.nameGenerators.put(name, ReplaceIdGenerators.this.createNameSupplier(RenameStrategy.XID, (BiMap<String, String>)((BiMap)ReplaceIdGenerators.this.previousMap.get(name))));
            } else if (doc.isIdGenerator()) {
                ReplaceIdGenerators.this.nameGenerators.put(name, ReplaceIdGenerators.this.createNameSupplier(RenameStrategy.INCONSISTENT, (BiMap<String, String>)((BiMap)ReplaceIdGenerators.this.previousMap.get(name))));
            } else if (doc.isMappedIdGenerator()) {
                NameSupplier supplier = (NameSupplier)ReplaceIdGenerators.this.nameGenerators.get(name);
                if (supplier == null || supplier.getRenameStrategy() != RenameStrategy.MAPPED) {
                    ReplaceIdGenerators.this.compiler.report(t.makeError(n, MISSING_NAME_MAP_FOR_GENERATOR, new String[0]));
                    return;
                }
            } else {
                throw new IllegalStateException("unexpected");
            }
            ReplaceIdGenerators.this.idGeneratorMaps.put(name, new LinkedHashMap());
        }
    }

    private static class MappedNameSupplier
    implements NameSupplier {
        private final RenamingMap map;

        MappedNameSupplier(RenamingMap map) {
            this.map = map;
        }

        @Override
        public String getName(String id, String name) {
            return this.map.get(name);
        }

        @Override
        public RenameStrategy getRenameStrategy() {
            return RenameStrategy.MAPPED;
        }
    }

    private static class XidNameSupplier
    implements NameSupplier {
        final Xid xid;

        XidNameSupplier(Xid.HashFunction hashFunction) {
            this.xid = hashFunction == null ? new Xid() : new Xid(hashFunction);
        }

        @Override
        public String getName(String id, String name) {
            return this.xid.get(name);
        }

        @Override
        public RenameStrategy getRenameStrategy() {
            return RenameStrategy.XID;
        }
    }

    private static class StableNameSupplier
    implements NameSupplier {
        private StableNameSupplier() {
        }

        @Override
        public String getName(String id, String name) {
            return Base64.base64EncodeInt(name.hashCode());
        }

        @Override
        public RenameStrategy getRenameStrategy() {
            return RenameStrategy.STABLE;
        }
    }

    private static class PseudoNameSupplier
    implements NameSupplier {
        private int counter = 0;
        private RenameStrategy renameStrategy;

        public PseudoNameSupplier(RenameStrategy renameStrategy) {
            this.renameStrategy = renameStrategy;
        }

        @Override
        public String getName(String id, String name) {
            if (this.renameStrategy == RenameStrategy.INCONSISTENT) {
                return name + "$" + this.counter++;
            }
            return name + "$0";
        }

        @Override
        public RenameStrategy getRenameStrategy() {
            return this.renameStrategy;
        }
    }

    private static class ObfuscatedNameSupplier
    implements NameSupplier {
        private final NameGenerator generator;
        private final Map<String, String> previousMappings;
        private RenameStrategy renameStrategy;

        public ObfuscatedNameSupplier(RenameStrategy renameStrategy, BiMap<String, String> previousMappings) {
            this.previousMappings = previousMappings.inverse();
            this.generator = new DefaultNameGenerator(previousMappings.keySet(), "", null);
            this.renameStrategy = renameStrategy;
        }

        @Override
        public String getName(String id, String name) {
            String newName = this.previousMappings.get(id);
            if (newName == null) {
                newName = this.generator.generateNextName();
            }
            return newName;
        }

        @Override
        public RenameStrategy getRenameStrategy() {
            return this.renameStrategy;
        }
    }

    private static interface NameSupplier {
        public String getName(String var1, String var2);

        public RenameStrategy getRenameStrategy();
    }

    static enum RenameStrategy {
        CONSISTENT,
        INCONSISTENT,
        MAPPED,
        STABLE,
        XID;

    }
}

