/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PolymerClassDefinition;
import com.google.javascript.jscomp.PolymerClassRewriter;
import com.google.javascript.jscomp.PolymerPassErrors;
import com.google.javascript.jscomp.PolymerPassFindExterns;
import com.google.javascript.jscomp.PolymerPassStaticUtils;
import com.google.javascript.jscomp.PolymerPassSuppressBehaviors;
import com.google.javascript.jscomp.TagNameToType;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

final class PolymerPass
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    static final String VIRTUAL_FILE = "<PolymerPass.java>";
    private final AbstractCompiler compiler;
    private final Map<String, String> tagNameMap;
    private Node polymerElementExterns;
    private Set<String> nativeExternsAdded;
    private ImmutableList<Node> polymerElementProps;
    private GlobalNamespace globalNames;

    PolymerPass(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.tagNameMap = TagNameToType.getMap();
        this.nativeExternsAdded = new HashSet<String>();
        if (compiler.getOptions().polymerVersion != 1) {
            throw new IllegalStateException("Polymer version not supported: " + compiler.getOptions().polymerVersion);
        }
    }

    @Override
    public void process(Node externs, Node root) {
        PolymerPassFindExterns externsCallback = new PolymerPassFindExterns();
        NodeTraversal.traverseEs6(this.compiler, externs, externsCallback);
        this.polymerElementExterns = externsCallback.getPolymerElementExterns();
        this.polymerElementProps = externsCallback.getPolymerElementProps();
        if (this.polymerElementExterns == null) {
            this.compiler.report(JSError.make(externs, PolymerPassErrors.POLYMER_MISSING_EXTERNS, new String[0]));
            return;
        }
        this.globalNames = new GlobalNamespace(this.compiler, externs, root);
        this.hotSwapScript(root, null);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
        PolymerPassSuppressBehaviors suppressBehaviorsCallback = new PolymerPassSuppressBehaviors(this.compiler);
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, suppressBehaviorsCallback);
    }

    @Override
    public void visit(NodeTraversal traversal, Node node, Node parent) {
        Preconditions.checkState((this.polymerElementExterns != null && this.polymerElementProps != null && this.globalNames != null ? 1 : 0) != 0, (Object)"Cannot call visit() before process()");
        if (PolymerPass.isPolymerCall(node)) {
            this.rewriteClassDefinition(node, parent, traversal);
        }
    }

    private void rewriteClassDefinition(Node node, Node parent, NodeTraversal traversal) {
        Node grandparent = parent.getParent();
        if (grandparent.isConst()) {
            this.compiler.report(JSError.make(node, PolymerPassErrors.POLYMER_INVALID_DECLARATION, new String[0]));
            return;
        }
        PolymerClassDefinition def = PolymerClassDefinition.extractFromCallNode(node, this.compiler, this.globalNames);
        if (def != null) {
            if (def.nativeBaseElement != null) {
                this.appendPolymerElementExterns(def);
            }
            PolymerClassRewriter rewriter = new PolymerClassRewriter(this.compiler, this.polymerElementExterns);
            if (NodeUtil.isNameDeclaration(grandparent) || parent.isAssign()) {
                rewriter.rewritePolymerClass(grandparent, def, traversal.inGlobalScope());
            } else {
                rewriter.rewritePolymerClass(parent, def, traversal.inGlobalScope());
            }
        }
    }

    private void appendPolymerElementExterns(PolymerClassDefinition def) {
        if (!this.nativeExternsAdded.add(def.nativeBaseElement)) {
            return;
        }
        Node block = IR.block();
        Node baseExterns = this.polymerElementExterns.cloneTree();
        String polymerElementType = PolymerPassStaticUtils.getPolymerElementType(def);
        baseExterns.getFirstChild().setString(polymerElementType);
        String elementType = this.tagNameMap.get(def.nativeBaseElement);
        if (elementType == null) {
            this.compiler.report(JSError.make(def.descriptor, PolymerPassErrors.POLYMER_INVALID_EXTENDS, def.nativeBaseElement));
            return;
        }
        JSTypeExpression elementBaseType = new JSTypeExpression(new Node(Token.BANG, IR.string(elementType)), VIRTUAL_FILE);
        JSDocInfoBuilder baseDocs = JSDocInfoBuilder.copyFrom(baseExterns.getJSDocInfo());
        baseDocs.changeBaseType(elementBaseType);
        baseExterns.setJSDocInfo(baseDocs.build());
        block.addChildToBack(baseExterns);
        for (Node baseProp : this.polymerElementProps) {
            Node newProp = baseProp.cloneTree();
            Node newPropRootName = NodeUtil.getRootOfQualifiedName(newProp.getFirstFirstChild());
            newPropRootName.setString(polymerElementType);
            block.addChildToBack(newProp);
        }
        block.useSourceInfoIfMissingFromForTree(this.polymerElementExterns);
        Node parent = this.polymerElementExterns.getParent();
        Node stmts = block.removeChildren();
        parent.addChildrenAfter(stmts, this.polymerElementExterns);
        this.compiler.reportChangeToEnclosingScope(stmts);
    }

    @VisibleForTesting
    public static boolean isPolymerCall(Node value) {
        return value != null && value.isCall() && value.getFirstChild().matchesQualifiedName("Polymer");
    }

    static class MemberDefinition {
        final JSDocInfo info;
        final Node name;
        final Node value;

        MemberDefinition(JSDocInfo info, Node name, Node value) {
            this.info = info;
            this.name = name;
            this.value = value;
        }
    }
}

