/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PolymerBehaviorExtractor;
import com.google.javascript.jscomp.PolymerPass;
import com.google.javascript.jscomp.PolymerPassErrors;
import com.google.javascript.jscomp.PolymerPassStaticUtils;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;

final class PolymerClassDefinition {
    final Node target;
    final Node descriptor;
    final PolymerPass.MemberDefinition constructor;
    final String nativeBaseElement;
    final List<PolymerPass.MemberDefinition> props;
    final ImmutableList<PolymerBehaviorExtractor.BehaviorDefinition> behaviors;
    final FeatureSet features;

    PolymerClassDefinition(Node target, Node descriptor, JSDocInfo classInfo, PolymerPass.MemberDefinition constructor, String nativeBaseElement, List<PolymerPass.MemberDefinition> props, ImmutableList<PolymerBehaviorExtractor.BehaviorDefinition> behaviors, FeatureSet features) {
        this.target = target;
        Preconditions.checkState((boolean)descriptor.isObjectLit());
        this.descriptor = descriptor;
        this.constructor = constructor;
        this.nativeBaseElement = nativeBaseElement;
        this.props = props;
        this.behaviors = behaviors;
        this.features = features;
    }

    @Nullable
    static PolymerClassDefinition extractFromCallNode(Node callNode, AbstractCompiler compiler, GlobalNamespace globalNames) {
        Node descriptor = NodeUtil.getArgumentForCallOrNew(callNode, 0);
        if (descriptor == null || !descriptor.isObjectLit()) {
            compiler.report(JSError.make(callNode, PolymerPassErrors.POLYMER_DESCRIPTOR_NOT_VALID, new String[0]));
            return null;
        }
        int paramCount = callNode.getChildCount() - 1;
        if (paramCount != 1) {
            compiler.report(JSError.make(callNode, PolymerPassErrors.POLYMER_UNEXPECTED_PARAMS, new String[0]));
            return null;
        }
        Node elName = NodeUtil.getFirstPropMatchingKey(descriptor, "is");
        if (elName == null) {
            compiler.report(JSError.make(callNode, PolymerPassErrors.POLYMER_MISSING_IS, new String[0]));
            return null;
        }
        String elNameString = CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, elName.getString());
        elNameString = elNameString + "Element";
        Node target = NodeUtil.isNameDeclaration(callNode.getGrandparent()) ? IR.name(callNode.getParent().getString()) : (callNode.getParent().isAssign() ? callNode.getParent().getFirstChild().cloneTree() : IR.name(elNameString));
        JSDocInfo classInfo = NodeUtil.getBestJSDocInfo(target);
        JSDocInfo ctorInfo = null;
        Node constructor = NodeUtil.getFirstPropMatchingKey(descriptor, "factoryImpl");
        if (constructor == null) {
            constructor = IR.function(IR.name(""), IR.paramList(), IR.block());
            compiler.reportChangeToChangeScope(constructor);
            constructor.useSourceInfoFromForTree(callNode);
        } else {
            ctorInfo = NodeUtil.getBestJSDocInfo(constructor);
        }
        Node baseClass = NodeUtil.getFirstPropMatchingKey(descriptor, "extends");
        String nativeBaseElement = baseClass == null ? null : baseClass.getString();
        Node behaviorArray = NodeUtil.getFirstPropMatchingKey(descriptor, "behaviors");
        PolymerBehaviorExtractor behaviorExtractor = new PolymerBehaviorExtractor(compiler, globalNames);
        ImmutableList<PolymerBehaviorExtractor.BehaviorDefinition> behaviors = behaviorExtractor.extractBehaviors(behaviorArray);
        LinkedList<PolymerPass.MemberDefinition> allProperties = new LinkedList<PolymerPass.MemberDefinition>();
        for (PolymerBehaviorExtractor.BehaviorDefinition behavior : behaviors) {
            PolymerClassDefinition.overwriteMembersIfPresent(allProperties, behavior.props);
        }
        PolymerClassDefinition.overwriteMembersIfPresent(allProperties, PolymerPassStaticUtils.extractProperties(descriptor, compiler));
        FeatureSet newFeatures = null;
        if (!behaviors.isEmpty()) {
            newFeatures = ((PolymerBehaviorExtractor.BehaviorDefinition)behaviors.get((int)0)).features;
            for (int i = 1; i < behaviors.size(); ++i) {
                newFeatures = newFeatures.union(((PolymerBehaviorExtractor.BehaviorDefinition)behaviors.get((int)i)).features);
            }
        }
        return new PolymerClassDefinition(target, descriptor, classInfo, new PolymerPass.MemberDefinition(ctorInfo, null, constructor), nativeBaseElement, allProperties, behaviors, newFeatures);
    }

    private static void overwriteMembersIfPresent(List<PolymerPass.MemberDefinition> list, List<PolymerPass.MemberDefinition> newMembers) {
        for (PolymerPass.MemberDefinition newMember : newMembers) {
            for (PolymerPass.MemberDefinition member : list) {
                if (!member.name.getString().equals(newMember.name.getString())) continue;
                list.remove(member);
                break;
            }
            list.add(newMember);
        }
    }
}

