/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefinitionProvider;
import com.google.javascript.jscomp.DefinitionSite;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class NameBasedDefinitionProvider
implements DefinitionProvider,
CompilerPass {
    protected final Multimap<String, DefinitionsRemover.Definition> nameDefinitionMultimap = LinkedHashMultimap.create();
    protected final Map<Node, DefinitionSite> definitionNodeByDefinitionSite = new LinkedHashMap<Node, DefinitionSite>();
    protected final Set<Node> definitionNodes = new HashSet<Node>();
    protected final AbstractCompiler compiler;
    protected final boolean allowComplexFunctionDefs;
    protected boolean hasProcessBeenRun = false;

    public NameBasedDefinitionProvider(AbstractCompiler compiler, boolean allowComplexFunctionDefs) {
        this.compiler = compiler;
        this.allowComplexFunctionDefs = allowComplexFunctionDefs;
    }

    @Override
    public void process(Node externs, Node source) {
        Preconditions.checkState((!this.hasProcessBeenRun ? 1 : 0) != 0, (Object)"The definition provider is already initialized.");
        this.hasProcessBeenRun = true;
        NodeTraversal.traverseEs6(this.compiler, externs, new DefinitionGatheringCallback(true));
        this.dropUntypedExterns();
        NodeTraversal.traverseEs6(this.compiler, source, new DefinitionGatheringCallback(false));
    }

    private boolean jsdocContainsDeclarations(Node node) {
        JSDocInfo info = node.getJSDocInfo();
        return info != null && info.containsDeclaration();
    }

    private void dropUntypedExterns() {
        for (String externName : this.nameDefinitionMultimap.keySet()) {
            block1: for (DefinitionsRemover.Definition def : new ArrayList(this.nameDefinitionMultimap.get((Object)externName))) {
                Node node;
                if (!(def instanceof DefinitionsRemover.ExternalNameOnlyDefinition) || this.jsdocContainsDeclarations(node = def.getLValue())) continue;
                for (DefinitionsRemover.Definition prevDef : this.nameDefinitionMultimap.get((Object)externName)) {
                    if (prevDef == def || !node.matchesQualifiedName(prevDef.getLValue())) continue;
                    this.nameDefinitionMultimap.remove((Object)externName, (Object)def);
                    DefinitionSite site = this.definitionNodeByDefinitionSite.remove(def.getLValue());
                    Preconditions.checkNotNull((Object)site);
                    continue block1;
                }
            }
        }
    }

    @Override
    public Collection<DefinitionsRemover.Definition> getDefinitionsReferencedAt(Node useSite) {
        String name;
        String propName;
        Preconditions.checkState((boolean)this.hasProcessBeenRun, (Object)"The process was not run");
        Preconditions.checkArgument((useSite.isGetProp() || useSite.isName() ? 1 : 0) != 0);
        if (this.definitionNodes.contains(useSite)) {
            return null;
        }
        if (useSite.isGetProp() && ((propName = useSite.getLastChild().getString()).equals("apply") || propName.equals("call"))) {
            useSite = useSite.getFirstChild();
        }
        if ((name = NameBasedDefinitionProvider.getSimplifiedName(useSite)) != null) {
            Collection defs = this.nameDefinitionMultimap.get((Object)name);
            return defs.isEmpty() ? null : defs;
        }
        return null;
    }

    private void addDefinition(String name, DefinitionsRemover.Definition def, Node node, NodeTraversal traversal) {
        this.definitionNodes.add(def.getLValue());
        this.nameDefinitionMultimap.put((Object)name, (Object)def);
        this.definitionNodeByDefinitionSite.put(node, new DefinitionSite(node, def, traversal.getModule(), traversal.inGlobalScope(), def.isExtern()));
    }

    protected static String getSimplifiedName(Node node) {
        if (node.isName()) {
            String name = node.getString();
            if (name != null && !name.isEmpty()) {
                return name;
            }
            return null;
        }
        if (node.isGetProp()) {
            return "this." + node.getLastChild().getString();
        }
        return null;
    }

    @Override
    public Collection<DefinitionSite> getDefinitionSites() {
        Preconditions.checkState((boolean)this.hasProcessBeenRun, (Object)"The process was not run");
        return this.definitionNodeByDefinitionSite.values();
    }

    public DefinitionSite getDefinitionForFunction(Node function) {
        Preconditions.checkState((boolean)this.hasProcessBeenRun, (Object)"The process was not run");
        Preconditions.checkState((boolean)function.isFunction());
        return this.definitionNodeByDefinitionSite.get(NodeUtil.getNameNode(function));
    }

    private class DefinitionGatheringCallback
    implements NodeTraversal.Callback {
        private final boolean inExterns;

        DefinitionGatheringCallback(boolean inExterns) {
            this.inExterns = inExterns;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (this.inExterns) {
                if (n.isFunction() && !n.getFirstChild().isName()) {
                    return false;
                }
                if (parent != null && parent.isFunction() && n != parent.getFirstChild()) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal traversal, Node node, Node parent) {
            if (this.inExterns) {
                this.visitExterns(traversal, node, parent);
            } else {
                this.visitCode(traversal, node);
            }
        }

        private void visitExterns(NodeTraversal traversal, Node node, Node parent) {
            String name;
            DefinitionsRemover.Definition def;
            if (node.getJSDocInfo() != null) {
                for (Node typeRoot : node.getJSDocInfo().getTypeNodes()) {
                    traversal.traverse(typeRoot);
                }
            }
            if ((def = DefinitionsRemover.getDefinition(node, true)) != null && (name = NameBasedDefinitionProvider.getSimplifiedName(def.getLValue())) != null) {
                Node rValue = def.getRValue();
                if (rValue != null && !NodeUtil.isImmutableValue(rValue) && !rValue.isFunction()) {
                    DefinitionsRemover.UnknownDefinition unknownDef = new DefinitionsRemover.UnknownDefinition(def.getLValue(), true);
                    def = unknownDef;
                }
                NameBasedDefinitionProvider.this.addDefinition(name, def, node, traversal);
            }
        }

        private void visitCode(NodeTraversal traversal, Node node) {
            String name;
            DefinitionsRemover.Definition def = DefinitionsRemover.getDefinition(node, false);
            if (def != null && (name = NameBasedDefinitionProvider.getSimplifiedName(def.getLValue())) != null) {
                Node rValue = def.getRValue();
                if (rValue != null && !NodeUtil.isImmutableValue(rValue) && !this.isKnownFunctionDefinition(rValue)) {
                    def = new DefinitionsRemover.UnknownDefinition(def.getLValue(), false);
                }
                NameBasedDefinitionProvider.this.addDefinition(name, def, node, traversal);
            }
        }

        boolean isKnownFunctionDefinition(Node n) {
            switch (n.getToken()) {
                case FUNCTION: {
                    return true;
                }
                case HOOK: {
                    return NameBasedDefinitionProvider.this.allowComplexFunctionDefs && this.isKnownFunctionDefinition(n.getSecondChild()) && this.isKnownFunctionDefinition(n.getLastChild());
                }
            }
            return false;
        }
    }
}

