/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.rhino.Node;
import java.util.HashMap;
import java.util.Map;

class MemoizedScopeCreator
implements ScopeCreator {
    private final Map<Node, Scope> scopesByScopeRoot = new HashMap<Node, Scope>();
    private final ScopeCreator delegate;

    MemoizedScopeCreator(ScopeCreator delegate) {
        this.delegate = delegate;
    }

    public Scope createScope(Node n, Scope parent) {
        Scope scope = this.scopesByScopeRoot.get(n);
        if (scope == null) {
            scope = this.delegate.createScope(n, parent);
            this.scopesByScopeRoot.put(n, scope);
        } else {
            Preconditions.checkState((parent == scope.getParent() ? 1 : 0) != 0);
        }
        return scope;
    }

    @Override
    public boolean hasBlockScope() {
        return this.delegate.hasBlockScope();
    }
}

