/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.J2clSourceFileChecker;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

public class J2clAssertRemovalPass
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final AbstractCompiler compiler;

    J2clAssertRemovalPass(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        if (!J2clSourceFileChecker.shouldRunJ2clPasses(this.compiler)) {
            return;
        }
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node node, Node parent) {
        if (J2clAssertRemovalPass.isAssertionCall(node)) {
            this.compiler.reportChangeToEnclosingScope(node);
            parent.replaceChild(node, NodeUtil.newUndefinedNode(node));
        }
    }

    private static boolean isAssertionCall(Node node) {
        return node.isCall() && J2clAssertRemovalPass.isAssertionMethodName(node.getFirstChild());
    }

    private static boolean isAssertionMethodName(Node fnName) {
        if (!fnName.isQualifiedName()) {
            return false;
        }
        String originalQname = fnName.getOriginalQualifiedName();
        return originalQname.contains("Asserts") && originalQname.contains(".$assert");
    }
}

