/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.TypeMismatch;
import com.google.javascript.rhino.ObjectTypeI;
import com.google.javascript.rhino.TypeI;
import com.google.javascript.rhino.TypeIRegistry;
import com.google.javascript.rhino.jstype.JSTypeNative;

final class InvalidatingTypes {
    private final ImmutableSet<TypeI> types;

    private InvalidatingTypes(ImmutableSet<TypeI> types) {
        this.types = types;
    }

    boolean isInvalidating(TypeI type) {
        if (type.isUnionType() && (type = type.restrictByNotNullOrUndefined()).isUnionType()) {
            for (TypeI typeI : type.getUnionMembers()) {
                if (!this.isInvalidating(typeI)) continue;
                return true;
            }
            return false;
        }
        ObjectTypeI objType = type.toMaybeObjectType();
        return objType == null || this.types.contains((Object)objType) || objType.isUnknownObject() || objType.isUnknownType() || objType.isBottom() || objType.isEnumObject() || objType.isBoxableScalar();
    }

    static final class Builder {
        private final ImmutableSet.Builder<TypeI> types = ImmutableSet.builder();
        private final TypeIRegistry registry;

        Builder(TypeIRegistry registry) {
            this.registry = registry;
        }

        InvalidatingTypes build() {
            return new InvalidatingTypes(this.types.build());
        }

        Builder addAllTypeMismatches(Iterable<TypeMismatch> mismatches) {
            for (TypeMismatch mis : mismatches) {
                this.addType(mis.typeA);
                this.addType(mis.typeB);
            }
            return this;
        }

        Builder addTypesInvalidForPropertyRenaming() {
            this.types.addAll((Iterable)ImmutableList.of(this.registry.getNativeType(JSTypeNative.FUNCTION_FUNCTION_TYPE), this.registry.getNativeType(JSTypeNative.FUNCTION_INSTANCE_TYPE), this.registry.getNativeType(JSTypeNative.FUNCTION_PROTOTYPE), this.registry.getNativeType(JSTypeNative.GLOBAL_THIS), this.registry.getNativeType(JSTypeNative.OBJECT_TYPE), this.registry.getNativeType(JSTypeNative.OBJECT_PROTOTYPE), this.registry.getNativeType(JSTypeNative.OBJECT_FUNCTION_TYPE), this.registry.getNativeType(JSTypeNative.TOP_LEVEL_PROTOTYPE)));
            return this;
        }

        Builder addType(TypeI type) {
            if ((type = type.restrictByNotNullOrUndefined()).isUnionType()) {
                for (TypeI typeI : type.getUnionMembers()) {
                    this.addType(typeI);
                }
            }
            this.types.add((Object)type);
            ObjectTypeI objType = type.toMaybeObjectType();
            if (objType != null && objType.isInstanceType()) {
                this.types.add((Object)objType.getPrototypeObject());
            }
            return this;
        }
    }
}

