/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.Es6SyntacticScopeCreator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Reference;
import com.google.javascript.jscomp.ReferenceCollectingCallback;
import com.google.javascript.jscomp.ReferenceCollection;
import com.google.javascript.jscomp.ReferenceMap;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

class HoistVarsOutOfBlocks
extends NodeTraversal.AbstractPostOrderCallback
implements ReferenceCollectingCallback.Behavior,
CompilerPass {
    private final AbstractCompiler compiler;
    private ReferenceMap refMap;
    private final ScopeCreator scopeCreator;

    HoistVarsOutOfBlocks(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.scopeCreator = new Es6SyntacticScopeCreator(compiler);
    }

    @Override
    public void process(Node externs, Node root) {
        ReferenceCollectingCallback rcc = new ReferenceCollectingCallback(this.compiler, this, this.scopeCreator);
        rcc.process(root);
    }

    @Override
    public void afterExitScope(NodeTraversal t, ReferenceMap refMap) {
        if (!t.getScope().isHoistScope()) {
            return;
        }
        this.refMap = refMap;
        new NodeTraversal(this.compiler, this, this.scopeCreator).traverseAtScope(t.getScope());
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isVar() && t.getScope() != t.getClosestHoistScope()) {
            this.hoistVarIfNeeded(t, n, parent);
        }
    }

    private void hoistVarIfNeeded(NodeTraversal t, Node varNode, Node parent) {
        if (NodeUtil.isAnyFor(parent)) {
            return;
        }
        Node block = t.getScopeRoot();
        for (Node lhs : varNode.children()) {
            Var var;
            ReferenceCollection refs;
            if (!lhs.isName() || (refs = this.refMap.getReferences(var = t.getScope().getVar(lhs.getString()))) == null) continue;
            boolean hoist = false;
            for (Reference r : refs) {
                if (r.getNode().isDescendantOf(block)) continue;
                hoist = true;
                break;
            }
            if (!hoist) continue;
            Node rhs = lhs.removeFirstChild();
            Node hoistRoot = t.getClosestHoistScope().getRootNode();
            if (hoistRoot.isRoot()) {
                hoistRoot = NodeUtil.getEnclosingScript(varNode);
            }
            if (rhs == null) {
                NodeUtil.removeChild(lhs.getParent(), lhs);
            } else {
                Node exprAssign = IR.exprResult(IR.assign(lhs.cloneNode(), rhs));
                exprAssign.useSourceInfoIfMissingFromForTree(varNode);
                NodeUtil.replaceDeclarationChild(lhs, exprAssign);
            }
            hoistRoot.addChildToFront(IR.var(lhs.cloneNode()).useSourceInfoIfMissingFromForTree(lhs));
            t.reportCodeChange();
        }
    }
}

