/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6TemplateLiterals;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class Es6ToEs3Converter
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    static final DiagnosticType CANNOT_CONVERT = DiagnosticType.error("JSC_CANNOT_CONVERT", "This code cannot be converted from ES6. {0}");
    static final DiagnosticType CANNOT_CONVERT_YET = DiagnosticType.error("JSC_CANNOT_CONVERT_YET", "ES6 transpilation of ''{0}'' is not yet implemented.");
    static final DiagnosticType BAD_REST_PARAMETER_ANNOTATION = DiagnosticType.warning("BAD_REST_PARAMETER_ANNOTATION", "Missing \"...\" in type annotation for rest parameter.");
    private static final String REST_INDEX = "$jscomp$restIndex";
    private static final String REST_PARAMS = "$jscomp$restParams";
    private static final String FRESH_SPREAD_VAR = "$jscomp$spread$args";
    private static final String FRESH_COMP_PROP_VAR = "$jscomp$compprop";
    private static final String ITER_BASE = "$jscomp$iter$";
    private static final String ITER_RESULT = "$jscomp$key$";

    public Es6ToEs3Converter(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, externs, this);
        TranspilationPasses.processTranspile(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case REST: {
                this.visitRestParam(t, n, parent);
                break;
            }
            case GETTER_DEF: 
            case SETTER_DEF: {
                if (this.compiler.getOptions().getLanguageOut() != CompilerOptions.LanguageMode.ECMASCRIPT3) break;
                this.cannotConvert(n, "ES5 getters/setters (consider using --language_out=ES5)");
                return false;
            }
            case FUNCTION: {
                if (!n.isAsyncFunction()) break;
                throw new IllegalStateException("async functions should have already been converted");
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        block0 : switch (n.getToken()) {
            case NAME: {
                if (n.isFromExterns() || !this.isGlobalSymbol(t, n)) break;
                this.initSymbolBefore(n);
                break;
            }
            case GETPROP: {
                if (n.isFromExterns()) break;
                this.visitGetprop(t, n);
                break;
            }
            case OBJECTLIT: {
                this.visitObject(n);
                break;
            }
            case MEMBER_FUNCTION_DEF: {
                if (!parent.isObjectLit()) break;
                this.visitMemberFunctionDefInObjectLit(n, parent);
                break;
            }
            case FOR_OF: {
                this.visitForOf(n, parent);
                break;
            }
            case STRING_KEY: {
                this.visitStringKey(n);
                break;
            }
            case ARRAYLIT: 
            case NEW: 
            case CALL: {
                for (Node child : n.children()) {
                    if (!child.isSpread()) continue;
                    this.visitArrayLitOrCallWithSpread(n, parent);
                    break block0;
                }
                break;
            }
            case TAGGED_TEMPLATELIT: {
                Es6TemplateLiterals.visitTaggedTemplateLiteral(t, n);
                break;
            }
            case TEMPLATELIT: {
                if (parent.isTaggedTemplateLit()) break;
                Es6TemplateLiterals.visitTemplateLiteral(t, n);
                break;
            }
            case EXPONENT: {
                this.visitExponentiationExpression(n, parent);
                break;
            }
            case ASSIGN_EXPONENT: {
                this.visitExponentiationAssignmentExpression(n, parent);
                break;
            }
        }
    }

    private boolean isGlobalSymbol(NodeTraversal t, Node n) {
        if (!n.matchesQualifiedName("Symbol")) {
            return false;
        }
        Var var = t.getScope().getVar("Symbol");
        return var == null || var.isGlobal();
    }

    private void initSymbolBefore(Node n) {
        this.compiler.ensureLibraryInjected("es6/symbol", false);
        Node statement = NodeUtil.getEnclosingStatement(n);
        Node initSymbol = IR.exprResult(IR.call(NodeUtil.newQName(this.compiler, "$jscomp.initSymbol"), new Node[0]));
        statement.getParent().addChildBefore(initSymbol.useSourceInfoFromForTree(statement), statement);
        this.compiler.reportChangeToEnclosingScope(initSymbol);
    }

    private void visitExponentiationExpression(Node n, Node parent) {
        Node left = n.removeFirstChild();
        Node right = n.removeFirstChild();
        Node mathDotPowCall = IR.call(NodeUtil.newQName(this.compiler, "Math.pow"), left, right).useSourceInfoIfMissingFromForTree(n);
        parent.replaceChild(n, mathDotPowCall);
        this.compiler.reportChangeToEnclosingScope(mathDotPowCall);
    }

    private void visitExponentiationAssignmentExpression(Node n, Node parent) {
        Node left = n.removeFirstChild();
        Node right = n.removeFirstChild();
        Node mathDotPowCall = IR.call(NodeUtil.newQName(this.compiler, "Math.pow"), left.cloneTree(), right);
        Node assign = IR.assign(left, mathDotPowCall).useSourceInfoIfMissingFromForTree(n);
        parent.replaceChild(n, assign);
        this.compiler.reportChangeToEnclosingScope(assign);
    }

    private void visitGetprop(NodeTraversal t, Node n) {
        if (!n.matchesQualifiedName("Symbol.iterator")) {
            return;
        }
        if (this.isGlobalSymbol(t, n.getFirstChild())) {
            this.compiler.ensureLibraryInjected("es6/symbol", false);
            Node statement = NodeUtil.getEnclosingStatement(n);
            Node init = IR.exprResult(IR.call(NodeUtil.newQName(this.compiler, "$jscomp.initSymbolIterator"), new Node[0]));
            statement.getParent().addChildBefore(init.useSourceInfoFromForTree(statement), statement);
            this.compiler.reportChangeToEnclosingScope(init);
        }
    }

    private void visitMemberFunctionDefInObjectLit(Node n, Node parent) {
        String name = n.getString();
        Node stringKey = IR.stringKey(name, n.getFirstChild().detach());
        stringKey.setJSDocInfo(n.getJSDocInfo());
        parent.replaceChild(n, stringKey);
        this.compiler.reportChangeToEnclosingScope(stringKey);
    }

    private void visitStringKey(Node n) {
        if (!n.hasChildren()) {
            Node name = IR.name(n.getString());
            name.useSourceInfoIfMissingFrom(n);
            n.addChildToBack(name);
            this.compiler.reportChangeToEnclosingScope(name);
        }
    }

    private void visitForOf(Node node, Node parent) {
        Node declarationOrAssign;
        String variableName;
        Token declType;
        Node variable = node.removeFirstChild();
        Node iterable = node.removeFirstChild();
        Node body = node.removeFirstChild();
        JSDocInfo varJSDocInfo = variable.getJSDocInfo();
        Node iterName = IR.name(ITER_BASE + (String)this.compiler.getUniqueNameIdSupplier().get());
        iterName.makeNonIndexable();
        Node getNext = IR.call(IR.getprop(iterName.cloneTree(), IR.string("next")), new Node[0]);
        if (variable.isName()) {
            declType = Token.NAME;
            variableName = variable.getQualifiedName();
        } else {
            Preconditions.checkState((boolean)NodeUtil.isNameDeclaration(variable), (String)"Expected var, let, or const. Got %s", (Object)variable);
            declType = variable.getToken();
            variableName = variable.getFirstChild().getQualifiedName();
        }
        Node iterResult = IR.name(ITER_RESULT + variableName);
        iterResult.makeNonIndexable();
        Node init = IR.var(iterName.cloneTree(), Es6ToEs3Converter.makeIterator(this.compiler, iterable));
        Node initIterResult = iterResult.cloneTree();
        initIterResult.addChildToFront(getNext.cloneTree());
        init.addChildToBack(initIterResult);
        Node cond = IR.not(IR.getprop(iterResult.cloneTree(), IR.string("done")));
        Node incr = IR.assign(iterResult.cloneTree(), getNext.cloneTree());
        if (declType == Token.NAME) {
            declarationOrAssign = IR.assign(IR.name(variableName).useSourceInfoFrom(variable), IR.getprop(iterResult.cloneTree(), IR.string("value")));
            declarationOrAssign.setJSDocInfo(varJSDocInfo);
            declarationOrAssign = IR.exprResult(declarationOrAssign);
        } else {
            declarationOrAssign = new Node(declType, IR.name(variableName).useSourceInfoFrom(variable.getFirstChild()));
            declarationOrAssign.getFirstChild().addChildToBack(IR.getprop(iterResult.cloneTree(), IR.string("value")));
            declarationOrAssign.setJSDocInfo(varJSDocInfo);
        }
        Node newBody = IR.block(declarationOrAssign, body).useSourceInfoFrom(body);
        Node newFor = IR.forNode(init, cond, incr, newBody);
        newFor.useSourceInfoIfMissingFromForTree(node);
        parent.replaceChild(node, newFor);
        this.compiler.reportChangeToEnclosingScope(newFor);
    }

    private void visitRestParam(NodeTraversal t, Node restParam, Node paramList) {
        Node functionBody = paramList.getNext();
        int restIndex = paramList.getIndexOfChild(restParam);
        String paramName = restParam.getFirstChild().getString();
        Node nameNode = IR.name(paramName);
        nameNode.setVarArgs(true);
        nameNode.setJSDocInfo(restParam.getJSDocInfo());
        paramList.replaceChild(restParam, nameNode);
        JSTypeExpression type = null;
        JSDocInfo info = restParam.getJSDocInfo();
        if (info != null) {
            type = info.getType();
        } else {
            JSDocInfo functionInfo = NodeUtil.getBestJSDocInfo(paramList.getParent());
            if (functionInfo != null) {
                type = functionInfo.getParameterType(paramName);
            }
        }
        if (type != null && type.getRoot().getToken() != Token.ELLIPSIS) {
            this.compiler.report(JSError.make(restParam, BAD_REST_PARAMETER_ANNOTATION, new String[0]));
        }
        if (!functionBody.hasChildren()) {
            t.reportCodeChange();
            return;
        }
        Node newBlock = IR.block().useSourceInfoFrom(functionBody);
        Node name = IR.name(paramName);
        Node let = IR.let(name, IR.name(REST_PARAMS)).useSourceInfoIfMissingFromForTree(functionBody);
        newBlock.addChildToFront(let);
        for (Node child : functionBody.children()) {
            newBlock.addChildToBack(child.detach());
        }
        if (type != null) {
            Node arrayType = IR.string("Array");
            Node typeNode = type.getRoot();
            Node memberType = typeNode.getToken() == Token.ELLIPSIS ? typeNode.getFirstChild().cloneTree() : typeNode.cloneTree();
            arrayType.addChildToFront(new Node(Token.BLOCK, memberType).useSourceInfoIfMissingFrom(typeNode));
            JSDocInfoBuilder builder = new JSDocInfoBuilder(false);
            builder.recordType(new JSTypeExpression(new Node(Token.BANG, arrayType), restParam.getSourceFileName()));
            name.setJSDocInfo(builder.build());
        }
        Node newArr = IR.var(IR.name(REST_PARAMS), IR.arraylit(new Node[0]));
        functionBody.addChildToFront(newArr.useSourceInfoIfMissingFromForTree(restParam));
        Node init = IR.var(IR.name(REST_INDEX), IR.number(restIndex));
        Node cond = IR.lt(IR.name(REST_INDEX), IR.getprop(IR.name("arguments"), IR.string("length")));
        Node incr = IR.inc(IR.name(REST_INDEX), false);
        Node body = IR.block(IR.exprResult(IR.assign(IR.getelem(IR.name(REST_PARAMS), IR.sub(IR.name(REST_INDEX), IR.number(restIndex))), IR.getelem(IR.name("arguments"), IR.name(REST_INDEX)))));
        functionBody.addChildAfter(IR.forNode(init, cond, incr, body).useSourceInfoIfMissingFromForTree(restParam), newArr);
        functionBody.addChildToBack(newBlock);
        this.compiler.reportChangeToEnclosingScope(newBlock);
    }

    private void visitArrayLitOrCallWithSpread(Node node, Node parent) {
        Preconditions.checkArgument((node.isCall() || node.isArrayLit() || node.isNew() ? 1 : 0) != 0);
        ArrayList<Node> groups = new ArrayList<Node>();
        Node currGroup = null;
        Node callee = node.isArrayLit() ? null : node.removeFirstChild();
        Node currElement = node.removeFirstChild();
        while (currElement != null) {
            if (currElement.isSpread()) {
                if (currGroup != null) {
                    groups.add(currGroup);
                    currGroup = null;
                }
                groups.add(Es6ToEs3Converter.arrayFromIterable(this.compiler, currElement.removeFirstChild()));
            } else {
                if (currGroup == null) {
                    currGroup = IR.arraylit(new Node[0]);
                }
                currGroup.addChildToBack(currElement);
            }
            currElement = node.removeFirstChild();
        }
        if (currGroup != null) {
            groups.add(currGroup);
        }
        Node result = null;
        Node firstGroup = node.isNew() ? IR.arraylit(IR.nullNode()) : IR.arraylit(new Node[0]);
        Node joinedGroups = IR.call(IR.getprop(firstGroup, IR.string("concat")), groups.toArray(new Node[0]));
        if (node.isArrayLit()) {
            result = joinedGroups;
        } else if (node.isCall()) {
            if (NodeUtil.mayHaveSideEffects(callee) && callee.isGetProp()) {
                Node statement = node;
                while (!NodeUtil.isStatement(statement)) {
                    statement = statement.getParent();
                }
                Node freshVar = IR.name(FRESH_SPREAD_VAR + (String)this.compiler.getUniqueNameIdSupplier().get());
                Node n = IR.var(freshVar.cloneTree());
                n.useSourceInfoIfMissingFromForTree(statement);
                statement.getParent().addChildBefore(n, statement);
                callee.addChildToFront(IR.assign(freshVar.cloneTree(), callee.removeFirstChild()));
                result = IR.call(IR.getprop(callee, IR.string("apply")), freshVar, joinedGroups);
            } else {
                Node context = callee.isGetProp() ? callee.getFirstChild().cloneTree() : IR.nullNode();
                result = IR.call(IR.getprop(callee, IR.string("apply")), context, joinedGroups);
            }
        } else {
            if (this.compiler.getOptions().getLanguageOut() == CompilerOptions.LanguageMode.ECMASCRIPT3) {
                this.cannotConvert(node, "\"...\" passed to a constructor (consider using --language_out=ES5)");
            }
            Node bindApply = NodeUtil.newQName(this.compiler, "Function.prototype.bind.apply");
            result = IR.newNode(IR.call(bindApply, callee, joinedGroups), new Node[0]);
        }
        result.useSourceInfoIfMissingFromForTree(node);
        parent.replaceChild(node, result);
        this.compiler.reportChangeToEnclosingScope(result);
    }

    private void visitObject(Node obj) {
        for (Node child : obj.children()) {
            if (!child.isComputedProp()) continue;
            this.visitObjectWithComputedProperty(obj);
            return;
        }
    }

    private void visitObjectWithComputedProperty(Node obj) {
        Preconditions.checkArgument((boolean)obj.isObjectLit());
        List<Node> props = new ArrayList();
        Node currElement = obj.getFirstChild();
        while (currElement != null) {
            if (currElement.getBooleanProp(73) || currElement.getBooleanProp(74)) {
                this.cannotConvertYet(currElement, "computed getter/setter in an object literal");
                return;
            }
            if (currElement.isGetterDef() || currElement.isSetterDef()) {
                currElement = currElement.getNext();
                continue;
            }
            Node nextNode = currElement.getNext();
            obj.removeChild(currElement);
            props.add(currElement);
            currElement = nextNode;
        }
        String objName = FRESH_COMP_PROP_VAR + (String)this.compiler.getUniqueNameIdSupplier().get();
        props = Lists.reverse(props);
        Node result = IR.name(objName);
        for (Node propdef : props) {
            if (propdef.isComputedProp()) {
                Node propertyExpression = propdef.removeFirstChild();
                Node value = propdef.removeFirstChild();
                result = IR.comma(IR.assign(IR.getelem(IR.name(objName), propertyExpression), value), result);
                continue;
            }
            if (!propdef.hasChildren()) {
                Node name = IR.name(propdef.getString()).useSourceInfoIfMissingFrom(propdef);
                propdef.addChildToBack(name);
            }
            Node val = propdef.removeFirstChild();
            propdef.setToken(Token.STRING);
            Token type = propdef.isQuotedString() ? Token.GETELEM : Token.GETPROP;
            Node access = new Node(type, IR.name(objName), propdef);
            result = IR.comma(IR.assign(access, val), result);
        }
        Node statement = obj;
        while (!NodeUtil.isStatement(statement)) {
            statement = statement.getParent();
        }
        result.useSourceInfoIfMissingFromForTree(obj);
        obj.replaceWith(result);
        Node var = IR.var(IR.name(objName), obj);
        var.useSourceInfoIfMissingFromForTree(statement);
        statement.getParent().addChildBefore(var, statement);
        this.compiler.reportChangeToEnclosingScope(var);
    }

    private void cannotConvert(Node n, String message) {
        this.compiler.report(JSError.make(n, CANNOT_CONVERT, message));
    }

    private void cannotConvertYet(Node n, String feature) {
        this.compiler.report(JSError.make(n, CANNOT_CONVERT_YET, feature));
    }

    static Node makeIterator(AbstractCompiler compiler, Node iterable) {
        return Es6ToEs3Converter.callEs6RuntimeFunction(compiler, iterable, "makeIterator");
    }

    private static Node arrayFromIterable(AbstractCompiler compiler, Node iterable) {
        return Es6ToEs3Converter.callEs6RuntimeFunction(compiler, iterable, "arrayFromIterable");
    }

    private static Node callEs6RuntimeFunction(AbstractCompiler compiler, Node iterable, String function) {
        compiler.ensureLibraryInjected("es6/util/" + function.toLowerCase(Locale.US), false);
        return IR.call(NodeUtil.newQName(compiler, "$jscomp." + function), iterable);
    }
}

