/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.Es6ToEs3Converter;
import com.google.javascript.jscomp.ExpressionDecomposer;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class Es6RewriteGenerators
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    private static final String GENERATOR_STATE = "$jscomp$generator$state";
    private static final String GENERATOR_DO_WHILE_INITIAL = "$jscomp$generator$first$do";
    private static final String GENERATOR_YIELD_ALL_NAME = "$jscomp$generator$yield$all";
    private static final String GENERATOR_YIELD_ALL_ENTRY = "$jscomp$generator$yield$entry";
    private static final String GENERATOR_ARGUMENTS = "$jscomp$generator$arguments";
    private static final String GENERATOR_THIS = "$jscomp$generator$this";
    private static final String GENERATOR_NEXT_ARG = "$jscomp$generator$next$arg";
    private static final String GENERATOR_THROW_ARG = "$jscomp$generator$throw$arg";
    private static final String GENERATOR_SWITCH_ENTERED = "$jscomp$generator$switch$entered";
    private static final String GENERATOR_SWITCH_VAL = "$jscomp$generator$switch$val";
    private static final String GENERATOR_FINALLY_JUMP = "$jscomp$generator$finally";
    private static final String GENERATOR_ERROR = "$jscomp$generator$global$error";
    private static final String GENERATOR_FOR_IN_ARRAY = "$jscomp$generator$forin$array";
    private static final String GENERATOR_FOR_IN_VAR = "$jscomp$generator$forin$var";
    private static final String GENERATOR_FOR_IN_ITER = "$jscomp$generator$forin$iter";
    private static final String GENERATOR_LOOP_GUARD = "$jscomp$generator$loop$guard";
    private final AbstractCompiler compiler;
    private final List<LoopContext> currentLoopContext;
    private final List<ExceptionContext> currentExceptionContext;
    private static int generatorCaseCount;
    private Supplier<String> generatorCounter;
    private Node enclosingBlock;
    private Node hoistRoot;
    private Node originalGeneratorBody;
    private Node currentStatement;
    private boolean hasTranslatedTry;

    public Es6RewriteGenerators(AbstractCompiler compiler) {
        Preconditions.checkNotNull((Object)compiler);
        this.compiler = compiler;
        this.currentLoopContext = new ArrayList<LoopContext>();
        this.currentExceptionContext = new ArrayList<ExceptionContext>();
        this.generatorCounter = compiler.getUniqueNameIdSupplier();
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, root, new DecomposeYields(this.compiler), this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, new DecomposeYields(this.compiler), this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case FUNCTION: {
                if (!n.isGeneratorFunction()) break;
                generatorCaseCount = 0;
                this.visitGenerator(n, parent);
                break;
            }
            case NAME: {
                Node enclosing = NodeUtil.getEnclosingFunction(n);
                if (enclosing == null || !enclosing.isGeneratorFunction() || !n.matchesQualifiedName("arguments")) break;
                n.setString(GENERATOR_ARGUMENTS);
                break;
            }
            case THIS: {
                Node enclosing = NodeUtil.getEnclosingFunction(n);
                if (enclosing == null || !enclosing.isGeneratorFunction()) break;
                n.replaceWith(IR.name(GENERATOR_THIS));
                break;
            }
            case YIELD: {
                if (n.isYieldFor()) {
                    this.visitYieldFor(t, n, parent);
                    break;
                }
                if (!parent.isExprResult()) {
                    this.visitYieldExpr(t, n, parent);
                    break;
                }
                this.visitYieldThrows(t, parent, parent.getParent());
                break;
            }
        }
    }

    private void visitYieldThrows(NodeTraversal t, Node n, Node parent) {
        Node ifThrows = IR.ifNode(IR.shne(IR.name(GENERATOR_THROW_ARG), IR.name("undefined")), IR.block(IR.throwNode(IR.name(GENERATOR_THROW_ARG))));
        parent.addChildAfter(ifThrows, n);
        t.reportCodeChange();
    }

    private void visitYieldFor(NodeTraversal t, Node n, Node parent) {
        Node enclosingStatement = NodeUtil.getEnclosingStatement(n);
        Node generator = IR.var(IR.name(GENERATOR_YIELD_ALL_NAME), Es6ToEs3Converter.makeIterator(this.compiler, n.removeFirstChild()));
        Node entryDecl = IR.var(IR.name(GENERATOR_YIELD_ALL_ENTRY));
        Node assignIterResult = IR.assign(IR.name(GENERATOR_YIELD_ALL_ENTRY), IR.call(IR.getprop(IR.name(GENERATOR_YIELD_ALL_NAME), IR.string("next")), IR.name(GENERATOR_NEXT_ARG)));
        Node loopCondition = IR.not(IR.getprop(assignIterResult, IR.string("done")));
        Node elemValue = IR.getprop(IR.name(GENERATOR_YIELD_ALL_ENTRY), IR.string("value"));
        Node yieldStatement = IR.exprResult(IR.yield(elemValue.cloneTree()));
        Node loop = IR.whileNode(loopCondition, IR.block(yieldStatement));
        enclosingStatement.getParent().addChildBefore(generator, enclosingStatement);
        enclosingStatement.getParent().addChildBefore(entryDecl, enclosingStatement);
        enclosingStatement.getParent().addChildBefore(loop, enclosingStatement);
        if (parent.isExprResult()) {
            parent.detach();
        } else {
            parent.replaceChild(n, elemValue);
        }
        this.visitYieldThrows(t, yieldStatement, yieldStatement.getParent());
        t.reportCodeChange();
    }

    private void visitYieldExpr(NodeTraversal t, Node n, Node parent) {
        Node enclosingStatement = NodeUtil.getEnclosingStatement(n);
        Node yieldStatement = IR.exprResult(n.hasChildren() ? IR.yield(n.removeFirstChild()) : IR.yield());
        Node yieldResult = IR.name(GENERATOR_NEXT_ARG + (String)this.generatorCounter.get());
        Node yieldResultDecl = IR.var(yieldResult.cloneTree(), IR.name(GENERATOR_NEXT_ARG));
        parent.replaceChild(n, yieldResult);
        enclosingStatement.getParent().addChildBefore(yieldStatement, enclosingStatement);
        enclosingStatement.getParent().addChildBefore(yieldResultDecl, enclosingStatement);
        this.visitYieldThrows(t, yieldStatement, yieldStatement.getParent());
        t.reportCodeChange();
    }

    private void visitGenerator(Node n, Node parent) {
        this.compiler.ensureLibraryInjected("es6/symbol", false);
        this.hasTranslatedTry = false;
        Node genBlock = this.compiler.parseSyntheticCode(Joiner.on((char)'\n').join((Object)"function generatorBody() {", (Object)("  var $jscomp$generator$state = " + generatorCaseCount + ";"), new Object[]{"  function $jscomp$generator$impl($jscomp$generator$next$arg, ", "      $jscomp$generator$throw$arg) {", "    while (1) switch ($jscomp$generator$state) {", "      case " + generatorCaseCount + ":", "      default:", "        return {value: undefined, done: true};", "    }", "  }", "  var iterator = /** @type {!Generator<?>} */ ({", "    next: function(arg) { return $jscomp$generator$impl(arg, undefined); },", "    throw: function(arg) { return $jscomp$generator$impl(undefined, arg); },", "    return: function(arg) { throw Error('Not yet implemented'); },", "  });", "  $jscomp.initSymbolIterator();", "  /** @this {!Generator<?>} */", "  iterator[Symbol.iterator] = function() { return this; };", "  return iterator;", "}"})).getFirstChild().getLastChild().detach();
        ++generatorCaseCount;
        this.originalGeneratorBody = n.getLastChild();
        n.replaceChild(this.originalGeneratorBody, genBlock);
        NodeUtil.markNewScopesChanged(genBlock, this.compiler);
        n.setIsGeneratorFunction(false);
        JSDocInfoBuilder builder = JSDocInfoBuilder.maybeCopyFrom(n.getJSDocInfo());
        builder.recordSuppressions((Set<String>)ImmutableSet.of((Object)"uselessCode"));
        JSDocInfo info = builder.build();
        n.setJSDocInfo(info);
        this.originalGeneratorBody.addChildToBack(IR.exprResult(IR.assign(IR.name(GENERATOR_STATE), IR.number(-1.0))));
        this.enclosingBlock = this.getUnique(genBlock, Token.CASE).getLastChild();
        this.hoistRoot = genBlock.getFirstChild();
        if (NodeUtil.isNameReferenced(this.originalGeneratorBody, GENERATOR_ARGUMENTS)) {
            this.hoistRoot.getParent().addChildAfter(IR.var(IR.name(GENERATOR_ARGUMENTS), IR.name("arguments")), this.hoistRoot);
        }
        if (NodeUtil.isNameReferenced(this.originalGeneratorBody, GENERATOR_THIS)) {
            this.hoistRoot.getParent().addChildAfter(IR.var(IR.name(GENERATOR_THIS), IR.thisNode()), this.hoistRoot);
        }
        while (this.originalGeneratorBody.hasChildren()) {
            this.currentStatement = this.originalGeneratorBody.removeFirstChild();
            boolean advanceCase = this.translateStatementInOriginalBody();
            if (!advanceCase) continue;
            int caseNumber = this.currentStatement.isGeneratorMarker() ? (int)this.currentStatement.getFirstChild().getDouble() : generatorCaseCount++;
            Node oldCase = this.enclosingBlock.getParent();
            Node newCase = IR.caseNode(IR.number(caseNumber), IR.block());
            this.enclosingBlock = newCase.getLastChild();
            if (oldCase.isTry()) {
                oldCase = oldCase.getGrandparent();
                if (!this.currentExceptionContext.isEmpty()) {
                    Node newTry = IR.tryCatch(IR.block(), this.currentExceptionContext.get((int)0).catchBlock.cloneTree());
                    newCase.getLastChild().addChildToBack(newTry);
                    this.enclosingBlock = newCase.getLastChild().getLastChild().getFirstChild();
                }
            }
            oldCase.getParent().addChildAfter(newCase, oldCase);
        }
        parent.useSourceInfoIfMissingFromForTree(parent);
        this.compiler.reportChangeToEnclosingScope(genBlock);
    }

    private boolean translateStatementInOriginalBody() {
        if (this.currentStatement.isVar()) {
            this.visitVar();
            return false;
        }
        if (this.currentStatement.isGeneratorMarker()) {
            this.visitGeneratorMarker();
            return true;
        }
        if (this.currentStatement.isFunction()) {
            this.visitFunctionStatement();
            return false;
        }
        if (this.currentStatement.isNormalBlock()) {
            this.visitBlock();
            return false;
        }
        if (this.controlCanExit(this.currentStatement)) {
            switch (this.currentStatement.getToken()) {
                case WHILE: 
                case DO: 
                case FOR: {
                    this.visitLoop(null);
                    return false;
                }
                case FOR_IN: {
                    this.visitForIn();
                    return false;
                }
                case LABEL: {
                    this.visitLabel();
                    return false;
                }
                case SWITCH: {
                    this.visitSwitch();
                    return false;
                }
                case IF: {
                    if (this.currentStatement.isGeneratorSafe()) break;
                    this.visitIf();
                    return false;
                }
                case TRY: {
                    this.visitTry();
                    return false;
                }
                case EXPR_RESULT: {
                    if (!this.currentStatement.getFirstChild().isYield()) break;
                    this.visitYieldExprResult();
                    return true;
                }
                case RETURN: {
                    this.visitReturn();
                    return false;
                }
                case CONTINUE: {
                    this.visitContinue();
                    return false;
                }
                case BREAK: {
                    if (this.currentStatement.isGeneratorSafe()) break;
                    this.visitBreak();
                    return false;
                }
                case THROW: {
                    this.visitThrow();
                    return false;
                }
                default: {
                    throw new RuntimeException("Untranslatable control-exiting statement in generator function: " + (Object)((Object)this.currentStatement.getToken()));
                }
            }
        }
        this.enclosingBlock.addChildToBack(this.currentStatement);
        return false;
    }

    private void visitFunctionStatement() {
        this.hoistRoot.getParent().addChildAfter(this.currentStatement, this.hoistRoot);
    }

    private void visitTry() {
        Node catchBody;
        Node caughtError;
        Node tryBody = this.currentStatement.getFirstChild();
        Node catchBlock = tryBody.getNext();
        if (catchBlock.hasChildren()) {
            caughtError = catchBlock.getFirstChild().removeFirstChild();
            catchBody = catchBlock.getFirstChild().removeFirstChild();
        } else {
            caughtError = IR.name("$jscomp$generator$global$errortemp");
            catchBody = IR.block(IR.throwNode(caughtError.cloneTree()));
            catchBody.getFirstChild().setGeneratorSafe(true);
        }
        Node finallyBody = catchBlock.getNext();
        int catchStartState = generatorCaseCount++;
        Node catchStart = Es6RewriteGenerators.makeGeneratorMarker(catchStartState);
        Node errorNameGenerated = IR.name("$jscomp$generator$" + caughtError.getString());
        this.originalGeneratorBody.addChildToFront(catchStart);
        this.originalGeneratorBody.addChildAfter(catchBody, catchStart);
        Node assignError = IR.assign(IR.name(GENERATOR_ERROR), errorNameGenerated.cloneTree());
        Node newCatchBody = IR.block(IR.exprResult(assignError), Es6RewriteGenerators.createStateUpdate(catchStartState), Es6RewriteGenerators.createSafeBreak());
        Node newCatch = IR.catchNode(errorNameGenerated, newCatchBody);
        this.currentExceptionContext.add(0, new ExceptionContext(catchStartState, newCatch));
        if (finallyBody != null) {
            Node finallyName = IR.name(GENERATOR_FINALLY_JUMP + (String)this.generatorCounter.get());
            int finallyStartState = generatorCaseCount++;
            Node finallyStart = Es6RewriteGenerators.makeGeneratorMarker(finallyStartState);
            int finallyEndState = generatorCaseCount++;
            Node finallyEnd = Es6RewriteGenerators.makeGeneratorMarker(finallyEndState);
            NodeTraversal.traverseEs6(this.compiler, tryBody, new ControlExitsCheck(finallyName, finallyStartState));
            NodeTraversal.traverseEs6(this.compiler, catchBody, new ControlExitsCheck(finallyName, finallyStartState));
            this.originalGeneratorBody.addChildToFront(tryBody.detach());
            this.originalGeneratorBody.addChildAfter(finallyStart, catchBody);
            this.originalGeneratorBody.addChildAfter(finallyBody.detach(), finallyStart);
            this.originalGeneratorBody.addChildAfter(finallyEnd, finallyBody);
            this.originalGeneratorBody.addChildToFront(IR.var(finallyName.cloneTree()));
            finallyBody.addChildToBack(IR.exprResult(IR.assign(IR.name(GENERATOR_STATE), finallyName.cloneTree())));
            finallyBody.addChildToBack(Es6RewriteGenerators.createSafeBreak());
            tryBody.addChildToBack(IR.exprResult(IR.assign(finallyName.cloneTree(), IR.number(finallyEndState))));
            tryBody.addChildToBack(Es6RewriteGenerators.createStateUpdate(finallyStartState));
            tryBody.addChildToBack(Es6RewriteGenerators.createSafeBreak());
            catchBody.addChildToBack(IR.exprResult(IR.assign(finallyName.cloneTree(), IR.number(finallyEndState))));
        } else {
            int catchEndState = generatorCaseCount++;
            Node catchEnd = Es6RewriteGenerators.makeGeneratorMarker(catchEndState);
            this.originalGeneratorBody.addChildAfter(catchEnd, catchBody);
            tryBody.addChildToBack(Es6RewriteGenerators.createStateUpdate(catchEndState));
            tryBody.addChildToBack(Es6RewriteGenerators.createSafeBreak());
            this.originalGeneratorBody.addChildToFront(tryBody.detach());
        }
        catchBody.addChildToFront(IR.var(caughtError, IR.name(GENERATOR_ERROR)));
        if (this.enclosingBlock.getParent().isTry()) {
            this.enclosingBlock = this.enclosingBlock.getGrandparent();
        }
        this.enclosingBlock.addChildToBack(IR.tryCatch(IR.block(), newCatch));
        this.enclosingBlock = this.enclosingBlock.getLastChild().getFirstChild();
        if (!this.hasTranslatedTry) {
            this.hasTranslatedTry = true;
            this.hoistRoot.getParent().addChildAfter(IR.var(IR.name(GENERATOR_ERROR)), this.hoistRoot);
        }
    }

    private void visitContinue() {
        Preconditions.checkState((this.currentLoopContext.get((int)0).continueCase != -1 ? 1 : 0) != 0);
        int continueCase = this.currentStatement.hasChildren() ? this.getLoopContext((String)this.currentStatement.removeFirstChild().getString()).continueCase : this.currentLoopContext.get((int)0).continueCase;
        this.enclosingBlock.addChildToBack(Es6RewriteGenerators.createStateUpdate(continueCase));
        this.enclosingBlock.addChildToBack(Es6RewriteGenerators.createSafeBreak());
    }

    private void visitThrow() {
        this.enclosingBlock.addChildToBack(Es6RewriteGenerators.createStateUpdate(-1));
        this.enclosingBlock.addChildToBack(this.currentStatement);
    }

    private void visitBreak() {
        int breakCase;
        if (this.currentStatement.hasChildren()) {
            LoopContext loop = this.getLoopContext(this.currentStatement.removeFirstChild().getString());
            if (loop == null) {
                this.compiler.report(JSError.make(this.currentStatement, Es6ToEs3Converter.CANNOT_CONVERT_YET, "Breaking to a label that is not a loop"));
                return;
            }
            breakCase = loop.breakCase;
        } else {
            breakCase = this.currentLoopContext.get((int)0).breakCase;
        }
        this.enclosingBlock.addChildToBack(Es6RewriteGenerators.createStateUpdate(breakCase));
        this.enclosingBlock.addChildToBack(Es6RewriteGenerators.createSafeBreak());
    }

    private void visitLabel() {
        Node labelName = this.currentStatement.removeFirstChild();
        Node child = this.currentStatement.removeFirstChild();
        if (NodeUtil.isLoopStructure(child)) {
            this.currentStatement = child;
            this.visitLoop(labelName.getString());
        } else {
            this.originalGeneratorBody.addChildToFront(child);
        }
    }

    private void visitGeneratorMarker() {
        if (!this.currentLoopContext.isEmpty() && (double)this.currentLoopContext.get((int)0).breakCase == this.currentStatement.getFirstChild().getDouble()) {
            this.currentLoopContext.remove(0);
        }
        if (!this.currentExceptionContext.isEmpty() && (double)this.currentExceptionContext.get((int)0).catchStartCase == this.currentStatement.getFirstChild().getDouble()) {
            this.currentExceptionContext.remove(0);
        }
    }

    private void visitIf() {
        Node condition = this.currentStatement.removeFirstChild();
        Node ifBody = this.currentStatement.removeFirstChild();
        boolean hasElse = this.currentStatement.hasChildren();
        int ifEndState = generatorCaseCount++;
        Node invertedConditional = IR.ifNode(IR.not(condition), IR.block(Es6RewriteGenerators.createStateUpdate(ifEndState), Es6RewriteGenerators.createSafeBreak()));
        invertedConditional.setGeneratorSafe(true);
        Node endIf = Es6RewriteGenerators.makeGeneratorMarker(ifEndState);
        this.originalGeneratorBody.addChildToFront(invertedConditional);
        this.originalGeneratorBody.addChildAfter(ifBody, invertedConditional);
        this.originalGeneratorBody.addChildAfter(endIf, ifBody);
        if (hasElse) {
            Node elseBlock = this.currentStatement.removeFirstChild();
            int elseEndState = generatorCaseCount++;
            Node endElse = Es6RewriteGenerators.makeGeneratorMarker(elseEndState);
            ifBody.addChildToBack(Es6RewriteGenerators.createStateUpdate(elseEndState));
            ifBody.addChildToBack(Es6RewriteGenerators.createSafeBreak());
            this.originalGeneratorBody.addChildAfter(elseBlock, endIf);
            this.originalGeneratorBody.addChildAfter(endElse, elseBlock);
        }
    }

    private void visitSwitch() {
        Node didEnter = IR.name(GENERATOR_SWITCH_ENTERED + (String)this.generatorCounter.get());
        Node didEnterDecl = IR.var(didEnter.cloneTree(), IR.falseNode());
        Node switchVal = IR.name(GENERATOR_SWITCH_VAL + (String)this.generatorCounter.get());
        Node switchValDecl = IR.var(switchVal.cloneTree(), this.currentStatement.removeFirstChild());
        this.originalGeneratorBody.addChildToFront(didEnterDecl);
        this.originalGeneratorBody.addChildAfter(switchValDecl, didEnterDecl);
        Node insertionPoint = switchValDecl;
        while (this.currentStatement.hasChildren()) {
            Node equivBlock;
            Node currCase = this.currentStatement.removeFirstChild();
            currCase.getLastChild().addChildToFront(IR.exprResult(IR.assign(didEnter.cloneTree(), IR.trueNode())));
            if (currCase.isDefaultCase()) {
                if (this.currentStatement.hasChildren()) {
                    this.compiler.report(JSError.make(this.currentStatement, Es6ToEs3Converter.CANNOT_CONVERT_YET, "Default case as intermediate case"));
                }
                equivBlock = IR.block(currCase.removeFirstChild());
            } else {
                equivBlock = IR.ifNode(IR.or(didEnter.cloneTree(), IR.sheq(switchVal.cloneTree(), currCase.removeFirstChild())), currCase.removeFirstChild());
            }
            this.originalGeneratorBody.addChildAfter(equivBlock, insertionPoint);
            insertionPoint = equivBlock;
        }
        int breakTarget = generatorCaseCount++;
        int cont = this.currentLoopContext.isEmpty() ? -1 : this.currentLoopContext.get((int)0).continueCase;
        this.currentLoopContext.add(0, new LoopContext(breakTarget, cont, null));
        Node breakCase = Es6RewriteGenerators.makeGeneratorMarker(breakTarget);
        this.originalGeneratorBody.addChildAfter(breakCase, insertionPoint);
    }

    private void visitBlock() {
        if (!this.currentStatement.hasChildren()) {
            return;
        }
        Node insertionPoint = this.currentStatement.removeFirstChild();
        this.originalGeneratorBody.addChildToFront(insertionPoint);
        Node child = this.currentStatement.removeFirstChild();
        while (child != null) {
            this.originalGeneratorBody.addChildAfter(child, insertionPoint);
            insertionPoint = child;
            child = this.currentStatement.removeFirstChild();
        }
    }

    private void visitForIn() {
        Node variable = this.currentStatement.removeFirstChild();
        Node iterable = this.currentStatement.removeFirstChild();
        Node body = this.currentStatement.removeFirstChild();
        String loopId = (String)this.generatorCounter.get();
        Node arrayName = IR.name(GENERATOR_FOR_IN_ARRAY + loopId);
        Node varName = IR.name(GENERATOR_FOR_IN_VAR + loopId);
        Node iterableName = IR.name(GENERATOR_FOR_IN_ITER + loopId);
        if (variable.isVar()) {
            variable = variable.removeFirstChild();
        }
        body.addChildToFront(IR.ifNode(IR.not(IR.in(variable.cloneTree(), iterableName.cloneTree())), IR.block(IR.continueNode())));
        body.addChildToFront(IR.var(variable.cloneTree(), IR.getelem(arrayName.cloneTree(), varName.cloneTree())));
        this.hoistRoot.getParent().addChildAfter(IR.var(arrayName.cloneTree()), this.hoistRoot);
        this.hoistRoot.getParent().addChildAfter(IR.var(varName.cloneTree()), this.hoistRoot);
        this.hoistRoot.getParent().addChildAfter(IR.var(iterableName.cloneTree()), this.hoistRoot);
        Node arrayDef = IR.exprResult(IR.assign(arrayName.cloneTree(), IR.arraylit(new Node[0])));
        Node iterDef = IR.exprResult(IR.assign(iterableName.cloneTree(), iterable));
        Node newForIn = IR.forIn(variable.cloneTree(), iterableName, IR.block(IR.exprResult(IR.call(IR.getprop(arrayName.cloneTree(), IR.string("push")), variable))));
        Node newFor = IR.forNode(IR.assign(varName.cloneTree(), IR.number(0.0)), IR.lt(varName.cloneTree(), IR.getprop(arrayName, IR.string("length"))), IR.inc(varName, true), body);
        this.enclosingBlock.addChildToBack(arrayDef);
        this.enclosingBlock.addChildToBack(iterDef);
        this.enclosingBlock.addChildToBack(newForIn);
        this.originalGeneratorBody.addChildToFront(newFor);
    }

    private void visitLoop(String label) {
        int loopBeginState;
        Node condition;
        Node prestatement;
        Node incr;
        Node initializer;
        Node body;
        Node guard;
        if (this.currentStatement.isWhile()) {
            guard = this.currentStatement.removeFirstChild();
            body = this.currentStatement.removeFirstChild();
            initializer = IR.empty();
            incr = IR.empty();
        } else if (this.currentStatement.isVanillaFor()) {
            initializer = this.currentStatement.removeFirstChild();
            if (initializer.isAssign()) {
                initializer = IR.exprResult(initializer);
            }
            guard = this.currentStatement.removeFirstChild();
            incr = this.currentStatement.removeFirstChild();
            body = this.currentStatement.removeFirstChild();
        } else {
            Preconditions.checkState((boolean)this.currentStatement.isDo());
            initializer = IR.empty();
            incr = IR.assign(IR.name(GENERATOR_DO_WHILE_INITIAL), IR.falseNode());
            body = this.currentStatement.removeFirstChild();
            guard = this.currentStatement.removeFirstChild();
        }
        if (guard.isNormalBlock()) {
            prestatement = guard.removeFirstChild();
            condition = guard.removeFirstChild();
        } else {
            prestatement = IR.block();
            condition = guard;
        }
        int continueState = loopBeginState = generatorCaseCount++;
        if (!incr.isEmpty()) {
            continueState = generatorCaseCount++;
            Node continueCase = Es6RewriteGenerators.makeGeneratorMarker(continueState);
            body.addChildToBack(continueCase);
            body.addChildToBack(incr.isNormalBlock() ? incr : IR.exprResult(incr));
        }
        this.currentLoopContext.add(0, new LoopContext(generatorCaseCount, continueState, label));
        Node beginCase = Es6RewriteGenerators.makeGeneratorMarker(loopBeginState);
        Node conditionalBranch = IR.ifNode(condition.isEmpty() ? IR.trueNode() : condition, body);
        Node setStateLoopStart = Es6RewriteGenerators.createStateUpdate(loopBeginState);
        Node breakToStart = Es6RewriteGenerators.createSafeBreak();
        this.originalGeneratorBody.addChildToFront(conditionalBranch);
        if (!prestatement.isEmpty()) {
            this.originalGeneratorBody.addChildToFront(prestatement);
        }
        this.originalGeneratorBody.addChildToFront(beginCase);
        if (!initializer.isEmpty()) {
            this.originalGeneratorBody.addChildToFront(initializer);
        }
        body.addChildToBack(setStateLoopStart);
        body.addChildToBack(breakToStart);
    }

    private void visitVar() {
        Node name = this.currentStatement.removeFirstChild();
        while (name != null) {
            if (name.hasChildren()) {
                this.enclosingBlock.addChildToBack(IR.exprResult(IR.assign(name, name.removeFirstChild())));
            }
            this.hoistRoot.getParent().addChildAfter(IR.var(name.cloneTree()), this.hoistRoot);
            name = this.currentStatement.removeFirstChild();
        }
    }

    private void visitYieldExprResult() {
        this.enclosingBlock.addChildToBack(Es6RewriteGenerators.createStateUpdate());
        Node yield = this.currentStatement.getFirstChild();
        Node value = yield.hasChildren() ? yield.removeFirstChild() : IR.name("undefined");
        this.enclosingBlock.addChildToBack(IR.returnNode(Es6RewriteGenerators.createIteratorResult(value, false)));
    }

    private void visitReturn() {
        this.enclosingBlock.addChildToBack(Es6RewriteGenerators.createStateUpdate(-1));
        this.enclosingBlock.addChildToBack(IR.returnNode(Es6RewriteGenerators.createIteratorResult(this.currentStatement.hasChildren() ? this.currentStatement.removeFirstChild() : IR.name("undefined"), true)));
    }

    private static Node createStateUpdate() {
        return IR.exprResult(IR.assign(IR.name(GENERATOR_STATE), IR.number(generatorCaseCount)));
    }

    private static Node createStateUpdate(int state) {
        return IR.exprResult(IR.assign(IR.name(GENERATOR_STATE), IR.number(state)));
    }

    private static Node createIteratorResult(Node value, boolean done) {
        return IR.objectlit(IR.propdef(IR.stringKey("value"), value), IR.propdef(IR.stringKey("done"), done ? IR.trueNode() : IR.falseNode()));
    }

    private static Node createSafeBreak() {
        Node breakNode = IR.breakNode();
        breakNode.setGeneratorSafe(true);
        return breakNode;
    }

    private static Node createFinallyJumpBlock(Node finallyName, int finallyStartState) {
        int jumpPoint = generatorCaseCount++;
        Node setReturnState = IR.exprResult(IR.assign(finallyName.cloneTree(), IR.number(jumpPoint)));
        Node toFinally = Es6RewriteGenerators.createStateUpdate(finallyStartState);
        Node returnPoint = Es6RewriteGenerators.makeGeneratorMarker(jumpPoint);
        Node returnBlock = IR.block(setReturnState, toFinally, Es6RewriteGenerators.createSafeBreak());
        returnBlock.addChildToBack(returnPoint);
        return returnBlock;
    }

    private LoopContext getLoopContext(String label) {
        for (LoopContext context : this.currentLoopContext) {
            if (!label.equals(context.label)) continue;
            return context;
        }
        return null;
    }

    private boolean controlCanExit(Node n) {
        ControlExitsCheck exits = new ControlExitsCheck();
        NodeTraversal.traverseEs6(this.compiler, n, exits);
        return exits.didExit();
    }

    private Node getUnique(Node node, Token type) {
        ArrayList<Node> matches = new ArrayList<Node>();
        this.insertAll(node, type, matches);
        Preconditions.checkState((matches.size() == 1 ? 1 : 0) != 0, matches);
        return (Node)matches.get(0);
    }

    private void insertAll(Node node, Token type, List<Node> matchingNodes) {
        if (node.getToken() == type) {
            matchingNodes.add(node);
        }
        for (Node c = node.getFirstChild(); c != null; c = c.getNext()) {
            this.insertAll(c, type, matchingNodes);
        }
    }

    private static Node makeGeneratorMarker(int i) {
        Node n = IR.exprResult(IR.number(i));
        n.setGeneratorMarker(true);
        return n;
    }

    private static final class ExceptionContext {
        int catchStartCase;
        Node catchBlock;

        ExceptionContext(int catchStartCase, Node catchBlock) {
            this.catchStartCase = catchStartCase;
            this.catchBlock = catchBlock;
        }
    }

    private static final class LoopContext {
        int breakCase;
        int continueCase;
        String label;

        LoopContext(int breakCase, int continueCase, String label) {
            this.breakCase = breakCase;
            this.continueCase = continueCase;
            this.label = label;
        }
    }

    private static final class ControlExitsCheck
    implements NodeTraversal.Callback {
        int continueCatchers;
        int breakCatchers;
        int throwCatchers;
        List<String> labels = new ArrayList<String>();
        boolean exited;
        boolean addJumps;
        private Node finallyName;
        private int finallyStartState;

        ControlExitsCheck(Node finallyName, int finallyStartState) {
            this.finallyName = finallyName;
            this.finallyStartState = finallyStartState;
            this.addJumps = true;
        }

        ControlExitsCheck() {
            this.addJumps = false;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            switch (n.getToken()) {
                case FUNCTION: {
                    return false;
                }
                case LABEL: {
                    this.labels.add(0, n.getFirstChild().getString());
                    break;
                }
                case WHILE: 
                case DO: 
                case FOR: 
                case FOR_IN: {
                    ++this.continueCatchers;
                    ++this.breakCatchers;
                    break;
                }
                case SWITCH: {
                    ++this.breakCatchers;
                    break;
                }
                case BLOCK: {
                    parent = n.getParent();
                    if (parent == null || !parent.isTry() || parent.getFirstChild() != n || !n.getNext().hasChildren()) break;
                    ++this.throwCatchers;
                    break;
                }
                case BREAK: {
                    if (n.isGeneratorSafe() || (this.breakCatchers != 0 || n.hasChildren()) && (!n.hasChildren() || this.labels.contains(n.getFirstChild().getString()))) break;
                    this.exited = true;
                    if (!this.addJumps) break;
                    parent.addChildBefore(Es6RewriteGenerators.createFinallyJumpBlock(this.finallyName, this.finallyStartState), n);
                    break;
                }
                case CONTINUE: {
                    if (this.continueCatchers != 0 && (!n.hasChildren() || this.labels.contains(n.getFirstChild().getString()))) break;
                    this.exited = true;
                    if (!this.addJumps) break;
                    parent.addChildBefore(Es6RewriteGenerators.createFinallyJumpBlock(this.finallyName, this.finallyStartState), n);
                    break;
                }
                case THROW: {
                    if (this.throwCatchers != 0) break;
                    this.exited = true;
                    if (!this.addJumps || n.isGeneratorSafe()) break;
                    parent.addChildBefore(Es6RewriteGenerators.createFinallyJumpBlock(this.finallyName, this.finallyStartState), n);
                    break;
                }
                case RETURN: {
                    this.exited = true;
                    if (!this.addJumps) break;
                    parent.addChildBefore(Es6RewriteGenerators.createFinallyJumpBlock(this.finallyName, this.finallyStartState), n);
                    break;
                }
                case YIELD: {
                    this.exited = true;
                    break;
                }
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case LABEL: {
                    this.labels.remove(0);
                    break;
                }
                case WHILE: 
                case DO: 
                case FOR: 
                case FOR_IN: {
                    --this.continueCatchers;
                    --this.breakCatchers;
                    break;
                }
                case SWITCH: {
                    --this.breakCatchers;
                    break;
                }
                case BLOCK: {
                    parent = n.getParent();
                    if (parent == null || !parent.isTry() || parent.getFirstChild() != n || !n.getNext().hasChildren()) break;
                    --this.throwCatchers;
                    break;
                }
            }
        }

        public boolean didExit() {
            return this.exited;
        }
    }

    private final class DecomposeYields
    extends NodeTraversal.AbstractPreOrderCallback {
        private final AbstractCompiler compiler;
        private final ExpressionDecomposer decomposer;

        DecomposeYields(AbstractCompiler compiler) {
            this.compiler = compiler;
            HashSet<String> consts = new HashSet<String>();
            this.decomposer = new ExpressionDecomposer(compiler, compiler.getUniqueNameIdSupplier(), consts, Scope.createGlobalScope(new Node(Token.SCRIPT)));
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case YIELD: {
                    this.visitYieldExpression(t, n);
                    break;
                }
                case WHILE: 
                case DO: 
                case FOR: {
                    this.visitLoop(t, n);
                    break;
                }
                case CASE: {
                    if (!Es6RewriteGenerators.this.controlCanExit(n.getFirstChild())) break;
                    this.compiler.report(JSError.make(n, Es6ToEs3Converter.CANNOT_CONVERT_YET, "Case statements that contain yields"));
                    return false;
                }
            }
            return true;
        }

        private void visitYieldExpression(NodeTraversal t, Node n) {
            if (n.getParent().isExprResult()) {
                return;
            }
            if (this.decomposer.canExposeExpression(n) != ExpressionDecomposer.DecompositionType.UNDECOMPOSABLE) {
                this.decomposer.exposeExpression(n);
                t.reportCodeChange();
            } else {
                this.compiler.report(JSError.make(n, Es6ToEs3Converter.CANNOT_CONVERT, "Undecomposable expression"));
            }
        }

        private void visitLoop(NodeTraversal t, Node n) {
            Node enclosingFunc = NodeUtil.getEnclosingFunction(n);
            if (enclosingFunc == null || !enclosingFunc.isGeneratorFunction() || n.isForIn()) {
                return;
            }
            Node enclosingBlock = NodeUtil.getEnclosingBlock(n);
            Node guard = null;
            Node incr = null;
            switch (n.getToken()) {
                case FOR: {
                    guard = n.getSecondChild();
                    incr = guard.getNext();
                    break;
                }
                case WHILE: {
                    guard = n.getFirstChild();
                    incr = IR.empty();
                    break;
                }
                case DO: {
                    guard = n.getLastChild();
                    if (!guard.isEmpty()) {
                        Node firstEntry = IR.name(Es6RewriteGenerators.GENERATOR_DO_WHILE_INITIAL);
                        enclosingBlock.addChildToFront(IR.var(firstEntry.cloneTree(), IR.trueNode()));
                        guard = IR.or(firstEntry, n.getLastChild().detach());
                        n.addChildToBack(guard);
                    }
                    incr = IR.empty();
                    break;
                }
            }
            if (!Es6RewriteGenerators.this.controlCanExit(guard) && !Es6RewriteGenerators.this.controlCanExit(incr)) {
                return;
            }
            Node guardName = IR.name(Es6RewriteGenerators.GENERATOR_LOOP_GUARD + (String)Es6RewriteGenerators.this.generatorCounter.get());
            if (!guard.isEmpty()) {
                Node container = new Node(Token.BLOCK);
                n.replaceChild(guard, container);
                container.addChildToFront(IR.block(IR.exprResult(IR.assign(guardName.cloneTree(), guard.cloneTree()))));
                container.addChildToBack(guardName.cloneTree());
            }
            if (!incr.isEmpty()) {
                n.addChildBefore(IR.block(IR.exprResult(incr.detach())), n.getLastChild());
            }
            enclosingBlock.addChildToFront(IR.var(guardName));
            t.reportCodeChange();
        }
    }
}

