/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.Es6ToEs3Converter;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TokenStream;

public final class Es6RewriteDestructuring
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    private static final String DESTRUCTURING_TEMP_VAR = "$jscomp$destructuring$var";
    private int destructuringVarCounter = 0;

    public Es6RewriteDestructuring(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, externs, this);
        TranspilationPasses.processTranspile(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case FUNCTION: {
                this.visitFunction(t, n);
                break;
            }
            case PARAM_LIST: {
                this.visitParamList(t, n, parent);
                break;
            }
            case FOR_OF: {
                this.visitForOf(n);
                break;
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (parent != null && parent.isDestructuringLhs()) {
            parent = parent.getParent();
        }
        switch (n.getToken()) {
            case ARRAY_PATTERN: 
            case OBJECT_PATTERN: {
                this.visitPattern(t, n, parent);
                break;
            }
        }
    }

    private void visitFunction(NodeTraversal t, Node function) {
        Node body = function.getLastChild();
        if (!body.isNormalBlock()) {
            body.detach();
            Node replacement = IR.block(IR.returnNode(body)).useSourceInfoIfMissingFromForTree(body);
            function.addChildToBack(replacement);
            t.reportCodeChange();
        }
    }

    private void visitParamList(NodeTraversal t, Node paramList, Node function) {
        Node insertSpot = null;
        Node body = function.getLastChild();
        int i = 0;
        Node next = null;
        Node param = paramList.getFirstChild();
        while (param != null) {
            next = param.getNext();
            if (param.isDefaultValue()) {
                Node newParam;
                JSDocInfo jsDoc = param.getJSDocInfo();
                Node nameOrPattern = param.removeFirstChild();
                Node defaultValue = param.removeFirstChild();
                boolean isNoop = false;
                if (nameOrPattern.isName()) {
                    if (defaultValue.isName()) {
                        isNoop = "undefined".equals(defaultValue.getString());
                    } else if (defaultValue.isVoid()) {
                        isNoop = NodeUtil.isImmutableValue(defaultValue.getFirstChild());
                    }
                }
                if (isNoop) {
                    newParam = nameOrPattern.cloneTree();
                } else {
                    newParam = nameOrPattern.isName() ? nameOrPattern : IR.name(this.getTempParameterName(function, i));
                    Node lhs = nameOrPattern.cloneTree();
                    Node rhs = Es6RewriteDestructuring.defaultValueHook(newParam.cloneTree(), defaultValue);
                    Node newStatement = nameOrPattern.isName() ? IR.exprResult(IR.assign(lhs, rhs)) : IR.var(lhs, rhs);
                    newStatement.useSourceInfoIfMissingFromForTree(param);
                    body.addChildAfter(newStatement, insertSpot);
                    insertSpot = newStatement;
                }
                paramList.replaceChild(param, newParam);
                newParam.setOptionalArg(true);
                newParam.setJSDocInfo(jsDoc);
                t.reportCodeChange();
            } else if (param.isDestructuringPattern()) {
                insertSpot = this.replacePatternParamWithTempVar(function, insertSpot, param, this.getTempParameterName(function, i));
                t.reportCodeChange();
            } else if (param.isRest() && param.getFirstChild().isDestructuringPattern()) {
                insertSpot = this.replacePatternParamWithTempVar(function, insertSpot, param.getFirstChild(), this.getTempParameterName(function, i));
                t.reportCodeChange();
            }
            param = next;
            ++i;
        }
    }

    private Node replacePatternParamWithTempVar(Node function, Node insertSpot, Node patternParam, String tempVarName) {
        Node newParam = IR.name(tempVarName);
        newParam.setJSDocInfo(patternParam.getJSDocInfo());
        patternParam.replaceWith(newParam);
        Node newDecl = IR.var(patternParam, IR.name(tempVarName));
        function.getLastChild().addChildAfter(newDecl, insertSpot);
        return newDecl;
    }

    private String getTempParameterName(Node function, int parameterIndex) {
        JSDocInfo fnJSDoc = NodeUtil.getBestJSDocInfo(function);
        String tempVarName = fnJSDoc != null && fnJSDoc.getParameterNameAt(parameterIndex) != null ? fnJSDoc.getParameterNameAt(parameterIndex) : DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
        Preconditions.checkState((boolean)TokenStream.isJSIdentifier(tempVarName));
        return tempVarName;
    }

    private void visitForOf(Node node) {
        Node lhs = node.getFirstChild();
        if (lhs.isDestructuringLhs()) {
            this.visitDestructuringPatternInEnhancedFor(lhs.getFirstChild());
        }
    }

    private void visitPattern(NodeTraversal t, Node pattern, Node parent) {
        if (NodeUtil.isNameDeclaration(parent) && !NodeUtil.isEnhancedFor(parent.getParent())) {
            this.replacePattern(t, pattern, pattern.getNext(), parent, parent);
        } else if (parent.isAssign()) {
            if (parent.getParent().isExprResult()) {
                this.replacePattern(t, pattern, pattern.getNext(), parent, parent.getParent());
            } else {
                this.wrapAssignmentInCallToArrow(t, parent);
            }
        } else if (!(parent.isRest() || parent.isStringKey() || parent.isArrayPattern() || parent.isDefaultValue())) {
            if (NodeUtil.isEnhancedFor(parent) || NodeUtil.isEnhancedFor(parent.getParent())) {
                this.visitDestructuringPatternInEnhancedFor(pattern);
            } else if (parent.isCatch()) {
                this.visitDestructuringPatternInCatch(pattern);
            } else {
                throw new IllegalStateException("unexpected parent");
            }
        }
    }

    private void replacePattern(NodeTraversal t, Node pattern, Node rhs, Node parent, Node nodeToDetach) {
        switch (pattern.getToken()) {
            case ARRAY_PATTERN: {
                this.replaceArrayPattern(t, pattern, rhs, parent, nodeToDetach);
                break;
            }
            case OBJECT_PATTERN: {
                this.replaceObjectPattern(t, pattern, rhs, parent, nodeToDetach);
                break;
            }
            default: {
                throw new IllegalStateException("unexpected");
            }
        }
    }

    private void replaceObjectPattern(NodeTraversal t, Node objectPattern, Node rhs, Node parent, Node nodeToDetach) {
        String tempVarName = DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
        Node tempDecl = IR.var(IR.name(tempVarName), rhs.detach()).useSourceInfoIfMissingFromForTree(objectPattern);
        if (parent.isConst()) {
            JSDocInfoBuilder jsDoc = new JSDocInfoBuilder(false);
            jsDoc.recordConstancy();
            tempDecl.setJSDocInfo(jsDoc.build());
        }
        nodeToDetach.getParent().addChildBefore(tempDecl, nodeToDetach);
        Node child = objectPattern.getFirstChild();
        while (child != null) {
            Node newNode;
            Node newRHS;
            Node newLHS;
            Node next = child.getNext();
            if (child.isStringKey()) {
                if (!child.hasChildren()) {
                    Node name = IR.name(child.getString());
                    name.useSourceInfoIfMissingFrom(child);
                    child.addChildToBack(name);
                }
                Node getprop = new Node(child.isQuotedString() ? Token.GETELEM : Token.GETPROP, IR.name(tempVarName), IR.string(child.getString()));
                Node value = child.removeFirstChild();
                if (!value.isDefaultValue()) {
                    newLHS = value;
                    newRHS = getprop;
                } else {
                    newLHS = value.removeFirstChild();
                    Node defaultValue = value.removeFirstChild();
                    newRHS = Es6RewriteDestructuring.defaultValueHook(getprop, defaultValue);
                }
            } else if (child.isComputedProp()) {
                if (child.getLastChild().isDefaultValue()) {
                    newLHS = child.getLastChild().removeFirstChild();
                    Node getelem = IR.getelem(IR.name(tempVarName), child.removeFirstChild());
                    String intermediateTempVarName = DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
                    Node intermediateDecl = IR.var(IR.name(intermediateTempVarName), getelem);
                    intermediateDecl.useSourceInfoIfMissingFromForTree(child);
                    nodeToDetach.getParent().addChildBefore(intermediateDecl, nodeToDetach);
                    newRHS = Es6RewriteDestructuring.defaultValueHook(IR.name(intermediateTempVarName), child.getLastChild().removeFirstChild());
                } else {
                    newRHS = IR.getelem(IR.name(tempVarName), child.removeFirstChild());
                    newLHS = child.removeFirstChild();
                }
            } else if (child.isDefaultValue()) {
                newLHS = child.removeFirstChild();
                Node defaultValue = child.removeFirstChild();
                Node getprop = IR.getprop(IR.name(tempVarName), IR.string(newLHS.getString()));
                newRHS = Es6RewriteDestructuring.defaultValueHook(getprop, defaultValue);
            } else {
                throw new IllegalStateException("unexpected child");
            }
            if (NodeUtil.isNameDeclaration(parent)) {
                newNode = IR.declaration(newLHS, newRHS, parent.getToken());
            } else if (parent.isAssign()) {
                newNode = IR.exprResult(IR.assign(newLHS, newRHS));
            } else {
                throw new IllegalStateException("not reached");
            }
            newNode.useSourceInfoIfMissingFromForTree(child);
            nodeToDetach.getParent().addChildBefore(newNode, nodeToDetach);
            this.visit(t, newLHS, newLHS.getParent());
            child = next;
        }
        nodeToDetach.detach();
        t.reportCodeChange();
    }

    private void replaceArrayPattern(NodeTraversal t, Node arrayPattern, Node rhs, Node parent, Node nodeToDetach) {
        String tempVarName = DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
        Node tempDecl = IR.var(IR.name(tempVarName), Es6ToEs3Converter.makeIterator(this.compiler, rhs.detach()));
        tempDecl.useSourceInfoIfMissingFromForTree(arrayPattern);
        nodeToDetach.getParent().addChildBefore(tempDecl, nodeToDetach);
        boolean needsRuntime = false;
        Node child = arrayPattern.getFirstChild();
        while (child != null) {
            Node next = child.getNext();
            if (child.isEmpty()) {
                Node nextCall = IR.exprResult(IR.call(IR.getprop(IR.name(tempVarName), IR.string("next")), new Node[0]));
                nextCall.useSourceInfoIfMissingFromForTree(child);
                nodeToDetach.getParent().addChildBefore(nextCall, nodeToDetach);
            } else {
                Node newNode;
                Node newRHS;
                Node newLHS;
                if (child.isDefaultValue()) {
                    String nextVarName = DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
                    Node var = IR.var(IR.name(nextVarName), IR.getprop(IR.call(IR.getprop(IR.name(tempVarName), IR.string("next")), new Node[0]), IR.string("value")));
                    var.useSourceInfoIfMissingFromForTree(child);
                    nodeToDetach.getParent().addChildBefore(var, nodeToDetach);
                    newLHS = child.getFirstChild().detach();
                    newRHS = Es6RewriteDestructuring.defaultValueHook(IR.name(nextVarName), child.getLastChild().detach());
                } else if (child.isRest()) {
                    newLHS = child.getFirstChild().detach();
                    newRHS = IR.call(NodeUtil.newQName(this.compiler, "$jscomp.arrayFromIterator"), IR.name(tempVarName));
                    needsRuntime = true;
                } else {
                    newLHS = child.detach();
                    newRHS = IR.getprop(IR.call(IR.getprop(IR.name(tempVarName), IR.string("next")), new Node[0]), IR.string("value"));
                }
                if (parent.isAssign()) {
                    Node assignment = IR.assign(newLHS, newRHS);
                    newNode = IR.exprResult(assignment);
                } else {
                    newNode = IR.declaration(newLHS, newRHS, parent.getToken());
                }
                newNode.useSourceInfoIfMissingFromForTree(arrayPattern);
                nodeToDetach.getParent().addChildBefore(newNode, nodeToDetach);
                this.visit(t, newLHS, newLHS.getParent());
            }
            child = next;
        }
        nodeToDetach.detach();
        if (needsRuntime) {
            this.compiler.ensureLibraryInjected("es6/util/arrayfromiterator", false);
        }
        t.reportCodeChange();
    }

    private void wrapAssignmentInCallToArrow(NodeTraversal t, Node assignment) {
        String tempVarName = DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
        Node rhs = assignment.getLastChild().detach();
        Node newAssignment = IR.let(IR.name(tempVarName), rhs);
        Node replacementExpr = IR.assign(assignment.getFirstChild().detach(), IR.name(tempVarName));
        Node exprResult = IR.exprResult(replacementExpr);
        Node returnNode = IR.returnNode(IR.name(tempVarName));
        Node block = IR.block(newAssignment, exprResult, returnNode);
        Node call = IR.call(IR.arrowFunction(IR.name(""), IR.paramList(), block), new Node[0]);
        call.useSourceInfoIfMissingFromForTree(assignment);
        call.putBooleanProp(50, true);
        assignment.getParent().replaceChild(assignment, call);
        NodeUtil.markNewScopesChanged(call, this.compiler);
        this.replacePattern(t, replacementExpr.getFirstChild(), replacementExpr.getLastChild(), replacementExpr, exprResult);
    }

    private void visitDestructuringPatternInEnhancedFor(Node pattern) {
        Preconditions.checkArgument((boolean)pattern.isDestructuringPattern());
        String tempVarName = DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
        if (NodeUtil.isEnhancedFor(pattern.getParent())) {
            Node forNode = pattern.getParent();
            Node block = forNode.getLastChild();
            Node decl = IR.var(IR.name(tempVarName));
            decl.useSourceInfoIfMissingFromForTree(pattern);
            forNode.replaceChild(pattern, decl);
            Node exprResult = IR.exprResult(IR.assign(pattern, IR.name(tempVarName)));
            exprResult.useSourceInfoIfMissingFromForTree(pattern);
            block.addChildToFront(exprResult);
        } else {
            Node destructuringLhs = pattern.getParent();
            Preconditions.checkState((boolean)destructuringLhs.isDestructuringLhs());
            Node declarationNode = destructuringLhs.getParent();
            Node forNode = declarationNode.getParent();
            Preconditions.checkState((boolean)NodeUtil.isEnhancedFor(forNode));
            Node block = forNode.getLastChild();
            declarationNode.replaceChild(destructuringLhs, IR.name(tempVarName).useSourceInfoFrom(pattern));
            Token declarationType = declarationNode.getToken();
            Node decl = IR.declaration(pattern.detach(), IR.name(tempVarName), declarationType);
            decl.useSourceInfoIfMissingFromForTree(pattern);
            block.addChildToFront(decl);
        }
    }

    private void visitDestructuringPatternInCatch(Node pattern) {
        String tempVarName = DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
        Node catchBlock = pattern.getNext();
        pattern.replaceWith(IR.name(tempVarName));
        catchBlock.addChildToFront(IR.declaration(pattern, IR.name(tempVarName), Token.LET));
    }

    private static Node defaultValueHook(Node getprop, Node defaultValue) {
        return IR.hook(IR.sheq(getprop, IR.name("undefined")), defaultValue, getprop.cloneTree());
    }
}

