/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.Es6RenameReferences;
import com.google.javascript.jscomp.Es6SyntacticScopeCreator;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.Set;

public final class Es6RenameVariablesInParamLists
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    private final AbstractCompiler compiler;

    public Es6RenameVariablesInParamLists(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (!n.isFunction() || !n.getLastChild().isNormalBlock()) {
            return;
        }
        Node paramList = n.getSecondChild();
        final CollectReferences collector = new CollectReferences();
        NodeTraversal.traverseEs6(this.compiler, paramList, new NodeTraversal.AbstractPreOrderCallback(){

            @Override
            public final boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
                if (parent == null) {
                    return true;
                }
                if (parent.isDefaultValue() && n == parent.getLastChild() || parent.isComputedProp() && n == parent.getFirstChild()) {
                    NodeTraversal.traverseEs6(Es6RenameVariablesInParamLists.this.compiler, n, collector);
                    return false;
                }
                return true;
            }
        });
        Node block = paramList.getNext();
        Es6SyntacticScopeCreator creator = new Es6SyntacticScopeCreator(this.compiler);
        Scope fScope = creator.createScope(n, t.getScope());
        Scope fBlockScope = creator.createScope(block, fScope);
        HashBasedTable renameTable = HashBasedTable.create();
        for (Var var : fBlockScope.getVarIterable()) {
            String oldName = var.getName();
            if (!collector.currFuncReferences.contains(oldName) || renameTable.contains((Object)fBlockScope.rootNode, (Object)oldName)) continue;
            renameTable.put((Object)fBlockScope.rootNode, (Object)oldName, (Object)(oldName + "$" + (String)this.compiler.getUniqueNameIdSupplier().get()));
        }
        new NodeTraversal(this.compiler, new Es6RenameReferences((Table<Node, String, String>)renameTable), new Es6SyntacticScopeCreator(this.compiler)).traverseInnerNode(block, block.getParent(), fScope);
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, this);
    }

    private static class CollectReferences
    extends NodeTraversal.AbstractPostOrderCallback {
        private final Set<String> currFuncReferences = new HashSet<String>();

        private CollectReferences() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!NodeUtil.isReferenceName(n)) {
                return;
            }
            this.currFuncReferences.add(n.getString());
        }
    }
}

