/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.Es6ToEs3Converter;
import com.google.javascript.jscomp.ExpressionDecomposer;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.deps.ModuleNames;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;

public final class Es6ExtractClasses
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    static final String CLASS_DECL_VAR = "$classdecl$var";
    private final AbstractCompiler compiler;
    private final ExpressionDecomposer expressionDecomposer;
    private int classDeclVarCounter = 0;

    Es6ExtractClasses(AbstractCompiler compiler) {
        this.compiler = compiler;
        HashSet<String> consts = new HashSet<String>();
        this.expressionDecomposer = new ExpressionDecomposer(compiler, compiler.getUniqueNameIdSupplier(), consts, Scope.createGlobalScope(new Node(Token.SCRIPT)));
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, root, this, new SelfReferenceRewriter());
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, this, new SelfReferenceRewriter());
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isClass() && this.shouldExtractClass(n, parent)) {
            this.extractClass(n, parent);
        }
    }

    private boolean shouldExtractClass(Node classNode, Node parent) {
        boolean isAnonymous = classNode.getFirstChild().isEmpty();
        if (NodeUtil.isClassDeclaration(classNode) || isAnonymous && parent.isName() || isAnonymous && parent.isAssign() && parent.getFirstChild().isQualifiedName() && parent.getParent().isExprResult()) {
            return false;
        }
        if (NodeUtil.mayHaveSideEffects(classNode) || this.expressionDecomposer.canExposeExpression(classNode) != ExpressionDecomposer.DecompositionType.MOVABLE) {
            this.compiler.report(JSError.make(classNode, Es6ToEs3Converter.CANNOT_CONVERT, "class expression that cannot be extracted"));
            return false;
        }
        return true;
    }

    private void extractClass(Node classNode, Node parent) {
        String name = ModuleNames.fileToJsIdentifier(classNode.getStaticSourceFile().getName()) + CLASS_DECL_VAR + this.classDeclVarCounter++;
        JSDocInfo info = NodeUtil.getBestJSDocInfo(classNode);
        Node statement = NodeUtil.getEnclosingStatement(parent);
        parent.replaceChild(classNode, IR.name(name));
        Node classDeclaration = IR.constNode(IR.name(name), classNode).useSourceInfoIfMissingFromForTree(classNode);
        classDeclaration.setJSDocInfo(JSDocInfoBuilder.maybeCopyFrom(info).build());
        statement.getParent().addChildBefore(classDeclaration, statement);
        this.compiler.reportChangeToEnclosingScope(classDeclaration);
    }

    private class SelfReferenceRewriter
    implements NodeTraversal.Callback {
        private Deque<ClassDescription> classStack = new LinkedList<ClassDescription>();

        private SelfReferenceRewriter() {
        }

        private boolean needsInnerNameRewriting(Node classNode, Node parent) {
            Preconditions.checkArgument((boolean)classNode.isClass());
            return classNode.getFirstChild().isName() && parent.isName();
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (n.isClass() && this.needsInnerNameRewriting(n, parent)) {
                this.classStack.addFirst(new ClassDescription(n.getFirstChild(), parent.getString()));
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case CLASS: {
                    if (!this.needsInnerNameRewriting(n, parent)) break;
                    this.classStack.removeFirst();
                    n.replaceChild(n.getFirstChild(), IR.empty().useSourceInfoFrom(n.getFirstChild()));
                    Es6ExtractClasses.this.compiler.reportChangeToEnclosingScope(n);
                    break;
                }
                case NAME: {
                    this.maybeUpdateClassSelfRef(t, n, parent);
                    break;
                }
            }
        }

        private void maybeUpdateClassSelfRef(NodeTraversal t, Node nameNode, Node parent) {
            for (ClassDescription klass : this.classStack) {
                Var var;
                if (nameNode == klass.nameNode || !nameNode.matchesQualifiedName(klass.nameNode) || (var = t.getScope().getVar(nameNode.getString())) == null || var.getNameNode() != klass.nameNode) continue;
                Node newNameNode = IR.name(klass.outerName).useSourceInfoFrom(nameNode);
                parent.replaceChild(nameNode, newNameNode);
                Es6ExtractClasses.this.compiler.reportChangeToEnclosingScope(newNameNode);
                return;
            }
        }

        private class ClassDescription {
            Node nameNode;
            String outerName;

            ClassDescription(Node nameNode, String outerName) {
                this.nameNode = nameNode;
                this.outerName = outerName;
            }
        }
    }
}

