/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.CheckAccessControls;
import com.google.javascript.jscomp.CheckConformance;
import com.google.javascript.jscomp.CheckDebuggerStatement;
import com.google.javascript.jscomp.CheckEventfulObjectDisposal;
import com.google.javascript.jscomp.CheckGlobalNames;
import com.google.javascript.jscomp.CheckGlobalThis;
import com.google.javascript.jscomp.CheckJSDoc;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CheckMissingGetCssName;
import com.google.javascript.jscomp.CheckMissingReturn;
import com.google.javascript.jscomp.CheckProvides;
import com.google.javascript.jscomp.CheckRegExp;
import com.google.javascript.jscomp.CheckRequiresForConstructors;
import com.google.javascript.jscomp.CheckSideEffects;
import com.google.javascript.jscomp.CheckSuspiciousCode;
import com.google.javascript.jscomp.CheckUnreachableCode;
import com.google.javascript.jscomp.CheckUnusedPrivateProperties;
import com.google.javascript.jscomp.ClosureCheckModule;
import com.google.javascript.jscomp.ClosureRewriteModule;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.ConstCheck;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.DisambiguateProperties;
import com.google.javascript.jscomp.Es6ExternsCheck;
import com.google.javascript.jscomp.FunctionTypeBuilder;
import com.google.javascript.jscomp.GlobalTypeInfo;
import com.google.javascript.jscomp.ImplicitNullabilityCheck;
import com.google.javascript.jscomp.J2clChecksPass;
import com.google.javascript.jscomp.JsMessageVisitor;
import com.google.javascript.jscomp.NewTypeInference;
import com.google.javascript.jscomp.PeepholeFoldConstants;
import com.google.javascript.jscomp.ProcessClosurePrimitives;
import com.google.javascript.jscomp.ProcessCommonJSModules;
import com.google.javascript.jscomp.ProcessDefines;
import com.google.javascript.jscomp.ProcessTweaks;
import com.google.javascript.jscomp.RewritePolyfills;
import com.google.javascript.jscomp.RhinoErrorReporter;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.StrictModeCheck;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.VarCheck;
import com.google.javascript.jscomp.VariableReferenceCheck;
import com.google.javascript.jscomp.lint.CheckArrayWithGoogObject;
import com.google.javascript.jscomp.lint.CheckDuplicateCase;
import com.google.javascript.jscomp.lint.CheckEmptyStatements;
import com.google.javascript.jscomp.lint.CheckEnums;
import com.google.javascript.jscomp.lint.CheckInterfaces;
import com.google.javascript.jscomp.lint.CheckJSDocStyle;
import com.google.javascript.jscomp.lint.CheckMissingSemicolon;
import com.google.javascript.jscomp.lint.CheckNullableReturn;
import com.google.javascript.jscomp.lint.CheckPrimitiveAsObject;
import com.google.javascript.jscomp.lint.CheckPrototypeProperties;
import com.google.javascript.jscomp.lint.CheckRequiresAndProvidesSorted;
import com.google.javascript.jscomp.lint.CheckUnusedLabels;
import com.google.javascript.jscomp.lint.CheckUselessBlocks;
import com.google.javascript.jscomp.newtypes.JSTypeCreatorFromJSDoc;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DiagnosticGroups {
    static final DiagnosticType UNUSED = DiagnosticType.warning("JSC_UNUSED", "{0}");
    public static final Set<String> wildcardExcludedGroups = ImmutableSet.of((Object)"reportUnknownTypes", (Object)"analyzerChecks", (Object)"analyzerChecksInternal", (Object)"oldReportUnknownTypes", (Object)"newCheckTypes", (Object)"newCheckTypesCompatibility", (Object[])new String[]{"newCheckTypesExtraChecks", "missingSourcesWarnings"});
    private static final Map<String, DiagnosticGroup> groupsByName = new HashMap<String, DiagnosticGroup>();
    static final String DIAGNOSTIC_GROUP_NAMES = "accessControls, ambiguousFunctionDecl, checkEventfulObjectDisposal, checkRegExp, checkTypes, checkVars, commonJsModuleLoad, conformanceViolations, const, constantProperty, deprecated, deprecatedAnnotations, duplicateMessage, es3, es5Strict, externsValidation, fileoverviewTags, functionParams, globalThis, internetExplorerChecks, invalidCasts, misplacedTypeAnnotation, missingGetCssName, missingOverride, missingPolyfill, missingProperties, missingProvide, missingRequire, missingReturn, msgDescriptions, newCheckTypes, nonStandardJsDocs, missingSourcesWarnings, reportUnknownTypes, suspiciousCode, strictModuleDepCheck, typeInvalidation, undefinedNames, undefinedVars, unknownDefines, unusedLocalVariables, unusedPrivateMembers, uselessCode, useOfGoogBase, underscore, visibility";
    public static final DiagnosticGroup COMMON_JS_MODULE_LOAD = DiagnosticGroups.registerGroup("commonJsModuleLoad", ProcessCommonJSModules.SUSPICIOUS_EXPORTS_ASSIGNMENT, ProcessCommonJSModules.UNKNOWN_REQUIRE_ENSURE);
    public static final DiagnosticGroup GLOBAL_THIS = DiagnosticGroups.registerGroup("globalThis", CheckGlobalThis.GLOBAL_THIS);
    public static final DiagnosticGroup DEPRECATED = DiagnosticGroups.registerGroup("deprecated", CheckAccessControls.DEPRECATED_NAME, CheckAccessControls.DEPRECATED_NAME_REASON, CheckAccessControls.DEPRECATED_PROP, CheckAccessControls.DEPRECATED_PROP_REASON, CheckAccessControls.DEPRECATED_CLASS, CheckAccessControls.DEPRECATED_CLASS_REASON);
    public static final DiagnosticGroup UNDERSCORE = DiagnosticGroups.registerGroup("underscore", CheckJSDocStyle.MUST_BE_PRIVATE, CheckJSDocStyle.MUST_HAVE_TRAILING_UNDERSCORE);
    public static final DiagnosticGroup VISIBILITY = DiagnosticGroups.registerGroup("visibility", CheckAccessControls.BAD_PRIVATE_GLOBAL_ACCESS, CheckAccessControls.BAD_PRIVATE_PROPERTY_ACCESS, CheckAccessControls.BAD_PACKAGE_PROPERTY_ACCESS, CheckAccessControls.BAD_PROTECTED_PROPERTY_ACCESS, CheckAccessControls.EXTEND_FINAL_CLASS, CheckAccessControls.PRIVATE_OVERRIDE, CheckAccessControls.VISIBILITY_MISMATCH, CheckAccessControls.CONVENTION_MISMATCH);
    public static final DiagnosticGroup ACCESS_CONTROLS = DiagnosticGroups.registerGroup("accessControls", VISIBILITY);
    public static final DiagnosticGroup NON_STANDARD_JSDOC = DiagnosticGroups.registerGroup("nonStandardJsDocs", RhinoErrorReporter.BAD_JSDOC_ANNOTATION, RhinoErrorReporter.INVALID_PARAM, RhinoErrorReporter.JSDOC_IN_BLOCK_COMMENT);
    public static final DiagnosticGroup INVALID_CASTS = DiagnosticGroups.registerGroup("invalidCasts", TypeValidator.INVALID_CAST, NewTypeInference.INVALID_CAST);
    @Deprecated
    public static final DiagnosticGroup INFERRED_CONST_CHECKS = DiagnosticGroups.registerDeprecatedGroup("inferredConstCheck");
    public static final DiagnosticGroup FILEOVERVIEW_JSDOC = DiagnosticGroups.registerDeprecatedGroup("fileoverviewTags");
    public static final DiagnosticGroup STRICT_MODULE_DEP_CHECK = DiagnosticGroups.registerGroup("strictModuleDepCheck", VarCheck.STRICT_MODULE_DEP_ERROR, CheckGlobalNames.STRICT_MODULE_DEP_QNAME);
    public static final DiagnosticGroup VIOLATED_MODULE_DEP = DiagnosticGroups.registerGroup("violatedModuleDep", VarCheck.VIOLATED_MODULE_DEP_ERROR);
    public static final DiagnosticGroup EXTERNS_VALIDATION = DiagnosticGroups.registerGroup("externsValidation", VarCheck.NAME_REFERENCE_IN_EXTERNS_ERROR, VarCheck.UNDEFINED_EXTERN_VAR_ERROR);
    public static final DiagnosticGroup AMBIGUOUS_FUNCTION_DECL = DiagnosticGroups.registerGroup("ambiguousFunctionDecl", StrictModeCheck.BAD_FUNCTION_DECLARATION);
    public static final DiagnosticGroup UNKNOWN_DEFINES = DiagnosticGroups.registerGroup("unknownDefines", ProcessDefines.UNKNOWN_DEFINE_WARNING);
    public static final DiagnosticGroup TWEAKS = DiagnosticGroups.registerGroup("tweakValidation", ProcessTweaks.INVALID_TWEAK_DEFAULT_VALUE_WARNING, ProcessTweaks.TWEAK_WRONG_GETTER_TYPE_WARNING, ProcessTweaks.UNKNOWN_TWEAK_WARNING);
    public static final DiagnosticGroup MISSING_OVERRIDE = DiagnosticGroups.registerGroup("missingOverride", TypeCheck.HIDDEN_INTERFACE_PROPERTY, TypeCheck.HIDDEN_SUPERCLASS_PROPERTY);
    public static final DiagnosticGroup MISSING_PROPERTIES = DiagnosticGroups.registerGroup("missingProperties", TypeCheck.INEXISTENT_PROPERTY, TypeCheck.INEXISTENT_PROPERTY_WITH_SUGGESTION, TypeCheck.POSSIBLE_INEXISTENT_PROPERTY, NewTypeInference.INEXISTENT_PROPERTY, NewTypeInference.POSSIBLY_INEXISTENT_PROPERTY);
    public static final DiagnosticGroup J2CL_CHECKS = DiagnosticGroups.registerGroup("j2clChecks", J2clChecksPass.J2CL_REFERENCE_EQUALITY);
    public static final DiagnosticGroup MISSING_RETURN = DiagnosticGroups.registerGroup("missingReturn", CheckMissingReturn.MISSING_RETURN_STATEMENT);
    public static final DiagnosticGroup INTERNET_EXPLORER_CHECKS = DiagnosticGroups.registerGroup("internetExplorerChecks", RhinoErrorReporter.TRAILING_COMMA);
    public static final DiagnosticGroup UNDEFINED_VARIABLES = DiagnosticGroups.registerGroup("undefinedVars", VarCheck.UNDEFINED_VAR_ERROR);
    public static final DiagnosticGroup UNDEFINED_NAMES = DiagnosticGroups.registerGroup("undefinedNames", CheckGlobalNames.UNDEFINED_NAME_WARNING);
    public static final DiagnosticGroup DEBUGGER_STATEMENT_PRESENT = DiagnosticGroups.registerGroup("checkDebuggerStatement", CheckDebuggerStatement.DEBUGGER_STATEMENT_PRESENT);
    public static final DiagnosticGroup CHECK_REGEXP = DiagnosticGroups.registerGroup("checkRegExp", CheckRegExp.REGEXP_REFERENCE, CheckRegExp.MALFORMED_REGEXP);
    public static final DiagnosticGroup OLD_CHECK_TYPES = DiagnosticGroups.registerGroup("oldCheckTypes", TypeValidator.ALL_DIAGNOSTICS, TypeCheck.ALL_DIAGNOSTICS);
    public static final DiagnosticGroup NEW_CHECK_TYPES_COMPATIBILITY_MODE = DiagnosticGroups.registerGroup("newCheckTypesCompatibility", JSTypeCreatorFromJSDoc.COMPATIBLE_DIAGNOSTICS, GlobalTypeInfo.COMPATIBLE_DIAGNOSTICS, NewTypeInference.COMPATIBLE_DIAGNOSTICS);
    public static final DiagnosticGroup NEW_CHECK_TYPES_EXTRA_CHECKS = DiagnosticGroups.registerGroup("newCheckTypesExtraChecks", JSTypeCreatorFromJSDoc.NEW_DIAGNOSTICS, GlobalTypeInfo.NEW_DIAGNOSTICS, NewTypeInference.NEW_DIAGNOSTICS);
    public static final DiagnosticGroup NEW_CHECK_TYPES = DiagnosticGroups.registerGroup("newCheckTypes", NEW_CHECK_TYPES_COMPATIBILITY_MODE, NEW_CHECK_TYPES_EXTRA_CHECKS);
    public static final DiagnosticGroup CHECK_TYPES = DiagnosticGroups.registerGroup("checkTypes", OLD_CHECK_TYPES, NEW_CHECK_TYPES);
    public static final DiagnosticGroup NEW_CHECK_TYPES_ALL_CHECKS = DiagnosticGroups.registerGroup("newCheckTypesAllChecks", NewTypeInference.NULLABLE_DEREFERENCE);
    public static final DiagnosticGroup TOO_MANY_TYPE_PARAMS;
    public static final DiagnosticGroup CHECK_EVENTFUL_OBJECT_DISPOSAL;
    public static final DiagnosticGroup OLD_REPORT_UNKNOWN_TYPES;
    public static final DiagnosticGroup REPORT_UNKNOWN_TYPES;
    public static final DiagnosticGroup CHECK_VARIABLES;
    public static final DiagnosticGroup CHECK_USELESS_CODE;
    public static final DiagnosticGroup CONST;
    static final DiagnosticGroup ACCESS_CONTROLS_CONST;
    public static final DiagnosticGroup CONSTANT_PROPERTY;
    public static final DiagnosticGroup TYPE_INVALIDATION;
    public static final DiagnosticGroup DUPLICATE_VARS;
    public static final DiagnosticGroup ES3;
    static final DiagnosticGroup ES5_STRICT_UNCOMMON;
    static final DiagnosticGroup ES5_STRICT_REFLECTION;
    public static final DiagnosticGroup ES5_STRICT;
    public static final DiagnosticGroup MISSING_PROVIDE;
    public static final DiagnosticGroup MISSING_REQUIRE;
    public static final DiagnosticGroup MISSING_SOURCES_WARNINGS;
    public static final DiagnosticGroup STRICT_MISSING_REQUIRE;
    public static final DiagnosticGroup STRICT_REQUIRES;
    public static final DiagnosticGroup EXTRA_REQUIRE;
    @GwtIncompatible(value="java.util.regex")
    public static final DiagnosticGroup MISSING_GETCSSNAME;
    @GwtIncompatible(value="JsMessage")
    public static final DiagnosticGroup DUPLICATE_MESSAGE;
    @GwtIncompatible(value="JsMessage")
    public static final DiagnosticGroup MESSAGE_DESCRIPTIONS;
    @GwtIncompatible(value="JsMessage")
    public static final DiagnosticGroup MSG_CONVENTIONS;
    public static final DiagnosticGroup MISPLACED_TYPE_ANNOTATION;
    public static final DiagnosticGroup SUSPICIOUS_CODE;
    public static final DiagnosticGroup FUNCTION_PARAMS;
    public static final DiagnosticGroup DEPRECATED_ANNOTATIONS;
    public static final DiagnosticGroup UNUSED_PRIVATE_PROPERTY;
    public static final DiagnosticGroup UNUSED_LOCAL_VARIABLE;
    public static final DiagnosticGroup LINT_CHECKS;
    static final DiagnosticGroup STRICT_MODULE_CHECKS;
    static final DiagnosticGroup ANALYZER_CHECKS_INTERNAL;
    public static final DiagnosticGroup ANALYZER_CHECKS;
    public static final DiagnosticGroup USE_OF_GOOG_BASE;
    public static final DiagnosticGroup CLOSURE_DEP_METHOD_USAGE_CHECKS;
    @GwtIncompatible(value="Conformance")
    public static final DiagnosticGroup CONFORMANCE_VIOLATIONS;
    public static final DiagnosticGroup LATE_PROVIDE;
    public static final DiagnosticGroup MISSING_POLYFILL;

    static DiagnosticGroup registerDeprecatedGroup(String name) {
        return DiagnosticGroups.registerGroup(name, new DiagnosticGroup(name, UNUSED));
    }

    static DiagnosticGroup registerGroup(String name, DiagnosticGroup group) {
        groupsByName.put(name, group);
        return group;
    }

    static DiagnosticGroup registerGroup(String name, DiagnosticType ... types) {
        DiagnosticGroup group = new DiagnosticGroup(name, types);
        groupsByName.put(name, group);
        return group;
    }

    static DiagnosticGroup registerGroup(String name, DiagnosticGroup ... groups) {
        DiagnosticGroup group = new DiagnosticGroup(name, groups);
        groupsByName.put(name, group);
        return group;
    }

    public Map<String, DiagnosticGroup> getRegisteredGroups() {
        return ImmutableMap.copyOf(groupsByName);
    }

    public DiagnosticGroup forName(String name) {
        return groupsByName.get(name);
    }

    void setWarningLevel(CompilerOptions options, String name, CheckLevel level) {
        DiagnosticGroup group = this.forName(name);
        Preconditions.checkNotNull((Object)group, (String)"No warning class for name: %s", (Object)name);
        options.setWarningLevel(group, level);
    }

    static {
        DiagnosticGroups.registerGroup("newCheckTypesClosureClean", JSTypeCreatorFromJSDoc.CONFLICTING_EXTENDED_TYPE, JSTypeCreatorFromJSDoc.CONFLICTING_IMPLEMENTED_TYPE, JSTypeCreatorFromJSDoc.DICT_IMPLEMENTS_INTERF, JSTypeCreatorFromJSDoc.EXTENDS_NON_OBJECT, JSTypeCreatorFromJSDoc.EXTENDS_NOT_ON_CTOR_OR_INTERF, JSTypeCreatorFromJSDoc.IMPLEMENTS_WITHOUT_CONSTRUCTOR, JSTypeCreatorFromJSDoc.INHERITANCE_CYCLE, JSTypeCreatorFromJSDoc.UNION_IS_UNINHABITABLE, GlobalTypeInfo.ABSTRACT_METHOD_IN_CONCRETE_CLASS, GlobalTypeInfo.ANONYMOUS_NOMINAL_TYPE, GlobalTypeInfo.CANNOT_INIT_TYPEDEF, GlobalTypeInfo.CANNOT_OVERRIDE_FINAL_METHOD, GlobalTypeInfo.CONST_WITHOUT_INITIALIZER, GlobalTypeInfo.CTOR_IN_DIFFERENT_SCOPE, GlobalTypeInfo.DICT_WITHOUT_CTOR, GlobalTypeInfo.DUPLICATE_JSDOC, GlobalTypeInfo.DUPLICATE_PROP_IN_ENUM, GlobalTypeInfo.EXPECTED_CONSTRUCTOR, GlobalTypeInfo.EXPECTED_INTERFACE, GlobalTypeInfo.INEXISTENT_PARAM, GlobalTypeInfo.INTERFACE_METHOD_NOT_IMPLEMENTED, GlobalTypeInfo.LENDS_ON_BAD_TYPE, GlobalTypeInfo.MALFORMED_ENUM, GlobalTypeInfo.MISPLACED_CONST_ANNOTATION, GlobalTypeInfo.ONE_TYPE_FOR_MANY_VARS, GlobalTypeInfo.STRUCT_WITHOUT_CTOR_OR_INTERF, GlobalTypeInfo.SUPER_INTERFACES_HAVE_INCOMPATIBLE_PROPERTIES, GlobalTypeInfo.UNKNOWN_OVERRIDE, GlobalTypeInfo.UNRECOGNIZED_TYPE_NAME, NewTypeInference.ABSTRACT_SUPER_METHOD_NOT_CALLABLE, NewTypeInference.ASSERT_FALSE, NewTypeInference.CANNOT_BIND_CTOR, NewTypeInference.CONST_REASSIGNED, NewTypeInference.CONSTRUCTOR_NOT_CALLABLE, NewTypeInference.CROSS_SCOPE_GOTCHA, NewTypeInference.FORIN_EXPECTS_STRING_KEY, NewTypeInference.ILLEGAL_OBJLIT_KEY, NewTypeInference.IN_USED_WITH_STRUCT, NewTypeInference.INVALID_INFERRED_RETURN_TYPE, NewTypeInference.INVALID_OBJLIT_PROPERTY_TYPE, NewTypeInference.INVALID_THIS_TYPE_IN_BIND, NewTypeInference.MISSING_RETURN_STATEMENT, NewTypeInference.UNKNOWN_ASSERTION_TYPE, NewTypeInference.UNKNOWN_TYPEOF_VALUE);
        TOO_MANY_TYPE_PARAMS = DiagnosticGroups.registerGroup("tooManyTypeParams", RhinoErrorReporter.TOO_MANY_TEMPLATE_PARAMS);
        CHECK_EVENTFUL_OBJECT_DISPOSAL = DiagnosticGroups.registerGroup("checkEventfulObjectDisposal", CheckEventfulObjectDisposal.EVENTFUL_OBJECT_NOT_DISPOSED, CheckEventfulObjectDisposal.EVENTFUL_OBJECT_PURELY_LOCAL, CheckEventfulObjectDisposal.OVERWRITE_PRIVATE_EVENTFUL_OBJECT, CheckEventfulObjectDisposal.UNLISTEN_WITH_ANONBOUND);
        OLD_REPORT_UNKNOWN_TYPES = DiagnosticGroups.registerGroup("oldReportUnknownTypes", TypeCheck.UNKNOWN_EXPR_TYPE);
        REPORT_UNKNOWN_TYPES = DiagnosticGroups.registerGroup("reportUnknownTypes", TypeCheck.UNKNOWN_EXPR_TYPE, NewTypeInference.UNKNOWN_EXPR_TYPE);
        CHECK_VARIABLES = DiagnosticGroups.registerGroup("checkVars", VarCheck.UNDEFINED_VAR_ERROR, VarCheck.VAR_MULTIPLY_DECLARED_ERROR, VariableReferenceCheck.EARLY_REFERENCE, VariableReferenceCheck.REDECLARED_VARIABLE);
        CHECK_USELESS_CODE = DiagnosticGroups.registerGroup("uselessCode", CheckSideEffects.USELESS_CODE_ERROR, CheckUnreachableCode.UNREACHABLE_CODE);
        CONST = DiagnosticGroups.registerGroup("const", CheckAccessControls.CONST_PROPERTY_DELETED, CheckAccessControls.CONST_PROPERTY_REASSIGNED_VALUE, ConstCheck.CONST_REASSIGNED_VALUE_ERROR, NewTypeInference.CONST_REASSIGNED, NewTypeInference.CONST_PROPERTY_REASSIGNED, NewTypeInference.CONST_PROPERTY_DELETED);
        ACCESS_CONTROLS_CONST = DiagnosticGroups.registerGroup("accessControlsConst", CheckAccessControls.CONST_PROPERTY_DELETED, CheckAccessControls.CONST_PROPERTY_REASSIGNED_VALUE);
        CONSTANT_PROPERTY = DiagnosticGroups.registerGroup("constantProperty", CheckAccessControls.CONST_PROPERTY_DELETED, CheckAccessControls.CONST_PROPERTY_REASSIGNED_VALUE, NewTypeInference.CONST_PROPERTY_REASSIGNED, NewTypeInference.CONST_PROPERTY_DELETED);
        TYPE_INVALIDATION = DiagnosticGroups.registerGroup("typeInvalidation", DisambiguateProperties.Warnings.INVALIDATION, DisambiguateProperties.Warnings.INVALIDATION_ON_TYPE);
        DUPLICATE_VARS = DiagnosticGroups.registerGroup("duplicate", VarCheck.VAR_MULTIPLY_DECLARED_ERROR, TypeValidator.DUP_VAR_DECLARATION, TypeValidator.DUP_VAR_DECLARATION_TYPE_MISMATCH, VariableReferenceCheck.REDECLARED_VARIABLE, GlobalTypeInfo.REDECLARED_PROPERTY);
        ES3 = DiagnosticGroups.registerGroup("es3", RhinoErrorReporter.INVALID_ES3_PROP_NAME, RhinoErrorReporter.TRAILING_COMMA);
        ES5_STRICT_UNCOMMON = DiagnosticGroups.registerGroup("es5StrictUncommon", RhinoErrorReporter.INVALID_OCTAL_LITERAL, RhinoErrorReporter.DUPLICATE_PARAM, StrictModeCheck.USE_OF_WITH, StrictModeCheck.EVAL_DECLARATION, StrictModeCheck.EVAL_ASSIGNMENT, StrictModeCheck.ARGUMENTS_DECLARATION, StrictModeCheck.ARGUMENTS_ASSIGNMENT, StrictModeCheck.DELETE_VARIABLE, StrictModeCheck.DUPLICATE_OBJECT_KEY, StrictModeCheck.BAD_FUNCTION_DECLARATION);
        ES5_STRICT_REFLECTION = DiagnosticGroups.registerGroup("es5StrictReflection", StrictModeCheck.ARGUMENTS_CALLEE_FORBIDDEN, StrictModeCheck.ARGUMENTS_CALLER_FORBIDDEN, StrictModeCheck.FUNCTION_CALLER_FORBIDDEN, StrictModeCheck.FUNCTION_ARGUMENTS_PROP_FORBIDDEN);
        ES5_STRICT = DiagnosticGroups.registerGroup("es5Strict", ES5_STRICT_UNCOMMON, ES5_STRICT_REFLECTION);
        MISSING_PROVIDE = DiagnosticGroups.registerGroup("missingProvide", CheckProvides.MISSING_PROVIDE_WARNING, ClosureRewriteModule.MISSING_MODULE_OR_PROVIDE);
        MISSING_REQUIRE = DiagnosticGroups.registerGroup("missingRequire", CheckRequiresForConstructors.MISSING_REQUIRE_WARNING);
        MISSING_SOURCES_WARNINGS = DiagnosticGroups.registerGroup("missingSourcesWarnings", REPORT_UNKNOWN_TYPES, UNDEFINED_NAMES, UNDEFINED_VARIABLES, MISSING_PROVIDE, DiagnosticGroup.forType(FunctionTypeBuilder.RESOLVED_TAG_EMPTY), DiagnosticGroup.forType(ProcessClosurePrimitives.MISSING_PROVIDE_ERROR), MISSING_PROPERTIES, DUPLICATE_VARS, DiagnosticGroup.forType(ProcessDefines.INVALID_DEFINE_INIT_ERROR), DiagnosticGroup.forType(Es6ExternsCheck.MISSING_ES6_EXTERNS));
        STRICT_MISSING_REQUIRE = DiagnosticGroups.registerGroup("strictMissingRequire", CheckRequiresForConstructors.MISSING_REQUIRE_WARNING, CheckRequiresForConstructors.MISSING_REQUIRE_FOR_GOOG_SCOPE, CheckRequiresForConstructors.MISSING_REQUIRE_STRICT_WARNING);
        STRICT_REQUIRES = DiagnosticGroups.registerGroup("legacyGoogScopeRequire", CheckRequiresForConstructors.MISSING_REQUIRE_FOR_GOOG_SCOPE, CheckRequiresForConstructors.EXTRA_REQUIRE_WARNING);
        EXTRA_REQUIRE = DiagnosticGroups.registerGroup("extraRequire", CheckRequiresForConstructors.EXTRA_REQUIRE_WARNING);
        MISSING_GETCSSNAME = DiagnosticGroups.registerGroup("missingGetCssName", CheckMissingGetCssName.MISSING_GETCSSNAME);
        DUPLICATE_MESSAGE = DiagnosticGroups.registerGroup("duplicateMessage", JsMessageVisitor.MESSAGE_DUPLICATE_KEY);
        MESSAGE_DESCRIPTIONS = DiagnosticGroups.registerGroup("msgDescriptions", JsMessageVisitor.MESSAGE_HAS_NO_DESCRIPTION);
        MSG_CONVENTIONS = DiagnosticGroups.registerGroup("messageConventions", JsMessageVisitor.MESSAGE_HAS_NO_DESCRIPTION, JsMessageVisitor.MESSAGE_HAS_NO_TEXT, JsMessageVisitor.MESSAGE_TREE_MALFORMED, JsMessageVisitor.MESSAGE_HAS_NO_VALUE, JsMessageVisitor.MESSAGE_DUPLICATE_KEY, JsMessageVisitor.MESSAGE_NOT_INITIALIZED_USING_NEW_SYNTAX);
        MISPLACED_TYPE_ANNOTATION = DiagnosticGroups.registerGroup("misplacedTypeAnnotation", CheckJSDoc.ARROW_FUNCTION_AS_CONSTRUCTOR, CheckJSDoc.DEFAULT_PARAM_MUST_BE_MARKED_OPTIONAL, CheckJSDoc.DISALLOWED_MEMBER_JSDOC, CheckJSDoc.INVALID_NO_SIDE_EFFECT_ANNOTATION, CheckJSDoc.INVALID_MODIFIES_ANNOTATION, CheckJSDoc.MISPLACED_ANNOTATION, CheckJSDoc.MISPLACED_MSG_ANNOTATION);
        SUSPICIOUS_CODE = DiagnosticGroups.registerGroup("suspiciousCode", CheckDuplicateCase.DUPLICATE_CASE, CheckSuspiciousCode.SUSPICIOUS_SEMICOLON, CheckSuspiciousCode.SUSPICIOUS_COMPARISON_WITH_NAN, CheckSuspiciousCode.SUSPICIOUS_IN_OPERATOR, CheckSuspiciousCode.SUSPICIOUS_INSTANCEOF_LEFT_OPERAND, CheckSuspiciousCode.SUSPICIOUS_NEGATED_LEFT_OPERAND_OF_IN_OPERATOR, TypeCheck.DETERMINISTIC_TEST, ProcessCommonJSModules.SUSPICIOUS_EXPORTS_ASSIGNMENT);
        FUNCTION_PARAMS = DiagnosticGroups.registerGroup("functionParams", FunctionTypeBuilder.INEXISTENT_PARAM, FunctionTypeBuilder.OPTIONAL_ARG_AT_END);
        DEPRECATED_ANNOTATIONS = DiagnosticGroups.registerGroup("deprecatedAnnotations", CheckJSDoc.ANNOTATION_DEPRECATED);
        UNUSED_PRIVATE_PROPERTY = DiagnosticGroups.registerGroup("unusedPrivateMembers", CheckUnusedPrivateProperties.UNUSED_PRIVATE_PROPERTY);
        UNUSED_LOCAL_VARIABLE = DiagnosticGroups.registerGroup("unusedLocalVariables", VariableReferenceCheck.UNUSED_LOCAL_ASSIGNMENT);
        LINT_CHECKS = DiagnosticGroups.registerGroup("lintChecks", CheckJSDocStyle.ALL_DIAGNOSTICS, new DiagnosticGroup(CheckEmptyStatements.USELESS_EMPTY_STATEMENT, CheckEnums.COMPUTED_PROP_NAME_IN_ENUM, CheckEnums.DUPLICATE_ENUM_VALUE, CheckEnums.ENUM_PROP_NOT_CONSTANT, CheckEnums.SHORTHAND_ASSIGNMENT_IN_ENUM, CheckInterfaces.INTERFACE_FUNCTION_NOT_EMPTY, CheckInterfaces.INTERFACE_SHOULD_NOT_TAKE_ARGS, CheckMissingSemicolon.MISSING_SEMICOLON, CheckPrimitiveAsObject.NEW_PRIMITIVE_OBJECT, CheckPrimitiveAsObject.PRIMITIVE_OBJECT_DECLARATION, CheckPrototypeProperties.ILLEGAL_PROTOTYPE_MEMBER, CheckRequiresAndProvidesSorted.DUPLICATE_REQUIRE, CheckRequiresAndProvidesSorted.REQUIRES_NOT_SORTED, CheckRequiresAndProvidesSorted.PROVIDES_NOT_SORTED, CheckRequiresAndProvidesSorted.PROVIDES_AFTER_REQUIRES, CheckUnusedLabels.UNUSED_LABEL, CheckUselessBlocks.USELESS_BLOCK, ClosureCheckModule.GOOG_MODULE_IN_NON_MODULE, ClosureCheckModule.INCORRECT_SHORTNAME_CAPITALIZATION, ClosureCheckModule.LET_GOOG_REQUIRE, ClosureCheckModule.JSDOC_REFERENCE_TO_FULLY_QUALIFIED_IMPORT_NAME, ClosureCheckModule.JSDOC_REFERENCE_TO_SHORT_IMPORT_BY_LONG_NAME_INCLUDING_SHORT_NAME, ClosureCheckModule.REFERENCE_TO_FULLY_QUALIFIED_IMPORT_NAME, ClosureCheckModule.REFERENCE_TO_SHORT_IMPORT_BY_LONG_NAME_INCLUDING_SHORT_NAME, ClosureRewriteModule.USELESS_USE_STRICT_DIRECTIVE, RhinoErrorReporter.UNNECESSARY_ESCAPE, RhinoErrorReporter.JSDOC_MISSING_BRACES_WARNING, RhinoErrorReporter.JSDOC_MISSING_TYPE_WARNING));
        STRICT_MODULE_CHECKS = DiagnosticGroups.registerGroup("strictModuleChecks", ClosureCheckModule.AT_EXPORT_IN_NON_LEGACY_GOOG_MODULE, ClosureCheckModule.LET_GOOG_REQUIRE, ClosureCheckModule.JSDOC_REFERENCE_TO_FULLY_QUALIFIED_IMPORT_NAME, ClosureCheckModule.JSDOC_REFERENCE_TO_SHORT_IMPORT_BY_LONG_NAME_INCLUDING_SHORT_NAME, ClosureCheckModule.REFERENCE_TO_FULLY_QUALIFIED_IMPORT_NAME, ClosureCheckModule.REFERENCE_TO_SHORT_IMPORT_BY_LONG_NAME_INCLUDING_SHORT_NAME);
        ANALYZER_CHECKS_INTERNAL = DiagnosticGroups.registerGroup("analyzerChecksInternal", CheckArrayWithGoogObject.ARRAY_PASSED_TO_GOOG_OBJECT, CheckNullableReturn.NULLABLE_RETURN, CheckNullableReturn.NULLABLE_RETURN_WITH_NAME, ImplicitNullabilityCheck.IMPLICITLY_NULLABLE_JSDOC, RhinoErrorReporter.TOO_MANY_TEMPLATE_PARAMS);
        ANALYZER_CHECKS = DiagnosticGroups.registerGroup("analyzerChecks", ANALYZER_CHECKS_INTERNAL, UNUSED_PRIVATE_PROPERTY);
        USE_OF_GOOG_BASE = DiagnosticGroups.registerGroup("useOfGoogBase", ProcessClosurePrimitives.USE_OF_GOOG_BASE);
        CLOSURE_DEP_METHOD_USAGE_CHECKS = DiagnosticGroups.registerGroup("closureDepMethodUsageChecks", ProcessClosurePrimitives.INVALID_CLOSURE_CALL_ERROR);
        DiagnosticGroups.registerGroup("transitionalSuspiciousCodeWarnings", PeepholeFoldConstants.INDEX_OUT_OF_BOUNDS_ERROR, PeepholeFoldConstants.NEGATING_A_NON_NUMBER_ERROR, PeepholeFoldConstants.FRACTIONAL_BITWISE_OPERAND);
        CONFORMANCE_VIOLATIONS = DiagnosticGroups.registerGroup("conformanceViolations", CheckConformance.CONFORMANCE_VIOLATION, CheckConformance.CONFORMANCE_POSSIBLE_VIOLATION);
        LATE_PROVIDE = DiagnosticGroups.registerGroup("lateProvide", ProcessClosurePrimitives.LATE_PROVIDE_ERROR, ClosureRewriteModule.LATE_PROVIDE_ERROR);
        MISSING_POLYFILL = DiagnosticGroups.registerGroup("missingPolyfill", RewritePolyfills.INSUFFICIENT_OUTPUT_VERSION_ERROR);
        DiagnosticGroups.registerGroup("invalidProvide", ProcessClosurePrimitives.INVALID_PROVIDE_ERROR);
        DiagnosticGroups.registerGroup("es6Typed", RhinoErrorReporter.MISPLACED_TYPE_SYNTAX);
        DiagnosticGroups.registerGroup("duplicateZipContents", SourceFile.DUPLICATE_ZIP_CONTENTS);
        DiagnosticGroups.registerDeprecatedGroup("unnecessaryCasts");
    }
}

