/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;

class DefinitionsRemover {
    DefinitionsRemover() {
    }

    static Definition getDefinition(Node n, boolean isExtern) {
        Node parent = n.getParent();
        if (parent == null) {
            return null;
        }
        if (NodeUtil.isVarDeclaration(n) && (isExtern || n.hasChildren())) {
            return new VarDefinition(n, isExtern);
        }
        if (parent.isFunction() && parent.getFirstChild() == n) {
            if (!NodeUtil.isFunctionExpression(parent)) {
                return new NamedFunctionDefinition(parent, isExtern);
            }
            if (!n.getString().isEmpty()) {
                return new FunctionExpressionDefinition(parent, isExtern);
            }
        } else if (parent.isClass() && parent.getFirstChild() == n) {
            if (!NodeUtil.isClassExpression(parent)) {
                return new NamedClassDefinition(parent, isExtern);
            }
            if (!n.isEmpty()) {
                return new ClassExpressionDefinition(parent, isExtern);
            }
        } else {
            if (n.isMemberFunctionDef() && parent.isClassMembers()) {
                return new MemberFunctionDefinition(n, isExtern);
            }
            if (parent.isAssign() && parent.getFirstChild() == n) {
                return new AssignmentDefinition(parent, isExtern);
            }
            if (NodeUtil.isObjectLitKey(n)) {
                return new ObjectLiteralPropertyDefinition(parent, n, n.getFirstChild(), isExtern);
            }
            if (NodeUtil.getEnclosingType(n, Token.PARAM_LIST) != null && n.isName()) {
                Node paramList = NodeUtil.getEnclosingType(n, Token.PARAM_LIST);
                Node function = paramList.getParent();
                return new FunctionArgumentDefinition(function, n, isExtern);
            }
            if (parent.getToken() == Token.COLON && parent.getFirstChild() == n && isExtern) {
                Node grandparent = parent.getParent();
                Preconditions.checkState((grandparent.getToken() == Token.LB ? 1 : 0) != 0);
                Preconditions.checkState((grandparent.getParent().getToken() == Token.LC ? 1 : 0) != 0);
                return new RecordTypePropertyDefinition(n);
            }
            if (isExtern && n.isGetProp() && parent.isExprResult() && n.isQualifiedName()) {
                return new ExternalNameOnlyDefinition(n);
            }
        }
        return null;
    }

    static boolean isDefinitionNode(Node n) {
        Node parent = n.getParent();
        if (parent == null) {
            return false;
        }
        if (NodeUtil.isVarDeclaration(n) && (n.isFromExterns() || n.hasChildren())) {
            return true;
        }
        if (parent.isFunction() && parent.getFirstChild() == n) {
            if (!NodeUtil.isFunctionExpression(parent)) {
                return true;
            }
            if (!n.getString().isEmpty()) {
                return true;
            }
        } else if (parent.isClass() && parent.getFirstChild() == n) {
            if (!NodeUtil.isClassExpression(parent)) {
                return true;
            }
            if (!n.isEmpty()) {
                return true;
            }
        } else {
            if (n.isMemberFunctionDef() && parent.isClassMembers()) {
                return true;
            }
            if (parent.isAssign() && parent.getFirstChild() == n) {
                return true;
            }
            if (NodeUtil.isObjectLitKey(n)) {
                return true;
            }
            if (parent.isParamList()) {
                return true;
            }
            if (parent.getToken() == Token.COLON && parent.getFirstChild() == n && n.isFromExterns()) {
                Node grandparent = parent.getParent();
                Preconditions.checkState((grandparent.getToken() == Token.LB ? 1 : 0) != 0);
                Preconditions.checkState((grandparent.getParent().getToken() == Token.LC ? 1 : 0) != 0);
                return true;
            }
            if (n.isFromExterns() && parent.isExprResult() && n.isGetProp() && n.isQualifiedName()) {
                return true;
            }
        }
        return false;
    }

    static final class VarDefinition
    extends Definition {
        private final Node name;

        VarDefinition(Node node, boolean inExterns) {
            super(inExterns);
            Preconditions.checkArgument((boolean)NodeUtil.isVarDeclaration(node));
            Preconditions.checkArgument((inExterns || node.hasChildren() ? 1 : 0) != 0, (String)"VAR Declaration of %s must be assigned a value.", (Object)node.getString());
            this.name = node;
        }

        @Override
        public void performRemove(AbstractCompiler compiler) {
            Node var = this.name.getParent();
            Preconditions.checkState((var.getFirstChild() == var.getLastChild() ? 1 : 0) != 0, (Object)"AST should be normalized first");
            Node parent = var.getParent();
            Node rValue = this.name.removeFirstChild();
            Preconditions.checkState((!NodeUtil.isLoopStructure(parent) ? 1 : 0) != 0);
            parent.replaceChild(var, NodeUtil.newExpr(rValue));
            compiler.reportChangeToEnclosingScope(parent);
        }

        @Override
        public Node getLValue() {
            return this.name;
        }

        @Override
        public Node getRValue() {
            return this.name.getFirstChild();
        }
    }

    static final class ObjectLiteralPropertyDefinition
    extends Definition {
        private final Node literal;
        private final Node name;
        private final Node value;

        ObjectLiteralPropertyDefinition(Node lit, Node name, Node value, boolean isExtern) {
            super(isExtern);
            this.literal = lit;
            this.name = name;
            this.value = value;
        }

        @Override
        public void performRemove(AbstractCompiler compiler) {
            this.literal.removeChild(this.name);
            compiler.reportChangeToEnclosingScope(this.literal);
        }

        @Override
        public Node getLValue() {
            switch (this.name.getToken()) {
                case SETTER_DEF: 
                case GETTER_DEF: 
                case STRING_KEY: {
                    return IR.getprop(IR.objectlit(new Node[0]), IR.string(this.name.getString()));
                }
            }
            throw new IllegalStateException("Unexpected left Token: " + (Object)((Object)this.name.getToken()));
        }

        @Override
        public Node getRValue() {
            return this.value;
        }
    }

    static final class RecordTypePropertyDefinition
    extends IncompleteDefinition {
        RecordTypePropertyDefinition(Node name) {
            super(IR.getprop(IR.objectlit(new Node[0]), name.cloneNode()), true);
            Preconditions.checkArgument((boolean)name.isString());
        }

        @Override
        public void performRemove(AbstractCompiler compiler) {
            throw new UnsupportedOperationException("Can't remove RecordType def");
        }
    }

    static final class AssignmentDefinition
    extends Definition {
        private final Node assignment;

        AssignmentDefinition(Node node, boolean inExterns) {
            super(inExterns);
            Preconditions.checkArgument((boolean)node.isAssign());
            this.assignment = node;
        }

        @Override
        public void performRemove(AbstractCompiler compiler) {
            Node parent = this.assignment.getParent();
            Node last = this.assignment.getLastChild();
            this.assignment.removeChild(last);
            parent.replaceChild(this.assignment, last);
            compiler.reportChangeToEnclosingScope(parent);
        }

        @Override
        public Node getLValue() {
            return this.assignment.getFirstChild();
        }

        @Override
        public Node getRValue() {
            return this.assignment.getLastChild();
        }
    }

    static final class ClassExpressionDefinition
    extends ClassDefinition {
        ClassExpressionDefinition(Node node, boolean inExterns) {
            super(node, inExterns);
            Preconditions.checkArgument((boolean)NodeUtil.isClassExpression(node));
        }

        @Override
        public void performRemove(AbstractCompiler compiler) {
            this.c.replaceChild(this.c.getFirstChild(), IR.empty());
            compiler.reportChangeToEnclosingScope(this.c.getFirstChild());
        }
    }

    static final class NamedClassDefinition
    extends ClassDefinition {
        NamedClassDefinition(Node node, boolean inExterns) {
            super(node, inExterns);
        }

        @Override
        public void performRemove(AbstractCompiler compiler) {
            NodeUtil.deleteNode(this.c, compiler);
        }
    }

    static abstract class ClassDefinition
    extends Definition {
        protected final Node c;

        ClassDefinition(Node node, boolean inExterns) {
            super(inExterns);
            Preconditions.checkArgument((boolean)node.isClass());
            this.c = node;
        }

        @Override
        public Node getLValue() {
            return this.c.getFirstChild();
        }

        @Override
        public Node getRValue() {
            return this.c;
        }
    }

    static final class MemberFunctionDefinition
    extends FunctionDefinition {
        protected final Node memberFunctionDef;

        MemberFunctionDefinition(Node node, boolean inExterns) {
            super(node.getFirstChild(), inExterns);
            this.memberFunctionDef = node;
        }

        @Override
        public void performRemove(AbstractCompiler compiler) {
            NodeUtil.deleteNode(this.memberFunctionDef, compiler);
        }

        @Override
        public Node getLValue() {
            return IR.getprop(IR.objectlit(new Node[0]), this.memberFunctionDef.getString(), new String[0]);
        }
    }

    static final class FunctionExpressionDefinition
    extends FunctionDefinition {
        FunctionExpressionDefinition(Node node, boolean inExterns) {
            super(node, inExterns);
            Preconditions.checkArgument((boolean)NodeUtil.isFunctionExpression(node));
        }

        @Override
        public void performRemove(AbstractCompiler compiler) {
            this.function.replaceChild(this.function.getFirstChild(), IR.name(""));
            compiler.reportChangeToEnclosingScope(this.function.getFirstChild());
        }
    }

    static final class NamedFunctionDefinition
    extends FunctionDefinition {
        NamedFunctionDefinition(Node node, boolean inExterns) {
            super(node, inExterns);
        }

        @Override
        public void performRemove(AbstractCompiler compiler) {
            compiler.reportChangeToEnclosingScope(this.function);
            this.function.detach();
            NodeUtil.markFunctionsDeleted(this.function, compiler);
        }
    }

    static abstract class FunctionDefinition
    extends Definition {
        protected final Node function;

        FunctionDefinition(Node node, boolean inExterns) {
            super(inExterns);
            Preconditions.checkArgument((boolean)node.isFunction());
            this.function = node;
        }

        @Override
        public Node getLValue() {
            return this.function.getFirstChild();
        }

        @Override
        public Node getRValue() {
            return this.function;
        }
    }

    static final class FunctionArgumentDefinition
    extends IncompleteDefinition {
        FunctionArgumentDefinition(Node function, Node argumentName, boolean inExterns) {
            super(argumentName, inExterns);
            Preconditions.checkArgument((boolean)function.isFunction());
            Preconditions.checkArgument((boolean)argumentName.isName());
        }

        @Override
        public void performRemove(AbstractCompiler compiler) {
            throw new IllegalArgumentException("Can't remove a FunctionArgumentDefinition");
        }
    }

    static final class ExternalNameOnlyDefinition
    extends IncompleteDefinition {
        ExternalNameOnlyDefinition(Node lValue) {
            super(lValue, true);
        }

        @Override
        public void performRemove(AbstractCompiler compiler) {
            throw new IllegalArgumentException("Can't remove external name-only definition");
        }
    }

    static final class UnknownDefinition
    extends IncompleteDefinition {
        UnknownDefinition(Node lValue, boolean inExterns) {
            super(lValue, inExterns);
        }

        @Override
        public void performRemove(AbstractCompiler compiler) {
            throw new IllegalArgumentException("Can't remove an UnknownDefinition");
        }
    }

    static abstract class IncompleteDefinition
    extends Definition {
        private static final ImmutableSet<Token> ALLOWED_TYPES = ImmutableSet.of((Object)((Object)Token.NAME), (Object)((Object)Token.GETPROP), (Object)((Object)Token.GETELEM));
        private final Node lValue;

        IncompleteDefinition(Node lValue, boolean inExterns) {
            super(inExterns);
            Preconditions.checkNotNull((Object)lValue);
            Preconditions.checkArgument((boolean)ALLOWED_TYPES.contains((Object)lValue.getToken()), (String)"Unexpected lValue type %s", (Object)((Object)lValue.getToken()));
            this.lValue = lValue;
        }

        @Override
        public Node getLValue() {
            return this.lValue;
        }

        @Override
        public Node getRValue() {
            return null;
        }
    }

    static abstract class Definition {
        private final boolean isExtern;

        Definition(boolean isExtern) {
            this.isExtern = isExtern;
        }

        public void remove(AbstractCompiler compiler) {
            if (this.isExtern) {
                throw new IllegalStateException("Attempt to remove() an extern definition.");
            }
            this.performRemove(compiler);
        }

        protected abstract void performRemove(AbstractCompiler var1);

        public abstract Node getLValue();

        public abstract Node getRValue();

        public boolean isExtern() {
            return this.isExtern;
        }

        public String toString() {
            return this.getLValue().getQualifiedName() + " = " + this.getRValue();
        }
    }
}

