/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.DefinitionSite;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.NameBasedDefinitionProvider;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.UseSite;
import com.google.javascript.rhino.Node;
import java.util.Collection;

public class DefinitionUseSiteFinder
extends NameBasedDefinitionProvider {
    private final Multimap<String, UseSite> nameUseSiteMultimap = LinkedHashMultimap.create();

    @VisibleForTesting
    Multimap<String, UseSite> getNameUseSiteMultimap() {
        return LinkedHashMultimap.create(this.nameUseSiteMultimap);
    }

    public DefinitionUseSiteFinder(AbstractCompiler compiler) {
        super(compiler, false);
    }

    @Override
    public void process(Node externs, Node source) {
        super.process(externs, source);
        NodeTraversal.traverseEs6(this.compiler, source, new UseSiteGatheringCallback());
    }

    public Collection<UseSite> getUseSites(DefinitionsRemover.Definition definition) {
        Preconditions.checkState((boolean)this.hasProcessBeenRun, (Object)"The process was not run");
        String name = DefinitionUseSiteFinder.getSimplifiedName(definition.getLValue());
        return this.nameUseSiteMultimap.get((Object)name);
    }

    static boolean isCallOrNewSite(UseSite use) {
        Node call = use.node.getParent();
        if (call == null) {
            return false;
        }
        return NodeUtil.isCallOrNew(call) && call.getFirstChild() == use.node;
    }

    boolean canModifyDefinition(DefinitionsRemover.Definition definition) {
        if (this.isExported(definition)) {
            return false;
        }
        Collection<UseSite> useSites = this.getUseSites(definition);
        if (useSites.isEmpty()) {
            return false;
        }
        for (UseSite site : useSites) {
            Node nameNode = site.node;
            Collection<DefinitionsRemover.Definition> singleSiteDefinitions = this.getDefinitionsReferencedAt(nameNode);
            if (singleSiteDefinitions.size() > 1) {
                return false;
            }
            Preconditions.checkState((!singleSiteDefinitions.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkState((boolean)singleSiteDefinitions.contains(definition));
        }
        return true;
    }

    private boolean isExported(DefinitionsRemover.Definition definition) {
        String partialName;
        Node lValue = definition.getLValue();
        if (lValue == null) {
            return true;
        }
        if (lValue.isGetProp()) {
            partialName = lValue.getLastChild().getString();
        } else if (lValue.isName()) {
            partialName = lValue.getString();
        } else {
            return true;
        }
        CodingConvention codingConvention = this.compiler.getCodingConvention();
        return codingConvention.isExported(partialName);
    }

    void removeReferences(Node node) {
        if (DefinitionsRemover.isDefinitionNode(node)) {
            DefinitionsRemover.Definition def;
            String name;
            DefinitionSite defSite = (DefinitionSite)this.definitionNodeByDefinitionSite.get(node);
            if (defSite != null && (name = DefinitionUseSiteFinder.getSimplifiedName((def = defSite.definition).getLValue())) != null) {
                this.definitionNodeByDefinitionSite.remove(node);
                this.nameDefinitionMultimap.remove((Object)name, (Object)def);
            }
        } else {
            String name;
            String propName;
            Node useSite = node;
            if (useSite.isGetProp() && ((propName = useSite.getLastChild().getString()).equals("apply") || propName.equals("call"))) {
                useSite = useSite.getFirstChild();
            }
            if ((name = DefinitionUseSiteFinder.getSimplifiedName(useSite)) != null) {
                this.nameUseSiteMultimap.remove((Object)name, (Object)new UseSite(useSite, null, null));
            }
        }
        for (Node child : node.children()) {
            this.removeReferences(child);
        }
    }

    private class UseSiteGatheringCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private UseSiteGatheringCallback() {
        }

        @Override
        public void visit(NodeTraversal traversal, Node node, Node parent) {
            if (!node.isGetProp() && !node.isName()) {
                return;
            }
            Collection<DefinitionsRemover.Definition> defs = DefinitionUseSiteFinder.this.getDefinitionsReferencedAt(node);
            if (defs == null) {
                return;
            }
            DefinitionsRemover.Definition first = defs.iterator().next();
            String name = NameBasedDefinitionProvider.getSimplifiedName(first.getLValue());
            Preconditions.checkNotNull((Object)name);
            DefinitionUseSiteFinder.this.nameUseSiteMultimap.put((Object)name, (Object)new UseSite(node, traversal.getScope(), traversal.getModule()));
        }
    }
}

