/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.BasicBlock;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Reference;
import com.google.javascript.jscomp.ReferenceCollection;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public final class CrossModuleReferenceCollector
implements NodeTraversal.ScopedCallback,
CompilerPass {
    private final Map<String, Var> varsByName = new HashMap<String, Var>();
    private final Map<Var, ReferenceCollection> referenceMap = new LinkedHashMap<Var, ReferenceCollection>();
    private final List<BasicBlock> blockStack = new ArrayList<BasicBlock>();
    private final List<TopLevelStatement> topLevelStatements = new ArrayList<TopLevelStatement>();
    private final ScopeCreator scopeCreator;
    private final AbstractCompiler compiler;
    private TopLevelStatementDraft topLevelStatementDraft = null;

    CrossModuleReferenceCollector(AbstractCompiler compiler, ScopeCreator creator) {
        this.compiler = compiler;
        this.scopeCreator = creator;
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState((boolean)this.topLevelStatements.isEmpty(), (Object)"process() called more than once");
        NodeTraversal t = new NodeTraversal(this.compiler, this, this.scopeCreator);
        t.traverseRoots(externs, root);
    }

    public void process(Node root) {
        Preconditions.checkState((boolean)this.topLevelStatements.isEmpty(), (Object)"process() called more than once");
        NodeTraversal t = new NodeTraversal(this.compiler, this, this.scopeCreator);
        t.traverse(root);
    }

    Iterable<Var> getAllSymbols() {
        return this.referenceMap.keySet();
    }

    ReferenceCollection getReferences(Var v) {
        return this.referenceMap.get(v);
    }

    ImmutableMap<String, Var> getGlobalVariableNamesMap() {
        return ImmutableMap.copyOf(this.varsByName);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (this.topLevelStatementDraft != null) {
            if (n.equals(this.topLevelStatementDraft.statementNode)) {
                this.topLevelStatements.add(new TopLevelStatement(this.topLevelStatementDraft));
                this.topLevelStatementDraft = null;
            } else if (n.isName() || n.isStringKey() && !n.hasChildren()) {
                String varName = n.getString();
                Var v = t.getScope().getVar(varName);
                if (v != null && v.isGlobal() && !this.compiler.getCodingConvention().isExported(v.getName())) {
                    if (this.varsByName.containsKey(varName)) {
                        Preconditions.checkState((boolean)Objects.equals(this.varsByName.get(varName), v));
                    } else {
                        this.varsByName.put(varName, v);
                    }
                    Reference reference = new Reference(n, t, CrossModuleReferenceCollector.peek(this.blockStack));
                    if (reference.getNode() == this.topLevelStatementDraft.declaredNameNode) {
                        this.topLevelStatementDraft.declaredNameReference = reference;
                    } else {
                        this.topLevelStatementDraft.nonDeclarationReferences.add(reference);
                    }
                    this.addReferenceToCollection(v, reference);
                }
            }
        }
        if (CrossModuleReferenceCollector.isBlockBoundary(n, parent)) {
            CrossModuleReferenceCollector.pop(this.blockStack);
        }
    }

    @Override
    public void enterScope(NodeTraversal t) {
        BasicBlock parent;
        Node n = t.getScopeRoot();
        BasicBlock basicBlock = parent = this.blockStack.isEmpty() ? null : CrossModuleReferenceCollector.peek(this.blockStack);
        if (t.getScope().isHoistScope()) {
            this.blockStack.add(new BasicBlock(parent, n));
        }
    }

    @Override
    public void exitScope(NodeTraversal t) {
        if (t.getScope().isHoistScope()) {
            CrossModuleReferenceCollector.pop(this.blockStack);
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        if (parent != null && NodeUtil.isTopLevel(parent)) {
            Preconditions.checkState((this.topLevelStatementDraft == null ? 1 : 0) != 0, (Object)n);
            this.topLevelStatementDraft = this.initializeDraftStatement(nodeTraversal.getModule(), n);
        }
        if (CrossModuleReferenceCollector.isBlockBoundary(n, parent)) {
            this.blockStack.add(new BasicBlock(CrossModuleReferenceCollector.peek(this.blockStack), n));
        }
        return true;
    }

    private TopLevelStatementDraft initializeDraftStatement(JSModule module, Node statementNode) {
        TopLevelStatementDraft draft = new TopLevelStatementDraft(module, statementNode);
        if (statementNode.isVar()) {
            draft.declaredNameNode = statementNode.getFirstChild();
            draft.declaredValueNode = statementNode.getFirstFirstChild();
        } else if (statementNode.isFunction()) {
            draft.declaredNameNode = statementNode.getFirstChild();
            draft.declaredValueNode = statementNode;
        } else if (statementNode.isExprResult()) {
            CodingConvention.SubclassRelationship relationship;
            Node expr = (Node)Preconditions.checkNotNull((Object)statementNode.getFirstChild());
            if (expr.isAssign()) {
                Node lhs = (Node)Preconditions.checkNotNull((Object)expr.getFirstChild());
                Node rhs = (Node)Preconditions.checkNotNull((Object)expr.getSecondChild());
                if (lhs.isName()) {
                    draft.declaredNameNode = lhs;
                    draft.declaredValueNode = rhs;
                } else if (lhs.isGetProp()) {
                    Node nameNode = (Node)Preconditions.checkNotNull((Object)lhs.getFirstChild());
                    while (nameNode.isGetProp()) {
                        nameNode = (Node)Preconditions.checkNotNull((Object)nameNode.getFirstChild());
                    }
                    if (nameNode.isName()) {
                        draft.declaredNameNode = nameNode;
                        draft.declaredValueNode = rhs;
                    }
                }
            } else if (expr.isCall() && (relationship = this.compiler.getCodingConvention().getClassesDefinedByCall(expr)) != null) {
                String declaredName = (String)Preconditions.checkNotNull((Object)relationship.subclassName);
                Node nameNode = null;
                for (Node callArg = expr.getSecondChild(); callArg != null; callArg = callArg.getNext()) {
                    if (!callArg.isName() || !declaredName.equals(callArg.getString())) continue;
                    nameNode = callArg;
                    break;
                }
                if (nameNode != null) {
                    draft.declaredNameNode = nameNode;
                    draft.declaredValueNode = null;
                }
            }
        }
        return draft;
    }

    private static <T> T pop(List<T> list) {
        return list.remove(list.size() - 1);
    }

    private static <T> T peek(List<T> list) {
        return (T)Iterables.getLast(list);
    }

    private static boolean isBlockBoundary(Node n, Node parent) {
        if (parent != null) {
            switch (parent.getToken()) {
                case DO: 
                case FOR: 
                case FOR_IN: 
                case FOR_OF: 
                case TRY: 
                case WHILE: 
                case WITH: 
                case CLASS: {
                    return true;
                }
                case AND: 
                case HOOK: 
                case IF: 
                case OR: 
                case SWITCH: {
                    return n != parent.getFirstChild();
                }
            }
        }
        return n.isCase();
    }

    private void addReferenceToCollection(Var v, Reference reference) {
        ReferenceCollection referenceInfo = this.referenceMap.get(v);
        if (referenceInfo == null) {
            referenceInfo = new ReferenceCollection();
            this.referenceMap.put(v, referenceInfo);
        }
        referenceInfo.add(reference);
    }

    List<TopLevelStatement> getTopLevelStatements() {
        return Collections.unmodifiableList(this.topLevelStatements);
    }

    private boolean canMoveValue(Scope scope, Node valueNode) {
        ReferenceCollection refCollection;
        Var v;
        if (valueNode == null || NodeUtil.isLiteralValue(valueNode, true) || valueNode.isFunction()) {
            return true;
        }
        if (valueNode.isCall()) {
            Node functionName = (Node)Preconditions.checkNotNull((Object)valueNode.getFirstChild());
            return functionName.isName() && (functionName.getString().equals("JSCompiler_stubMethod") || functionName.getString().equals("JSCompiler_unstubMethod"));
        }
        if (valueNode.isArrayLit() || valueNode.isObjectLit()) {
            boolean isObjectLit = valueNode.isObjectLit();
            for (Node child = valueNode.getFirstChild(); child != null; child = child.getNext()) {
                if (this.canMoveValue(scope, isObjectLit ? child.getFirstChild() : child)) continue;
                return false;
            }
            return true;
        }
        return valueNode.isName() && (v = scope.getVar(valueNode.getString())) != null && v.isGlobal() && (refCollection = this.getReferences(v)) != null && refCollection.isWellDefined() && refCollection.isAssignedOnceInLifetime();
    }

    private static final class TopLevelStatementDraft {
        final JSModule module;
        final Node statementNode;
        final List<Reference> nonDeclarationReferences = new ArrayList<Reference>();
        Node declaredValueNode = null;
        Node declaredNameNode = null;
        Reference declaredNameReference = null;

        TopLevelStatementDraft(JSModule module, Node statementNode) {
            this.module = module;
            this.statementNode = statementNode;
        }
    }

    final class TopLevelStatement {
        private final JSModule module;
        private final Node statementNode;
        private final List<Reference> nonDeclarationReferences;
        private final Reference declaredNameReference;
        private final Node declaredValueNode;

        TopLevelStatement(TopLevelStatementDraft draft) {
            this.module = draft.module;
            this.statementNode = draft.statementNode;
            this.nonDeclarationReferences = Collections.unmodifiableList(draft.nonDeclarationReferences);
            this.declaredNameReference = draft.declaredNameReference;
            this.declaredValueNode = draft.declaredValueNode;
        }

        JSModule getModule() {
            return this.module;
        }

        Node getStatementNode() {
            return this.statementNode;
        }

        List<Reference> getNonDeclarationReferences() {
            return Collections.unmodifiableList(this.nonDeclarationReferences);
        }

        boolean isDeclarationStatement() {
            return this.declaredNameReference != null;
        }

        Reference getDeclaredNameReference() {
            return (Reference)Preconditions.checkNotNull((Object)this.declaredNameReference);
        }

        @Nullable
        Node getDeclaredValueNode() {
            return this.declaredValueNode;
        }

        boolean isMovableDeclaration() {
            return this.isDeclarationStatement() && CrossModuleReferenceCollector.this.canMoveValue(this.declaredNameReference.getScope(), this.declaredValueNode);
        }
    }
}

