/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

class ConvertToTypedInterface
implements CompilerPass {
    static final DiagnosticType CONSTANT_WITHOUT_EXPLICIT_TYPE = DiagnosticType.warning("JSC_CONSTANT_WITHOUT_EXPLICIT_TYPE", "/** @const */-annotated values in library API should have types explicitly specified.");
    private final AbstractCompiler compiler;

    ConvertToTypedInterface(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    private void unhoistExternsToCode(Node externs, Node root) {
        for (Node script = root.getFirstChild(); script != null; script = script.getNext()) {
            if (!script.hasChildren()) continue;
            NodeUtil.deleteChildren(script, this.compiler);
        }
        Node firstScript = root.getFirstChild();
        boolean firstTime = true;
        while (externs.hasChildren()) {
            Node externScript = externs.removeFirstChild();
            if (!externScript.hasChildren()) continue;
            firstScript.addChildrenToBack(externScript.removeChildren());
            this.compiler.reportChangeToChangeScope(externScript);
            if (!firstTime) continue;
            this.compiler.reportChangeToChangeScope(firstScript);
            firstTime = false;
        }
    }

    @Override
    public void process(Node externs, Node root) {
        if (!root.hasChildren() || root.hasOneChild() && !root.getFirstChild().hasChildren()) {
            this.unhoistExternsToCode(externs, root);
            return;
        }
        NodeTraversal.traverseEs6(this.compiler, root, new RemoveNonDeclarations(this.compiler));
        NodeTraversal.traverseEs6(this.compiler, root, new PropagateConstJsdoc());
        SimplifyDeclarations simplify = new SimplifyDeclarations(this.compiler);
        NodeTraversal.traverseEs6(this.compiler, root, simplify);
    }

    @Nullable
    private static Var findNameDeclaration(NodeTraversal t, Node rhs) {
        if (!rhs.isName()) {
            return null;
        }
        return t.getScope().getVar(rhs.getString());
    }

    private static void replaceRhsWithUnknown(Node lhs) {
        Node rhs = NodeUtil.getRValueOfLValue(lhs);
        rhs.replaceWith(IR.cast(IR.number(0.0), JsdocUtil.getQmarkTypeJSDoc()).srcrefTree(rhs));
    }

    private static boolean isDeclaration(Node nameNode) {
        Preconditions.checkArgument((boolean)nameNode.isQualifiedName());
        Node parent = nameNode.getParent();
        switch (parent.getToken()) {
            case FUNCTION: 
            case CONST: 
            case LET: 
            case VAR: 
            case CLASS: {
                return true;
            }
        }
        return false;
    }

    private static boolean isConstToBeInferred(JSDocInfo jsdoc, Node nameNode, boolean isImpliedConst) {
        boolean isConst = isImpliedConst || nameNode.getParent().isConst() || jsdoc != null && jsdoc.hasConstAnnotation();
        return isConst && !JsdocUtil.hasAnnotatedType(jsdoc) && !NodeUtil.isNamespaceDecl(nameNode);
    }

    private static boolean isClassMemberFunction(Node functionNode) {
        Preconditions.checkArgument((boolean)functionNode.isFunction());
        Node parent = functionNode.getParent();
        if (parent.isMemberFunctionDef() && parent.getParent().isClassMembers()) {
            return true;
        }
        return parent.isStringKey() && parent.getParent().isObjectLit() && parent.getGrandparent().isCall() && parent.getGrandparent().getFirstChild().matchesQualifiedName("goog.defineClass");
    }

    private static String getClassName(Node functionNode) {
        if (ConvertToTypedInterface.isClassMemberFunction(functionNode)) {
            Node parent = functionNode.getParent();
            if (parent.isMemberFunctionDef()) {
                Node classNode = functionNode.getGrandparent().getParent();
                Preconditions.checkState((boolean)classNode.isClass());
                return NodeUtil.getName(classNode);
            }
            Preconditions.checkState((boolean)parent.isStringKey());
            Node defineClassCall = parent.getGrandparent();
            Preconditions.checkState((boolean)defineClassCall.isCall());
            return NodeUtil.getBestLValue(defineClassCall).getQualifiedName();
        }
        return NodeUtil.getName(functionNode);
    }

    private static boolean isConstructor(Node functionNode) {
        if (ConvertToTypedInterface.isClassMemberFunction(functionNode)) {
            return "constructor".equals(functionNode.getParent().getString());
        }
        JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(functionNode);
        return jsdoc != null && jsdoc.isConstructor();
    }

    private static class JsdocUtil {
        private JsdocUtil() {
        }

        private static JSDocInfo pullJsdocTypeFromAst(AbstractCompiler compiler, JSDocInfo oldJSDoc, Node nameNode) {
            Preconditions.checkArgument((boolean)nameNode.isQualifiedName());
            if (!nameNode.isFromExterns() && !JsdocUtil.isPrivate(oldJSDoc)) {
                compiler.report(JSError.make(nameNode, CONSTANT_WITHOUT_EXPLICIT_TYPE, new String[0]));
            }
            return JsdocUtil.getConstJSDoc(oldJSDoc, new Node(Token.STAR));
        }

        private static boolean isPrivate(@Nullable JSDocInfo jsdoc) {
            return jsdoc != null && jsdoc.getVisibility().equals((Object)JSDocInfo.Visibility.PRIVATE);
        }

        private static JSDocInfo getAllTypeJSDoc() {
            return JsdocUtil.getConstJSDoc(null, new Node(Token.STAR));
        }

        private static JSDocInfo getQmarkTypeJSDoc() {
            return JsdocUtil.getConstJSDoc(null, new Node(Token.QMARK));
        }

        private static JSTypeExpression asTypeExpression(Node typeAst) {
            return new JSTypeExpression(typeAst, "<synthetic>");
        }

        private static JSDocInfo getConstJSDoc(JSDocInfo oldJSDoc, String contents) {
            return JsdocUtil.getConstJSDoc(oldJSDoc, Node.newString(contents));
        }

        private static JSDocInfo getConstJSDoc(JSDocInfo oldJSDoc, Node typeAst) {
            return JsdocUtil.getConstJSDoc(oldJSDoc, JsdocUtil.asTypeExpression(typeAst));
        }

        private static JSDocInfo getConstJSDoc(JSDocInfo oldJSDoc, JSTypeExpression newType) {
            JSDocInfoBuilder builder = JSDocInfoBuilder.maybeCopyFrom(oldJSDoc);
            builder.recordType(newType);
            builder.recordConstancy();
            return builder.build();
        }

        private static boolean hasAnnotatedType(JSDocInfo jsdoc) {
            if (jsdoc == null) {
                return false;
            }
            return jsdoc.hasType() || jsdoc.hasReturnType() || jsdoc.getParameterCount() > 0 || jsdoc.isConstructorOrInterface() || jsdoc.hasThisType() || jsdoc.hasEnumParameterType();
        }

        private static JSDocInfo getJSDocForRhs(Node rhs, JSDocInfo oldJSDoc) {
            switch (NodeUtil.getKnownValueType(rhs)) {
                case BOOLEAN: {
                    return JsdocUtil.getConstJSDoc(oldJSDoc, "boolean");
                }
                case NUMBER: {
                    return JsdocUtil.getConstJSDoc(oldJSDoc, "number");
                }
                case STRING: {
                    return JsdocUtil.getConstJSDoc(oldJSDoc, "string");
                }
                case NULL: {
                    return JsdocUtil.getConstJSDoc(oldJSDoc, "null");
                }
                case VOID: {
                    return JsdocUtil.getConstJSDoc(oldJSDoc, "void");
                }
                case OBJECT: {
                    if (!rhs.isRegExp()) break;
                    return JsdocUtil.getConstJSDoc(oldJSDoc, new Node(Token.BANG, IR.string("RegExp")));
                }
            }
            return null;
        }

        private static JSDocInfo getJSDocForName(Var decl, JSDocInfo oldJSDoc) {
            if (decl == null) {
                return null;
            }
            JSTypeExpression expr = NodeUtil.getDeclaredTypeExpression(decl.getNameNode());
            if (expr == null) {
                return null;
            }
            switch (expr.getRoot().getToken()) {
                case EQUALS: {
                    Node typeRoot = expr.getRoot().getFirstChild().cloneTree();
                    if (!decl.isDefaultParam()) {
                        typeRoot = new Node(Token.PIPE, typeRoot, IR.string("undefined"));
                    }
                    expr = JsdocUtil.asTypeExpression(typeRoot);
                    break;
                }
                case ELLIPSIS: {
                    Node type = new Node(Token.BANG);
                    Node array = IR.string("Array");
                    type.addChildToBack(array);
                    Node block = new Node(Token.BLOCK, expr.getRoot().getFirstChild().cloneTree());
                    array.addChildToBack(block);
                    expr = JsdocUtil.asTypeExpression(type);
                    break;
                }
            }
            return JsdocUtil.getConstJSDoc(oldJSDoc, expr);
        }
    }

    private static class SimplifyDeclarations
    implements NodeTraversal.Callback {
        private final AbstractCompiler compiler;
        private final FileInfo currentFile = new FileInfo();

        SimplifyDeclarations(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        private void processConstructors(List<Node> constructorNodes) {
            for (Node ctorNode : constructorNodes) {
                this.processConstructor(ctorNode);
            }
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            block0 : switch (n.getToken()) {
                case SCRIPT: {
                    this.currentFile.clear();
                    break;
                }
                case CLASS: {
                    if (!NodeUtil.isStatementParent(parent)) break;
                    this.currentFile.markNameProcessed(n.getFirstChild().getString());
                    break;
                }
                case FUNCTION: {
                    if (NodeUtil.isStatementParent(parent)) {
                        this.currentFile.markNameProcessed(n.getFirstChild().getString());
                    }
                    this.processFunctionParameters(n.getSecondChild());
                    if (ConvertToTypedInterface.isConstructor(n) && n.getLastChild().hasChildren()) {
                        this.currentFile.markConstructorToProcess(n);
                    }
                    return false;
                }
                case EXPR_RESULT: {
                    Node expr = n.getFirstChild();
                    switch (expr.getToken()) {
                        case CALL: {
                            Node callee = expr.getFirstChild();
                            if (callee.matchesQualifiedName("goog.provide")) {
                                this.currentFile.markProvided(expr.getLastChild().getString());
                                break block0;
                            }
                            if (callee.matchesQualifiedName("goog.require")) {
                                this.currentFile.markImportedName(expr.getLastChild().getString());
                                break block0;
                            }
                            if (callee.matchesQualifiedName("goog.define")) {
                                NodeUtil.deleteNode(expr.getLastChild(), this.compiler);
                                break block0;
                            }
                            Preconditions.checkState((boolean)callee.matchesQualifiedName("goog.module"));
                            break block0;
                        }
                        case ASSIGN: {
                            this.processName(t, expr.getFirstChild(), n);
                            break block0;
                        }
                        case GETPROP: {
                            this.processName(t, expr, n);
                            break block0;
                        }
                    }
                    throw new RuntimeException("Unexpected declaration: " + expr);
                }
                case CONST: 
                case LET: 
                case VAR: {
                    Preconditions.checkState((n.hasOneChild() && NodeUtil.isStatement(n) ? 1 : 0) != 0);
                    Node lhs = n.getFirstChild();
                    this.processNameDecl(t, lhs, lhs.getLastChild());
                    break;
                }
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isScript()) {
                this.processConstructors(this.currentFile.constructorsToProcess);
            }
        }

        private void processNameDecl(NodeTraversal t, Node lhs, Node rhs) {
            if (rhs != null && SimplifyDeclarations.isImportRhs(rhs)) {
                for (Node importedName : NodeUtil.getLhsNodesOfDeclaration(lhs.getParent())) {
                    this.currentFile.markImportedName(importedName.getString());
                }
            } else {
                this.processName(t, lhs, lhs.getParent());
            }
        }

        private void processFunctionParameters(Node paramList) {
            Preconditions.checkArgument((boolean)paramList.isParamList());
            for (Node arg = paramList.getFirstChild(); arg != null; arg = arg.getNext()) {
                if (!arg.isDefaultValue()) continue;
                Node replacement = arg.getFirstChild().detach();
                arg.replaceWith(replacement);
                arg = replacement;
                this.compiler.reportChangeToEnclosingScope(replacement);
            }
        }

        private void processConstructor(Node function) {
            final String className = ConvertToTypedInterface.getClassName(function);
            if (className == null) {
                return;
            }
            final Node insertionPoint = NodeUtil.getEnclosingStatement(function);
            NodeTraversal.traverseEs6(this.compiler, function.getLastChild(), new NodeTraversal.AbstractShallowStatementCallback(){

                @Override
                public void visit(NodeTraversal t, Node n, Node parent) {
                    if (n.isExprResult()) {
                        Node name;
                        Node expr = n.getFirstChild();
                        Node node = name = expr.isAssign() ? expr.getFirstChild() : expr;
                        if (!name.isGetProp() || !name.getFirstChild().isThis()) {
                            return;
                        }
                        String pname = name.getLastChild().getString();
                        String fullyQualifiedName = className + ".prototype." + pname;
                        if (SimplifyDeclarations.this.currentFile.isNameProcessed(fullyQualifiedName)) {
                            return;
                        }
                        JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(name);
                        if (jsdoc == null) {
                            jsdoc = JsdocUtil.getAllTypeJSDoc();
                        } else if (ConvertToTypedInterface.isConstToBeInferred(jsdoc, name, false)) {
                            jsdoc = JsdocUtil.pullJsdocTypeFromAst(SimplifyDeclarations.this.compiler, jsdoc, name);
                        }
                        Node newProtoAssignStmt = NodeUtil.newQNameDeclaration(SimplifyDeclarations.this.compiler, fullyQualifiedName, null, jsdoc);
                        newProtoAssignStmt.useSourceInfoIfMissingFromForTree(expr);
                        insertionPoint.getParent().addChildAfter(newProtoAssignStmt, insertionPoint);
                        SimplifyDeclarations.this.compiler.reportChangeToEnclosingScope(newProtoAssignStmt);
                        SimplifyDeclarations.this.currentFile.markNameProcessed(fullyQualifiedName);
                    }
                }
            });
            Node functionBody = function.getLastChild();
            Preconditions.checkState((boolean)functionBody.isNormalBlock());
            NodeUtil.deleteChildren(functionBody, this.compiler);
        }

        private static boolean isImportRhs(Node rhs) {
            if (!rhs.isCall()) {
                return false;
            }
            Node callee = rhs.getFirstChild();
            return callee.matchesQualifiedName("goog.require") || callee.matchesQualifiedName("goog.forwardDeclare");
        }

        private static boolean isExportLhs(Node lhs) {
            return lhs.isName() && lhs.matchesQualifiedName("exports") || lhs.isGetProp() && lhs.getFirstChild().matchesQualifiedName("exports");
        }

        private RemovalType shouldRemove(NodeTraversal t, Node nameNode) {
            Node jsdocNode = NodeUtil.getBestJSDocInfoNode(nameNode);
            JSDocInfo jsdoc = jsdocNode.getJSDocInfo();
            Node rhs = NodeUtil.getRValueOfLValue(nameNode);
            boolean isExport = SimplifyDeclarations.isExportLhs(nameNode);
            if (rhs == null || rhs.isFunction() || rhs.isClass() || NodeUtil.isCallTo(rhs, "goog.defineClass") || SimplifyDeclarations.isImportRhs(rhs) || isExport && (rhs.isQualifiedName() || rhs.isObjectLit()) || rhs.isQualifiedName() && rhs.matchesQualifiedName("goog.abstractMethod") || rhs.isQualifiedName() && rhs.matchesQualifiedName("goog.nullFunction") || jsdoc != null && jsdoc.isConstructor() && rhs.isQualifiedName() || rhs.isObjectLit() && !rhs.hasChildren() && (jsdoc == null || !JsdocUtil.hasAnnotatedType(jsdoc))) {
                return RemovalType.PRESERVE_ALL;
            }
            if (!(isExport || jsdoc != null && jsdoc.containsDeclaration())) {
                String fullyQualifiedName = nameNode.getQualifiedName();
                if (this.currentFile.isNameProcessed(fullyQualifiedName)) {
                    return RemovalType.REMOVE_ALL;
                }
                if (ConvertToTypedInterface.isDeclaration(nameNode) || this.currentFile.isPrefixProvided(fullyQualifiedName)) {
                    jsdocNode.setJSDocInfo(JsdocUtil.getAllTypeJSDoc());
                    return RemovalType.REMOVE_RHS;
                }
                return RemovalType.REMOVE_ALL;
            }
            if (ConvertToTypedInterface.isConstToBeInferred(jsdoc, nameNode, isExport)) {
                if (rhs.isQualifiedName() && this.currentFile.isRequiredName(rhs.getQualifiedName())) {
                    return RemovalType.PRESERVE_ALL;
                }
                Var originalDecl = ConvertToTypedInterface.findNameDeclaration(t, rhs);
                if (originalDecl != null && (originalDecl.isClass() || JsdocUtil.hasAnnotatedType(originalDecl.getJSDocInfo()))) {
                    return RemovalType.PRESERVE_ALL;
                }
                jsdocNode.setJSDocInfo(JsdocUtil.pullJsdocTypeFromAst(this.compiler, jsdoc, nameNode));
            }
            return RemovalType.REMOVE_RHS;
        }

        private void processName(NodeTraversal t, Node nameNode, Node statement) {
            Preconditions.checkState((boolean)NodeUtil.isStatement(statement), (Object)statement);
            if (!nameNode.isQualifiedName()) {
                this.removeNode(statement);
                return;
            }
            Node jsdocNode = NodeUtil.getBestJSDocInfoNode(nameNode);
            switch (this.shouldRemove(t, nameNode)) {
                case REMOVE_ALL: {
                    this.removeNode(statement);
                    break;
                }
                case PRESERVE_ALL: {
                    break;
                }
                case REMOVE_RHS: {
                    this.maybeRemoveRhs(t, nameNode, statement, jsdocNode.getJSDocInfo());
                }
            }
            this.currentFile.markNameProcessed(nameNode.getQualifiedName());
        }

        private void removeNode(Node n) {
            this.compiler.reportChangeToEnclosingScope(n);
            if (NodeUtil.isStatement(n)) {
                n.detach();
            } else {
                n.replaceWith(IR.empty().srcref(n));
            }
            NodeUtil.markFunctionsDeleted(n, this.compiler);
        }

        private void maybeRemoveRhs(NodeTraversal t, Node nameNode, Node statement, JSDocInfo jsdoc) {
            if (jsdoc != null && jsdoc.hasEnumParameterType()) {
                this.removeEnumValues(t, NodeUtil.getRValueOfLValue(nameNode));
                return;
            }
            if (nameNode.matchesQualifiedName("exports")) {
                ConvertToTypedInterface.replaceRhsWithUnknown(nameNode);
                t.reportCodeChange();
                return;
            }
            Node newStatement = NodeUtil.newQNameDeclaration(this.compiler, nameNode.getQualifiedName(), null, jsdoc);
            newStatement.useSourceInfoIfMissingFromForTree(nameNode);
            statement.replaceWith(newStatement);
            t.reportCodeChange();
        }

        private void removeEnumValues(NodeTraversal t, Node objLit) {
            if (objLit.isObjectLit() && objLit.hasChildren()) {
                for (Node key : objLit.children()) {
                    Node value = key.getFirstChild();
                    Node replacementValue = IR.number(0.0).srcrefTree(value);
                    key.replaceChild(value, replacementValue);
                }
                t.reportCodeChange();
            }
        }

        static enum RemovalType {
            PRESERVE_ALL,
            REMOVE_RHS,
            REMOVE_ALL;

        }
    }

    private static class FileInfo {
        private final Set<String> providedNamespaces = new HashSet<String>();
        private final Set<String> requiredLocalNames = new HashSet<String>();
        private final Set<String> seenNames = new HashSet<String>();
        private final List<Node> constructorsToProcess = new ArrayList<Node>();

        private FileInfo() {
        }

        boolean isNameProcessed(String fullyQualifiedName) {
            return this.seenNames.contains(fullyQualifiedName);
        }

        boolean isPrefixProvided(String fullyQualifiedName) {
            for (String prefix : Iterables.concat(this.seenNames, this.providedNamespaces)) {
                if (!fullyQualifiedName.startsWith(prefix)) continue;
                return true;
            }
            return false;
        }

        boolean isRequiredName(String fullyQualifiedName) {
            return this.requiredLocalNames.contains(fullyQualifiedName);
        }

        void markConstructorToProcess(Node ctorNode) {
            Preconditions.checkArgument((boolean)ctorNode.isFunction(), (Object)ctorNode);
            this.constructorsToProcess.add(ctorNode);
        }

        void markNameProcessed(String fullyQualifiedName) {
            this.seenNames.add(fullyQualifiedName);
        }

        void markProvided(String providedName) {
            this.providedNamespaces.add(providedName);
        }

        void markImportedName(String requiredLocalName) {
            this.requiredLocalNames.add(requiredLocalName);
        }

        void clear() {
            this.providedNamespaces.clear();
            this.seenNames.clear();
            this.constructorsToProcess.clear();
        }
    }

    private static class PropagateConstJsdoc
    extends NodeTraversal.AbstractPostOrderCallback {
        private PropagateConstJsdoc() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case EXPR_RESULT: {
                    if (!NodeUtil.isExprAssign(n)) break;
                    Node expr = n.getFirstChild();
                    this.propagateJsdocAtName(t, expr.getFirstChild());
                    break;
                }
                case CONST: 
                case LET: 
                case VAR: {
                    Preconditions.checkState((boolean)n.hasOneChild());
                    this.propagateJsdocAtName(t, n.getFirstChild());
                    break;
                }
            }
        }

        private void propagateJsdocAtName(NodeTraversal t, Node nameNode) {
            Node jsdocNode = NodeUtil.getBestJSDocInfoNode(nameNode);
            JSDocInfo jsdoc = jsdocNode.getJSDocInfo();
            if (!ConvertToTypedInterface.isConstToBeInferred(jsdoc, nameNode, false)) {
                return;
            }
            Node rhs = NodeUtil.getRValueOfLValue(nameNode);
            if (rhs == null) {
                return;
            }
            JSDocInfo newJsdoc = JsdocUtil.getJSDocForRhs(rhs, jsdoc);
            if (newJsdoc == null && nameNode.isGetProp() && nameNode.getFirstChild().isThis()) {
                Var decl = ConvertToTypedInterface.findNameDeclaration(t, rhs);
                newJsdoc = JsdocUtil.getJSDocForName(decl, jsdoc);
            }
            if (newJsdoc != null) {
                jsdocNode.setJSDocInfo(newJsdoc);
                t.reportCodeChange();
            }
        }
    }

    private static class RemoveNonDeclarations
    implements NodeTraversal.Callback {
        private final AbstractCompiler compiler;

        public RemoveNonDeclarations(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case FUNCTION: {
                    Node body;
                    if (!(ConvertToTypedInterface.isConstructor(n) || (body = n.getLastChild()).isNormalBlock() && !body.hasChildren())) {
                        t.reportCodeChange(body);
                        body.replaceWith(IR.block().srcref(body));
                        NodeUtil.markFunctionsDeleted(body, this.compiler);
                    }
                    return true;
                }
                case EXPR_RESULT: {
                    Node expr = n.getFirstChild();
                    switch (expr.getToken()) {
                        case CALL: {
                            Node callee = expr.getFirstChild();
                            Preconditions.checkState((!callee.matchesQualifiedName("goog.scope") ? 1 : 0) != 0);
                            if (!(callee.matchesQualifiedName("goog.provide") || callee.matchesQualifiedName("goog.define") || callee.matchesQualifiedName("goog.require") || callee.matchesQualifiedName("goog.module"))) {
                                NodeUtil.deleteNode(n, t.getCompiler());
                            }
                            return false;
                        }
                        case ASSIGN: {
                            if (!expr.getFirstChild().isQualifiedName() || expr.getFirstChild().isName() && !t.inGlobalScope() && !t.inModuleScope()) {
                                NodeUtil.deleteNode(n, t.getCompiler());
                                return false;
                            }
                            return true;
                        }
                        case GETPROP: {
                            return true;
                        }
                    }
                    NodeUtil.deleteNode(n, t.getCompiler());
                    return false;
                }
                case THROW: 
                case RETURN: 
                case BREAK: 
                case CONTINUE: 
                case DEBUGGER: 
                case EMPTY: {
                    if (NodeUtil.isStatementParent(parent)) {
                        NodeUtil.deleteNode(n, this.compiler);
                    }
                    return false;
                }
                case LABEL: 
                case IF: 
                case SWITCH: 
                case CASE: 
                case WHILE: {
                    NodeUtil.deleteNode(n.getFirstChild(), this.compiler);
                    return true;
                }
                case TRY: 
                case DO: {
                    NodeUtil.deleteNode(n.getSecondChild(), this.compiler);
                    return true;
                }
                case FOR: {
                    NodeUtil.deleteNode(n.getSecondChild(), this.compiler);
                }
                case FOR_OF: 
                case FOR_IN: {
                    NodeUtil.deleteNode(n.getSecondChild(), this.compiler);
                    Node initializer = n.removeFirstChild();
                    if (initializer.isVar()) {
                        n.getLastChild().addChildToFront(initializer);
                    }
                    return true;
                }
                case CONST: 
                case LET: {
                    if (!t.inGlobalScope() && !t.inModuleScope()) {
                        NodeUtil.removeChild(parent, n);
                        t.reportCodeChange(parent);
                        return false;
                    }
                    return true;
                }
                case VAR: {
                    if (!t.inGlobalHoistScope() && !t.inModuleHoistScope()) {
                        NodeUtil.removeChild(parent, n);
                        t.reportCodeChange(parent);
                        return false;
                    }
                    return true;
                }
                case MODULE_BODY: 
                case CLASS: 
                case DEFAULT_CASE: 
                case BLOCK: 
                case EXPORT: 
                case IMPORT: {
                    return true;
                }
            }
            Preconditions.checkState((!NodeUtil.isStatement(n) ? 1 : 0) != 0, (Object)((Object)n.getToken()));
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case LABEL: 
                case IF: 
                case SWITCH: 
                case CASE: 
                case WHILE: 
                case TRY: 
                case DO: 
                case FOR: 
                case FOR_OF: 
                case FOR_IN: 
                case DEFAULT_CASE: {
                    if (n.getParent() == null) break;
                    Node children = n.removeChildren();
                    parent.addChildrenAfter(children, n);
                    NodeUtil.removeChild(parent, n);
                    t.reportCodeChange();
                    break;
                }
                case CONST: 
                case LET: 
                case VAR: {
                    while (n.hasMoreThanOneChild()) {
                        Node nameToSplit = n.getLastChild().detach();
                        Node rhs = nameToSplit.hasChildren() ? nameToSplit.removeFirstChild() : null;
                        Node newDeclaration = IR.declaration(nameToSplit, rhs, n.getToken()).srcref(n);
                        parent.addChildAfter(newDeclaration, n);
                        t.reportCodeChange();
                    }
                    break;
                }
                case BLOCK: {
                    if (parent.isFunction()) break;
                    parent.addChildrenAfter(n.removeChildren(), n);
                    n.detach();
                    t.reportCodeChange(parent);
                    break;
                }
            }
        }
    }
}

