/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.dtoa.DToA;
import java.util.HashSet;

final class ClosureOptimizePrimitives
implements CompilerPass {
    static final DiagnosticType DUPLICATE_SET_MEMBER = DiagnosticType.warning("JSC_DUPLICATE_SET_MEMBER", "Found duplicate value ''{0}'' in set");
    private final AbstractCompiler compiler;
    private final boolean propertyRenamingEnabled;

    ClosureOptimizePrimitives(AbstractCompiler compiler, boolean propertyRenamingEnabled) {
        this.compiler = compiler;
        this.propertyRenamingEnabled = propertyRenamingEnabled;
    }

    @Override
    public void process(Node externs, Node root) {
        FindPrimitives pass = new FindPrimitives();
        NodeTraversal.traverseEs6(this.compiler, root, pass);
    }

    private void processObjectCreateCall(Node callNode) {
        Node curParam = callNode.getSecondChild();
        if (ClosureOptimizePrimitives.canOptimizeObjectCreate(curParam)) {
            Node objNode = IR.objectlit(new Node[0]).srcref(callNode);
            while (curParam != null) {
                Node keyNode = curParam;
                Node valueNode = curParam.getNext();
                curParam = valueNode.getNext();
                callNode.removeChild(keyNode);
                callNode.removeChild(valueNode);
                if (!keyNode.isString()) {
                    keyNode = IR.string(NodeUtil.getStringValue(keyNode)).srcref(keyNode);
                }
                keyNode.setToken(Token.STRING_KEY);
                keyNode.setQuotedString();
                objNode.addChildToBack(IR.propdef(keyNode, valueNode));
            }
            callNode.replaceWith(objNode);
            this.compiler.reportChangeToEnclosingScope(objNode);
        }
    }

    private void processRenamePropertyCall(Node callNode) {
        Node propName;
        if (!this.propertyRenamingEnabled && (propName = NodeUtil.getArgumentForCallOrNew(callNode, 0)) != null) {
            callNode.replaceWith(propName.detach());
            this.compiler.reportChangeToEnclosingScope(propName);
            return;
        }
        Node nameNode = callNode.getFirstChild();
        if (nameNode.matchesQualifiedName("JSCompiler_renameProperty")) {
            return;
        }
        Node newTarget = IR.name("JSCompiler_renameProperty").useSourceInfoFrom(nameNode);
        newTarget.setOriginalName(nameNode.getOriginalQualifiedName());
        callNode.replaceChild(nameNode, newTarget);
        callNode.putBooleanProp(50, true);
        this.compiler.reportChangeToEnclosingScope(callNode);
    }

    private static boolean canOptimizeObjectCreate(Node firstParam) {
        for (Node curParam = firstParam; curParam != null; curParam = curParam.getNext()) {
            if (!curParam.isString() && !curParam.isNumber()) {
                return false;
            }
            if ((curParam = curParam.getNext()) != null) continue;
            return false;
        }
        return true;
    }

    private void processObjectCreateSetCall(Node callNode) {
        Node curParam = callNode.getSecondChild();
        if (this.canOptimizeObjectCreateSet(curParam)) {
            Node objNode = IR.objectlit(new Node[0]).srcref(callNode);
            while (curParam != null) {
                Node keyNode = curParam;
                Node valueNode = IR.trueNode().srcref(keyNode);
                curParam = curParam.getNext();
                callNode.removeChild(keyNode);
                if (!keyNode.isString()) {
                    keyNode = IR.string(NodeUtil.getStringValue(keyNode)).srcref(keyNode);
                }
                keyNode.setToken(Token.STRING_KEY);
                keyNode.setQuotedString();
                objNode.addChildToBack(IR.propdef(keyNode, valueNode));
            }
            callNode.replaceWith(objNode);
            this.compiler.reportChangeToEnclosingScope(objNode);
        }
    }

    private boolean canOptimizeObjectCreateSet(Node firstParam) {
        HashSet<String> keys = new HashSet<String>();
        for (Node curParam = firstParam; curParam != null; curParam = curParam.getNext()) {
            String key;
            if (!curParam.isString() && !curParam.isNumber()) {
                return false;
            }
            String string = key = curParam.isString() ? curParam.getString() : DToA.numberToString(curParam.getDouble());
            if (keys.add(key)) continue;
            this.compiler.report(JSError.make(firstParam.getPrevious(), DUPLICATE_SET_MEMBER, key));
            return false;
        }
        return true;
    }

    private void maybeProcessDomTagName(Node n) {
        String tagName;
        if (NodeUtil.isLValue(n)) {
            return;
        }
        String prefix = "goog$dom$TagName$";
        if (n.isName() && n.getString().startsWith(prefix)) {
            tagName = n.getString().substring(prefix.length());
        } else if (n.isGetProp() && !n.getParent().isGetProp() && n.getFirstChild().matchesQualifiedName("goog.dom.TagName")) {
            tagName = n.getSecondChild().getString().replaceFirst(".*\\$", "");
        } else {
            return;
        }
        Node stringNode = IR.string(tagName).srcref(n);
        n.replaceWith(stringNode);
        this.compiler.reportChangeToEnclosingScope(stringNode);
    }

    private class FindPrimitives
    extends NodeTraversal.AbstractPostOrderCallback {
        private FindPrimitives() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isCall()) {
                Node fn = n.getFirstChild();
                if (ClosureOptimizePrimitives.this.compiler.getCodingConvention().isPropertyRenameFunction(fn.getOriginalQualifiedName())) {
                    ClosureOptimizePrimitives.this.processRenamePropertyCall(n);
                } else if (fn.matchesQualifiedName("goog$object$create") || fn.matchesQualifiedName("goog.object.create")) {
                    ClosureOptimizePrimitives.this.processObjectCreateCall(n);
                } else if (fn.matchesQualifiedName("goog$object$createSet") || fn.matchesQualifiedName("goog.object.createSet")) {
                    ClosureOptimizePrimitives.this.processObjectCreateSetCall(n);
                }
            }
            ClosureOptimizePrimitives.this.maybeProcessDomTagName(n);
        }
    }
}

