/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ChromePass
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    final AbstractCompiler compiler;
    private final Set<String> createdObjects;
    private static final String CR_DEFINE = "cr.define";
    private static final String CR_EXPORT_PATH = "cr.exportPath";
    private static final String OBJECT_DEFINE_PROPERTY = "Object.defineProperty";
    private static final String CR_DEFINE_PROPERTY = "cr.defineProperty";
    private static final String CR_MAKE_PUBLIC = "cr.makePublic";
    private static final String CR_DEFINE_COMMON_EXPLANATION = "It should be called like this: cr.define('name.space', function() '{ ... return {Export: Internal}; }');";
    static final DiagnosticType CR_DEFINE_WRONG_NUMBER_OF_ARGUMENTS = DiagnosticType.error("JSC_CR_DEFINE_WRONG_NUMBER_OF_ARGUMENTS", "cr.define() should have exactly 2 arguments. It should be called like this: cr.define('name.space', function() '{ ... return {Export: Internal}; }');");
    static final DiagnosticType CR_EXPORT_PATH_TOO_FEW_ARGUMENTS = DiagnosticType.error("JSC_CR_EXPORT_PATH_TOO_FEW_ARGUMENTS", "cr.exportPath() should have at least 1 argument: path name.");
    static final DiagnosticType CR_DEFINE_INVALID_FIRST_ARGUMENT = DiagnosticType.error("JSC_CR_DEFINE_INVALID_FIRST_ARGUMENT", "Invalid first argument for cr.define(). It should be called like this: cr.define('name.space', function() '{ ... return {Export: Internal}; }');");
    static final DiagnosticType CR_DEFINE_INVALID_SECOND_ARGUMENT = DiagnosticType.error("JSC_CR_DEFINE_INVALID_SECOND_ARGUMENT", "Invalid second argument for cr.define(). It should be called like this: cr.define('name.space', function() '{ ... return {Export: Internal}; }');");
    static final DiagnosticType CR_DEFINE_INVALID_RETURN_IN_FUNCTION = DiagnosticType.error("JSC_CR_DEFINE_INVALID_RETURN_IN_SECOND_ARGUMENT", "Function passed as second argument of cr.define() should return the dictionary in its last statement. It should be called like this: cr.define('name.space', function() '{ ... return {Export: Internal}; }');");
    static final DiagnosticType CR_DEFINE_PROPERTY_INVALID_PROPERTY_KIND = DiagnosticType.error("JSC_CR_DEFINE_PROPERTY_INVALID_PROPERTY_KIND", "Invalid cr.PropertyKind passed to cr.defineProperty(): expected ATTR, BOOL_ATTR or JS, found \"{0}\".");
    static final DiagnosticType CR_MAKE_PUBLIC_HAS_NO_JSDOC = DiagnosticType.error("JSC_CR_MAKE_PUBLIC_HAS_NO_JSDOC", "Private method exported by cr.makePublic() has no JSDoc.");
    static final DiagnosticType CR_MAKE_PUBLIC_MISSED_DECLARATION = DiagnosticType.error("JSC_CR_MAKE_PUBLIC_MISSED_DECLARATION", "Method \"{1}_\" exported by cr.makePublic() on \"{0}\" has no declaration.");
    static final DiagnosticType CR_MAKE_PUBLIC_INVALID_SECOND_ARGUMENT = DiagnosticType.error("JSC_CR_MAKE_PUBLIC_INVALID_SECOND_ARGUMENT", "Invalid second argument passed to cr.makePublic(): should be array of strings.");

    public ChromePass(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.createdObjects = new HashSet<String>(Arrays.asList("cr"));
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node node, Node parent) {
        if (node.isCall()) {
            Node callee = node.getFirstChild();
            if (callee.matchesQualifiedName(CR_DEFINE)) {
                this.visitNamespaceDefinition(node, parent);
            } else if (callee.matchesQualifiedName(CR_EXPORT_PATH)) {
                this.visitExportPath(node, parent);
            } else if (callee.matchesQualifiedName(OBJECT_DEFINE_PROPERTY) || callee.matchesQualifiedName(CR_DEFINE_PROPERTY)) {
                this.visitPropertyDefinition(node, parent);
            } else if (callee.matchesQualifiedName(CR_MAKE_PUBLIC)) {
                this.visitMakePublic(node, parent);
            }
        }
    }

    private void visitPropertyDefinition(Node call, Node parent) {
        Node callee = call.getFirstChild();
        String target = call.getSecondChild().getQualifiedName();
        if (callee.matchesQualifiedName(CR_DEFINE_PROPERTY) && !target.endsWith(".prototype")) {
            target = target + ".prototype";
        }
        Node property = call.getChildAtIndex(2);
        Node getPropNode = NodeUtil.newQName(this.compiler, target + "." + property.getString()).srcrefTree(call);
        if (callee.matchesQualifiedName(CR_DEFINE_PROPERTY)) {
            ChromePass.setJsDocWithType(getPropNode, this.getTypeByCrPropertyKind(call.getChildAtIndex(3)));
        } else {
            ChromePass.setJsDocWithType(getPropNode, new Node(Token.QMARK));
        }
        Node definitionNode = IR.exprResult(getPropNode).srcref(parent);
        parent.getParent().addChildAfter(definitionNode, parent);
        this.compiler.reportChangeToEnclosingScope(definitionNode);
    }

    private Node getTypeByCrPropertyKind(Node propertyKind) {
        if (propertyKind == null || propertyKind.matchesQualifiedName("cr.PropertyKind.JS")) {
            return new Node(Token.QMARK);
        }
        if (propertyKind.matchesQualifiedName("cr.PropertyKind.ATTR")) {
            return IR.string("string");
        }
        if (propertyKind.matchesQualifiedName("cr.PropertyKind.BOOL_ATTR")) {
            return IR.string("boolean");
        }
        this.compiler.report(JSError.make(propertyKind, CR_DEFINE_PROPERTY_INVALID_PROPERTY_KIND, propertyKind.getQualifiedName()));
        return null;
    }

    private static void setJsDocWithType(Node target, Node type) {
        JSDocInfoBuilder builder = new JSDocInfoBuilder(false);
        builder.recordType(new JSTypeExpression(type, ""));
        target.setJSDocInfo(builder.build());
    }

    private void visitMakePublic(Node call, Node exprResult) {
        Node scope = exprResult.getParent();
        String className = call.getSecondChild().getQualifiedName();
        String prototype = className + ".prototype";
        Node methods = call.getChildAtIndex(2);
        if (methods == null || !methods.isArrayLit()) {
            this.compiler.report(JSError.make(exprResult, CR_MAKE_PUBLIC_INVALID_SECOND_ARGUMENT, new String[0]));
            return;
        }
        HashSet<String> methodNames = new HashSet<String>();
        for (Node methodName : methods.children()) {
            if (!methodName.isString()) {
                this.compiler.report(JSError.make(methodName, CR_MAKE_PUBLIC_INVALID_SECOND_ARGUMENT, new String[0]));
                return;
            }
            methodNames.add(methodName.getString());
        }
        for (Node child : scope.children()) {
            if (ChromePass.isAssignmentToPrototype(child, prototype)) {
                Node objectLit = child.getFirstChild().getSecondChild();
                for (Node stringKey : objectLit.children()) {
                    String field = stringKey.getString();
                    this.maybeAddPublicDeclaration(field, methodNames, className, stringKey, scope, exprResult);
                }
                continue;
            }
            if (ChromePass.isAssignmentToPrototypeMethod(child, prototype)) {
                Node assignNode = child.getFirstChild();
                String qualifiedName = assignNode.getFirstChild().getQualifiedName();
                String field = qualifiedName.substring(qualifiedName.lastIndexOf(46) + 1);
                this.maybeAddPublicDeclaration(field, methodNames, className, assignNode, scope, exprResult);
                continue;
            }
            if (!ChromePass.isDummyPrototypeMethodDeclaration(child, prototype)) continue;
            String qualifiedName = child.getFirstChild().getQualifiedName();
            String field = qualifiedName.substring(qualifiedName.lastIndexOf(46) + 1);
            this.maybeAddPublicDeclaration(field, methodNames, className, child.getFirstChild(), scope, exprResult);
        }
        for (String missedDeclaration : methodNames) {
            this.compiler.report(JSError.make(exprResult, CR_MAKE_PUBLIC_MISSED_DECLARATION, className, missedDeclaration));
        }
    }

    private static boolean isAssignmentToPrototype(Node node, String prototype) {
        Node assignNode;
        return node.isExprResult() && (assignNode = node.getFirstChild()).isAssign() && assignNode.getFirstChild().matchesQualifiedName(prototype);
    }

    private static boolean isAssignmentToPrototypeMethod(Node node, String prototype) {
        Node assignNode;
        return node.isExprResult() && (assignNode = node.getFirstChild()).isAssign() && assignNode.getFirstChild().getQualifiedName().startsWith(prototype + ".");
    }

    private static boolean isDummyPrototypeMethodDeclaration(Node node, String prototype) {
        Node getPropNode;
        return node.isExprResult() && (getPropNode = node.getFirstChild()).isGetProp() && getPropNode.getQualifiedName().startsWith(prototype + ".");
    }

    private void maybeAddPublicDeclaration(String field, Set<String> publicAPIStrings, String className, Node jsDocSourceNode, Node scope, Node exprResult) {
        String publicName;
        if (field.endsWith("_") && publicAPIStrings.contains(publicName = field.substring(0, field.length() - 1))) {
            Node methodDeclaration = NodeUtil.newQName(this.compiler, className + "." + publicName);
            if (jsDocSourceNode.getJSDocInfo() != null) {
                methodDeclaration.setJSDocInfo(jsDocSourceNode.getJSDocInfo());
                Node publicDeclaration = IR.exprResult(methodDeclaration).srcrefTree(exprResult);
                scope.addChildBefore(publicDeclaration, exprResult);
                this.compiler.reportChangeToEnclosingScope(publicDeclaration);
            } else {
                this.compiler.report(JSError.make(jsDocSourceNode, CR_MAKE_PUBLIC_HAS_NO_JSDOC, new String[0]));
            }
            publicAPIStrings.remove(publicName);
        }
    }

    private void visitExportPath(Node crExportPathNode, Node parent) {
        if (crExportPathNode.getChildCount() < 2) {
            this.compiler.report(JSError.make(crExportPathNode, CR_EXPORT_PATH_TOO_FEW_ARGUMENTS, new String[0]));
            return;
        }
        Node pathArg = crExportPathNode.getSecondChild();
        if (pathArg.isString()) {
            this.createAndInsertObjectsForQualifiedName(parent, pathArg.getString());
        }
    }

    private void createAndInsertObjectsForQualifiedName(Node scriptChild, String namespace) {
        List<Node> objectsForQualifiedName = this.createObjectsForQualifiedName(namespace);
        for (Node n : objectsForQualifiedName) {
            scriptChild.getParent().addChildBefore(n, scriptChild);
        }
        if (!objectsForQualifiedName.isEmpty()) {
            this.compiler.reportChangeToEnclosingScope(scriptChild);
        }
    }

    private void visitNamespaceDefinition(Node crDefineCallNode, Node parent) {
        Node objectLit;
        if (crDefineCallNode.getChildCount() != 3) {
            this.compiler.report(JSError.make(crDefineCallNode, CR_DEFINE_WRONG_NUMBER_OF_ARGUMENTS, new String[0]));
        }
        Node namespaceArg = crDefineCallNode.getSecondChild();
        Node function = crDefineCallNode.getChildAtIndex(2);
        if (!namespaceArg.isString()) {
            this.compiler.report(JSError.make(namespaceArg, CR_DEFINE_INVALID_FIRST_ARGUMENT, new String[0]));
            return;
        }
        String namespace = namespaceArg.getString();
        this.createAndInsertObjectsForQualifiedName(parent, namespace);
        if (!function.isFunction()) {
            this.compiler.report(JSError.make(namespaceArg, CR_DEFINE_INVALID_SECOND_ARGUMENT, new String[0]));
            return;
        }
        Node functionBlock = function.getLastChild();
        Node returnNode = functionBlock.getLastChild();
        if (returnNode == null || !returnNode.isReturn() || (objectLit = returnNode.getFirstChild()) == null || !objectLit.isObjectLit()) {
            this.compiler.report(JSError.make(namespaceArg, CR_DEFINE_INVALID_RETURN_IN_FUNCTION, new String[0]));
            return;
        }
        Map<String, String> exports = ChromePass.objectLitToMap(objectLit);
        NodeTraversal.traverseEs6(this.compiler, functionBlock, new RenameInternalsToExternalsCallback(namespace, exports, functionBlock));
    }

    private static Map<String, String> objectLitToMap(Node objectLit) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (Node keyNode : objectLit.children()) {
            String key = keyNode.getString();
            Node valueNode = keyNode.getFirstChild();
            if (!valueNode.isName()) continue;
            String value = keyNode.getFirstChild().getString();
            res.put(value, key);
        }
        return res;
    }

    private List<Node> createObjectsForQualifiedName(String namespace) {
        ArrayList<Node> objects = new ArrayList<Node>();
        String[] parts = namespace.split("\\.");
        this.createObjectIfNew(objects, parts[0], true);
        if (parts.length >= 2) {
            StringBuilder currPrefix = new StringBuilder().append(parts[0]);
            for (int i = 1; i < parts.length; ++i) {
                currPrefix.append(".").append(parts[i]);
                this.createObjectIfNew(objects, currPrefix.toString(), false);
            }
        }
        return objects;
    }

    private void createObjectIfNew(List<Node> objects, String name, boolean needVar) {
        if (!this.createdObjects.contains(name)) {
            objects.add(this.createJsNode((needVar ? "var " : "") + name + " = " + name + " || {};"));
            this.createdObjects.add(name);
        }
    }

    private Node createJsNode(String code) {
        return this.compiler.parseSyntheticCode(code).removeFirstChild();
    }

    private class RenameInternalsToExternalsCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private final String namespaceName;
        private final Map<String, String> exports;
        private final Node namespaceBlock;

        public RenameInternalsToExternalsCallback(String namespaceName, Map<String, String> exports, Node namespaceBlock) {
            this.namespaceName = namespaceName;
            this.exports = exports;
            this.namespaceBlock = namespaceBlock;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if ((n.isFunction() || n.isClass()) && parent == this.namespaceBlock && this.exports.containsKey(n.getFirstChild().getString())) {
                Node clone = n.cloneTree();
                if (clone.isClass()) {
                    Node className = clone.getFirstChild();
                    className.replaceWith(IR.empty().useSourceInfoFrom(className));
                }
                NodeUtil.markNewScopesChanged(clone, ChromePass.this.compiler);
                Node exprResult = IR.exprResult(IR.assign(this.buildQualifiedName(n.getFirstChild()), clone).srcref(n)).srcref(n);
                if (n.getJSDocInfo() != null) {
                    exprResult.getFirstChild().setJSDocInfo(n.getJSDocInfo());
                    clone.removeProp(29);
                }
                this.namespaceBlock.replaceChild(n, exprResult);
                NodeUtil.markFunctionsDeleted(n, ChromePass.this.compiler);
                ChromePass.this.compiler.reportChangeToEnclosingScope(exprResult);
            } else if (n.isName() && this.exports.containsKey(n.getString()) && !parent.isFunction() && !parent.isClass()) {
                if (parent.isVar()) {
                    if (parent.getParent() == this.namespaceBlock) {
                        Node varContent = n.removeFirstChild();
                        Node exprResult = varContent == null ? IR.exprResult(this.buildQualifiedName(n)).srcref(parent) : IR.exprResult(IR.assign(this.buildQualifiedName(n), varContent).srcref(parent)).srcref(parent);
                        if (parent.getJSDocInfo() != null) {
                            exprResult.getFirstChild().setJSDocInfo(parent.getJSDocInfo().clone());
                        }
                        this.namespaceBlock.replaceChild(parent, exprResult);
                        ChromePass.this.compiler.reportChangeToEnclosingScope(exprResult);
                    }
                } else {
                    Node newNode = this.buildQualifiedName(n);
                    if (n.getJSDocInfo() != null) {
                        newNode.setJSDocInfo(n.getJSDocInfo().clone());
                    }
                    if (parent.isCall()) {
                        parent.putBooleanProp(50, false);
                    }
                    parent.replaceChild(n, newNode);
                    ChromePass.this.compiler.reportChangeToEnclosingScope(newNode);
                }
            }
        }

        private Node buildQualifiedName(Node internalName) {
            String externalName = this.exports.get(internalName.getString());
            return NodeUtil.newQName(ChromePass.this.compiler, this.namespaceName + "." + externalName).srcrefTree(internalName);
        }
    }
}

