/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.grpc;

import com.google.common.base.Preconditions;
import io.opencensus.metrics.LabelKey;
import io.opencensus.metrics.LabelValue;
import io.opencensus.metrics.MetricRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class GcpManagedChannelOptions {
    private static final Logger logger = Logger.getLogger(GcpManagedChannelOptions.class.getName());
    @Nullable
    private final GcpMetricsOptions metricsOptions;
    @Nullable
    private final GcpResiliencyOptions resiliencyOptions;

    public GcpManagedChannelOptions() {
        this.metricsOptions = null;
        this.resiliencyOptions = null;
    }

    public GcpManagedChannelOptions(Builder builder) {
        this.metricsOptions = builder.metricsOptions;
        this.resiliencyOptions = builder.resiliencyOptions;
    }

    @Nullable
    public GcpMetricsOptions getMetricsOptions() {
        return this.metricsOptions;
    }

    @Nullable
    public GcpResiliencyOptions getResiliencyOptions() {
        return this.resiliencyOptions;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(GcpManagedChannelOptions options) {
        return new Builder(options);
    }

    public static class GcpResiliencyOptions {
        private final boolean notReadyFallbackEnabled;
        private final boolean unresponsiveDetectionEnabled;
        private final int unresponsiveDetectionMs;
        private final int unresponsiveDetectionDroppedCount;

        public GcpResiliencyOptions(Builder builder) {
            this.notReadyFallbackEnabled = builder.notReadyFallbackEnabled;
            this.unresponsiveDetectionEnabled = builder.unresponsiveDetectionEnabled;
            this.unresponsiveDetectionMs = builder.unresponsiveDetectionMs;
            this.unresponsiveDetectionDroppedCount = builder.unresponsiveDetectionDroppedCount;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static Builder newBuilder(GcpResiliencyOptions options) {
            return new Builder(options);
        }

        public boolean isNotReadyFallbackEnabled() {
            return this.notReadyFallbackEnabled;
        }

        public boolean isUnresponsiveDetectionEnabled() {
            return this.unresponsiveDetectionEnabled;
        }

        public int getUnresponsiveDetectionMs() {
            return this.unresponsiveDetectionMs;
        }

        public int getUnresponsiveDetectionDroppedCount() {
            return this.unresponsiveDetectionDroppedCount;
        }

        public static class Builder {
            private boolean notReadyFallbackEnabled = false;
            private boolean unresponsiveDetectionEnabled = false;
            private int unresponsiveDetectionMs = 0;
            private int unresponsiveDetectionDroppedCount = 0;

            public Builder() {
            }

            public Builder(GcpResiliencyOptions options) {
                this.notReadyFallbackEnabled = options.isNotReadyFallbackEnabled();
                this.unresponsiveDetectionEnabled = options.isUnresponsiveDetectionEnabled();
                this.unresponsiveDetectionMs = options.getUnresponsiveDetectionMs();
                this.unresponsiveDetectionDroppedCount = options.getUnresponsiveDetectionDroppedCount();
            }

            public GcpResiliencyOptions build() {
                return new GcpResiliencyOptions(this);
            }

            public Builder setNotReadyFallback(boolean enabled) {
                this.notReadyFallbackEnabled = enabled;
                return this;
            }

            public Builder withUnresponsiveConnectionDetection(int ms, int numDroppedRequests) {
                Preconditions.checkArgument((ms > 0 ? 1 : 0) != 0, (String)"ms should be > 0, got %s", (int)ms);
                Preconditions.checkArgument((numDroppedRequests > 0 ? 1 : 0) != 0, (String)"numDroppedRequests should be > 0, got %s", (int)numDroppedRequests);
                this.unresponsiveDetectionEnabled = true;
                this.unresponsiveDetectionMs = ms;
                this.unresponsiveDetectionDroppedCount = numDroppedRequests;
                return this;
            }

            public Builder disableUnresponsiveConnectionDetection() {
                this.unresponsiveDetectionEnabled = false;
                return this;
            }
        }
    }

    public static class GcpMetricsOptions {
        private final MetricRegistry metricRegistry;
        private final List<LabelKey> labelKeys;
        private final List<LabelValue> labelValues;
        private final String namePrefix;

        public GcpMetricsOptions(Builder builder) {
            this.metricRegistry = builder.metricRegistry;
            this.labelKeys = builder.labelKeys;
            this.labelValues = builder.labelValues;
            this.namePrefix = builder.namePrefix;
        }

        public MetricRegistry getMetricRegistry() {
            return this.metricRegistry;
        }

        public List<LabelKey> getLabelKeys() {
            return this.labelKeys;
        }

        public List<LabelValue> getLabelValues() {
            return this.labelValues;
        }

        public String getNamePrefix() {
            return this.namePrefix;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static Builder newBuilder(GcpMetricsOptions options) {
            return new Builder(options);
        }

        public static class Builder {
            private MetricRegistry metricRegistry;
            private List<LabelKey> labelKeys = new ArrayList<LabelKey>();
            private List<LabelValue> labelValues = new ArrayList<LabelValue>();
            private String namePrefix = "";

            public Builder() {
            }

            public Builder(GcpMetricsOptions options) {
                this();
                if (options == null) {
                    return;
                }
                this.metricRegistry = options.getMetricRegistry();
                this.labelKeys = options.getLabelKeys();
                this.labelValues = options.getLabelValues();
                this.namePrefix = options.getNamePrefix();
            }

            public GcpMetricsOptions build() {
                return new GcpMetricsOptions(this);
            }

            public Builder withMetricRegistry(MetricRegistry registry) {
                this.metricRegistry = registry;
                return this;
            }

            public Builder withLabels(List<LabelKey> labelKeys, List<LabelValue> labelValues) {
                if (labelKeys == null || labelValues == null || labelKeys.size() != labelValues.size()) {
                    logger.warning("Unable to set label keys and values - size mismatch or null.");
                    return this;
                }
                this.labelKeys = labelKeys;
                this.labelValues = labelValues;
                return this;
            }

            public Builder withNamePrefix(String namePrefix) {
                this.namePrefix = namePrefix;
                return this;
            }
        }
    }

    public static class Builder {
        private GcpMetricsOptions metricsOptions;
        private GcpResiliencyOptions resiliencyOptions;

        public Builder() {
        }

        public Builder(GcpManagedChannelOptions options) {
            this.metricsOptions = options.getMetricsOptions();
            this.resiliencyOptions = options.getResiliencyOptions();
        }

        public GcpManagedChannelOptions build() {
            return new GcpManagedChannelOptions(this);
        }

        public Builder withMetricsOptions(GcpMetricsOptions metricsOptions) {
            this.metricsOptions = metricsOptions;
            return this;
        }

        public Builder withResiliencyOptions(GcpResiliencyOptions resiliencyOptions) {
            this.resiliencyOptions = resiliencyOptions;
            return this;
        }
    }
}

