/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.threeten.bp.Duration;

public class SessionPoolOptions {
    private static final int DEFAULT_MAX_SESSIONS = 400;
    private static final int DEFAULT_MIN_SESSIONS = 100;
    private static final int DEFAULT_INC_STEP = 25;
    private static final ActionOnExhaustion DEFAULT_ACTION = ActionOnExhaustion.BLOCK;
    private final int minSessions;
    private final int maxSessions;
    private final int incStep;
    @Deprecated
    private final int maxIdleSessions;
    @Deprecated
    private final float writeSessionsFraction;
    private final ActionOnExhaustion actionOnExhaustion;
    private final long loopFrequency;
    private final int keepAliveIntervalMinutes;
    private final Duration removeInactiveSessionAfter;
    private final ActionOnSessionNotFound actionOnSessionNotFound;
    private final ActionOnSessionLeak actionOnSessionLeak;
    private final long initialWaitForSessionTimeoutMillis;

    private SessionPoolOptions(Builder builder) {
        this.minSessions = Math.min(builder.minSessions, builder.maxSessions);
        this.maxSessions = builder.maxSessions;
        this.incStep = builder.incStep;
        this.maxIdleSessions = builder.maxIdleSessions;
        this.writeSessionsFraction = builder.writeSessionsFraction;
        this.actionOnExhaustion = builder.actionOnExhaustion;
        this.actionOnSessionNotFound = builder.actionOnSessionNotFound;
        this.actionOnSessionLeak = builder.actionOnSessionLeak;
        this.initialWaitForSessionTimeoutMillis = builder.initialWaitForSessionTimeoutMillis;
        this.loopFrequency = builder.loopFrequency;
        this.keepAliveIntervalMinutes = builder.keepAliveIntervalMinutes;
        this.removeInactiveSessionAfter = builder.removeInactiveSessionAfter;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SessionPoolOptions)) {
            return false;
        }
        SessionPoolOptions other = (SessionPoolOptions)o;
        return Objects.equals(this.minSessions, other.minSessions) && Objects.equals(this.maxSessions, other.maxSessions) && Objects.equals(this.incStep, other.incStep) && Objects.equals(this.maxIdleSessions, other.maxIdleSessions) && Objects.equals(Float.valueOf(this.writeSessionsFraction), Float.valueOf(other.writeSessionsFraction)) && Objects.equals((Object)this.actionOnExhaustion, (Object)other.actionOnExhaustion) && Objects.equals((Object)this.actionOnSessionNotFound, (Object)other.actionOnSessionNotFound) && Objects.equals((Object)this.actionOnSessionLeak, (Object)other.actionOnSessionLeak) && Objects.equals(this.initialWaitForSessionTimeoutMillis, other.initialWaitForSessionTimeoutMillis) && Objects.equals(this.loopFrequency, other.loopFrequency) && Objects.equals(this.keepAliveIntervalMinutes, other.keepAliveIntervalMinutes) && Objects.equals(this.removeInactiveSessionAfter, other.removeInactiveSessionAfter);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.minSessions, this.maxSessions, this.incStep, this.maxIdleSessions, Float.valueOf(this.writeSessionsFraction), this.actionOnExhaustion, this.actionOnSessionNotFound, this.actionOnSessionLeak, this.initialWaitForSessionTimeoutMillis, this.loopFrequency, this.keepAliveIntervalMinutes, this.removeInactiveSessionAfter});
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public int getMinSessions() {
        return this.minSessions;
    }

    public int getMaxSessions() {
        return this.maxSessions;
    }

    int getIncStep() {
        return this.incStep;
    }

    @Deprecated
    public int getMaxIdleSessions() {
        return this.maxIdleSessions;
    }

    @Deprecated
    public float getWriteSessionsFraction() {
        return this.writeSessionsFraction;
    }

    long getLoopFrequency() {
        return this.loopFrequency;
    }

    public int getKeepAliveIntervalMinutes() {
        return this.keepAliveIntervalMinutes;
    }

    public Duration getRemoveInactiveSessionAfter() {
        return this.removeInactiveSessionAfter;
    }

    public boolean isFailIfPoolExhausted() {
        return this.actionOnExhaustion == ActionOnExhaustion.FAIL;
    }

    public boolean isBlockIfPoolExhausted() {
        return this.actionOnExhaustion == ActionOnExhaustion.BLOCK;
    }

    @VisibleForTesting
    long getInitialWaitForSessionTimeoutMillis() {
        return this.initialWaitForSessionTimeoutMillis;
    }

    @VisibleForTesting
    boolean isFailIfSessionNotFound() {
        return this.actionOnSessionNotFound == ActionOnSessionNotFound.FAIL;
    }

    @VisibleForTesting
    boolean isFailOnSessionLeak() {
        return this.actionOnSessionLeak == ActionOnSessionLeak.FAIL;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static /* synthetic */ ActionOnExhaustion access$1300() {
        return DEFAULT_ACTION;
    }

    public static class Builder {
        private boolean minSessionsSet = false;
        private int minSessions = 100;
        private int maxSessions = 400;
        private int incStep = 25;
        @Deprecated
        private int maxIdleSessions;
        @Deprecated
        private float writeSessionsFraction = 0.2f;
        private ActionOnExhaustion actionOnExhaustion = SessionPoolOptions.access$1300();
        private long initialWaitForSessionTimeoutMillis = 30000L;
        private ActionOnSessionNotFound actionOnSessionNotFound = ActionOnSessionNotFound.RETRY;
        private ActionOnSessionLeak actionOnSessionLeak = ActionOnSessionLeak.WARN;
        private long loopFrequency = 10000L;
        private int keepAliveIntervalMinutes = 30;
        private Duration removeInactiveSessionAfter = Duration.ofMinutes((long)55L);

        public Builder() {
        }

        private Builder(SessionPoolOptions options) {
            this.minSessionsSet = true;
            this.minSessions = options.minSessions;
            this.maxSessions = options.maxSessions;
            this.incStep = options.incStep;
            this.maxIdleSessions = options.maxIdleSessions;
            this.writeSessionsFraction = options.writeSessionsFraction;
            this.actionOnExhaustion = options.actionOnExhaustion;
            this.initialWaitForSessionTimeoutMillis = options.initialWaitForSessionTimeoutMillis;
            this.actionOnSessionNotFound = options.actionOnSessionNotFound;
            this.actionOnSessionLeak = options.actionOnSessionLeak;
            this.loopFrequency = options.loopFrequency;
            this.keepAliveIntervalMinutes = options.keepAliveIntervalMinutes;
            this.removeInactiveSessionAfter = options.removeInactiveSessionAfter;
        }

        public Builder setMinSessions(int minSessions) {
            Preconditions.checkArgument((minSessions >= 0 ? 1 : 0) != 0, (Object)"minSessions must be >= 0");
            this.minSessionsSet = true;
            this.minSessions = minSessions;
            return this;
        }

        public Builder setMaxSessions(int maxSessions) {
            Preconditions.checkArgument((maxSessions > 0 ? 1 : 0) != 0, (Object)"maxSessions must be > 0");
            this.maxSessions = maxSessions;
            return this;
        }

        Builder setIncStep(int incStep) {
            Preconditions.checkArgument((incStep > 0 ? 1 : 0) != 0, (Object)"incStep must be > 0");
            this.incStep = incStep;
            return this;
        }

        @Deprecated
        public Builder setMaxIdleSessions(int maxIdleSessions) {
            this.maxIdleSessions = maxIdleSessions;
            return this;
        }

        Builder setLoopFrequency(long loopFrequency) {
            this.loopFrequency = loopFrequency;
            return this;
        }

        public Builder setRemoveInactiveSessionAfter(Duration duration) {
            this.removeInactiveSessionAfter = duration;
            return this;
        }

        public Builder setKeepAliveIntervalMinutes(int intervalMinutes) {
            this.keepAliveIntervalMinutes = intervalMinutes;
            return this;
        }

        public Builder setFailIfPoolExhausted() {
            this.actionOnExhaustion = ActionOnExhaustion.FAIL;
            return this;
        }

        public Builder setBlockIfPoolExhausted() {
            this.actionOnExhaustion = ActionOnExhaustion.BLOCK;
            return this;
        }

        @VisibleForTesting
        Builder setInitialWaitForSessionTimeoutMillis(long timeout) {
            this.initialWaitForSessionTimeoutMillis = timeout;
            return this;
        }

        @VisibleForTesting
        Builder setFailIfSessionNotFound() {
            this.actionOnSessionNotFound = ActionOnSessionNotFound.FAIL;
            return this;
        }

        @VisibleForTesting
        Builder setFailOnSessionLeak() {
            this.actionOnSessionLeak = ActionOnSessionLeak.FAIL;
            return this;
        }

        public Builder setWriteSessionsFraction(float writeSessionsFraction) {
            this.writeSessionsFraction = writeSessionsFraction;
            return this;
        }

        public SessionPoolOptions build() {
            this.validate();
            return new SessionPoolOptions(this);
        }

        private void validate() {
            if (this.minSessionsSet) {
                Preconditions.checkArgument((this.maxSessions >= this.minSessions ? 1 : 0) != 0, (String)"Min sessions(%s) must be <= max sessions(%s)", (int)this.minSessions, (int)this.maxSessions);
            }
            Preconditions.checkArgument((this.keepAliveIntervalMinutes < 60 ? 1 : 0) != 0, (Object)"Keep alive interval should be less than60 minutes");
        }
    }

    private static enum ActionOnSessionLeak {
        WARN,
        FAIL;

    }

    private static enum ActionOnSessionNotFound {
        RETRY,
        FAIL;

    }

    private static enum ActionOnExhaustion {
        BLOCK,
        FAIL;

    }
}

