/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.ObjectParser;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallOptions;
import com.google.api.gax.httpjson.HttpJsonHeaderEnhancer;
import com.google.api.gax.httpjson.HttpJsonStatusCode;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class HttpRequestRunnable<RequestT, ResponseT>
implements Runnable {
    private final HttpJsonCallOptions callOptions;
    private final RequestT request;
    private final ApiMethodDescriptor<RequestT, ResponseT> methodDescriptor;
    private final HttpTransport httpTransport;
    private final String endpoint;
    private final JsonFactory jsonFactory;
    private final ImmutableList<HttpJsonHeaderEnhancer> headerEnhancers;
    private final SettableApiFuture<ResponseT> responseFuture;

    private HttpRequestRunnable(HttpJsonCallOptions callOptions, RequestT request, ApiMethodDescriptor<RequestT, ResponseT> methodDescriptor, HttpTransport httpTransport, String endpoint, JsonFactory jsonFactory, List<HttpJsonHeaderEnhancer> headerEnhancers, SettableApiFuture<ResponseT> responseFuture) {
        this.endpoint = endpoint;
        this.jsonFactory = jsonFactory;
        this.headerEnhancers = ImmutableList.copyOf(headerEnhancers);
        this.callOptions = callOptions;
        this.request = request;
        this.methodDescriptor = methodDescriptor;
        this.httpTransport = httpTransport;
        this.responseFuture = responseFuture;
    }

    HttpRequest createHttpRequest() throws IOException {
        GenericData tokenRequest = new GenericData();
        HttpRequestFormatter<RequestT> requestFormatter = this.methodDescriptor.getRequestFormatter();
        Credentials credentials = this.callOptions.getCredentials();
        HttpRequestFactory requestFactory = credentials != null ? this.httpTransport.createRequestFactory((HttpRequestInitializer)new HttpCredentialsAdapter(credentials)) : this.httpTransport.createRequestFactory();
        String requestBody = requestFormatter.getRequestBody(this.request);
        JsonHttpContent jsonHttpContent = null;
        if (!Strings.isNullOrEmpty((String)requestBody)) {
            this.jsonFactory.createJsonParser(requestBody).parse((Object)tokenRequest);
            jsonHttpContent = new JsonHttpContent(this.jsonFactory, (Object)tokenRequest).setMediaType(new HttpMediaType("application/json"));
        }
        GenericUrl url = new GenericUrl(this.endpoint + requestFormatter.getPath(this.request));
        Map<String, List<String>> queryParams = requestFormatter.getQueryParamNames(this.request);
        for (Map.Entry<String, List<String>> queryParam : queryParams.entrySet()) {
            if (queryParam.getValue() == null) continue;
            url.set(queryParam.getKey(), queryParam.getValue());
        }
        HttpRequest httpRequest = requestFactory.buildRequest(this.methodDescriptor.getHttpMethod(), url, (HttpContent)jsonHttpContent);
        for (HttpJsonHeaderEnhancer enhancer : this.headerEnhancers) {
            enhancer.enhance(httpRequest.getHeaders());
        }
        httpRequest.setParser((ObjectParser)new JsonObjectParser(this.jsonFactory));
        return httpRequest;
    }

    @Override
    public void run() {
        try {
            HttpRequest httpRequest = this.createHttpRequest();
            HttpResponse httpResponse = httpRequest.execute();
            if (!httpResponse.isSuccessStatusCode()) {
                ApiExceptionFactory.createException(null, (StatusCode)HttpJsonStatusCode.of(httpResponse.getStatusCode(), httpResponse.getStatusMessage()), (boolean)false);
            }
            if (this.methodDescriptor.getResponseParser() != null) {
                ResponseT response = this.methodDescriptor.getResponseParser().parse(httpResponse.getContent());
                this.responseFuture.set(response);
            } else {
                this.responseFuture.set(null);
            }
        }
        catch (Exception e) {
            this.responseFuture.setException((Throwable)e);
        }
    }

    static <RequestT, ResponseT> Builder<RequestT, ResponseT> newBuilder() {
        return new Builder().setHeaderEnhancers(new LinkedList<HttpJsonHeaderEnhancer>());
    }

    static class Builder<RequestT, ResponseT> {
        private HttpJsonCallOptions callOptions;
        private RequestT request;
        private ApiMethodDescriptor<RequestT, ResponseT> methodDescriptor;
        private HttpTransport httpTransport;
        private String endpoint;
        private JsonFactory jsonFactory;
        private List<HttpJsonHeaderEnhancer> headerEnhancers;
        private SettableApiFuture<ResponseT> responseFuture;

        private Builder() {
        }

        Builder<RequestT, ResponseT> setHttpJsonCallOptions(HttpJsonCallOptions callOptions) {
            this.callOptions = callOptions;
            return this;
        }

        Builder<RequestT, ResponseT> setRequest(RequestT request) {
            this.request = request;
            return this;
        }

        Builder<RequestT, ResponseT> setApiMethodDescriptor(ApiMethodDescriptor<RequestT, ResponseT> methodDescriptor) {
            this.methodDescriptor = methodDescriptor;
            return this;
        }

        Builder<RequestT, ResponseT> setHttpTransport(HttpTransport httpTransport) {
            this.httpTransport = httpTransport;
            return this;
        }

        Builder<RequestT, ResponseT> setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        Builder<RequestT, ResponseT> setJsonFactory(JsonFactory jsonFactory) {
            this.jsonFactory = jsonFactory;
            return this;
        }

        Builder<RequestT, ResponseT> setHeaderEnhancers(List<HttpJsonHeaderEnhancer> headerEnhancers) {
            this.headerEnhancers = headerEnhancers;
            return this;
        }

        Builder<RequestT, ResponseT> setApiFuture(SettableApiFuture<ResponseT> responseFuture) {
            this.responseFuture = responseFuture;
            return this;
        }

        HttpRequestRunnable<RequestT, ResponseT> build() {
            return new HttpRequestRunnable(this.callOptions, this.request, this.methodDescriptor, this.httpTransport, this.endpoint, this.jsonFactory, this.headerEnhancers, this.responseFuture);
        }
    }
}

