/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.util;

import com.google.common.base.CharMatcher;
import java.util.regex.PatternSyntaxException;
import org.springframework.web.bind.annotation.RequestMapping;

public class SprintUtils {
    public static String createResourceKey(String resourceName, String version) {
        String resourceKey = version.length() > 0 ? resourceName + "." + version : resourceName;
        resourceKey = CharMatcher.anyOf((CharSequence)"%^#?:;").removeFrom((CharSequence)resourceKey);
        return resourceKey;
    }

    public static String parseResourceName(String mapping) {
        String resourceName = mapping;
        if (!SprintUtils.parseVersion(mapping).equals("") && resourceName.contains(SprintUtils.parseVersion(mapping))) {
            try {
                resourceName = mapping.replaceFirst(SprintUtils.parseVersion(mapping), "");
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        while (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        }
        if (resourceName.contains("/")) {
            resourceName = resourceName.substring(0, resourceName.indexOf("/"));
        }
        if (resourceName.contains("{")) {
            resourceName = "";
        }
        return resourceName;
    }

    public static String parseResourceName(Class<?> clazz) {
        String fullPath = clazz.getAnnotation(RequestMapping.class).value()[0];
        String resource = "";
        try {
            resource = fullPath.endsWith("/") ? fullPath.substring(0, fullPath.length() - 1) : fullPath;
            resource = resource.substring(resource.lastIndexOf("/"), resource.length());
            resource = resource.replaceAll("/", "");
            if (resource.equals(SprintUtils.parseVersion(fullPath))) {
                return "";
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        return resource;
    }

    public static String parseVersion(String mapping) {
        String[] mappingArray;
        String version = "";
        block0: for (String str : mappingArray = mapping.split("/")) {
            if (str.length() >= 4) continue;
            for (char c : str.toCharArray()) {
                if (!Character.isDigit(c)) continue;
                version = str;
                continue block0;
            }
        }
        return version;
    }
}

