/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.spring;

import com.wordnik.swagger.converter.ModelConverters;
import com.wordnik.swagger.jaxrs.ext.AbstractSwaggerExtension;
import com.wordnik.swagger.jaxrs.ext.SwaggerExtension;
import com.wordnik.swagger.models.parameters.CookieParameter;
import com.wordnik.swagger.models.parameters.HeaderParameter;
import com.wordnik.swagger.models.parameters.Parameter;
import com.wordnik.swagger.models.parameters.PathParameter;
import com.wordnik.swagger.models.parameters.QueryParameter;
import com.wordnik.swagger.models.properties.Property;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

public class SpringSwaggerExtension
extends AbstractSwaggerExtension
implements SwaggerExtension {
    public List<Parameter> extractParameters(Annotation[] annotations, Class<?> cls, boolean isArray, Set<Class<?>> classesToSkip, Iterator<SwaggerExtension> chain) {
        String defaultValue = "";
        if (this.shouldIgnoreClass(cls)) {
            return new ArrayList<Parameter>();
        }
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        QueryParameter parameter = null;
        for (Annotation annotation : annotations) {
            Property schema;
            RequestParam param;
            if (annotation instanceof RequestParam) {
                param = (RequestParam)annotation;
                QueryParameter qp = new QueryParameter().name(param.value());
                if (!defaultValue.isEmpty()) {
                    qp.setDefaultValue(defaultValue);
                }
                if ((schema = ModelConverters.getInstance().readAsProperty(cls)) != null) {
                    qp.setProperty(schema);
                }
                parameter = qp;
                continue;
            }
            if (annotation instanceof PathVariable) {
                param = (PathVariable)annotation;
                PathParameter pp = new PathParameter().name(param.value());
                if (!defaultValue.isEmpty()) {
                    pp.setDefaultValue(defaultValue);
                }
                if ((schema = ModelConverters.getInstance().readAsProperty(cls)) != null) {
                    pp.setProperty(schema);
                }
                parameter = pp;
                continue;
            }
            if (annotation instanceof RequestHeader) {
                param = (RequestHeader)annotation;
                HeaderParameter hp = new HeaderParameter().name(param.value());
                hp.setDefaultValue(defaultValue);
                schema = ModelConverters.getInstance().readAsProperty(cls);
                if (schema != null) {
                    hp.setProperty(schema);
                }
                parameter = hp;
                continue;
            }
            if (!(annotation instanceof CookieValue)) continue;
            param = (CookieValue)annotation;
            CookieParameter cp = new CookieParameter().name(param.value());
            if (!defaultValue.isEmpty()) {
                cp.setDefaultValue(defaultValue);
            }
            if ((schema = ModelConverters.getInstance().readAsProperty(cls)) != null) {
                cp.setProperty(schema);
            }
            parameter = cp;
        }
        if (parameter != null) {
            parameters.add((Parameter)parameter);
        }
        return parameters;
    }

    public boolean shouldIgnoreClass(Class<?> cls) {
        boolean output = false;
        output = cls.getName().startsWith("org.springframework");
        return output;
    }
}

