/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.reader;

import com.github.kongchen.swagger.docgen.LogAdapter;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import com.wordnik.swagger.annotations.Authorization;
import com.wordnik.swagger.annotations.AuthorizationScope;
import com.wordnik.swagger.annotations.ResponseHeader;
import com.wordnik.swagger.converter.ModelConverters;
import com.wordnik.swagger.jaxrs.ParameterProcessor;
import com.wordnik.swagger.jaxrs.ext.SwaggerExtension;
import com.wordnik.swagger.jaxrs.ext.SwaggerExtensions;
import com.wordnik.swagger.jaxrs.utils.ParameterUtils;
import com.wordnik.swagger.models.Model;
import com.wordnik.swagger.models.Operation;
import com.wordnik.swagger.models.Path;
import com.wordnik.swagger.models.Response;
import com.wordnik.swagger.models.Scheme;
import com.wordnik.swagger.models.SecurityRequirement;
import com.wordnik.swagger.models.Swagger;
import com.wordnik.swagger.models.Tag;
import com.wordnik.swagger.models.parameters.Parameter;
import com.wordnik.swagger.models.properties.ArrayProperty;
import com.wordnik.swagger.models.properties.MapProperty;
import com.wordnik.swagger.models.properties.Property;
import com.wordnik.swagger.models.properties.RefProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AbstractReader {
    protected final LogAdapter LOG;
    protected Swagger swagger;

    public AbstractReader(Swagger swagger, LogAdapter LOG) {
        this.swagger = swagger;
        this.LOG = LOG;
    }

    protected List<SecurityRequirement> getSecurityRequirements(Api api) {
        int position = api.position();
        String produces = api.produces();
        String consumes = api.consumes();
        String schems = api.protocols();
        Authorization[] authorizations = api.authorizations();
        ArrayList<SecurityRequirement> securities = new ArrayList<SecurityRequirement>();
        for (Authorization auth : authorizations) {
            AuthorizationScope[] scopes;
            if (auth.value() == null || "".equals(auth.value())) continue;
            SecurityRequirement security = new SecurityRequirement();
            security.setName(auth.value());
            for (AuthorizationScope scope : scopes = auth.scopes()) {
                if (scope.scope() == null || "".equals(scope.scope())) continue;
                security.addScope(scope.scope());
            }
            securities.add(security);
        }
        return securities;
    }

    protected String parseOperationPath(String operationPath, Map<String, String> regexMap) {
        String[] pps = operationPath.split("/");
        String[] pathParts = new String[pps.length];
        for (int i = 0; i < pps.length; ++i) {
            String p = pps[i];
            if (p.startsWith("{")) {
                int pos = p.indexOf(":");
                if (pos > 0) {
                    String left = p.substring(1, pos);
                    String right = p.substring(pos + 1, p.length() - 1);
                    pathParts[i] = "{" + left + "}";
                    regexMap.put(left, right);
                    continue;
                }
                pathParts[i] = p;
                continue;
            }
            pathParts[i] = p;
        }
        StringBuilder pathBuilder = new StringBuilder();
        for (String p : pathParts) {
            if (p.isEmpty()) continue;
            pathBuilder.append("/").append(p);
        }
        operationPath = pathBuilder.toString();
        return operationPath;
    }

    protected void updateOperationParameters(List<Parameter> parentParameters, Map<String, String> regexMap, Operation operation) {
        if (parentParameters != null) {
            for (Parameter param : parentParameters) {
                operation.parameter(param);
            }
        }
        for (Parameter param : operation.getParameters()) {
            if (regexMap.get(param.getName()) == null) continue;
            String pattern = regexMap.get(param.getName());
            param.setPattern(pattern);
        }
    }

    protected Map<String, Property> parseResponseHeaders(ResponseHeader[] headers) {
        HashMap<String, ArrayProperty> responseHeaders = null;
        if (headers != null && headers.length > 0) {
            for (ResponseHeader header : headers) {
                String name = header.name();
                if ("".equals(name)) continue;
                if (responseHeaders == null) {
                    responseHeaders = new HashMap<String, ArrayProperty>();
                }
                String description = header.description();
                Class cls = header.response();
                String container = header.responseContainer();
                if (cls.equals(Void.class) || "void".equals(cls.toString())) continue;
                Object responseProperty = null;
                Property property = ModelConverters.getInstance().readAsProperty((Type)cls);
                if (property == null) continue;
                responseProperty = "list".equalsIgnoreCase(container) ? new ArrayProperty(property) : ("map".equalsIgnoreCase(container) ? new MapProperty(property) : property);
                responseProperty.setDescription(description);
                responseHeaders.put(name, (ArrayProperty)responseProperty);
            }
        }
        return responseHeaders;
    }

    protected void updatePath(String operationPath, String httpMethod, Operation operation) {
        if (httpMethod == null) {
            return;
        }
        Path path = this.swagger.getPath(operationPath);
        if (path == null) {
            path = new Path();
            this.swagger.path(operationPath, path);
        }
        path.set(httpMethod, operation);
    }

    protected void updateTagsForOperation(Operation operation, ApiOperation op) {
        if (op != null) {
            boolean hasExplicitTag = false;
            for (String tag : op.tags()) {
                if ("".equals(tag)) continue;
                operation.tag(tag);
                this.swagger.tag(new Tag().name(tag));
            }
        }
    }

    protected boolean canReadApi(boolean readHidden, Api api) {
        return api != null && readHidden || api != null && !api.hidden();
    }

    protected Set<String> extractTags(Api api) {
        String tagString;
        LinkedHashSet<String> output = new LinkedHashSet<String>();
        boolean hasExplicitTags = false;
        for (String tag : api.tags()) {
            if ("".equals(tag)) continue;
            hasExplicitTags = true;
            output.add(tag);
        }
        if (!hasExplicitTags && !"".equals(tagString = api.value().replace("/", ""))) {
            output.add(tagString);
        }
        return output;
    }

    protected void updateOperationProtocols(ApiOperation apiOperation, Operation operation) {
        String protocols = apiOperation.protocols();
        if (!"".equals(protocols)) {
            String[] parts;
            for (String part : parts = protocols.split(",")) {
                String trimmed = part.trim();
                if ("".equals(trimmed)) continue;
                operation.scheme(Scheme.forValue((String)trimmed));
            }
        }
    }

    protected Map<String, Tag> updateTagsForApi(Map<String, Tag> parentTags, Api api) {
        Set<String> tagStrings = this.extractTags(api);
        HashMap<String, Tag> tags = new HashMap<String, Tag>();
        for (String tagString : tagStrings) {
            Tag tag = new Tag().name(tagString);
            tags.put(tagString, tag);
        }
        if (parentTags != null) {
            tags.putAll(parentTags);
        }
        for (String tagName : tags.keySet()) {
            this.swagger.tag((Tag)tags.get(tagName));
        }
        return tags;
    }

    boolean isPrimitive(Class<?> cls) {
        boolean out = false;
        Property property = ModelConverters.getInstance().readAsProperty(cls);
        if (property == null) {
            out = false;
        } else if ("integer".equals(property.getType())) {
            out = true;
        } else if ("string".equals(property.getType())) {
            out = true;
        } else if ("number".equals(property.getType())) {
            out = true;
        } else if ("boolean".equals(property.getType())) {
            out = true;
        } else if ("array".equals(property.getType())) {
            out = true;
        } else if ("file".equals(property.getType())) {
            out = true;
        }
        return out;
    }

    protected void updateOperation(String[] apiConsumes, String[] apiProduces, Map<String, Tag> tags, List<SecurityRequirement> securities, Operation operation) {
        if (operation == null) {
            return;
        }
        if (operation.getConsumes() == null) {
            for (String mediaType : apiConsumes) {
                operation.consumes(mediaType);
            }
        }
        if (operation.getProduces() == null) {
            for (String mediaType : apiProduces) {
                operation.produces(mediaType);
            }
        }
        if (operation.getTags() == null) {
            for (String tagString : tags.keySet()) {
                operation.tag(tagString);
            }
        }
        for (SecurityRequirement security : securities) {
            operation.security(security);
        }
    }

    protected List<Parameter> getParameters(Class<?> cls, Type type, Annotation[] annotations) {
        boolean isArray = ParameterUtils.isMethodArgumentAnArray(cls, (Type)type);
        Iterator chain = SwaggerExtensions.chain();
        List parameters = null;
        this.LOG.info("getParameters for " + cls);
        HashSet classesToSkip = new HashSet();
        if (chain.hasNext()) {
            SwaggerExtension extension = (SwaggerExtension)chain.next();
            this.LOG.info("trying extension " + extension);
            parameters = extension.extractParameters(annotations, cls, isArray, classesToSkip, chain);
        }
        if (parameters.size() > 0) {
            for (Parameter parameter : parameters) {
                ParameterProcessor.applyAnnotations((Swagger)this.swagger, (Parameter)parameter, cls, (Annotation[])annotations, (boolean)isArray);
            }
        } else {
            this.LOG.info("no parameter found, looking at body params");
            if (!classesToSkip.contains(cls)) {
                if (type instanceof ParameterizedType) {
                    Parameter param;
                    ParameterizedType ti = (ParameterizedType)type;
                    Type innerType = ti.getActualTypeArguments()[0];
                    if (innerType instanceof Class && (param = ParameterProcessor.applyAnnotations((Swagger)this.swagger, null, (Class)((Class)innerType), (Annotation[])annotations, (boolean)isArray)) != null) {
                        parameters.add(param);
                    }
                } else {
                    Parameter param = ParameterProcessor.applyAnnotations((Swagger)this.swagger, null, cls, (Annotation[])annotations, (boolean)isArray);
                    if (param != null) {
                        parameters.add(param);
                    }
                }
            }
        }
        return parameters;
    }

    protected void updateApiResponse(Operation operation, ApiResponses responseAnnotation) {
        for (ApiResponse apiResponse : responseAnnotation.value()) {
            Map<String, Property> responseHeaders = this.parseResponseHeaders(apiResponse.responseHeaders());
            Response response = new Response().description(apiResponse.message()).headers(responseHeaders);
            if (apiResponse.code() == 0) {
                operation.defaultResponse(response);
            } else {
                operation.response(apiResponse.code(), response);
            }
            Class responseClass = apiResponse.response();
            if (responseClass == null || responseClass.equals(Void.class)) continue;
            Map models = ModelConverters.getInstance().read((Type)responseClass);
            for (String key : models.keySet()) {
                response.schema((Property)new RefProperty().asDefault(key));
                this.swagger.model(key, (Model)models.get(key));
            }
            models = ModelConverters.getInstance().readAll((Type)responseClass);
            for (String key : models.keySet()) {
                this.swagger.model(key, (Model)models.get(key));
            }
        }
    }

    protected String[] updateOperationProduces(String[] parentProduces, String[] apiProduces, Operation operation) {
        if (parentProduces != null) {
            HashSet<String> both = new HashSet<String>(Arrays.asList(apiProduces));
            both.addAll(new HashSet<String>(Arrays.asList(parentProduces)));
            if (operation.getProduces() != null) {
                both.addAll(new HashSet(operation.getProduces()));
            }
            apiProduces = both.toArray(new String[both.size()]);
        }
        return apiProduces;
    }

    protected String[] updateOperationConsumes(String[] parentConsumes, String[] apiConsumes, Operation operation) {
        if (parentConsumes != null) {
            HashSet<String> both = new HashSet<String>(Arrays.asList(apiConsumes));
            both.addAll(new HashSet<String>(Arrays.asList(parentConsumes)));
            if (operation.getConsumes() != null) {
                both.addAll(new HashSet(operation.getConsumes()));
            }
            apiConsumes = both.toArray(new String[both.size()]);
        }
        return apiConsumes;
    }
}

