/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.mavenplugin;

import com.github.kongchen.swagger.docgen.AbstractDocumentSource;
import com.github.kongchen.swagger.docgen.GenerateException;
import com.github.kongchen.swagger.docgen.LogAdapter;
import com.github.kongchen.swagger.docgen.mavenplugin.ApiSource;
import com.github.kongchen.swagger.docgen.reader.SpringMvcApiReader;
import com.wordnik.swagger.config.FilterFactory;
import com.wordnik.swagger.core.filter.SpecFilter;
import com.wordnik.swagger.core.filter.SwaggerSpecFilter;
import java.util.HashMap;
import org.apache.maven.plugin.logging.Log;

public class SpringMavenDocumentSource
extends AbstractDocumentSource {
    private final SpecFilter specFilter = new SpecFilter();

    public SpringMavenDocumentSource(ApiSource apiSource, Log log) {
        super(new LogAdapter(log), apiSource);
    }

    @Override
    public void loadDocuments() throws GenerateException {
        if (this.apiSource.getSwaggerInternalFilter() != null) {
            try {
                this.LOG.info("Setting filter configuration: " + this.apiSource.getSwaggerInternalFilter());
                FilterFactory.setFilter((SwaggerSpecFilter)((SwaggerSpecFilter)Class.forName(this.apiSource.getSwaggerInternalFilter()).newInstance()));
            }
            catch (Exception e) {
                throw new GenerateException("Cannot load: " + this.apiSource.getSwaggerInternalFilter(), e);
            }
        }
        this.swagger = new SpringMvcApiReader(this.swagger, this.LOG).read(this.apiSource.getValidClasses());
        if (FilterFactory.getFilter() != null) {
            this.swagger = new SpecFilter().filter(this.swagger, FilterFactory.getFilter(), new HashMap(), new HashMap(), new HashMap());
        }
    }
}

