/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.remote;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.github.kongchen.swagger.docgen.AbstractDocumentSource;
import com.github.kongchen.swagger.docgen.LogAdapter;
import com.wordnik.swagger.model.ApiDescription;
import com.wordnik.swagger.model.ApiListing;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;

public class RemoteDocumentSource
extends AbstractDocumentSource {
    private final LogAdapter LOG;
    private final URI requestURI;
    ObjectMapper mapper = new ObjectMapper();
    private boolean withFormatSuffix = true;

    public RemoteDocumentSource(LogAdapter logAdapter, URI requestURI, String outputTpl, String outputPath, String swaggerOutput, String mustacheFileRoot, boolean useOutputFlatStructure) {
        super(logAdapter, outputPath, outputTpl, swaggerOutput, mustacheFileRoot, useOutputFlatStructure);
        this.LOG = new LogAdapter(Logger.getLogger(RemoteDocumentSource.class));
        this.requestURI = requestURI;
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        this.mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public void loadDocuments() throws IOException {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpResponse response = client.execute((HttpUriRequest)new HttpGet(this.requestURI));
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IOException(this.requestURI + " got " + response.getStatusLine().getReasonPhrase());
        }
        ApiListing doc = (ApiListing)this.mapper.readValue(response.getEntity().getContent(), ApiListing.class);
        this.setApiVersion(doc.apiVersion());
        this.setBasePath(doc.basePath());
        URIBuilder uriBuilder = new URIBuilder(this.requestURI);
        String path = uriBuilder.getPath();
        for (ApiDescription endPoint : doc.apis()) {
            String _endpoint = endPoint.path().replaceAll("/api-docs\\.\\{format\\}", "");
            uriBuilder.setPath((path + "/" + _endpoint).replaceAll("\\/\\/", "/"));
            String newURL = null;
            try {
                newURL = uriBuilder.build().toString();
            }
            catch (URISyntaxException e) {
                this.LOG.error("URL is not valid." + e);
                continue;
            }
            this.LOG.info("calling " + newURL);
            response = client.execute((HttpUriRequest)new HttpGet(newURL));
            ApiListing _doc = (ApiListing)this.mapper.readValue(response.getEntity().getContent(), ApiListing.class);
            if (!this.withFormatSuffix) {
                for (ApiDescription ep : _doc.apis()) {
                }
            }
            this.acceptDocument(_doc);
        }
    }

    public void withFormatSuffix(boolean with) {
        this.withFormatSuffix = with;
    }
}

