/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.mustache;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.github.kongchen.swagger.docgen.AbstractDocumentSource;
import com.github.kongchen.swagger.docgen.TypeUtils;
import com.github.kongchen.swagger.docgen.mustache.MustacheApi;
import com.github.kongchen.swagger.docgen.mustache.MustacheDataType;
import com.github.kongchen.swagger.docgen.mustache.MustacheDocument;
import com.github.kongchen.swagger.docgen.mustache.MustacheItem;
import com.github.kongchen.swagger.docgen.mustache.MustacheOperation;
import com.github.kongchen.swagger.docgen.mustache.MustacheResponseClass;
import com.github.kongchen.swagger.docgen.util.Utils;
import com.wordnik.swagger.model.ApiDescription;
import com.wordnik.swagger.model.ApiListing;
import com.wordnik.swagger.model.Operation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import scala.Option;

public class OutputTemplate {
    private String basePath;
    private String apiVersion;
    private List<MustacheDocument> apiDocuments = new ArrayList<MustacheDocument>();
    private Set<MustacheDataType> dataTypes = new TreeSet<MustacheDataType>();

    public OutputTemplate(AbstractDocumentSource docSource) {
        this.feedSource(docSource);
    }

    public static String getJsonSchema() {
        ObjectMapper m = new ObjectMapper();
        try {
            JsonSchema js = m.generateJsonSchema(OutputTemplate.class);
            return m.writeValueAsString((Object)js);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Set<MustacheDataType> getDataTypes() {
        return this.dataTypes;
    }

    public void addDateType(MustacheDocument mustacheDocument, MustacheDataType dataType) {
        if (this.dataTypes.contains(dataType)) {
            return;
        }
        this.dataTypes.add(dataType);
        for (MustacheItem item : dataType.getItems()) {
            String trueType = TypeUtils.getTrueType(item.getType());
            if (trueType == null) continue;
            this.addDateType(mustacheDocument, new MustacheDataType(mustacheDocument, trueType));
        }
    }

    public List<MustacheDocument> getApiDocuments() {
        return this.apiDocuments;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    private MustacheDocument createMustacheDocument(ApiListing swaggerDoc) {
        MustacheDocument mustacheDocument = new MustacheDocument(swaggerDoc);
        this.setApiVersion(swaggerDoc.apiVersion());
        this.setBasePath(swaggerDoc.basePath());
        for (ApiDescription api : swaggerDoc.apis()) {
            mustacheDocument.setDescription(Utils.getStrInOption((Option<String>)api.description()));
            MustacheApi mustacheApi = new MustacheApi(swaggerDoc.basePath(), api);
            for (Operation op : api.operations()) {
                MustacheOperation mustacheOperation = null;
                mustacheOperation = new MustacheOperation(mustacheDocument, op);
                mustacheApi.addOperation(mustacheOperation);
                this.addResponseType(mustacheDocument, mustacheOperation.getResponseClass());
            }
            mustacheDocument.addApi(mustacheApi);
        }
        for (String requestType : mustacheDocument.getRequestTypes()) {
            MustacheDataType dataType = new MustacheDataType(mustacheDocument, requestType);
            this.addDateType(mustacheDocument, dataType);
        }
        LinkedHashSet<String> missedTypes = new LinkedHashSet<String>();
        for (String responseType : mustacheDocument.getResponseTypes()) {
            String ttype;
            if (mustacheDocument.getRequestTypes().contains(responseType) || (ttype = TypeUtils.getTrueType(responseType)) == null) continue;
            missedTypes.add(ttype);
        }
        for (String type : missedTypes) {
            MustacheDataType dataType = new MustacheDataType(mustacheDocument, type);
            this.addDateType(mustacheDocument, dataType);
        }
        this.filterDatatypes(this.dataTypes);
        return mustacheDocument;
    }

    private void filterDatatypes(Set<MustacheDataType> dataTypes) {
        Iterator<MustacheDataType> it = dataTypes.iterator();
        while (it.hasNext()) {
            MustacheDataType type = it.next();
            if (type.getItems() != null && type.getItems().size() != 0) continue;
            it.remove();
        }
    }

    private void addResponseType(MustacheDocument mustacheDocument, MustacheResponseClass responseClass) {
        mustacheDocument.addResponseType(responseClass);
        if (responseClass.getGenericClasses() != null) {
            for (MustacheResponseClass mrc : responseClass.getGenericClasses()) {
                this.addResponseType(mustacheDocument, mrc);
            }
        }
    }

    private void feedSource(AbstractDocumentSource source) {
        for (ApiListing doc : source.getValidDocuments()) {
            if (doc.apis().isEmpty()) continue;
            MustacheDocument mustacheDocument = this.createMustacheDocument(doc);
            this.addMustacheDocument(mustacheDocument);
        }
        Collections.sort(this.apiDocuments, new Comparator<MustacheDocument>(){

            @Override
            public int compare(MustacheDocument o1, MustacheDocument o2) {
                return o1.getIndex() - o2.getIndex();
            }
        });
    }

    private void addMustacheDocument(MustacheDocument mustacheDocument) {
        this.apiDocuments.add(mustacheDocument);
    }

    public void setDataTypes(Set<MustacheDataType> dataTypes) {
        this.dataTypes = dataTypes;
    }
}

