/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.mustache;

import com.github.kongchen.swagger.docgen.mustache.MustacheAuthorization;
import com.github.kongchen.swagger.docgen.mustache.MustacheDocument;
import com.github.kongchen.swagger.docgen.mustache.MustacheParameterSet;
import com.github.kongchen.swagger.docgen.mustache.MustacheResponseClass;
import com.github.kongchen.swagger.docgen.mustache.MustacheSample;
import com.wordnik.swagger.core.ApiValues;
import com.wordnik.swagger.model.Authorization;
import com.wordnik.swagger.model.Operation;
import com.wordnik.swagger.model.ResponseMessage;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;
import scala.collection.JavaConversions;
import scala.collection.mutable.Buffer;

public class MustacheOperation {
    private final int opIndex;
    private final String httpMethod;
    private final String summary;
    private final String notes;
    private final MustacheResponseClass responseClass;
    private final String nickname;
    private final List<MustacheAuthorization> authorizations = new ArrayList<MustacheAuthorization>();
    private List<MustacheParameterSet> parameters;
    private MustacheParameterSet requestQuery;
    private MustacheParameterSet requestHeader;
    private MustacheParameterSet requestBody;
    private MustacheParameterSet requestPath;
    private MustacheParameterSet responseHeader;
    private static final Pattern genericInNotes = Pattern.compile("(/\\*.*<)((\\w+|((\\w+\\.)+\\w+))|(((\\w+|((\\w+\\.)+\\w+)),)+(\\w+|((\\w+\\.)+\\w+))))(>.*\\*/)");
    private List<ResponseMessage> errorResponses;
    List<MustacheSample> samples;

    public MustacheOperation(MustacheDocument mustacheDocument, Operation op) {
        Buffer authorBuffer = op.authorizations().toBuffer();
        for (Authorization authorization : JavaConversions.asJavaList((Buffer)authorBuffer)) {
            this.authorizations.add(new MustacheAuthorization(authorization));
        }
        this.opIndex = op.position();
        this.httpMethod = op.method();
        AbstractMap.SimpleEntry<String, String> notesAndGenericStr = this.parseGenericFromNotes(op.notes());
        this.notes = notesAndGenericStr.getKey();
        this.summary = op.summary();
        this.nickname = op.nickname();
        Buffer buffer = op.parameters().toBuffer();
        this.parameters = mustacheDocument.analyzeParameters(JavaConversions.asJavaList((Buffer)buffer));
        this.responseClass = new MustacheResponseClass(op.responseClass() + notesAndGenericStr.getValue());
        Buffer errorbuffer = op.responseMessages().toBuffer();
        this.errorResponses = JavaConversions.asJavaList((Buffer)errorbuffer);
        if (this.parameters == null) {
            return;
        }
        for (MustacheParameterSet para : this.parameters) {
            if (para.getParamType().equals(ApiValues.TYPE_QUERY())) {
                this.requestQuery = para;
                continue;
            }
            if (para.getParamType().equals(ApiValues.TYPE_HEADER())) {
                this.requestHeader = para;
                continue;
            }
            if (para.getParamType().equals(ApiValues.TYPE_BODY())) {
                this.requestBody = para;
                continue;
            }
            if (para.getParamType().equals(ApiValues.TYPE_PATH())) {
                this.requestPath = para;
                continue;
            }
            if (!para.getParamType().equals("response_header")) continue;
            this.responseHeader = para;
        }
    }

    private AbstractMap.SimpleEntry<String, String> parseGenericFromNotes(String notes) {
        Scanner scanner = new Scanner(notes);
        String genericString = scanner.findInLine(genericInNotes);
        if (genericString != null) {
            return new AbstractMap.SimpleEntry<String, String>(notes.replaceFirst(genericInNotes.pattern(), ""), genericString.replaceAll("/\\*", "").replaceAll("\\*/", "").trim());
        }
        return new AbstractMap.SimpleEntry<String, String>(notes, "");
    }

    public List<MustacheAuthorization> getAuthorizations() {
        return this.authorizations;
    }

    public MustacheParameterSet getResponseHeader() {
        return this.responseHeader;
    }

    public void setResponseHeader(MustacheParameterSet responseHeader) {
        this.responseHeader = responseHeader;
    }

    public MustacheParameterSet getRequestPath() {
        return this.requestPath;
    }

    public void setRequestPath(MustacheParameterSet requestPath) {
        this.requestPath = requestPath;
    }

    public MustacheParameterSet getRequestQuery() {
        return this.requestQuery;
    }

    public void setRequestQuery(MustacheParameterSet requestQuery) {
        this.requestQuery = requestQuery;
    }

    public MustacheParameterSet getRequestHeader() {
        return this.requestHeader;
    }

    public void setRequestHeader(MustacheParameterSet requestHeader) {
        this.requestHeader = requestHeader;
    }

    public MustacheParameterSet getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(MustacheParameterSet requestBody) {
        this.requestBody = requestBody;
    }

    public List<MustacheSample> getSamples() {
        return this.samples;
    }

    public void setSamples(List<MustacheSample> samples) {
        this.samples = samples;
    }

    public int getOpIndex() {
        return this.opIndex;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getNotes() {
        return this.notes;
    }

    public String getNickname() {
        return this.nickname;
    }

    public List<MustacheParameterSet> getParameters() {
        return this.parameters;
    }

    public List<ResponseMessage> getErrorResponses() {
        return this.errorResponses;
    }

    public MustacheResponseClass getResponseClass() {
        return this.responseClass;
    }
}

